/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.base.BgItemCollection;
import com.kingdee.eas.ma.base.BgItemException;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemGroupFactory;
import com.kingdee.eas.ma.base.BgItemGroupInfo;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.IBgItem;
import com.kingdee.eas.ma.base.client.AbstractBgItemGroupListUI;
import com.kingdee.eas.ma.base.client.BgItemAllocationUI;
import com.kingdee.eas.ma.base.client.BgItemEditUI;
import com.kingdee.eas.ma.base.client.BgItemGroupEditUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgItemGroupListUI
extends AbstractBgItemGroupListUI {
    private static final long serialVersionUID = 6039597979786829334L;
    private static final Logger logger = CoreUIObject.getLogger(BgItemGroupListUI.class);
    private OrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private CtrlUnitInfo CU = SysContext.getSysContext().getCurrentCtrlUnit();
    private NumberExpendRender render = null;
    private Color disableColor = new Color(230, 230, 230);

    public void onLoad() throws Exception {
        super.onLoad();
        BgCommCHelper.initOrgUnit((CoreUIObject)this, this.prmtOrgUnit, this.getUnitInfo(), this.getCU().getId().toString());
        this.prmtOrgUnit.setEnabled(true);
        this.prmtOrgUnit.setEditable(false);
        this.setRender(new NumberExpendRender(1));
        this.tblMain.getColumn("number").setRenderer((IBasicRender)this.getRender());
        this.tblMain.getColumn("bgItemGroup.id").getStyleAttributes().setHided(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAllocation.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnUnAllocation.setIcon(EASResource.getIcon((String)"imgTbtn_undistribute"));
        BgCommCHelper.disableVisible((JButton)this.btnGroupMoveTree, (JMenuItem)this.menuItemGroupMoveTree);
        BgCommCHelper.enableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.enableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        this.btnImprotExcel.setEnabled(true);
        this.btnImprotExcel.setVisible(true);
        this.btnImprotExcel.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemGroupView.setIcon(EASResource.getIcon((String)"imgTree_view"));
        this.menuItemGroupEdit.setIcon(EASResource.getIcon((String)"imgTree_edit"));
        this.menuItemGroupRemove.setIcon(EASResource.getIcon((String)"imgTree_delete"));
    }

    public OrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(OrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    public CtrlUnitInfo getCU() {
        return this.CU;
    }

    public Color getDisableColor() {
        return this.disableColor;
    }

    public void setRender(NumberExpendRender render) {
        this.render = render;
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.BGITEMGROUP_INFO, (Object)this.getSelectedBgItemGroupInfo());
        uiContext.put((Object)BgBaseConstants.BGITEM_INFO, (Object)this.getSelectedBgItemInfo());
        uiContext.put((Object)BgBaseConstants.ORGUNIT_INFO, this.prmtOrgUnit.getData());
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
        uiContext.put((Object)BgBaseConstants.BGITEMGROUP_INFO, (Object)this.getSelectedBgItemGroupInfo());
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgItemFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgItemEditUI.class.getName();
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.isModify = false;
        super.refresh(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isDoRefresh(IUIWindow uiWindow) {
        return super.isDoRefresh(uiWindow);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("bgItemGroup.id");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("isForFP");
        sic.add("fpDirection");
        sic.add("elimType");
        sic.add("dataRelation");
        sic.add("longNumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("relation.id");
        sic.add("relation.isEffective");
        sic.add("relation.parentId");
        sic.add("relation.rootId");
        return sic;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgItemGroup.global", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("relation.orgUnitID", (Object)this.getUnitInfo().getId().toString(), CompareType.EQUALS));
        filter.setMaskString("#0 OR #1");
        return filter;
    }

    protected String getQueryFieldName() {
        return "bgItemGroup.id";
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    protected BgItemInfo getSelectedBgItemInfo() {
        IRow row;
        BgItemInfo itemInfo = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            itemInfo = new BgItemInfo();
            itemInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            itemInfo.setName(row.getCell("name").getValue().toString());
            Object obj = row.getCell("number").getValue();
            if (obj instanceof NumberExpandInfo) {
                itemInfo.setNumber(((NumberExpandInfo)obj).getNumber());
            } else {
                itemInfo.setNumber(obj.toString());
            }
        }
        return itemInfo;
    }

    protected void enableAllAction() {
        BgCommCHelper.enableAction((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew, (ItemAction)this.actionAddNew);
        BgCommCHelper.enableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
        BgCommCHelper.enableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
    }

    protected void disableAllAction() {
        BgCommCHelper.disableAction((JButton)this.btnAddNew, (JMenuItem)this.menuItemAddNew, (ItemAction)this.actionAddNew);
        BgCommCHelper.disableAction((JButton)this.btnEdit, (JMenuItem)this.menuItemEdit, (ItemAction)this.actionEdit);
        BgCommCHelper.disableAction((JButton)this.btnRemove, (JMenuItem)this.menuItemRemove, (ItemAction)this.actionRemove);
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                try {
                    BgItemGroupListUI.this.afterDataFill_actionEvent(e);
                }
                catch (Exception ex) {
                    BgItemGroupListUI.this.handUIExceptionAndAbort(ex);
                }
            }
        });
    }

    protected void afterDataFill_actionEvent(KDTDataRequestEvent e) throws Exception {
        int beginIndex = e.getFirstRow();
        int endIndex = e.getLastRow();
        int level = 0;
        Object numberValue = null;
        String id = null;
        String number = null;
        String longNumber = null;
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int index = beginIndex; index <= endIndex; ++index) {
            row = this.tblMain.getRow(index);
            if (row == null) continue;
            id = (String)row.getCell("id").getValue();
            numberValue = row.getCell("number").getValue();
            if (!(numberValue instanceof String)) {
                return;
            }
            number = numberValue.toString();
            longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            boolean isEffective = (Boolean)row.getCell("isEffective").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setEffective(isEffective);
            expandInfo.setName(number);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setExpandStatus(true);
            row.getCell("number").setValue((Object)expandInfo);
            if (isEffective) {
                row.getStyleAttributes().setBackground(null);
                continue;
            }
            row.getStyleAttributes().setBackground(this.getDisableColor());
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    protected void cancel() throws Exception {
        super.cancel();
        this.refreshList();
    }

    protected void runCancel(IObjectPK pk) throws Exception {
        ((IBgItem)this.getBizInterface()).disable(BOSUuid.read((String)pk.toString()), this.getUnitInfo().getId());
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
        this.checkSelected();
        String cancelMsg = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_CancelCancel");
        if (this.confirmDialog(cancelMsg)) {
            if (UtilRequest.isPrepare((String)"ActionCancelCancel", (CoreUIObject)this)) {
                this.prepareCancel(new RequestContext()).callHandler();
            }
            this.cancelCancel();
        }
    }

    protected void cancelCancel() throws Exception {
        super.cancelCancel();
        this.refreshList();
    }

    protected void runCancelCancel(IObjectPK pk) throws Exception {
        ((IBgItem)this.getBizInterface()).enable(BOSUuid.read((String)pk.toString()), this.getUnitInfo().getId());
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BgItemGroupFactory.getRemoteInstance();
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("global");
        sic.add("longnumber");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("parent.id");
        sic.add("parent.name");
        sic.add("parent.number");
        return sic;
    }

    protected FilterInfo getDefaultFilterForTree() {
        return new FilterInfo();
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected String getGroupEditUIName() {
        return BgItemGroupEditUI.class.getName();
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected String getRootName() {
        return BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "bgItemGroup");
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        Object obj;
        ObjectUuidPK groupPk = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && (obj = row.getCell("bgItemGroup.id").getValue()) != null) {
            groupPk = new ObjectUuidPK(obj.toString());
        }
        return groupPk;
    }

    protected BgItemGroupInfo getSelectedBgItemGroupInfo() {
        KDTreeNode treeNode = null;
        BgItemGroupInfo groupInfo = null;
        treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof BgItemGroupInfo) {
            groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
        }
        return groupInfo;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        boolean canAlo = false;
        if (treeNode != null && treeNode.getUserObject() instanceof BgItemGroupInfo) {
            BgItemGroupInfo groupInfo = (BgItemGroupInfo)treeNode.getUserObject();
            boolean bl = canAlo = groupInfo.isIsLeaf() && !groupInfo.isGlobal();
            if (groupInfo.isIsLeaf()) {
                this.enableAllAction();
            } else {
                this.disableAllAction();
            }
        } else {
            this.disableAllAction();
        }
        this.btnAllocation.setEnabled(canAlo);
        this.actionAllocation.setEnabled(canAlo);
        this.btnUnAllocation.setEnabled(canAlo);
        this.actionUnAllocation.setEnabled(canAlo);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getType() == 1) {
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn("number").getColumnIndex()) {
                NumberExpandInfo expandInfo = (NumberExpandInfo)row.getCell("number").getValue();
                if (this.getRender().inRect(expandInfo, e.getX(), e.getY())) {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo) throws Exception {
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = null;
        NumberExpandInfo expandInfo = null;
        parentLongNumber = parentExpandInfo.getLongNumber();
        boolean isExpandStatus = parentExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            int rowCount = this.tblMain.getRowCount3();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell("number").getValue()).getLongNumber()).startsWith(parentLongNumber + "!"); ++rowIndex) {
                if (expandInfo.getLevel() - parentLevel != 1) continue;
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                expandInfo.setExpandStatus(false);
            }
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtOrgUnit.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "inputOrgUnit"));
            this.prmtOrgUnit.setValue(e.getOldValue());
            return;
        }
        super.prmtOrgUnit_dataChanged(e);
        if (this.prmtOrgUnit.getData() instanceof FullOrgUnitInfo) {
            this.setUnitInfo((OrgUnitInfo)this.prmtOrgUnit.getData());
            this.refreshList();
        }
    }

    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        BgItemGroupInfo group;
        KDTreeNode node = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof BgItemGroupInfo && (group = (BgItemGroupInfo)node.getUserObject()) != null && group.isIsLeaf() && this.tblMain.getBody().size() > 0) {
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "hasItem_add"));
            return;
        }
        super.actionGroupAddNew_actionPerformed(e);
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkTreeNodeSelected(e);
        KDTreeNode node = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (node != null && node.getUserObject() instanceof BgItemGroupInfo) {
            BgItemGroupInfo group = (BgItemGroupInfo)node.getUserObject();
            if (!BgCommCHelper.isCreator(group.getCreator().getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "notCreatorNotRem"));
                return;
            }
            if (!group.isIsLeaf()) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "notLeaf_delete"));
                return;
            }
            if (this.tblMain.getBody().size() > 0) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "hasItem_delete"));
            } else {
                boolean isRefDim = BgItemFactory.getRemoteInstance().checkRefDim(group.getId());
                if (!isRefDim) {
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "refDim"));
                    return;
                }
                super.actionGroupRemove_actionPerformed(e);
                this.refresh(e);
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        ArrayList selIds = new ArrayList();
        ArrayList list = this.getSelectedIdValues();
        if (list == null || list.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "selRecordLine"));
            return;
        }
        selIds.addAll(this.getSelectedIdValues());
        if (!((IBgItem)this.getBizInterface()).checkDelete(selIds, this.getUnitInfo().getId())) {
            throw new BgItemException(BgItemException.ISRELATION);
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectRows[0]);
        String createOrgUnitId = row.getCell("orgUnit.id").getValue().toString();
        if (!createOrgUnitId.equalsIgnoreCase(ccoui.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"cantEditItem"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    public boolean isPrepareActionRemove() {
        return true;
    }

    public RequestContext prepareActionRemove(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionAddNew(itemAction);
        if (request != null) {
            request.put(BgBaseConstants.BGITEM_ID, (Object)this.getSelectedIdValues());
            request.put(BgBaseConstants.ORGUNIT_ID, (Object)this.getUnitInfo().getId().toString());
        }
        return request;
    }

    @Override
    public void actionAllocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionAllocation_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgItemAllocationUI.DISTRIBUTION, (Object)Boolean.TRUE);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getUnitInfo().getId().toString());
        BgItemGroupInfo itemGroupInfo = this.getSelectedBgItemGroupInfo();
        if (itemGroupInfo != null) {
            uiContext.put((Object)BgBaseConstants.BGITEMGROUP_INFO, (Object)itemGroupInfo);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getAllocationUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionUnAllocation_actionPerformed(ActionEvent e) throws Exception {
        super.actionUnAllocation_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)BgItemAllocationUI.DISTRIBUTION, (Object)Boolean.FALSE);
        uiContext.put((Object)BgBaseConstants.ORGUNIT_ID, (Object)this.getUnitInfo().getId().toString());
        BgItemGroupInfo itemGroupInfo = this.getSelectedBgItemGroupInfo();
        if (itemGroupInfo != null) {
            uiContext.put((Object)BgBaseConstants.BGITEMGROUP_INFO, (Object)itemGroupInfo);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getAllocationUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionImportExcel_actionPerformed(ActionEvent e) throws Exception {
        String res = "com.kingdee.eas.ma.base.client.BgItemExcelResource";
        FullOrgUnitInfo fullOrgUnit = new FullOrgUnitInfo();
        OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        fullOrgUnit.setId(orgUnit.getId());
        BgItemGroupInfo bgItemGroupInfo = this.getSelectedBgItemGroupInfo();
        if (bgItemGroupInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)res, (String)"noGroup"));
            return;
        }
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)res, (String)"in"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)res, (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)res, (String)"notFile"));
            SysUtil.abort();
        }
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        int rowCount = sheet.getRowCount();
        BgItemInfo info = null;
        Locale locale = LocaleUtils.getDefaultLocale();
        CostCenterOrgUnitInfo org = null;
        if (this.prmtOrgUnit.getData() instanceof OrgUnitInfo) {
            org = (OrgUnitInfo)this.prmtOrgUnit.getData();
            org = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()));
        } else {
            org = SysContext.getSysContext().getCurrentCostUnit();
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        Timestamp time = new Timestamp(new Date().getTime());
        CtrlUnitInfo cu = SysContext.getSysContext().getCurrentCtrlUnit();
        BgItemCollection colls = new BgItemCollection();
        HashSet<String> longNumberSet = new HashSet<String>();
        for (int row = 1; row < rowCount; ++row) {
            String level;
            String number = sheet.getCell(row, 0, false).getValue() == null ? null : sheet.getCell(row, 0, false).getValue().toString().trim();
            String name = sheet.getCell(row, 1, false) == null ? null : sheet.getCell(row, 1, false).getValue().toString().trim();
            String longNumber = sheet.getCell(row, 2, false) == null ? null : sheet.getCell(row, 2, false).getValue().toString().trim();
            String string = level = sheet.getCell(row, 3, false) == null ? null : sheet.getCell(row, 3, false).getValue().toString().trim();
            if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)longNumber)) continue;
            if (StringUtils.isEmpty((String)level)) {
                level = "1";
            }
            if (number != null && longNumber != null && !number.equals(longNumber.split("!")[longNumber.split("!").length - 1])) continue;
            longNumberSet.add(longNumber);
            info = new BgItemInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setNumber(number);
            info.setName(name, locale);
            info.setLongNumber(longNumber);
            info.setLevel(Integer.valueOf(level));
            info.setBgItemGroup(bgItemGroupInfo);
            info.setOrgUnit(org.castToFullOrgUnitInfo());
            info.setCreator(userInfo);
            info.setCreateTime(time);
            info.setCU(cu);
            colls.add(info);
        }
        this.setIsLeaf(colls, longNumberSet);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"groupInfo", (Object)bgItemGroupInfo);
        uiContext.put((Object)"collection", (Object)colls);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.base.client.BgItemImportUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionExportExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportExcel_actionPerformed(e);
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"out"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"number"));
        kdsSheet.setCellValue(0, 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"name"));
        kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"longnumber"));
        kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"level"));
        IRow row = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("number").getValue() != null && row.getCell("name").getValue() != null) {
                kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("number").getValue().toString());
                kdsSheet.setCellValue(i + 1, 1, (Object)row.getCell("name").getValue().toString());
                if (row.getCell("longNumber").getValue() != null) {
                    kdsSheet.setCellValue(i + 1, 2, (Object)row.getCell("longNumber").getValue().toString());
                }
                if (row.getCell("level").getValue() == null) continue;
                kdsSheet.setCellValue(i + 1, 3, (Object)row.getCell("level").getValue().toString());
                continue;
            }
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "errorValue", new Integer[]{i + 1}));
            return;
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgItemImportResource", (String)"fileIsNotOpen"));
        }
    }

    private void setIsLeaf(BgItemCollection colls, Set<String> longNumberSet) {
        if (colls == null || colls.isEmpty() || longNumberSet == null || longNumberSet.isEmpty()) {
            return;
        }
        for (int index = 0; index < colls.size(); ++index) {
            colls.get(index).setIsLeaf(this.isLeaf(colls.get(index).getLongNumber(), longNumberSet));
        }
    }

    private boolean isLeaf(String longNumber, Set<String> longNumberSet) {
        if (StringUtils.isEmpty((String)longNumber) || longNumberSet == null || longNumberSet.isEmpty()) {
            return true;
        }
        Iterator<String> it = longNumberSet.iterator();
        while (it.hasNext()) {
            if (!it.next().startsWith(longNumber + "!")) continue;
            return false;
        }
        return true;
    }

    protected String getAllocationUIName() {
        return BgItemAllocationUI.class.getName();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }
}

