/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgItemCollection;
import com.kingdee.eas.ma.base.BgItemFactory;
import com.kingdee.eas.ma.base.BgItemInfo;
import com.kingdee.eas.ma.base.IBgItem;
import com.kingdee.eas.ma.base.client.AbstractBgItemImportUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgItemImportUI
extends AbstractBgItemImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgItemImportUI.class);
    private IBgItem iBgItem = null;
    public static final String COL_ID = "id";
    public static final String COL_NUMBER = "number";
    public static final String COL_NAME = "name";
    public static final String COL_LONGNUMBER = "longNumber";
    public static final String COL_LEVEL = "level";
    public static final String COL_RESULT = "result";
    private BgItemCollection colls = null;
    private static final String RES = "com.kingdee.eas.ma.base.client.BgItemExcelResource";
    private boolean isCancel = true;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.getTable().checkParsed();
        this.getTable().getColumn(COL_NAME).setWidth(130);
        this.getTable().setEditable(false);
        this.fillDataToTable();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnOK.setEnabled(true);
        this.btnOK.setVisible(true);
        this.btnCancel.setEnabled(true);
        this.btnCancel.setVisible(true);
    }

    protected void fillDataToTable() {
        Map ctx = this.getUIContext();
        this.colls = (BgItemCollection)((Object)ctx.get("collection"));
        if (this.colls == null || this.colls.isEmpty()) {
            return;
        }
        BgItemInfo info = null;
        IRow row = null;
        for (int index = 0; index < this.colls.size(); ++index) {
            info = this.colls.get(index);
            row = this.table.addRow();
            row.getCell(COL_ID).setValue((Object)info.getId().toString());
            row.getCell(COL_NUMBER).setValue((Object)info.getNumber());
            row.getCell(COL_NAME).setValue((Object)info.getName());
            row.getCell(COL_LONGNUMBER).setValue((Object)info.getLongNumber());
            row.getCell(COL_LEVEL).setValue((Object)info.getLevel());
        }
    }

    protected KDTable getTable() {
        return this.table;
    }

    protected IBgItem getBizInteface() throws BOSException {
        if (this.iBgItem == null) {
            this.iBgItem = BgItemFactory.getRemoteInstance();
        }
        return this.iBgItem;
    }

    @Override
    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = false;
        if (this.colls == null || this.colls.isEmpty()) {
            return;
        }
        List rs = this.getBizInteface().importExcel((IObjectCollection)this.colls);
        IRow row = null;
        for (int rowIndex = 0; rowIndex < this.table.getRowCount(); ++rowIndex) {
            row = this.table.getRow(rowIndex);
            String rowId = row.getCell(COL_ID).getValue().toString();
            if (rs != null && rs.contains(rowId)) {
                row.getCell(COL_RESULT).setValue((Object)EASResource.getString((String)RES, (String)"fail"));
                continue;
            }
            row.getCell(COL_RESULT).setValue((Object)EASResource.getString((String)RES, (String)"success"));
        }
        this.btnOK.setVisible(false);
        this.btnCancel.setText(EASResource.getString((String)RES, (String)"close"));
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

