/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodEditUI;
import com.kingdee.eas.ma.base.client.BgPeriodListUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.STConverter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class BgPeriodEditUI
extends AbstractBgPeriodEditUI {
    private static final long serialVersionUID = 3246443963214501396L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodEditUI.class);
    private final int minYear = 1900;
    private final int maxYear = 2050;
    protected Locale locale = null;
    protected Locale sLocale = new Locale("l2");
    protected Locale tLocale = new Locale("l3");
    private BgPeriodListUI listUI = null;
    protected CalendarHelper helper = new CalendarHelper();
    protected NumberExpendRender render = new NumberExpendRender(1);
    protected DecimalFormat df = new DecimalFormat("00");
    protected Map<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.kDTable.getColumn(2).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
        this.kDTable.getColumn(3).getStyleAttributes().setNumberFormat(BgNationalFormatUIUtil.getNationalDateFormatString());
    }

    protected IBgPeriod getBizInterface() throws BOSException {
        return BgPeriodFactory.getRemoteInstance();
    }

    public CalendarHelper getCalHelper() {
        return this.helper;
    }

    public NumberExpendRender getRender() {
        return this.render;
    }

    public void init() {
        this.initUI();
        this.initTable();
        this.initData();
    }

    public void initUI() {
        this.listUI = (BgPeriodListUI)((Object)this.getUIContext().get("Owner"));
        Icon backGroup = EASResource.getIcon((String)"imgGuide_pic338");
        this.kDStartupImage.setIcon(backGroup);
        this.kDEndImage.setIcon(backGroup);
        this.KDPersonalImage.setIcon(backGroup);
        int currYear = this.getCalHelper().getCurrentlyYear() + 1;
        this.kDSpinner.setModel((SpinnerModel)new SpinnerNumberModel(currYear, 1900, 2050, 1));
        this.kDCheckYear.setSelected(true);
        this.kDCheckQuarter.setSelected(true);
        this.kDCheckMonth.setSelected(true);
        this.kDCheckHalfYear.setSelected(true);
        this.hidePeriodPanel();
        this.hidePersonPanel();
    }

    public void initTable() {
        this.kDTable.getSelectManager().setSelectMode(2);
        int colCount = 4;
        for (int i = 0; i < colCount; ++i) {
            this.kDTable.addColumn(i);
        }
        IRow row = this.kDTable.addHeadRow();
        if (row != null) {
            row.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"rowLongNumber"));
            row.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"rowName"));
            row.getCell(2).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"rowStartupDate"));
            row.getCell(3).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"rowEndDate"));
        }
        IColumn col = null;
        String formatString = "%{yyyy-MM-dd}t";
        col = this.kDTable.getColumn(0);
        if (col != null) {
            col.setRenderer((IBasicRender)this.getRender());
            col.setWidth(140);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(1)) != null) {
            col.setWidth(140);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(2)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
        if ((col = this.kDTable.getColumn(3)) != null) {
            col.getStyleAttributes().setNumberFormat(formatString);
            col.getStyleAttributes().setLocked(true);
        }
    }

    protected void initData() {
        this.locale = this.getCurrentLocale();
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected void showNaturePanel() {
        this.kDPanelStartup.setVisible(true);
        this.kDButStartupCancel.setVisible(true);
        this.kDButStartupNext.setVisible(true);
        this.kDPanelStartup.updateUI();
    }

    protected void hideNaturePanel() {
        this.kDPanelStartup.setVisible(false);
        this.kDButStartupCancel.setVisible(false);
        this.kDButStartupNext.setVisible(false);
        this.kDPanelStartup.updateUI();
    }

    @Override
    protected void kDButStartupCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButStartupCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void kDButStartupNext_actionPerformed(ActionEvent e) throws Exception {
        super.kDButStartupNext_actionPerformed(e);
        if (this.checkNaturePeriod()) {
            this.hideNaturePanel();
            this.showPeriodPanel();
            this.processPeriod(true);
        }
    }

    @Override
    protected void kDChecksYear_actionPerformed(ActionEvent e) throws Exception {
        super.kDChecksYear_actionPerformed(e);
        if (!this.kDCheckYear.isSelected()) {
            this.kDCheckHalfYear.setSelected(false);
            this.kDCheckQuarter.setSelected(false);
            this.kDCheckMonth.setSelected(false);
            this.kDCheckMWeek.setSelected(false);
            this.kDCheckYWeek.setSelected(false);
        }
    }

    @Override
    protected void kDCheckHalfYear_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckHalfYear_actionPerformed(e);
        if (this.kDCheckHalfYear.isSelected()) {
            this.kDCheckYear.setSelected(true);
        } else {
            this.kDCheckQuarter.setSelected(false);
            this.kDCheckMonth.setSelected(false);
            this.kDCheckMWeek.setSelected(false);
        }
    }

    @Override
    protected void kDCheckQuarter_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckQuarter_actionPerformed(e);
        if (this.kDCheckQuarter.isSelected()) {
            this.kDCheckYear.setSelected(true);
            this.kDCheckHalfYear.setSelected(true);
        } else {
            this.kDCheckMonth.setSelected(false);
            this.kDCheckMWeek.setSelected(false);
        }
    }

    @Override
    protected void kDCheckMonth_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckMonth_actionPerformed(e);
        if (this.kDCheckMonth.isSelected()) {
            this.kDCheckQuarter.setSelected(true);
            this.kDCheckHalfYear.setSelected(true);
            this.kDCheckYear.setSelected(true);
        } else {
            this.kDCheckMWeek.setSelected(false);
        }
    }

    @Override
    protected void kDCheckMWeek_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckMWeek_actionPerformed(e);
        if (this.kDCheckMWeek.isSelected()) {
            this.kDCheckMonth.setSelected(true);
            this.kDCheckQuarter.setSelected(true);
            this.kDCheckHalfYear.setSelected(true);
            this.kDCheckYear.setSelected(true);
        }
    }

    @Override
    protected void kDCheckYWeek_actionPerformed(ActionEvent e) throws Exception {
        super.kDCheckYWeek_actionPerformed(e);
        if (this.kDCheckYWeek.isSelected()) {
            this.kDCheckYear.setSelected(true);
        }
    }

    protected boolean checkNaturePeriod() throws EASBizException {
        if (!this.kDCheckYear.isSelected()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"selectPeriod"));
            SysUtil.abort();
        }
        this.checkProcessNature();
        return true;
    }

    protected void checkProcessNature() throws BgPeriodException {
        ArrayList<String> info = new ArrayList<String>();
        boolean isSelect = false;
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection yearCol = null;
        BgPeriodCollection halfYearCol = null;
        BgPeriodCollection quarterCol = null;
        BgPeriodCollection monthCol = null;
        BgPeriodCollection mWeekCol = null;
        BgPeriodCollection yWeekCol = null;
        this.periodMap.clear();
        try {
            Iterator iter;
            int iYear = Integer.valueOf(this.kDSpinner.getValue().toString());
            if (iYear < 1900 || iYear > 2050) {
                throw new BgPeriodException(BgPeriodException.SELECTYEARERROR, new String[]{String.valueOf(1900), String.valueOf(2050)});
            }
            StringBuffer oql = new StringBuffer();
            oql.append("select * where number like '" + iYear + "Y" + "' order by number");
            yearCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
            if (yearCol != null && yearCol.size() > 0) {
                iter = yearCol.iterator();
                while (iter.hasNext()) {
                    bgPeriodInfo = (BgPeriodInfo)iter.next();
                    this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                }
                info.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Year"));
                isSelect = yearCol.size() == 1;
            }
            if (this.kDCheckYear.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + iYear + "%" + "W" + "' order by number");
                yWeekCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
                if (yWeekCol != null && yWeekCol.size() > 0) {
                    iter = yWeekCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                }
            }
            if (this.kDCheckYear.isSelected() && this.kDCheckHalfYear.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + iYear + "%" + "HY" + "' order by number");
                halfYearCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
                if (halfYearCol != null && halfYearCol.size() > 0) {
                    iter = halfYearCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"HalfYear"));
                }
                isSelect = halfYearCol.size() == 2;
            }
            if (this.kDCheckHalfYear.isSelected() && this.kDCheckQuarter.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + iYear + "%" + "Q" + "' order by number");
                quarterCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
                if (quarterCol != null && quarterCol.size() > 0) {
                    iter = quarterCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Quarter"));
                }
                isSelect = quarterCol.size() == 4;
            }
            if (this.kDCheckQuarter.isSelected() && this.kDCheckMonth.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + iYear + "%" + "M" + "' order by number");
                monthCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
                if (monthCol != null && monthCol.size() > 0) {
                    iter = monthCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Month"));
                }
                isSelect = monthCol.size() == 12;
            }
            if (this.kDCheckQuarter.isSelected() && this.kDCheckMWeek.isSelected()) {
                oql = new StringBuffer();
                oql.append("select * where number like '" + iYear + "%" + "MW" + "' order by number");
                mWeekCol = this.getBizInterface().getBgPeriodCollection(oql.toString());
                if (mWeekCol != null && mWeekCol.size() > 0) {
                    iter = mWeekCol.iterator();
                    while (iter.hasNext()) {
                        bgPeriodInfo = (BgPeriodInfo)iter.next();
                        this.periodMap.put(bgPeriodInfo.getNumber(), bgPeriodInfo);
                    }
                    info.add(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"mWeek"));
                }
                isSelect = mWeekCol.size() > 12;
            }
            if (this.kDCheckYWeek.isSelected()) {
                if (yWeekCol != null && !yWeekCol.isEmpty()) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"existExit"));
                    SysUtil.abort();
                }
            } else if (isSelect) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"existExit"));
                SysUtil.abort();
            } else if (info.size() > 0) {
                StringBuffer message = new StringBuffer(128);
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"SYSTEM"));
                this.convertToString(info, message);
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"PERIOD"));
                message.append(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"existCreate"));
                MsgBox.showInfo((Component)((Object)this), (String)message.toString());
            }
        }
        catch (BOSException ex) {
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
    }

    protected void convertToString(List<String> info, StringBuffer message) {
        String and = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"AND");
        String left = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"left");
        String right = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"right");
        int n = info.size();
        for (int i = 0; i < n; ++i) {
            if (i + 1 < n) {
                message.append(left + info.get(i) + right + and);
                continue;
            }
            message.append(left + info.get(i) + right);
        }
    }

    protected void processPeriod(boolean periodType) {
        this.kDTable.setRefresh(false);
        this.kDTable.removeRows();
        this.processYear(periodType);
        this.kDTable.setRefresh(true);
    }

    protected void processYear(boolean periodType) {
        if (this.kDTable.getRowCount() > 0) {
            this.kDTable.removeRows();
        }
        int selYear = Integer.valueOf(this.kDSpinner.getValue().toString());
        String YearNumber = null;
        boolean isLeaf = true;
        if (periodType) {
            if (this.kDCheckHalfYear.isSelected()) {
                isLeaf = false;
            }
            BgPeriodInfo bgPeriodYear = null;
            if (this.kDCheckYear.isSelected()) {
                YearNumber = selYear + "Y";
                bgPeriodYear = this.periodMap.get(YearNumber);
                if (bgPeriodYear == null) {
                    bgPeriodYear = new BgPeriodInfo();
                    bgPeriodYear.setId(BOSUuid.create((BOSObjectType)bgPeriodYear.getBOSType()));
                    bgPeriodYear.setNumber(YearNumber);
                    bgPeriodYear.setLongNumber(YearNumber);
                    if (this.locale.equals(this.sLocale)) {
                        bgPeriodYear.setName(selYear + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Year"), this.sLocale);
                        bgPeriodYear.setName(STConverter.sc2tc((String)bgPeriodYear.getName(this.sLocale)), this.tLocale);
                    } else if (this.locale.equals(this.tLocale)) {
                        bgPeriodYear.setName(selYear + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Year"), this.tLocale);
                        bgPeriodYear.setName(STConverter.tc2sc((String)bgPeriodYear.getName(this.tLocale)), this.sLocale);
                    } else {
                        bgPeriodYear.setName(selYear + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Year"));
                    }
                    bgPeriodYear.setBeginDate(this.getCalHelper().getStartDate(this.getCalHelper().getFirstDayOfYear(selYear)));
                    bgPeriodYear.setEndDate(this.getCalHelper().getBeoverDate(this.getCalHelper().getLastDayOfYear(selYear)));
                    bgPeriodYear.setPeriodType(BgPeriodEnum.YEAR);
                    bgPeriodYear.setYear(selYear);
                    bgPeriodYear.setMonth(this.getCalHelper().getMonthsOfYear());
                    bgPeriodYear.setLevel(1);
                    bgPeriodYear.setShowLevel(1000000);
                }
                bgPeriodYear.setIsLeaf(isLeaf);
                this.processTable(bgPeriodYear);
                if (this.kDCheckHalfYear.isSelected()) {
                    this.processHalfYear(selYear, bgPeriodYear);
                }
                if (this.kDCheckYWeek.isSelected()) {
                    this.processYearWeek(selYear, bgPeriodYear);
                }
            }
        }
    }

    private void processYearWeek(int Year, BgPeriodInfo bgPeriodYear) {
        String Week = null;
        BgPeriodInfo bgPeriodWeek = null;
        int w = BgPeriodHelper.getWeek(Year, true);
        for (int i = 1; i <= w; ++i) {
            Week = this.df.format(i);
            String WeekNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + Week + "W").toString();
            bgPeriodWeek = this.periodMap.get(WeekNumber);
            if (bgPeriodWeek == null) {
                bgPeriodWeek = new BgPeriodInfo();
                bgPeriodWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodWeek.getBOSType()));
                bgPeriodWeek.setNumber(WeekNumber);
                bgPeriodWeek.setLongNumber(bgPeriodYear.getLongNumber() + "!" + WeekNumber);
                if (this.locale.equals(this.sLocale)) {
                    bgPeriodWeek.setName(bgPeriodYear.getName(this.sLocale) + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"), this.sLocale);
                    bgPeriodWeek.setName(STConverter.sc2tc((String)bgPeriodWeek.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgPeriodWeek.setName(bgPeriodYear.getName(this.tLocale) + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"), this.tLocale);
                    bgPeriodWeek.setName(STConverter.tc2sc((String)bgPeriodWeek.getName(this.tLocale)), this.sLocale);
                } else {
                    bgPeriodWeek.setName(bgPeriodYear.getName() + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"));
                }
                bgPeriodWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getYearWeekFirstDay(Year, i)));
                bgPeriodWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getYearWeekLastDay(Year, i)));
                bgPeriodWeek.setPeriodType(BgPeriodEnum.YWEEK);
                bgPeriodWeek.setYear(Year);
                bgPeriodWeek.setMonth(this.helper.getCurrentlyMonth(bgPeriodWeek.getEndDate()));
                bgPeriodWeek.setWeek(i);
                bgPeriodWeek.setLevel(2);
                bgPeriodWeek.setShowLevel(100 + i);
                bgPeriodWeek.setIsLeaf(true);
                bgPeriodWeek.setParent(bgPeriodYear);
            }
            this.processTable(bgPeriodWeek);
        }
    }

    protected void processHalfYear(int year, BgPeriodInfo bgPeriodYear) {
        String halfYear = null;
        String halfYearNumber = null;
        BgPeriodInfo bgPeriodHalfYear = null;
        boolean isLeaf = true;
        if (this.kDCheckQuarter.isSelected()) {
            isLeaf = false;
        }
        for (int i = 1; i <= 2; ++i) {
            halfYear = this.df.format(i);
            halfYearNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + halfYear + "HY").toString();
            bgPeriodHalfYear = this.periodMap.get(halfYearNumber);
            if (bgPeriodHalfYear == null) {
                bgPeriodHalfYear = new BgPeriodInfo();
                bgPeriodHalfYear.setId(BOSUuid.create((BOSObjectType)bgPeriodHalfYear.getBOSType()));
                bgPeriodHalfYear.setNumber(halfYearNumber);
                bgPeriodHalfYear.setLongNumber(bgPeriodYear.getLongNumber() + "!" + halfYearNumber);
                if (this.locale.equals(this.sLocale)) {
                    bgPeriodHalfYear.setName(bgPeriodYear.getName(this.sLocale) + BgPeriodEditUI.getHalfYearName(i) + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"HalfYear"), this.sLocale);
                    bgPeriodHalfYear.setName(STConverter.sc2tc((String)bgPeriodHalfYear.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgPeriodHalfYear.setName(bgPeriodYear.getName(this.tLocale) + BgPeriodEditUI.getHalfYearName(i) + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"HalfYear"), this.tLocale);
                    bgPeriodHalfYear.setName(STConverter.tc2sc((String)bgPeriodHalfYear.getName(this.tLocale)), this.sLocale);
                } else {
                    bgPeriodHalfYear.setName(bgPeriodYear.getName() + BgPeriodEditUI.getHalfYearName(i) + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"HalfYear"));
                }
                bgPeriodHalfYear.setBeginDate(this.getCalHelper().getStartDate(BgPeriodHelper.getHalfYearFirstDay(year, i)));
                bgPeriodHalfYear.setEndDate(this.getCalHelper().getBeoverDate(BgPeriodHelper.getHalfYearLastDay(year, i)));
                bgPeriodHalfYear.setPeriodType(BgPeriodEnum.HALFYEAR);
                bgPeriodHalfYear.setYear(year);
                bgPeriodHalfYear.setHalfYear(i);
                bgPeriodHalfYear.setMonth(i * 6);
                bgPeriodHalfYear.setLevel(2);
                bgPeriodHalfYear.setShowLevel(100 + (i - 1) * 100000);
                bgPeriodHalfYear.setParent(bgPeriodYear);
            }
            bgPeriodHalfYear.setIsLeaf(isLeaf);
            this.processTable(bgPeriodHalfYear);
            if (isLeaf) continue;
            this.processQuarter(year, bgPeriodYear, bgPeriodHalfYear);
        }
    }

    private static String getHalfYearName(int i) {
        String s = "";
        if (i == 1) {
            s = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"firstHalfYear");
        } else if (i == 2) {
            s = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"lastHalfYear");
        }
        return s;
    }

    protected void processQuarter(int Year, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodHalfYear) {
        boolean isLeaf = true;
        if (this.kDCheckMonth.isSelected()) {
            isLeaf = false;
        }
        int index = 0;
        String quearter = null;
        String number = null;
        BgPeriodInfo bgPeriodQuarter = null;
        int q = 2;
        for (int i = 1; i <= q; ++i) {
            index = (bgPeriodHalfYear.getHalfYear() - 1) * 2 + i;
            quearter = this.df.format(index);
            number = new StringBuffer(bgPeriodYear.getNumber() + "." + quearter + "Q").toString();
            bgPeriodQuarter = this.periodMap.get(number);
            if (bgPeriodQuarter == null) {
                bgPeriodQuarter = new BgPeriodInfo();
                bgPeriodQuarter.setId(BOSUuid.create((BOSObjectType)bgPeriodQuarter.getBOSType()));
                bgPeriodQuarter.setNumber(number);
                bgPeriodQuarter.setLongNumber(bgPeriodHalfYear.getLongNumber() + "!" + number);
                if (this.locale.equals(this.sLocale)) {
                    bgPeriodQuarter.setName(bgPeriodYear.getName(this.sLocale) + quearter + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Quarter"), this.sLocale);
                    bgPeriodQuarter.setName(STConverter.sc2tc((String)bgPeriodQuarter.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgPeriodQuarter.setName(bgPeriodYear.getName(this.tLocale) + quearter + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Quarter"), this.tLocale);
                    bgPeriodQuarter.setName(STConverter.tc2sc((String)bgPeriodQuarter.getName(this.tLocale)), this.sLocale);
                } else {
                    bgPeriodQuarter.setName(bgPeriodYear.getName() + quearter + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Quarter"));
                }
                bgPeriodQuarter.setBeginDate(this.helper.getStartDate(this.getCalHelper().getFirstDayOfQuarter(Year, index)));
                bgPeriodQuarter.setEndDate(this.helper.getBeoverDate(this.getCalHelper().getLastDayOfQuarter(Year, index)));
                bgPeriodQuarter.setPeriodType(BgPeriodEnum.QUARTER);
                bgPeriodQuarter.setYear(Year);
                bgPeriodQuarter.setHalfYear(bgPeriodHalfYear.getHalfYear());
                bgPeriodQuarter.setQuarter(index);
                bgPeriodQuarter.setLevel(3);
                bgPeriodQuarter.setShowLevel(bgPeriodHalfYear.getShowLevel() + 100 + (i - 1) * 10000);
                bgPeriodQuarter.setParent(bgPeriodHalfYear);
            }
            bgPeriodQuarter.setIsLeaf(isLeaf);
            this.processTable(bgPeriodQuarter);
            if (isLeaf) continue;
            this.processMonth(Year, index, bgPeriodYear, bgPeriodQuarter);
        }
    }

    private void processMonth(int Year, int Quarter, BgPeriodInfo bgPeriodYear, BgPeriodInfo bgPeriodQuarter) {
        int month = 1;
        boolean isLeaf = true;
        String sMonth = null;
        String MonthNumber = null;
        BgPeriodInfo bgPeriodMonth = null;
        int m = 3;
        for (int i = 1; i <= m; ++i) {
            month = (Quarter - 1) * 3 + i;
            sMonth = this.df.format(month);
            MonthNumber = new StringBuffer(bgPeriodYear.getNumber() + "." + sMonth + "M").toString();
            bgPeriodMonth = this.periodMap.get(MonthNumber);
            if (bgPeriodMonth == null) {
                bgPeriodMonth = new BgPeriodInfo();
                bgPeriodMonth.setId(BOSUuid.create((BOSObjectType)bgPeriodMonth.getBOSType()));
                bgPeriodMonth.setNumber(MonthNumber);
                bgPeriodMonth.setLongNumber(bgPeriodQuarter.getLongNumber() + "!" + MonthNumber);
                if (this.locale.equals(this.sLocale)) {
                    bgPeriodMonth.setName(bgPeriodYear.getName(this.sLocale) + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Month"), this.sLocale);
                    bgPeriodMonth.setName(STConverter.sc2tc((String)bgPeriodMonth.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgPeriodMonth.setName(bgPeriodYear.getName(this.tLocale) + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Month"), this.tLocale);
                    bgPeriodMonth.setName(STConverter.tc2sc((String)bgPeriodMonth.getName(this.tLocale)), this.sLocale);
                } else {
                    bgPeriodMonth.setName(bgPeriodYear.getName() + sMonth + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Month"));
                }
                bgPeriodMonth.setBeginDate(this.helper.getStartDate(this.helper.getFirstDayOfMonth(Year, month)));
                bgPeriodMonth.setEndDate(this.helper.getBeoverDate(this.helper.getLastDayOfMonth(Year, month)));
                bgPeriodMonth.setPeriodType(BgPeriodEnum.MONTH);
                bgPeriodMonth.setYear(Year);
                bgPeriodMonth.setHalfYear(bgPeriodQuarter.getHalfYear());
                bgPeriodMonth.setQuarter(Quarter);
                bgPeriodMonth.setMonth(month);
                bgPeriodMonth.setLevel(4);
                bgPeriodMonth.setShowLevel(bgPeriodQuarter.getShowLevel() + i * 100);
                bgPeriodMonth.setParent(bgPeriodQuarter);
            }
            bgPeriodMonth.setIsLeaf(isLeaf);
            this.processTable(bgPeriodMonth);
            if (this.kDCheckMWeek.isSelected()) {
                this.processMonthWeek(Year, month, bgPeriodMonth);
            }
            this.processDay(Year, Quarter, month, bgPeriodMonth);
            this.processTenDays(Year, Quarter, month, bgPeriodMonth);
        }
    }

    protected void processDay(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth) {
    }

    protected void processTenDays(int Year, int Quarter, int Month, BgPeriodInfo bgPeriodMonth) {
    }

    private void processMonthWeek(int year, int Month, BgPeriodInfo bgPeriodMonth) {
        String Week = null;
        BgPeriodInfo bgPeriodMonthWeek = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new CalendarHelper().getLastDayOfMonth(year, Month));
        int w = calendar.get(4);
        for (int i = 1; i <= w; ++i) {
            Week = this.df.format(i);
            String WeekNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + Week + "MW").toString();
            bgPeriodMonthWeek = this.periodMap.get(WeekNumber);
            if (bgPeriodMonthWeek == null) {
                bgPeriodMonthWeek = new BgPeriodInfo();
                bgPeriodMonthWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodMonthWeek.getBOSType()));
                bgPeriodMonthWeek.setNumber(WeekNumber);
                bgPeriodMonthWeek.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + WeekNumber);
                if (this.locale.equals(this.sLocale)) {
                    bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.sLocale) + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"), this.sLocale);
                    bgPeriodMonthWeek.setName(STConverter.sc2tc((String)bgPeriodMonthWeek.getName(this.sLocale)), this.tLocale);
                } else if (this.locale.equals(this.tLocale)) {
                    bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.tLocale) + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"), this.tLocale);
                    bgPeriodMonthWeek.setName(STConverter.tc2sc((String)bgPeriodMonthWeek.getName(this.tLocale)), this.sLocale);
                } else {
                    bgPeriodMonthWeek.setName(bgPeriodMonth.getName() + Week + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week"));
                }
                bgPeriodMonthWeek.setBeginDate(this.helper.getStartDate(BgPeriodHelper.getMonthWeekFirstDay(year, Month, i)));
                bgPeriodMonthWeek.setEndDate(this.helper.getBeoverDate(BgPeriodHelper.getMonthWeekLastDay(year, Month, i)));
                bgPeriodMonthWeek.setPeriodType(BgPeriodEnum.MWEEK);
                bgPeriodMonthWeek.setYear(year);
                bgPeriodMonthWeek.setHalfYear(bgPeriodMonth.getHalfYear());
                bgPeriodMonthWeek.setMonth(Month);
                bgPeriodMonthWeek.setWeek(i);
                bgPeriodMonthWeek.setLevel(5);
                bgPeriodMonthWeek.setShowLevel(bgPeriodMonth.getShowLevel() + 100 + i);
                bgPeriodMonthWeek.setIsLeaf(true);
                bgPeriodMonthWeek.setParent(bgPeriodMonth);
            }
            this.processTable(bgPeriodMonthWeek);
        }
    }

    protected void processTable(BgPeriodInfo bgPeriodInfo) {
        IRow row = null;
        NumberExpandInfo numberExpandInfo = null;
        row = this.kDTable.addRow();
        if (row != null) {
            row.setUserObject((Object)bgPeriodInfo);
            row.getCell(0).setValue((Object)bgPeriodInfo.getNumber());
            row.getCell(1).setValue((Object)bgPeriodInfo.getName());
            row.getCell(2).setValue((Object)bgPeriodInfo.getBeginDate());
            row.getCell(3).setValue((Object)bgPeriodInfo.getEndDate());
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setLevel(bgPeriodInfo.getLevel());
            numberExpandInfo.setLeaf(bgPeriodInfo.isIsLeaf());
            numberExpandInfo.setLongNumber(bgPeriodInfo.getLongNumber());
            numberExpandInfo.setNumber(bgPeriodInfo.getNumber());
            numberExpandInfo.setExpandStatus(true);
            row.getCell(0).setValue((Object)numberExpandInfo);
        }
    }

    protected void showPeriodPanel() {
        this.kDPanelEnd.setVisible(true);
        this.kDButEndCancel.setVisible(true);
        this.kDButEndPrevious.setVisible(true);
        this.kDButEndFinish.setVisible(true);
        this.kDPanelEnd.updateUI();
        this.kDProgressBar.setValue(0);
        this.kDProgressBar.setMinimum(0);
    }

    protected void hidePeriodPanel() {
        this.kDPanelEnd.setVisible(false);
        this.kDButEndCancel.setVisible(false);
        this.kDButEndPrevious.setVisible(false);
        this.kDButEndFinish.setVisible(false);
        this.kDPanelEnd.updateUI();
    }

    protected void disablePeriodPanel() {
        this.kDButEndCancel.setEnabled(false);
        this.kDButEndPrevious.setEnabled(false);
        this.kDButEndFinish.setEnabled(false);
    }

    @Override
    protected void kDButEndPrevious_actionPerformed(ActionEvent e) throws Exception {
        super.kDButEndPrevious_actionPerformed(e);
        this.hidePeriodPanel();
        this.showNaturePanel();
    }

    @Override
    protected void kDButEndCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButEndCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void kDButEndFinish_actionPerformed(ActionEvent e) throws Exception {
        super.kDButEndFinish_actionPerformed(e);
        this.disablePeriodPanel();
        this.periodProcess();
    }

    protected void periodProcess() {
        BarThread process = new BarThread();
        process.start();
    }

    @Override
    protected void kDTable_tableClicked(KDTMouseEvent e) throws Exception {
        NumberExpandInfo numberExpandInfo;
        int rowIndex;
        IRow row;
        int colIndex;
        super.kDTable_tableClicked(e);
        if (e.getClickCount() == 1 && (colIndex = e.getColIndex()) == 0 && (row = this.kDTable.getRow(rowIndex = e.getRowIndex())) != null && (numberExpandInfo = (NumberExpandInfo)row.getCell(0).getValue()) != null && this.render.inRect(numberExpandInfo, e.getX(), e.getY())) {
            this.setTreeDisplayStyle(row, numberExpandInfo);
        }
    }

    private void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) {
        if (row == null || expandInfo == null) {
            return;
        }
        if (!expandInfo.isLeaf()) {
            this.kDTable.setRefresh(false);
            this.expandTable(row, expandInfo);
            this.kDTable.setRefresh(true);
            this.kDTable.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo numberExpandInfo) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getLongNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            int rowCount = this.kDTable.getRowCount();
            for (int rowIndex = row.getRowIndex() + 1; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.kDTable.getRow(rowIndex)).getCell(0).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                this.expandChild(child, expandInfo);
            }
        }
    }

    private int expandChild(IRow row, NumberExpandInfo parentExpandInfo) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.kDTable.getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getLongNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.kDTable.getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(0).getValue();
                number = childExpandInfo.getLongNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    protected void showPersonPanel() {
        this.kDPanelPersonalEnd.setEnabled(true);
        this.kDPanelPersonalEnd.setVisible(true);
        this.btnCancel.setVisible(true);
        this.btnNext.setVisible(true);
        this.btnPrevious.setVisible(true);
        this.kDPanelPersonalEnd.updateUI();
    }

    protected void hidePersonPanel() {
        this.kDPanelPersonalEnd.setEnabled(false);
        this.kDPanelPersonalEnd.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPrevious.setVisible(false);
        this.kDPanelPersonalEnd.updateUI();
    }

    class BarThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int iYear = Integer.valueOf(BgPeriodEditUI.this.kDSpinner.getValue().toString());
            int rowCount = BgPeriodEditUI.this.kDTable.getRowCount();
            BgPeriodEditUI.this.kDProgressBar.setMaximum(rowCount);
            IBgPeriod iBgPeriod = null;
            BgPeriodInfo bgPeriodInfo = null;
            try {
                iBgPeriod = BgPeriodEditUI.this.getBizInterface();
                for (int i = 0; i < rowCount; ++i) {
                    bgPeriodInfo = (BgPeriodInfo)BgPeriodEditUI.this.kDTable.getRow(i).getUserObject();
                    if (bgPeriodInfo != null) {
                        if (this.checkPeriodInfo(bgPeriodInfo)) {
                            iBgPeriod.addnew(bgPeriodInfo);
                        } else {
                            iBgPeriod.update((IObjectPK)new ObjectStringPK(bgPeriodInfo.getId().toString()), bgPeriodInfo);
                        }
                    }
                    BgPeriodEditUI.this.kDProgressBar.setValue(i);
                }
            }
            catch (Exception ex) {
                BgPeriodEditUI.this.handUIExceptionAndAbort(ex);
            }
            finally {
                if (BgPeriodEditUI.this.listUI != null) {
                    BgPeriodEditUI.this.listUI.reQueryYearPeriod(iYear);
                }
                BgPeriodEditUI.this.getUIWindow().close();
            }
        }

        private boolean checkPeriodInfo(BgPeriodInfo bgPeriodInfo) {
            return !BgPeriodEditUI.this.periodMap.containsKey(bgPeriodInfo.getNumber());
        }
    }
}

