/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeCollection;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodF7ListUI;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.client.NumberExpendRender;
import com.kingdee.eas.ma.base.client.utils.IViewDimensionMemberF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDefaultHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class BgPeriodF7ListUI
extends AbstractBgPeriodF7ListUI
implements IViewDimensionMemberF7 {
    private static final long serialVersionUID = -4834502664024740995L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodF7ListUI.class);
    private BgPeriodTypeInfo bgPeriodType = null;
    protected static final String COL_ID = "id";
    protected static final String COL_NUMBER = "number";
    protected static final String COL_NAME = "name";
    protected static final String COL_ALIAS = "alias";
    protected static final String COL_BDATE = "beginDate";
    protected static final String COL_EDATE = "endDate";
    private BgPeriodDispInfo year = null;
    public static final String ALLOW_SORT = "ALLOW_SORT";
    private boolean isCanceled = true;
    protected CalendarHelper calendar = new CalendarHelper();
    protected NumberExpendRender render = new NumberExpendRender(1);
    private Date beginDate = null;
    private Date endDate = null;
    private Set<String> bgPeriodTypeNumbers = null;
    public static final String KEY_BgPeriodTypeNumbers = "bgPeriodTypeNumbers";
    protected BigDecimal versionNum = BigDecimal.ZERO;
    public static Color lockColor = new Color(230, 230, 230);

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public BgPeriodF7ListUI() throws Exception {
    }

    public BgPeriodF7ListUI(boolean isMultiSelect) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("versionNum") instanceof BigDecimal) {
            this.versionNum = (BigDecimal)this.getUIContext().get("versionNum");
        }
        this.beginDate = (Date)this.getUIContext().get(COL_BDATE);
        this.endDate = (Date)this.getUIContext().get(COL_EDATE);
        this.bgPeriodTypeNumbers = (Set)this.getUIContext().get(KEY_BgPeriodTypeNumbers);
        this.initAction();
        this.loadBgPeriodType();
        if (Boolean.FALSE.equals(this.getUIContext().get(ALLOW_SORT))) {
            this.btnTop.setEnabled(false);
            this.btnBottom.setEnabled(false);
            this.btnDown.setEnabled(false);
            this.btnUp.setEnabled(false);
        }
    }

    protected void loadBgPeriodType() {
        try {
            this.bgPeriodTypeNumbers = (Set)this.getUIContext().get(KEY_BgPeriodTypeNumbers);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add("*");
            SorterItemInfo info0 = new SorterItemInfo("simplename");
            info0.setSortType(SortType.ASCEND);
            evi.getSorter().add(info0);
            SorterItemInfo info1 = new SorterItemInfo("isSysdata");
            info1.setSortType(SortType.DESCEND);
            evi.getSorter().add(info1);
            SorterItemInfo info2 = new SorterItemInfo(COL_NUMBER);
            info2.setSortType(SortType.ASCEND);
            evi.getSorter().add(info2);
            if (this.bgPeriodTypeNumbers == null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, (Object)"Select FTypeId FROM T_Mbg_BgPeriodDisp", CompareType.INNER));
            } else if (this.bgPeriodTypeNumbers.isEmpty()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, (Object)BgBaseConstants.nullID));
            } else {
                evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_NUMBER, this.bgPeriodTypeNumbers, CompareType.INCLUDE));
            }
            BgPeriodTypeCollection coll = BgPeriodTypeFactory.getRemoteInstance().getBgPeriodTypeCollection(evi);
            Object oldBgPeriodType = this.cbxBgPeriodType.getSelectedItem();
            this.cbxBgPeriodType.removeAllItems();
            if (coll != null && !coll.isEmpty()) {
                this.cbxBgPeriodType.addItems(coll.toArray());
                if (oldBgPeriodType instanceof BgPeriodTypeInfo) {
                    this.cbxBgPeriodType.setSelectedItem(oldBgPeriodType);
                } else {
                    this.selectDefaultBgPeriodType();
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
    }

    protected void selectDefaultBgPeriodType() {
        String number;
        BgPeriodInfo[] objs = (BgPeriodInfo[])this.getUIContext().get(BgBaseConstants.BGPERIOD_INFO);
        Object bgSchemeID = this.getUIContext().get(BgBaseConstants.BGSCHEME_ID);
        String typeNum = null;
        if (bgSchemeID != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            String sql = "SELECT dim.FDEFMEMBERID FROM T_Mbg_BgScheme scheme  join T_Mbg_BgDimSettings dim on dim.FBgschemeID = scheme.FID where scheme.FID = '" + bgSchemeID.toString() + "' and dim.FDIMNUMBER ='BG_Period'";
            evi.getFilter().getFilterItems().add(new FilterItemInfo(COL_ID, (Object)sql, CompareType.INNER));
            try {
                BgPeriodCollection coll = BgPeriodFactory.getRemoteInstance().getBgPeriodCollection(evi);
                if (coll != null && coll.size() > 0) {
                    String number2 = coll.get(0).getNumber();
                    typeNum = number2.split("\\.")[0];
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else if (objs != null) {
            if (objs.length == 1) {
                number = objs[0].getNumber();
                typeNum = number.split("\\.")[0];
            }
        } else {
            try {
                if (this.getData() instanceof BgPeriodInfo[] && (objs = (BgPeriodInfo[])this.getData()).length == 1) {
                    number = objs[0].getNumber();
                    typeNum = number.split("\\.")[0];
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.handUIExceptionAndAbort(e);
            }
        }
        int defaultIndex = -1;
        for (int i = 0; i < this.cbxBgPeriodType.getItemCount(); ++i) {
            BgPeriodTypeInfo itemAt = (BgPeriodTypeInfo)this.cbxBgPeriodType.getItemAt(i);
            if (typeNum != null && typeNum.equals(itemAt.getNumber())) {
                defaultIndex = i;
                break;
            }
            if (!FiscalYearEnum.STANDARDYEAR.equals((Object)itemAt.getFiscalYear()) || itemAt.getBgPeriodEnum(true) == 8 || 4 != itemAt.getBgPeriodEnum(false)) continue;
            defaultIndex = i;
            break;
        }
        if (defaultIndex >= 0 && defaultIndex != this.cbxBgPeriodType.getSelectedIndex()) {
            this.cbxBgPeriodType.setSelectedIndex(defaultIndex);
        }
    }

    protected void loadYear() throws BOSException {
        logger.error((Object)"******************************* loadYear **********************************");
        this.year = null;
        this.cbxYear.removeAllItems();
        this.beginDate = (Date)this.getUIContext().get(COL_BDATE);
        this.endDate = (Date)this.getUIContext().get(COL_EDATE);
        BgPeriodTypeInfo type = this.getSelectBgPeriodType();
        if (type.getBgPeriodEnum(false) == 0) {
            this.cbxYear.setAccessAuthority(0);
            this.lblYear.setEnabled(false);
            this.execQuery();
        } else {
            BgPeriodDispCollection yearPeriod;
            this.cbxYear.setAccessAuthority(0);
            this.lblYear.setEnabled(true);
            BgPeriodDispInfo disp = new BgPeriodDispInfo();
            disp.setId(BOSUuid.read((String)BgBaseConstants.nullID));
            disp.setName(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"ALL"));
            disp.setNumber("all");
            this.cbxYear.addItem((Object)disp);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(new FilterInfo());
            evi.setSelector(new SelectorItemCollection());
            evi.setSorter(new SorterItemCollection());
            evi.getSelector().add(COL_ID);
            evi.getSelector().add("bgPeriod.year");
            evi.getSelector().add(COL_NUMBER);
            evi.getSelector().add(COL_NAME);
            evi.getSelector().add("longNumber");
            evi.getSelector().add("periodType");
            evi.getSelector().add(COL_BDATE);
            evi.getSelector().add(COL_EDATE);
            evi.getSelector().add("type.id");
            evi.getSelector().add("type.fiscalYear");
            SorterItemInfo sic = new SorterItemInfo("bgPeriod.year");
            sic.setSortType(SortType.ASCEND);
            evi.getSorter().add(sic);
            HashSet<Integer> types = new HashSet<Integer>();
            types.add(16);
            types.add(1);
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.periodType", types, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", (Object)type.getId().toString()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("parent.id", null, CompareType.EQUALS));
            if (this.beginDate != null && this.endDate != null) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
            }
            if ((yearPeriod = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi)) != null && !yearPeriod.isEmpty()) {
                int defaultIndex = -1;
                int currYear = BgDefaultHelper.getCurrentYear(null, null);
                for (int i = 0; i < yearPeriod.size(); ++i) {
                    if (yearPeriod.get(i).getBgPeriod().getYear() == currYear) {
                        defaultIndex = i + 1;
                    }
                    this.cbxYear.addItem((Object)yearPeriod.get(i));
                }
                if (defaultIndex >= 0) {
                    this.cbxYear.setSelectedIndex(defaultIndex);
                } else if (this.cbxYear.getItemCount() > 0) {
                    this.cbxYear.setSelectedIndex(this.cbxYear.getItemCount() - 1);
                }
            }
        }
    }

    private BgPeriodTypeInfo getSelectBgPeriodType() {
        return (BgPeriodTypeInfo)this.cbxBgPeriodType.getSelectedItem();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.tblMain.checkParsed();
        this.tblRight.checkParsed();
        this.tblRight.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn(COL_NUMBER).setRenderer((IBasicRender)this.render);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    private void initAction() {
        this.tblMain.getActionMap().remove("SelectLeftCell");
        this.tblMain.getActionMap().remove("SelectRightCell");
        this.tblRight.getActionMap().remove("SelectLeftCell");
        this.tblRight.getActionMap().remove("SelectRightCell");
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExpand.setVisible(true);
        this.btnExpand.setEnabled(true);
        this.btnConstriction.setVisible(true);
        this.btnConstriction.setEnabled(true);
    }

    public KDTable getTable() {
        return this.tblMain;
    }

    public void loadPeriodYear(boolean isSelect, int year, int periodType) throws Exception {
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int start = e.getFirstRow();
                int end = e.getLastRow();
                BgPeriodF7ListUI.this.setTableDisplayStyle(start, end);
            }
        });
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo expandInfo) throws Exception {
        boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
        if (!isLeaf) {
            this.tblMain.setRefresh(false);
            this.expandTable(row, expandInfo, expandInfo.isExpandStatus());
            this.tblMain.setRefresh(true);
            this.tblMain.reLayoutAndPaint();
        }
    }

    private void expandTable(IRow row, NumberExpandInfo parentExpandInfo, boolean isExpandStatus) throws Exception {
        int rowIndex;
        if (row == null) {
            return;
        }
        IRow child = null;
        int parentLevel = parentExpandInfo.getLevel();
        String longNumber = null;
        String parentLongNumber = parentExpandInfo.getLongNumber();
        NumberExpandInfo expandInfo = null;
        int rowCount = this.tblMain.getRowCount3();
        if (isExpandStatus) {
            parentExpandInfo.setExpandStatus(false);
            for (rowIndex = row.getRowIndex() + 1; rowIndex < rowCount; ++rowIndex) {
                child = this.tblMain.getRow(rowIndex);
                if (child == null || child.getCell(COL_NUMBER) == null) {
                    return;
                }
                expandInfo = (NumberExpandInfo)child.getCell(COL_NUMBER).getValue();
                longNumber = expandInfo.getLongNumber();
                if (longNumber.startsWith(parentLongNumber + "!")) {
                    expandInfo.setExpandStatus(false);
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            parentExpandInfo.setExpandStatus(true);
            while (rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.tblMain.getRow(rowIndex)).getCell(COL_NUMBER).getValue()).getLongNumber()).startsWith(parentLongNumber + "!")) {
                if (expandInfo.getLevel() - parentLevel == 1) {
                    child.getStyleAttributes().setHided(false);
                    if (!expandInfo.isLeaf()) {
                        expandInfo.setExpandStatus(false);
                    }
                }
                ++rowIndex;
            }
        }
    }

    private void setTableDisplayStyle(int startup, int end) {
        IRow row = null;
        int level = 0;
        Object obj = null;
        NumberExpandInfo expandInfo = null;
        int count = end;
        for (int i = startup; i <= count; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            String id = (String)row.getCell(COL_ID).getValue();
            obj = row.getCell(COL_NUMBER).getValue();
            if (!(obj instanceof String)) {
                return;
            }
            String number = (String)obj;
            String longNumber = row.getCell("longNumber").getValue().toString();
            level = (Integer)row.getCell("level").getValue();
            boolean isLeaf = (Boolean)row.getCell("isLeaf").getValue();
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(id);
            expandInfo.setNumber(number);
            expandInfo.setLongNumber(longNumber);
            expandInfo.setLevel(level);
            expandInfo.setLeaf(isLeaf);
            expandInfo.setExpandStatus(true);
            row.getCell(COL_NUMBER).setValue((Object)expandInfo);
        }
    }

    @Override
    protected void cbxBgPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxBgPeriodType_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if (this.cbxBgPeriodType.getSelectedItem() != null) {
            BgPeriodTypeInfo newType = this.getSelectBgPeriodType();
            if (this.bgPeriodType == null || !this.bgPeriodType.getId().equals((Object)newType.getId())) {
                this.bgPeriodType = newType;
                this.loadYear();
            }
        }
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        int selectIndex = this.cbxYear.getSelectedIndex();
        BgPeriodTypeInfo periodType = this.getSelectBgPeriodType();
        if (periodType != null) {
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            if (this.cbxYear.getItemAt(selectIndex) instanceof BgPeriodDispInfo) {
                BgPeriodDispInfo bgPeriodInfo;
                this.year = bgPeriodInfo = (BgPeriodDispInfo)this.cbxYear.getItemAt(selectIndex);
                if (bgPeriodInfo.getId().toString().equals(BgBaseConstants.nullID)) {
                    items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                    if (this.beginDate != null && this.endDate != null) {
                        FilterItemInfo filterWithSchemeDate = this.filterWithSchemeDate();
                        filter.getFilterItems().add(filterWithSchemeDate);
                        filter.setMaskString("#0 AND #1 AND #2");
                    } else {
                        filter.setMaskString("#0");
                    }
                } else if (this.beginDate != null && this.endDate != null) {
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(bgPeriodInfo.getLongNumber() + "%"), CompareType.LIKE));
                    FilterItemInfo filterWithSchemeDate = this.filterWithSchemeDate();
                    filter.getFilterItems().add(filterWithSchemeDate);
                } else {
                    items.add(new FilterItemInfo("longNumber", (Object)(bgPeriodInfo.getLongNumber() + "!%"), CompareType.LIKE));
                    items.add(new FilterItemInfo("longNumber", (Object)bgPeriodInfo.getLongNumber(), CompareType.EQUALS));
                    filter.setMaskString("#0 or #1 ");
                }
            } else {
                this.year = null;
                if (this.beginDate != null && this.endDate != null && this.getSelectBgPeriodType().getBgPeriodEnum(false) != 0) {
                    items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                    filter.setMaskString("#0 AND #1 AND #2");
                } else {
                    CalendarHelper helper = new CalendarHelper();
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String beginDateString = df.format(this.beginDate);
                    String endDateString = df.format(this.endDate);
                    String defaultBeginDateString = df.format(helper.getFirstDayOfYear(2000));
                    String defaultEndDateString = df.format(helper.getLastDayOfYear(2099));
                    String filterString = "select fid from T_MBG_BgPeriodDisp where ftypeId ='" + periodType.getId().toString() + "' and (((fbeginDate <={ts'" + endDateString + "'} and fbeginDate>={ts'" + beginDateString + "'}) or (fEndDate <={ts'" + endDateString + "'} and fendDate>={ts'" + beginDateString + "'}) ) or (fbeginDate ={ts'" + defaultBeginDateString + "'} and fendDate={ts'" + defaultEndDateString + "'}))";
                    filter.getFilterItems().add(new FilterItemInfo(COL_ID, (Object)filterString, CompareType.INNER));
                }
            }
            viewInfo.setFilter(filter);
        } else {
            BgCommHelper.addFilterItem(viewInfo.getFilter(), new FilterItemInfo(COL_ID, (Object)BgBaseConstants.nullID));
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    @Override
    protected void cbxYear_itemStateChanged(ItemEvent e) throws Exception {
        BgPeriodDispInfo bgPeriod;
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        if ((this.cbxYear.getSelectedItem() instanceof BgPeriodDispInfo || !this.cbxYear.isEnabled()) && (bgPeriod = (BgPeriodDispInfo)this.cbxYear.getSelectedItem()) != this.year) {
            this.year = bgPeriod;
            this.execQuery();
        }
    }

    protected void execQuery() {
        if (this.cbxBgPeriodType.getSelectedItem() == null || this.cbxYear.isEnabled() && this.cbxYear.getSelectedItem() == null) {
            return;
        }
        this.chkYear.setSelected(false, false);
        this.chkHalfYear.setSelected(false, false);
        this.chkQuarter.setSelected(false, false);
        this.chkMonth.setSelected(false, false);
        this.chkMWeek.setSelected(false, false);
        this.chkYWeek.setSelected(false, false);
        super.execQuery();
        this.selectFirstRow();
    }

    @Override
    public Object getData() throws BOSException, EASBizException {
        return this.getBgPeriodCollection();
    }

    public BgPeriodCollection getBgPeriodCollection() {
        int i;
        String number;
        IRow row;
        if (this.tblRight.getRowCount() == 0) {
            return null;
        }
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        for (int i2 = 0; i2 < this.tblRight.getRowCount(); ++i2) {
            row = this.tblRight.getRow(i2);
            number = (String)row.getCell(COL_NUMBER).getValue();
            if (BgPeriodNVariableHelper.checkCanConvert(number)) continue;
            bgPeriodNumbers.add(number);
        }
        HashMap<String, BgPeriodDispInfo> bgPeriodMap = new HashMap<String, BgPeriodDispInfo>();
        if (!bgPeriodNumbers.isEmpty()) {
            try {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                FilterItemCollection items = filter.getFilterItems();
                items.add(new FilterItemInfo(COL_NUMBER, bgPeriodNumbers, CompareType.INCLUDE));
                view.getSorter().add(new SorterItemInfo("longNumber"));
                view.setFilter(filter);
                BgPeriodDispCollection col = this.getBgPeriodInterface().getBgPeriodDispCollection(view);
                if (col != null && !col.isEmpty()) {
                    for (i = 0; i < col.size(); ++i) {
                        bgPeriodMap.put(col.get(i).getNumber(), col.get(i));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        BgPeriodCollection result = new BgPeriodCollection();
        BgPeriodInfo info = null;
        BgPeriodDispInfo dispInfo = null;
        BigDecimal verNum = BigDecimal.ZERO;
        for (i = 0; i < this.tblRight.getRowCount(); ++i) {
            row = this.tblRight.getRow(i);
            number = (String)row.getCell(COL_NUMBER).getValue();
            verNum = this.versionNum;
            if (row.getUserObject() instanceof BigDecimal) {
                verNum = (BigDecimal)row.getUserObject();
            }
            if (BgPeriodNVariableHelper.checkCanConvert(number)) {
                info = new BgPeriodInfo();
                info.setNumber(number);
                info.setName((String)row.getCell(COL_NAME).getValue());
                info.setDisplayName((String)row.getCell(COL_ALIAS).getValue());
                info.setBigDecimal("versionNum", verNum);
                result.add(info);
                continue;
            }
            dispInfo = (BgPeriodDispInfo)bgPeriodMap.get(number);
            if (row.getCell(COL_ALIAS).getValue() != null && dispInfo.getAlias().equals("\u4e00")) {
                dispInfo.setAlias((String)row.getCell(COL_ALIAS).getValue());
            }
            if (dispInfo == null) continue;
            info = dispInfo.toBgPeriodInfo();
            info.setBigDecimal("versionNum", verNum);
            result.add(info);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    protected IBgPeriodDisp getBgPeriodInterface() throws BOSException {
        return BgPeriodDispFactory.getRemoteInstance();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    protected void chkYear_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.YEAR, this.chkYear.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_YEAE, this.chkYear.isSelected());
    }

    @Override
    protected void chkHalfYear_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.HALFYEAR, this.chkHalfYear.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_HALFYEAR, this.chkHalfYear.isSelected());
    }

    @Override
    protected void chkQuarter_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.QUARTER, this.chkQuarter.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_QUARTER, this.chkQuarter.isSelected());
    }

    @Override
    protected void chkMonth_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.MONTH, this.chkMonth.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_MONTH, this.chkMonth.isSelected());
    }

    @Override
    protected void chkMWeek_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.MWEEK, this.chkMWeek.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_MWEEK, this.chkMWeek.isSelected());
    }

    @Override
    protected void chkYWeek_actionPerformed(ActionEvent e) throws Exception {
        this.selectBgPeriod(BgPeriodEnum.YWEEK, this.chkYWeek.isSelected());
        this.selectBgPeriod(BgPeriodEnum.PERSONAL_YWEEK, this.chkYWeek.isSelected());
    }

    protected void selectBgPeriod(BgPeriodEnum periodType, boolean isSelected) throws Exception {
        if (isSelected) {
            this.btnExpand_actionPerformed(null);
        }
        for (int r = 0; r < this.tblMain.getBody().size(); ++r) {
            IRow row = this.tblMain.getRow(r);
            BizEnumValueDTO type = (BizEnumValueDTO)row.getCell("periodEnum").getValue();
            if (periodType.getValue() != type.getInt()) continue;
            if (isSelected) {
                this.tblMain.getSelectManager().add(r, 0);
                continue;
            }
            KDTSelectBlock block = new KDTSelectBlock(r, 0, r, 0, 2);
            this.tblMain.getSelectManager().unselect(block, true);
        }
    }

    @Override
    protected void btnExpand_actionPerformed(ActionEvent e) throws Exception {
        super.btnExpand_actionPerformed(e);
        int rowSize = this.tblMain.getRowCount();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell(COL_NUMBER).getValue();
            expandInfo.setExpandStatus(true);
            row.getStyleAttributes().setHided(false);
        }
    }

    @Override
    protected void btnConstriction_actionPerformed(ActionEvent e) throws Exception {
        super.btnConstriction_actionPerformed(e);
        int rowSize = this.tblMain.getRowCount();
        if (rowSize == 0) {
            return;
        }
        IRow row = null;
        NumberExpandInfo expandInfo = null;
        for (int i = 0; i < rowSize; ++i) {
            row = this.tblMain.getRow(i);
            if (row == null) continue;
            expandInfo = (NumberExpandInfo)row.getCell(COL_NUMBER).getValue();
            expandInfo.setExpandStatus(false);
            if (expandInfo.getLongNumber().equals(expandInfo.getNumber())) continue;
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.doubleClick();
            return;
        }
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            return;
        }
        if (e.getType() == 1) {
            NumberExpandInfo expandInfo;
            IRow row;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            if (clickCount == 1 && (row = this.tblMain.getRow(rowIndex)) != null && colIndex == this.tblMain.getColumn(COL_NUMBER).getColumnIndex() && this.render.inRect(expandInfo = (NumberExpandInfo)row.getCell(COL_NUMBER).getValue(), e.getX(), e.getY())) {
                try {
                    this.setTreeDisplayStyle(row, expandInfo);
                }
                catch (Exception e1) {
                    logger.error((Object)"", (Throwable)e1);
                    this.handUIExceptionAndAbort(e1);
                }
            }
        }
        super.tblMain_tableClicked(e);
    }

    protected void doubleClick() throws Exception {
        int currRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (currRowIndex >= 0) {
            ArrayList<Integer> rows = new ArrayList<Integer>();
            rows.add(currRowIndex);
            this.add(rows);
        }
    }

    @Override
    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        super.btnAdd_actionPerformed(e);
        List<Integer> rows = BgCommCHelper.getSelectRowIndexes(this.tblMain);
        this.add(rows);
    }

    @Override
    protected void btnAddAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnAddAll_actionPerformed(e);
        List<Integer> rows = BgCommCHelper.getSelectAllRowIndexes(this.tblMain);
        this.add(rows);
    }

    protected void add(List<Integer> rows) throws EASBizException, BOSException {
        IRow rowLeft;
        IRow rowRight;
        int i;
        if (rows == null) {
            return;
        }
        Collections.sort(rows);
        HashSet<String> selectedNumbers = new HashSet<String>();
        HashSet<String> allNumbers = new HashSet<String>();
        for (i = 0; i < this.tblRight.getRowCount(); ++i) {
            rowRight = this.tblRight.getRow(i);
            selectedNumbers.add((String)rowRight.getCell(COL_NUMBER).getValue());
        }
        allNumbers.addAll(selectedNumbers);
        for (i = 0; i < rows.size(); ++i) {
            rowLeft = this.tblMain.getRow(rows.get(i).intValue());
            String number = null;
            if (!(rowLeft.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo)) continue;
            number = ((NumberExpandInfo)rowLeft.getCell(COL_NUMBER).getValue()).getNumber();
            allNumbers.add(number);
        }
        if (allNumbers.size() > 1) {
            BgPeriodDispFactory.getRemoteInstance().checkPeriodType(allNumbers, true);
        }
        boolean isOnlyLeaf = Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf"));
        Set<String> leafNumbers = this.getLeafBgPeriods();
        StringBuffer cannotAdjustStr = new StringBuffer();
        Set canAdjustNumbers = null;
        if (this.getUIContext().get("canAdjustNumbers") != null) {
            canAdjustNumbers = (Set)this.getUIContext().get("canAdjustNumbers");
        }
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            rowLeft = this.tblMain.getRow(rows.get(i2).intValue());
            String number = null;
            number = rowLeft.getCell(COL_NUMBER).getValue() instanceof NumberExpandInfo ? ((NumberExpandInfo)rowLeft.getCell(COL_NUMBER).getValue()).getNumber() : (String)rowLeft.getCell(COL_NUMBER).getValue();
            if (selectedNumbers.contains(number) || isOnlyLeaf && !leafNumbers.contains(number)) continue;
            if (canAdjustNumbers != null && !canAdjustNumbers.isEmpty() && !canAdjustNumbers.contains(number)) {
                cannotAdjustStr.append(number).append(",");
                continue;
            }
            rowRight = this.tblRight.addRow();
            rowRight.getCell(COL_NUMBER).setValue((Object)number);
            rowRight.getCell(COL_NAME).setValue(rowLeft.getCell(COL_NAME).getValue());
            rowRight.getCell(COL_ALIAS).setValue(rowLeft.getCell(COL_ALIAS).getValue());
        }
        if (cannotAdjustStr.length() > 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"addPartFaith"), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgAdjustRuleResource", (String)"cannotAdjustPeriodNumber", (Object[])new Object[]{cannotAdjustStr}), (int)1);
        }
    }

    @Override
    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        super.btnDelete_actionPerformed(e);
        this.remove(BgCommCHelper.getSelectRowIndexes(this.tblRight));
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteAll_actionPerformed(e);
        this.remove(BgCommCHelper.getSelectAllRowIndexes(this.tblRight));
    }

    protected void remove(List rows) throws Exception {
        BgCommCHelper.removeRows(this.tblRight, rows);
    }

    @Override
    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        this.isCanceled = false;
        this.destroyWindow();
    }

    @Override
    protected void btnEnd_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(e);
    }

    @Override
    protected void btnUp_actionPerformed(ActionEvent e) throws Exception {
        super.btnUp_actionPerformed(e);
        BgCommCHelper.moveUp(this.tblRight);
    }

    @Override
    protected void btnTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnTop_actionPerformed(e);
        BgCommCHelper.moveTop(this.tblRight);
    }

    @Override
    protected void btnDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnDown_actionPerformed(e);
        BgCommCHelper.moveDown(this.tblRight);
    }

    @Override
    protected void btnBottom_actionPerformed(ActionEvent e) throws Exception {
        super.btnBottom_actionPerformed(e);
        BgCommCHelper.moveBottom(this.tblRight);
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgPeriodFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    public void registerPopupMenuManager(JComponent comp, PopupMenuManager mgr) {
        super.registerPopupMenuManager(comp, mgr);
    }

    protected boolean isAllowCommonMenu() {
        return false;
    }

    protected boolean isAllowOAMenu() {
        return false;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void reShow() {
        this.isCanceled = true;
        this.show();
    }

    @Override
    public void dataChanged(DataChangeEvent eventObj) {
    }

    protected void setSelectCombox(Set<String> bgPeriodNumbers) {
        try {
            String bgPeriodTypeNumber = null;
            int year = -1;
            if (bgPeriodNumbers != null && !bgPeriodNumbers.isEmpty()) {
                for (String bgPeriodNumber : bgPeriodNumbers) {
                    int index = bgPeriodNumber.indexOf(".");
                    if (index <= 0) continue;
                    String tmp = bgPeriodNumber.substring(0, index);
                    if (bgPeriodTypeNumber != null && !bgPeriodTypeNumber.equals(tmp)) {
                        bgPeriodTypeNumber = null;
                        year = -1;
                        break;
                    }
                    bgPeriodTypeNumber = tmp;
                    if (year == -2 || !Pattern.matches("\\d{4}Y", tmp = bgPeriodNumber.indexOf(".", index + 1) > 0 ? bgPeriodNumber.substring(index + 1, bgPeriodNumber.indexOf(".", index + 1)) : bgPeriodNumber.substring(index + 1))) continue;
                    int tmpYear = Integer.parseInt(tmp.substring(0, 4));
                    if (year != -1 && tmpYear != year) {
                        year = -2;
                    }
                    year = tmpYear;
                }
            }
            if (bgPeriodTypeNumber == null) {
                this.selectDefaultBgPeriodType();
            } else {
                int i;
                for (i = 0; i < this.cbxBgPeriodType.getItemCount(); ++i) {
                    if (!bgPeriodTypeNumber.equals(((BgPeriodTypeInfo)this.cbxBgPeriodType.getItemAt(i)).getNumber()) || this.cbxBgPeriodType.getSelectedIndex() == i) continue;
                    this.cbxBgPeriodType.setSelectedIndex(i);
                    break;
                }
                if (year < 0) {
                    year = BgDefaultHelper.getCurrentYear(null, null);
                }
                for (i = 0; i < this.cbxYear.getItemCount(); ++i) {
                    if (this.cbxYear.getSelectedIndex() == i || !(this.cbxYear.getItemAt(i) instanceof BgPeriodDispInfo) || ((BgPeriodDispInfo)this.cbxYear.getItemAt(i)).getBgPeriod() == null || ((BgPeriodDispInfo)this.cbxYear.getItemAt(i)).getBgPeriod().getYear() != year) continue;
                    this.cbxYear.setSelectedIndex(i);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            this.handUIExceptionAndAbort(e);
        }
    }

    protected String getName(Object obj) {
        return BgCommCHelper.getStringValue(obj, COL_NAME);
    }

    protected String getNumber(Object obj) {
        return BgCommCHelper.getStringValue(obj, COL_NUMBER);
    }

    protected String getAlias(Object obj) {
        return BgCommCHelper.getStringValue(obj, COL_ALIAS);
    }

    @Override
    public void setMultiSelect(boolean multiSelect) {
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        boolean isOnlyLeaf = Boolean.TRUE.equals(this.getUIContext().get("isOnlyLeaf"));
        if (isOnlyLeaf) {
            int firstIndex = e.getFirstRow();
            int lastIndex = e.getLastRow();
            Set<String> leafNumbers = this.getLeafBgPeriods();
            for (int r = firstIndex; r <= lastIndex; ++r) {
                Object obj = this.tblMain.getCell(r, COL_NUMBER).getValue();
                if (obj == null) continue;
                if (obj instanceof String && !leafNumbers.contains((String)obj)) {
                    this.tblMain.getRow(r).getStyleAttributes().setBackground(BgBaseConstants.LOCK_COLOR);
                    continue;
                }
                if (!(obj instanceof NumberExpandInfo) || leafNumbers.contains(((NumberExpandInfo)obj).getNumber())) continue;
                this.tblMain.getRow(r).getStyleAttributes().setBackground(BgBaseConstants.LOCK_COLOR);
            }
        }
    }

    protected Set<String> getLeafBgPeriods() {
        HashSet<String> leafNumbers = new HashSet<String>();
        BgPeriodTypeInfo periodType = this.getSelectBgPeriodType();
        int selectIndex = this.cbxYear.getSelectedIndex();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)true));
        if (periodType != null) {
            if (selectIndex == -1) {
                items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
            } else if (this.cbxYear.getItemAt(selectIndex) instanceof BgPeriodDispInfo) {
                FilterItemInfo filterWithSchemeDate;
                BgPeriodDispInfo year = (BgPeriodDispInfo)this.cbxYear.getItemAt(selectIndex);
                if (year.getId().toString().equals(BgBaseConstants.nullID)) {
                    items.add(new FilterItemInfo("type.id", (Object)periodType.getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                    if (this.beginDate != null && this.endDate != null) {
                        filterWithSchemeDate = this.filterWithSchemeDate();
                        filter.getFilterItems().add(filterWithSchemeDate);
                        filter.setMaskString("#0 AND #1 AND #2 AND #3 AND #4");
                    } else {
                        filter.setMaskString("#0 AND #1");
                    }
                } else if (this.beginDate != null && this.endDate != null) {
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.beginDate)), CompareType.GREATER_EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.getCurrentlyYear(this.endDate)), CompareType.LESS_EQUALS));
                    filterWithSchemeDate = this.filterWithSchemeDate();
                    filter.getFilterItems().add(filterWithSchemeDate);
                    filter.setMaskString("#0 AND #1 AND #2 AND #3");
                } else {
                    items.add(new FilterItemInfo("longNumber", (Object)(year.getLongNumber() + "!%"), CompareType.LIKE));
                    items.add(new FilterItemInfo("longNumber", (Object)year.getLongNumber(), CompareType.EQUALS));
                    filter.setMaskString("#0 and ( #1 or #2) ");
                }
            }
            try {
                BgPeriodDispCollection colls = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(viewInfo);
                if (colls != null) {
                    for (int i = 0; i < colls.size(); ++i) {
                        leafNumbers.add(colls.get(i).getNumber());
                    }
                }
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        return leafNumbers;
    }

    protected Set<String> getFilterNumbers() {
        if (this.getUIContext().get(BgBaseConstants.BGPERIOD_INFO) != null && this.getUIContext().get(BgBaseConstants.BGPERIOD_INFO) instanceof BgPeriodInfo[]) {
            HashSet<String> numbers = new HashSet<String>();
            BgPeriodInfo[] periods = (BgPeriodInfo[])this.getUIContext().get(BgBaseConstants.BGPERIOD_INFO);
            for (int i = 0; i < periods.length; ++i) {
                numbers.add(periods[i].getNumber());
            }
            return numbers;
        }
        return null;
    }

    protected void checkSelectRow() {
        if (this.tblRight.getSelectManager().getBlocks() == null || this.tblRight.getSelectManager().getBlocks().isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.mbg.client.BgTemplateResource", (String)"checkSelectRow"));
            SysUtil.abort();
        }
    }

    private FilterItemInfo filterWithSchemeDate() {
        StringBuffer sql = new StringBuffer();
        BgPeriodTypeInfo periodType = this.getSelectBgPeriodType();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sql.append("select fid from T_MBG_BgPeriodDisp  where ftypeId ='").append(periodType.getId().toString()).append("'");
        sql.append(" and ((FBeginDate >= {ts'" + format.format(this.beginDate) + "'} and FEndDate <= {ts'" + format.format(this.endDate) + "'})");
        sql.append(" or (FBeginDate <= {ts'" + format.format(this.beginDate) + "'} and FEndDate >= {ts'" + format.format(this.endDate) + "'})");
        sql.append(" or (FBeginDate >= {ts'" + format.format(this.beginDate) + "'} and FBeginDate <= {ts'" + format.format(this.endDate) + "'})");
        sql.append(" or (FEndDate >= {ts'" + format.format(this.beginDate) + "'} and FEndDate <= {ts'" + format.format(this.endDate) + "'}))");
        return new FilterItemInfo(COL_ID, (Object)sql.toString(), CompareType.INNER);
    }

    @Override
    protected void tblRight_tableClicked(KDTMouseEvent e) throws Exception {
        KDTRange range = this.tblRight.getSelectManager().toRange();
        if (range == null || range.size() == 0) {
            return;
        }
        KDTSelectBlock select = null;
        if (range.get(0) instanceof KDTSelectBlock) {
            select = (KDTSelectBlock)range.get(0);
        }
        if (select == null) {
            return;
        }
        boolean isEnableRemove = false;
        for (int rowIndex = select.getBeginRow(); rowIndex <= select.getEndRow(); ++rowIndex) {
            if (this.tblRight.getRow(rowIndex) == null || this.tblRight.getRow(rowIndex).getStyleAttributes().isHided() || !this.isCanRemove(this.tblRight.getRow(rowIndex))) continue;
            isEnableRemove = true;
            break;
        }
        if (isEnableRemove) {
            this.btnDelete.setEnabled(true);
            this.btnDeleteAll.setEnabled(true);
        } else {
            this.btnDelete.setEnabled(false);
            this.btnDeleteAll.setEnabled(false);
        }
    }

    protected boolean isCanRemove(IRow row) {
        if (row == null) {
            return false;
        }
        return !row.getStyleAttributes().getBackground().equals(lockColor);
    }
}

