/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodNSettingUI;
import com.kingdee.eas.ma.base.utils.BgPeriodVariable;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerModel;
import org.apache.log4j.Logger;

public class BgPeriodNSettingUI
extends AbstractBgPeriodNSettingUI {
    private static final long serialVersionUID = -850192395251020484L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodNSettingUI.class);
    public static final String DEFAULT_VALUE_N = "N";
    private boolean isCancel = true;
    private String[] valueOfYear = null;
    private String[] valueOfHalfYear = null;
    private String[] valueOfQuarter = null;
    private String[] valueOfMonth = null;
    private BgPeriodVariable bgPeriodSHelper = null;

    public BgPeriodVariable getBgPeriodVariable() {
        if (this.bgPeriodSHelper == null) {
            this.bgPeriodSHelper = new BgPeriodVariable();
        }
        return this.bgPeriodSHelper;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initListener();
        this.initPeriodCollection();
        this.initPeriod();
    }

    protected void initListener() {
        super.initListener();
        this.enableState(this.selectYear);
        this.year.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((KDRadioButton)arg0.getSource()).isSelected()) {
                    BgPeriodNSettingUI.this.enableState(BgPeriodNSettingUI.this.selectYear);
                }
            }
        });
        this.halfYear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((KDRadioButton)arg0.getSource()).isSelected()) {
                    BgPeriodNSettingUI.this.enableState(BgPeriodNSettingUI.this.selectHalfYear);
                }
            }
        });
        this.quarter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((KDRadioButton)arg0.getSource()).isSelected()) {
                    BgPeriodNSettingUI.this.enableState(BgPeriodNSettingUI.this.selectQuarter);
                }
            }
        });
        this.month.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (((KDRadioButton)arg0.getSource()).isSelected()) {
                    BgPeriodNSettingUI.this.enableState(BgPeriodNSettingUI.this.selectMonth);
                }
            }
        });
    }

    private void enableState(KDSpinner selectMenu) {
        this.selectYear.setEnabled(false);
        this.selectHalfYear.setEnabled(false);
        this.selectQuarter.setEnabled(false);
        this.selectMonth.setEnabled(false);
        selectMenu.setEnabled(true);
    }

    private void initPeriodCollection() {
        if (this.valueOfYear == null) {
            this.valueOfYear = this.getBgPeriodVariable().initValueOfYear();
        }
        if (this.valueOfHalfYear == null) {
            this.valueOfHalfYear = this.getBgPeriodVariable().initValueOfHalfYear();
        }
        if (this.valueOfQuarter == null) {
            this.valueOfQuarter = this.getBgPeriodVariable().initValueOfQuarter();
        }
        if (this.valueOfMonth == null) {
            this.valueOfMonth = this.getBgPeriodVariable().initValueOfMonth();
        }
    }

    private void initPeriod() {
        SpinnerListModel modelOfYear = new SpinnerListModel(this.valueOfYear);
        this.selectYear.setModel((SpinnerModel)modelOfYear);
        this.selectYear.getModel().setValue(this.getBgPeriodVariable().getcurrentlyDate(BgPeriodVariable.YEAR_OF_YEAR));
        SpinnerListModel modelOfHalfYear = new SpinnerListModel(this.valueOfHalfYear);
        this.selectHalfYear.setModel((SpinnerModel)modelOfHalfYear);
        this.selectHalfYear.getModel().setValue(this.getBgPeriodVariable().getcurrentlyDate(BgPeriodVariable.HALF_OF_YEAR));
        SpinnerListModel modelOfQuarter = new SpinnerListModel(this.valueOfQuarter);
        this.selectQuarter.setModel((SpinnerModel)modelOfQuarter);
        this.selectQuarter.getModel().setValue(this.getBgPeriodVariable().getcurrentlyDate(BgPeriodVariable.QUARTER_OF_YEAR));
        SpinnerListModel modelOfMonth = new SpinnerListModel(this.valueOfMonth);
        this.selectMonth.setModel((SpinnerModel)modelOfMonth);
        this.selectMonth.getModel().setValue(this.getBgPeriodVariable().getcurrentlyDate(BgPeriodVariable.MONTHS_OF_YEAR));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kDTextArea1.setEnabled(false);
        this.kDTextArea1.setEditable(false);
        this.kDTextArea1.setCustomForegroundColor(Color.gray);
        StringBuffer param = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"description01"));
        param.append("\r\n");
        param.append(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"description02"));
        param.append("\r\n");
        param.append(EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"description03"));
        this.kDTextArea1.setText(param.toString());
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.verify();
        this.setCancel(false);
        this.setSelectValue();
        this.getUIWindow().close();
    }

    private void verify() {
        String num;
        int yearValue;
        if (this.year.isSelected()) {
            String year = (String)this.selectYear.getValue();
            yearValue = BgPeriodVariable.parseIntPeriodYear(year);
            if (!this.getBgPeriodVariable().getYearMap().containsKey(yearValue)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"yearError"));
                SysUtil.abort();
            }
        }
        if (this.halfYear.isSelected()) {
            String halfYear = (String)this.selectHalfYear.getValue();
            yearValue = BgPeriodVariable.parseIntPeriodYear(halfYear);
            String halfYearValue = BgPeriodVariable.parseStringPeriod(halfYear, 2);
            num = "" + yearValue + halfYearValue;
            int halfYearNum = Integer.parseInt(num);
            if (!this.getBgPeriodVariable().getHalfYearMap().containsKey(halfYearNum)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"halfYearError"));
                SysUtil.abort();
            }
        }
        if (this.quarter.isSelected()) {
            String quarter = (String)this.selectQuarter.getValue();
            yearValue = BgPeriodVariable.parseIntPeriodYear(quarter);
            String quarterValue = BgPeriodVariable.parseStringPeriod(quarter, 4);
            num = "" + yearValue + quarterValue;
            int quarterNum = Integer.parseInt(num);
            if (!this.getBgPeriodVariable().getQuarterMap().containsKey(quarterNum)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"quarterError"));
                SysUtil.abort();
            }
        }
        if (this.month.isSelected()) {
            String month = this.selectMonth.getValue().toString().trim();
            yearValue = BgPeriodVariable.parseIntPeriodYear(month);
            String monthValue = BgPeriodVariable.parseStringPeriod(month, 12);
            num = "" + yearValue + monthValue;
            int monthNum = Integer.parseInt(num);
            if (!this.getBgPeriodVariable().getMonthMap().containsKey(monthNum)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)"monthError"));
                SysUtil.abort();
            }
        }
    }

    private void setSelectValue() {
        if (this.year.isSelected()) {
            String year = (String)this.selectYear.getValue();
            int yearValue = BgPeriodVariable.parseIntPeriodYear(year);
            this.getBgPeriodVariable().setType(1);
            this.getBgPeriodVariable().setYear(yearValue);
        } else if (this.halfYear.isSelected()) {
            String halfYear = (String)this.selectHalfYear.getValue();
            int yearValue = BgPeriodVariable.parseIntPeriodYear(halfYear);
            int halfYearValue = BgPeriodVariable.parseIntPeriod(halfYear, 2);
            this.getBgPeriodVariable().setType(2);
            this.getBgPeriodVariable().setYear(yearValue);
            this.getBgPeriodVariable().setHalfYear(halfYearValue);
        } else if (this.quarter.isSelected()) {
            String quarter = (String)this.selectQuarter.getValue();
            int yearValue = BgPeriodVariable.parseIntPeriodYear(quarter);
            int quarterValue = BgPeriodVariable.parseIntPeriod(quarter, 4);
            this.getBgPeriodVariable().setType(4);
            this.getBgPeriodVariable().setYear(yearValue);
            this.getBgPeriodVariable().setQuarter(quarterValue);
        } else if (this.month.isSelected()) {
            String month = (String)this.selectMonth.getValue();
            int yearValue = BgPeriodVariable.parseIntPeriodYear(month);
            int monthValue = BgPeriodVariable.parseIntPeriod(month, 12);
            this.getBgPeriodVariable().setType(12);
            this.getBgPeriodVariable().setYear(yearValue);
            this.getBgPeriodVariable().setMonth(monthValue);
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    public int getTheNValue() {
        return (Integer)this.selectYear.getValue();
    }

    protected String getTheSValue() {
        return (String)this.selectYear.getValue();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }
}

