/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgSpinnerMonthInfo;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodSpinnerEditUI;
import com.kingdee.eas.ma.base.client.BgPeriodTreeListUI;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.STConverter;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ActionMap;
import org.apache.log4j.Logger;

public class BgPeriodSpinnerEditUI
extends AbstractBgPeriodSpinnerEditUI {
    private static final long serialVersionUID = 96059330537232245L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodSpinnerEditUI.class);
    private static final String COLUMN_MONTH = "month";
    private static final String COLUMN_MONTH_WEEK = "monthWeek";
    private static final String COLUMN_DAYS = "days";
    private static final int MAX_OF_WEEK = 6;
    private static final int DEFUALT_MONTH = 0;
    private final List<BgPeriodInfo> addNew = new ArrayList<BgPeriodInfo>();
    private final List<BgPeriodInfo> update = new ArrayList<BgPeriodInfo>();
    private final List<BgPeriodInfo> delete = new ArrayList<BgPeriodInfo>();
    private Calendar calendar = Calendar.getInstance();
    protected DecimalFormat df = new DecimalFormat("00");
    protected Locale eLocale = new Locale("l1");
    protected Locale sLocale = new Locale("l2");
    protected Locale tLocale = new Locale("l3");
    private Map<String, Map<String, List<BgPeriodInfo>>> formatPeriods = new LinkedHashMap<String, Map<String, List<BgPeriodInfo>>>();
    private Map<String, BgPeriodInfo> periodCol = new HashMap<String, BgPeriodInfo>();
    private IObjectPK pk;
    boolean isUsed;
    private BgPeriodTypeInfo bgPeriodTypeInfo;

    public IObjectPK getIObjectPK() {
        return this.pk;
    }

    public BgPeriodTypeInfo getBgPeriodTypeInfo() {
        return this.bgPeriodTypeInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtable.checkParsed();
        this.initcbx();
        this.initTblMain();
    }

    private void initcbx() throws EASBizException, BOSException {
        if (this.getUIContext().get("UI_KEY_BGPERIODINFO_ID") != null) {
            this.pk = (IObjectPK)this.getUIContext().get("UI_KEY_BGPERIODINFO_ID");
        }
        if (this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO") != null) {
            this.bgPeriodTypeInfo = (BgPeriodTypeInfo)this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        }
        this.calendar.setTime(new Date());
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("bgPeriod.*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)this.bgPeriodTypeInfo.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(this.calendar.get(1)), CompareType.GREATER_EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sic = new SorterItemInfo("longNumber");
        sic.setSortType(SortType.ASCEND);
        evi.getSorter().add(sic);
        BgPeriodDispCollection col = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi);
        if (col == null || col.isEmpty()) {
            return;
        }
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            List<BgPeriodInfo> weekPeriod;
            Map<Object, Object> monthPeriod;
            BgPeriodInfo periodInfo = col.get(i).getBgPeriod();
            String longnumber = periodInfo.getLongNumber();
            String number = periodInfo.getNumber();
            this.periodCol.put(periodInfo.getId().toString(), periodInfo);
            if (BgPeriodEnum.YEAR.equals((Object)periodInfo.getPeriodType()) && !this.formatPeriods.containsKey(number)) {
                monthPeriod = new LinkedHashMap();
                this.formatPeriods.put(number, monthPeriod);
                continue;
            }
            String[] numbers = longnumber.split("!");
            if (BgPeriodEnum.MONTH.equals((Object)periodInfo.getPeriodType()) && this.formatPeriods.containsKey(numbers[0])) {
                monthPeriod = this.formatPeriods.get(numbers[0]);
                weekPeriod = new ArrayList(6);
                monthPeriod.put(number, weekPeriod);
                continue;
            }
            if (!BgPeriodEnum.MWEEK.equals((Object)periodInfo.getPeriodType()) || !this.formatPeriods.containsKey(numbers[0]) || !(monthPeriod = this.formatPeriods.get(numbers[0])).containsKey(numbers[numbers.length - 2])) continue;
            weekPeriod = (List)monthPeriod.get(numbers[numbers.length - 2]);
            weekPeriod.add(periodInfo);
        }
        if (this.pk == null) {
            this.setDefaultYear(col, this.calendar.get(1));
            this.setDefaultMonth(0);
        } else {
            int selectMonth = 0;
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("bgPeriod.*");
            BgPeriodDispInfo bgPeriodDispInfo = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispInfo(this.pk, selector);
            int selectYear = bgPeriodDispInfo.getBgPeriod().getYear();
            if (bgPeriodDispInfo.getBgPeriod().getPeriodType().getValue() >= 4) {
                selectMonth = bgPeriodDispInfo.getBgPeriod().getMonth();
            }
            if (selectYear < this.calendar.get(1)) {
                this.setDefaultYear(col, this.calendar.get(1));
            } else {
                this.setDefaultYear(col, selectYear);
            }
            this.setDefaultMonth(selectMonth);
        }
    }

    private void setDefaultMonth(int selectedMonth) {
        BgSpinnerMonthInfo info = new BgSpinnerMonthInfo(this.df.format(0L) + "M", EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"ALL"));
        this.cbxMonth.addItem((Object)info);
        String monthName = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Month");
        int endMonth = 12;
        for (int nowMonth = 1; nowMonth <= endMonth; ++nowMonth) {
            this.cbxMonth.addItem((Object)new BgSpinnerMonthInfo(this.df.format(nowMonth) + "M", nowMonth + monthName));
        }
        this.cbxMonth.setSelectedIndex(selectedMonth);
    }

    private void setDefaultYear(BgPeriodDispCollection col, int selectYear) {
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            BgPeriodInfo periodInfo = col.get(i).getBgPeriod();
            if (!BgPeriodEnum.YEAR.equals((Object)periodInfo.getPeriodType())) continue;
            this.cbxStandardYear.addItem((Object)periodInfo);
            if (periodInfo.getYear() != selectYear) continue;
            this.cbxStandardYear.setSelectedItem((Object)periodInfo);
        }
    }

    private void initTblMain() {
        this.kdtable.getSelectManager().setSelectMode(2);
        int colCount = this.kdtable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            this.kdtable.getColumn(i).getStyleAttributes().setLocked(true);
            String key = this.kdtable.getColumn(i).getKey();
            if (!COLUMN_DAYS.equals(key)) continue;
            this.kdtable.getColumn(i).getStyleAttributes().setLocked(false);
        }
        ActionMap am = this.kdtable.getActionMap();
        am.remove("Cut");
        am.remove("Paste");
        am.remove("Copy");
        am.remove("Delete");
    }

    @Override
    protected void kdtable_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        Object value = this.kdtable.getCell(rowIndex, COLUMN_DAYS).getValue();
        if (value == null || "".equals(value.toString().trim())) {
            return;
        }
        if (this.isUsed) {
            this.kdtable.getCell(rowIndex, e.getColIndex()).setValue(e.getOldValue());
        }
        this.verifyInput(value);
    }

    @Override
    protected void kdtable_editStarting(KDTEditEvent e) throws Exception {
        int rowIndex = e.getRowIndex();
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.kdtable.getRow(rowIndex).getUserObject();
        ArrayList<BgPeriodInfo> bgPeriodInfos = new ArrayList<BgPeriodInfo>();
        bgPeriodInfos.add(bgPeriodInfo);
        this.isUsed = BgPeriodDispFactory.getRemoteInstance().isUse(bgPeriodInfos);
        if (this.isUsed) {
            this.kdtable.getCell(rowIndex, e.getColIndex()).getStyleAttributes().setLocked(true);
            throw new BgPeriodException(BgPeriodException.ISUSEPERIOD);
        }
    }

    private void verifyInput(Object value) throws BgPeriodException {
        try {
            int parseInput = Integer.parseInt(value.toString());
            if (parseInput < 0 || parseInput > 15) {
                throw new BgPeriodException(BgPeriodException.INPUTDAYSERROR);
            }
        }
        catch (NumberFormatException e) {
            throw new BgPeriodException(BgPeriodException.INPUTDAYSERROR);
        }
    }

    @Override
    protected void cbxStandardYear_itemStateChanged(ItemEvent e) throws Exception {
        this.kdtable.removeRows();
        BgPeriodInfo selectYear = (BgPeriodInfo)e.getItem();
        if (this.cbxMonth.getSelectedItem() == null) {
            return;
        }
        BgSpinnerMonthInfo selectMonth = (BgSpinnerMonthInfo)this.cbxMonth.getSelectedItem();
        this.refresh(selectMonth, selectYear);
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput();
        this.parseTableData();
        BgPeriodFactory.getRemoteInstance().saveSpinnerWeek(this.addNew, this.update, this.delete, this.bgPeriodTypeInfo.getId().toString());
        this.getUIWindow().close();
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_actionPerformed(e);
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).setSelectTreeNode();
        }
    }

    private void parseTableData() throws BgPeriodException {
        int daySum = 0;
        int in = this.kdtable.getRowCount();
        for (int i = 0; i < in; ++i) {
            Date endDate;
            Date beginDate;
            int inputValue = 0;
            IRow row = this.kdtable.getRow(i);
            Object value = row.getCell(COLUMN_DAYS).getValue();
            if (value != null && !"".equals(value.toString().trim())) {
                inputValue = Integer.parseInt(value.toString());
            }
            BgPeriodInfo periodInfo = (BgPeriodInfo)row.getUserObject();
            if (i % 6 == 0) {
                beginDate = this.getDate(periodInfo.getYear(), periodInfo.getMonth(), 1, 0, 0, 0);
                endDate = this.getDate(periodInfo.getYear(), periodInfo.getMonth(), inputValue, 23, 59, 59);
                daySum = 0;
            } else {
                beginDate = this.getDate(periodInfo.getYear(), periodInfo.getMonth(), daySum + 1, 0, 0, 0);
                endDate = this.getDate(periodInfo.getYear(), periodInfo.getMonth(), daySum + inputValue, 23, 59, 59);
            }
            periodInfo.setBeginDate(beginDate);
            periodInfo.setEndDate(endDate);
            if (this.periodCol.containsKey(periodInfo.getId().toString())) {
                if (inputValue == 0) {
                    this.delete.add(periodInfo);
                } else {
                    this.update.add(periodInfo);
                }
            } else if (inputValue != 0) {
                this.addNew.add(periodInfo);
            }
            daySum += inputValue;
        }
    }

    private Date getDate(int year, int month, int day, int hour, int minute, int second) {
        this.calendar.clear();
        this.calendar.set(year, month - 1, day, hour, minute, second);
        return this.calendar.getTime();
    }

    private void verifyInput() throws BgPeriodException {
        int sum = 0;
        boolean flag = false;
        int in = this.kdtable.getRowCount();
        for (int i = 0; i < in; ++i) {
            int inputValue = 0;
            IRow row = this.kdtable.getRow(i);
            Object value = row.getCell(COLUMN_DAYS).getValue();
            if (value != null && !"".equals(value.toString().trim())) {
                this.verifyInput(value);
                inputValue = Integer.parseInt(value.toString());
            }
            sum += inputValue;
            if ((i + 1) % 6 == 0) {
                if (inputValue != 0 && flag) {
                    throw new BgPeriodException(BgPeriodException.DAYOFMONTHERROR, new Object[]{row.getCell(COLUMN_MONTH).getValue()});
                }
                BgPeriodInfo periodInfo = (BgPeriodInfo)row.getUserObject();
                int monthOfDay = this.getMonthOfDay(periodInfo.getYear(), periodInfo.getMonth());
                if (monthOfDay != sum) {
                    throw new BgPeriodException(BgPeriodException.DAYOFMONTHSIZEERROR, new Object[]{row.getCell(COLUMN_MONTH).getValue()});
                }
                sum = 0;
                flag = false;
                continue;
            }
            if (i % 6 == 0 && inputValue == 0) {
                throw new BgPeriodException(BgPeriodException.DAYOFMONTHERROR, new Object[]{row.getCell(COLUMN_MONTH).getValue()});
            }
            if (inputValue == 0) {
                flag = true;
                continue;
            }
            if (inputValue == 0 || !flag) continue;
            throw new BgPeriodException(BgPeriodException.DAYOFMONTHERROR, new Object[]{row.getCell(COLUMN_MONTH).getValue()});
        }
    }

    private int getMonthOfDay(int year, int month) {
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(2, month - 1);
        return this.calendar.getActualMaximum(5);
    }

    @Override
    protected void cbxMonth_itemStateChanged(ItemEvent e) throws Exception {
        this.kdtable.removeRows();
        BgSpinnerMonthInfo selectMonth = (BgSpinnerMonthInfo)e.getItem();
        if (this.cbxStandardYear.getSelectedItem() == null) {
            return;
        }
        BgPeriodInfo selectYear = (BgPeriodInfo)this.cbxStandardYear.getSelectedItem();
        this.refresh(selectMonth, selectYear);
    }

    private void refresh(BgSpinnerMonthInfo selectMonth, BgPeriodInfo selectYear) {
        if (this.formatPeriods.containsKey(selectYear.getNumber())) {
            Map<String, List<BgPeriodInfo>> monthPeriods = this.formatPeriods.get(selectYear.getNumber());
            if (selectMonth.getNumber().equals(this.df.format(0L) + "M")) {
                int mergerIndex = 0;
                for (List<BgPeriodInfo> monthWeeks : monthPeriods.values()) {
                    this.createMonthWeek(null, monthWeeks, mergerIndex++);
                }
            } else {
                String monthNumber = selectYear.getNumber() + "." + selectMonth.getNumber();
                List<BgPeriodInfo> monthWeeks = monthPeriods.get(monthNumber);
                this.createMonthWeek(selectMonth, monthWeeks, 0);
            }
        }
    }

    private void createMonthWeek(BgSpinnerMonthInfo selectMonth, List<BgPeriodInfo> monthWeeks, int mergeIndex) {
        IRow row;
        int needCreateSize = 6 - monthWeeks.size();
        String di = EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"di");
        for (BgPeriodInfo info : monthWeeks) {
            row = this.kdtable.addRow();
            row.getCell(COLUMN_MONTH).setValue((Object)(selectMonth == null ? info.getParent().getName() : selectMonth.getName()));
            row.getCell(COLUMN_MONTH_WEEK).setValue((Object)(di + info.getWeek() + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week")));
            long oldday = (info.getEndDate().getTime() - info.getBeginDate().getTime()) / 86400000L + 1L;
            row.getCell(COLUMN_DAYS).setValue((Object)oldday);
            row.setUserObject((Object)info);
        }
        int in = needCreateSize;
        for (int i = 1; i <= in; ++i) {
            row = this.kdtable.addRow();
            row.getCell(COLUMN_MONTH).setValue((Object)(selectMonth == null ? monthWeeks.get(0).getParent().getName() : selectMonth.getName()));
            int newWeek = i + monthWeeks.size();
            row.getCell(COLUMN_MONTH_WEEK).setValue((Object)(di + newWeek + EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week")));
            row.setUserObject((Object)this.createNewBgPeriodInfo(newWeek, monthWeeks.get(0).getParent()));
        }
        this.kdtable.getMergeManager().mergeBlock(mergeIndex * 6, 0, (mergeIndex + 1) * 6 - 1, 0);
    }

    private BgPeriodInfo createNewBgPeriodInfo(int newWeek, BgPeriodInfo bgPeriodMonth) {
        BgPeriodInfo bgPeriodMonthWeek = new BgPeriodInfo();
        String weekNumber = new StringBuffer(bgPeriodMonth.getNumber() + "." + this.df.format(newWeek) + "MW").toString();
        bgPeriodMonthWeek.setId(BOSUuid.create((BOSObjectType)bgPeriodMonthWeek.getBOSType()));
        bgPeriodMonthWeek.setNumber(weekNumber);
        bgPeriodMonthWeek.setLongNumber(bgPeriodMonth.getLongNumber() + "!" + weekNumber);
        bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.eLocale) + this.df.format(newWeek) + EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week", (Locale)this.eLocale), this.eLocale);
        bgPeriodMonthWeek.setName(bgPeriodMonth.getName(this.sLocale) + this.df.format(newWeek) + EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"Week", (Locale)this.sLocale), this.sLocale);
        bgPeriodMonthWeek.setName(STConverter.sc2tc((String)bgPeriodMonthWeek.getName(this.sLocale)), this.tLocale);
        bgPeriodMonthWeek.setYear(bgPeriodMonth.getYear());
        bgPeriodMonthWeek.setHalfYear(bgPeriodMonth.getHalfYear());
        bgPeriodMonthWeek.setMonth(bgPeriodMonth.getMonth());
        bgPeriodMonthWeek.setWeek(newWeek);
        bgPeriodMonthWeek.setLevel(5);
        bgPeriodMonthWeek.setShowLevel(bgPeriodMonth.getShowLevel() + 100 + (newWeek - 1) * 8);
        bgPeriodMonthWeek.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgPeriodMonthWeek.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgPeriodMonthWeek.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        bgPeriodMonthWeek.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        bgPeriodMonthWeek.setPeriodType(BgPeriodEnum.MWEEK);
        bgPeriodMonthWeek.setIsLeaf(!this.bgPeriodTypeInfo.isDay());
        bgPeriodMonthWeek.setParent(bgPeriodMonth);
        return bgPeriodMonthWeek;
    }
}

