/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.IBgPeriodType;
import com.kingdee.eas.ma.base.client.AbstractBgPeriodTypeEditUI;
import com.kingdee.eas.ma.base.client.BgPeriodTreeListUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.sql.Timestamp;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgPeriodTypeEditUI
extends AbstractBgPeriodTypeEditUI {
    private static final long serialVersionUID = -792287676426394233L;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodTypeEditUI.class);
    private static final String SIMPLE_NAME = "5";
    private static final int KDSPINNERDAY_DEFAULTVALUE = 5;

    @Override
    public void storeFields() {
        Object obj;
        if (this.kDRBStandardYear.isSelected()) {
            this.editData.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
        } else if (this.kDRBStrideYear.isSelected()) {
            this.editData.setFiscalYear(FiscalYearEnum.STRIDEYEAR);
        } else {
            this.editData.setFiscalYear(null);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState()) && (obj = this.getUIContext().get("UI_TREE_ROOT")) instanceof BgPeriodTypeInfo) {
            this.editData.setParent((BgPeriodTypeInfo)obj);
        }
        super.storeFields();
    }

    private boolean isOnlyUpdataName() {
        FilterInfo filter = new FilterInfo();
        BgPeriodTypeInfo obj = (BgPeriodTypeInfo)this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        filter.appendFilterItem("type.id", (Object)obj.getId().toString());
        try {
            return BgPeriodHelper.SYS_BGPERIOD_NUMBER.contains(obj.getNumber()) || BgPeriodDispFactory.getRemoteInstance().exists(filter);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return false;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.setOprtState(OprtState.VIEW);
        this.getUIWindow().close();
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).actionRefresh_actionPerformed(e);
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get("Owner"))).setSelectTreeNode();
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.editData.isYearWeek()) {
            this.chkMonth.setEnabled(false);
            this.chkQuarter.setEnabled(false);
            this.chkHalfYear.setEnabled(false);
            this.chkMonth.setSelected(false);
            this.chkQuarter.setSelected(false);
            this.chkHalfYear.setSelected(false);
        }
        if (this.editData.isSelfDefined()) {
            this.chkDay.setEnabled(false);
            this.chkMothWeek.setEnabled(false);
            this.chkYearWeek.setEnabled(false);
            this.chkTenday.setEnabled(false);
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.txtNumber.setStringValue(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodTypeNumberTips"));
            this.txtNumber.setCustomForegroundColor(this.txtNumber.getDisabledTextColor());
            this.kDSpinnerDay.setValue((Object)5);
        }
    }

    protected void initOldData(IObjectValue dataObject) {
        super.initOldData(dataObject);
        BgPeriodTypeInfo info = (BgPeriodTypeInfo)dataObject;
        Object obj = this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        if (obj instanceof BgPeriodTypeInfo) {
            FiscalYearEnum fYearEnum = ((BgPeriodTypeInfo)obj).getFiscalYear();
            info.setFiscalYear(fYearEnum);
            if (fYearEnum == FiscalYearEnum.STANDARDYEAR) {
                this.kDRBStandardYear.setSelected(true);
            }
            if (fYearEnum == FiscalYearEnum.STRIDEYEAR) {
                this.kDRBStrideYear.setSelected(true);
                this.disableCheckboxes();
            }
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                this.kDRBStandardYear.setSelected(true);
                info.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
            }
            if (this.chkMothWeek.isSelected() && !this.chkDay.isSelected()) {
                this.cbxSelfDefineRule.setEnabled(true);
                if (this.cbxSelfDefineRule.isSelected()) {
                    this.kDSpinnerDay.setEnabled(true);
                }
            }
            this.editData.setParent((BgPeriodTypeInfo)this.getUIContext().get("UI_TREE_ROOT"));
        }
    }

    protected void initState() {
        BgCommCHelper.disable((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint, (ItemAction)this.actionPrint);
        BgCommCHelper.disable((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy, (ItemAction)this.actionCopy);
        BgCommCHelper.disable((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview, (ItemAction)this.actionPrintPreview);
        BgCommCHelper.disable((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel, (ItemAction)this.actionCancel);
        BgCommCHelper.disable((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel, (ItemAction)this.actionCancelCancel);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.addnewState();
            if (this.kDRBStandardYear.isSelected()) {
                this.chkMothWeek.setEnabled(true);
                this.chkYearWeek.setEnabled(true);
                this.chkTenday.setEnabled(true);
                this.chkDay.setEnabled(true);
                this.chkSelfDefined.setEnabled(true);
            }
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.editState();
            if (this.isOnlyUpdataName()) {
                this.txtNumber.setEnabled(false);
                this.txtName.setEnabled(true);
                this.kDRBStandardYear.setEnabled(false);
                this.kDRBStrideYear.setEnabled(false);
                this.chkSelfDefined.setEnabled(false);
                this.chkTenday.setEnabled(false);
                this.chkYearWeek.setEnabled(false);
                this.chkMothWeek.setEnabled(false);
                this.chkDay.setEnabled(false);
                this.chkMonth.setEnabled(false);
                this.chkQuarter.setEnabled(false);
                this.chkHalfYear.setEnabled(false);
                this.chkYear.setEnabled(false);
            }
        } else if (OprtState.VIEW.equals(this.getOprtState())) {
            this.viewState();
        }
    }

    protected void addnewState() {
        this.txtNumber.setEnabled(true);
        this.txtNumber.requestFocus(true);
        this.txtNumber.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodTypeNumberTips"));
        this.txtName.setEnabled(true);
        this.kDRBStandardYear.setEnabled(true);
        this.kDRBStrideYear.setEnabled(true);
        this.chkYear.setSelected(true);
        this.kDRBStandardYear.setSelected(true);
        this.kDRBStrideYear.setSelected(false);
        this.chkMonth.setEnabled(true);
        this.chkQuarter.setEnabled(true);
        this.chkHalfYear.setEnabled(true);
        this.chkYear.setEnabled(true);
        this.chkMonth.setSelected(false);
        this.chkQuarter.setSelected(false);
        this.chkHalfYear.setSelected(false);
    }

    protected void editState() {
        this.txtNumber.setEnabled(false);
        this.txtName.setEnabled(true);
        this.kDRBStandardYear.setEnabled(true);
        this.kDRBStrideYear.setEnabled(true);
    }

    protected void viewState() {
        this.txtNumber.setEnabled(false);
        this.txtName.setEnabled(false);
        this.kDRBStandardYear.setEnabled(false);
        this.kDRBStrideYear.setEnabled(false);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initState();
        SpinnerNumberModel model = new SpinnerNumberModel();
        model.setMaximum(Integer.valueOf(7));
        model.setMinimum(Integer.valueOf(1));
        this.kDSpinnerDay.setModel((SpinnerModel)model);
    }

    protected IObjectValue createNewData() {
        BgPeriodTypeInfo bgPeriodTypeInfo = new BgPeriodTypeInfo();
        bgPeriodTypeInfo.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
        bgPeriodTypeInfo.setId(BOSUuid.create((BOSObjectType)bgPeriodTypeInfo.getBOSType()));
        bgPeriodTypeInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        bgPeriodTypeInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bgPeriodTypeInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        bgPeriodTypeInfo.setYear(true);
        bgPeriodTypeInfo.setSimpleName(SIMPLE_NAME);
        Object obj = this.getUIContext().get("UI_KEY_BGPERIODTYPEINFO");
        if (obj instanceof BgPeriodTypeInfo) {
            FiscalYearEnum fYearEnum = ((BgPeriodTypeInfo)obj).getFiscalYear();
            bgPeriodTypeInfo.setFiscalYear(fYearEnum);
            if (fYearEnum == FiscalYearEnum.STANDARDYEAR) {
                this.kDRBStandardYear.setSelected(true);
            }
            if (fYearEnum == FiscalYearEnum.STRIDEYEAR) {
                this.kDRBStrideYear.setSelected(true);
                this.disableCheckboxes();
            }
            if (OprtState.ADDNEW.equals(this.getOprtState())) {
                this.kDRBStandardYear.setSelected(true);
                bgPeriodTypeInfo.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
            }
            bgPeriodTypeInfo.setParent((BgPeriodTypeInfo)this.getUIContext().get("UI_TREE_ROOT"));
        }
        return bgPeriodTypeInfo;
    }

    protected IBgPeriodType getBizInterface() throws Exception {
        return BgPeriodTypeFactory.getRemoteInstance();
    }

    private boolean isCheckedPeriodMode() {
        return !this.chkSelfDefined.isSelected() && !this.chkYearWeek.isSelected() && !this.chkTenday.isSelected() && !this.chkMothWeek.isSelected() && !this.chkDay.isSelected() && !this.chkMonth.isSelected() && !this.chkQuarter.isSelected() && !this.chkHalfYear.isSelected() && !this.chkYear.isSelected();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        String oprationType;
        String id;
        super.verifyInput(e);
        String regexNumberString = "^[A-Za-z0-9]{4}$";
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"numberIsNull"));
                SysUtil.abort();
            } else if (!this.txtNumber.getText().matches(regexNumberString)) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"numberIsWrong"));
                SysUtil.abort();
            }
        }
        if (this.getUIContext().get("Owner") instanceof BgPeriodTreeListUI) {
            ((BgPeriodTreeListUI)((Object)this.getUIContext().get((Object)"Owner"))).newTypeID = this.txtNumber.getText();
        }
        if (StringUtils.isEmpty((String)this.txtName.getText())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
        if (this.isCheckedFiscalYearType()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"fiscalYearIsNull"));
            SysUtil.abort();
        } else if (this.kDRBStandardYear.isSelected()) {
            this.editData.setFiscalYear(FiscalYearEnum.STANDARDYEAR);
        } else {
            this.editData.setFiscalYear(FiscalYearEnum.STRIDEYEAR);
        }
        if (this.isCheckedPeriodMode()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"selectPeriod"));
            SysUtil.abort();
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            id = this.editData.getId().toString();
            oprationType = OprtState.ADDNEW;
        } else {
            id = null;
            oprationType = OprtState.EDIT;
        }
        this.getBizInterface().validate(id, this.editData, oprationType);
    }

    protected boolean isCheckedFiscalYearType() {
        return !this.kDRBStandardYear.isSelected() && !this.kDRBStrideYear.isSelected();
    }

    public void handUIException(Throwable exc) {
        Throwable e = exc;
        if (e instanceof BgPeriodException) {
            logger.info((Object)("BgPeriodException:" + exc));
            BgPeriodException temp = (BgPeriodException)((Object)e);
            if (temp != null) {
                MsgBox.showInfo((Component)((Object)this), (String)temp.getMessage());
            }
        } else {
            super.handUIException(exc);
        }
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initState();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.initState();
    }

    @Override
    protected void txtNumber_focusGained(FocusEvent e) throws Exception {
        if (this.txtNumber.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodTypeNumberTips"))) {
            this.txtNumber.setText(null);
            this.txtNumber.setCustomForegroundColor(Color.black);
        }
    }

    @Override
    protected void txtNumber_focusLost(FocusEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodTypeNumberTips"));
            this.txtNumber.setCustomForegroundColor(this.txtNumber.getDisabledTextColor());
        }
        if (!this.txtNumber.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.BgPeriodResource", (String)"periodTypeNumberTips"))) {
            this.txtNumber.setCustomForegroundColor(Color.black);
        }
    }

    @Override
    protected void kDRBStandardYear_actionPerformed(ActionEvent e) throws Exception {
        super.kDRBStandardYear_actionPerformed(e);
        if (this.kDRBStandardYear.isSelected()) {
            this.chkMothWeek.setEnabled(true);
            this.chkYearWeek.setEnabled(true);
            this.chkTenday.setEnabled(true);
            this.chkDay.setEnabled(true);
            this.chkSelfDefined.setEnabled(true);
        }
    }

    @Override
    protected void kDRBStrideYear_actionPerformed(ActionEvent e) throws Exception {
        super.kDRBStrideYear_actionPerformed(e);
        this.disableCheckboxes();
    }

    private void disableCheckboxes() {
        if (this.kDRBStrideYear.isSelected()) {
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.chkDay.setSelected(false);
            this.chkSelfDefined.setSelected(false);
            this.chkMothWeek.setEnabled(false);
            this.chkYearWeek.setEnabled(false);
            this.chkTenday.setEnabled(false);
            this.chkDay.setEnabled(false);
            this.chkSelfDefined.setEnabled(false);
            this.resetSelfDefineRule();
        }
    }

    private void resetSelfDefineRule() {
        this.cbxSelfDefineRule.setEnabled(false);
        this.cbxSelfDefineRule.setSelected(false);
        this.kDSpinnerDay.setEnabled(false);
        this.kDSpinnerDay.setValue((Object)5);
    }

    @Override
    protected void chkYear_actionPerformed(ActionEvent e) throws Exception {
        super.chkYear_actionPerformed(e);
        if (!this.chkYear.isSelected()) {
            this.chkHalfYear.setSelected(false);
            this.chkQuarter.setSelected(false);
            this.chkMonth.setSelected(false);
            this.chkDay.setSelected(false);
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.resetSelfDefineRule();
        }
    }

    @Override
    protected void chkHalfYear_actionPerformed(ActionEvent e) throws Exception {
        super.chkHalfYear_actionPerformed(e);
        if (this.chkHalfYear.isSelected()) {
            this.chkYear.setSelected(true);
        } else {
            this.chkQuarter.setSelected(false);
            this.chkMonth.setSelected(false);
            this.chkDay.setSelected(false);
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.resetSelfDefineRule();
        }
    }

    @Override
    protected void chkQuarter_actionPerformed(ActionEvent e) throws Exception {
        super.chkQuarter_actionPerformed(e);
        if (this.chkQuarter.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(true);
        } else {
            this.chkMonth.setSelected(false);
            this.chkDay.setSelected(false);
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.resetSelfDefineRule();
        }
    }

    @Override
    protected void chkMonth_actionPerformed(ActionEvent e) throws Exception {
        super.chkMonth_actionPerformed(e);
        if (this.chkMonth.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(true);
            this.chkQuarter.setSelected(true);
        } else {
            this.chkDay.setSelected(false);
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.resetSelfDefineRule();
        }
    }

    @Override
    protected void chkTenday_actionPerformed(ActionEvent e) throws Exception {
        super.chkTenday_actionPerformed(e);
        if (this.chkTenday.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(true);
            this.chkQuarter.setSelected(true);
            this.chkMonth.setSelected(true);
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.resetSelfDefineRule();
            this.chkHalfYear.setEnabled(true);
            this.chkQuarter.setEnabled(true);
            this.chkMonth.setEnabled(true);
        }
    }

    @Override
    protected void chkYearWeek_actionPerformed(ActionEvent e) throws Exception {
        super.chkYearWeek_actionPerformed(e);
        if (this.chkYearWeek.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(false);
            this.chkQuarter.setSelected(false);
            this.chkMonth.setSelected(false);
            this.chkMothWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.chkHalfYear.setEnabled(false);
            this.chkQuarter.setEnabled(false);
            this.chkMonth.setEnabled(false);
            this.resetSelfDefineRule();
        } else {
            this.chkHalfYear.setEnabled(true);
            this.chkQuarter.setEnabled(true);
            this.chkMonth.setEnabled(true);
            if (this.chkDay.isSelected()) {
                this.chkHalfYear.setSelected(true);
                this.chkQuarter.setSelected(true);
                this.chkMonth.setSelected(true);
            }
        }
    }

    @Override
    protected void chkMothWeek_actionPerformed(ActionEvent e) throws Exception {
        super.chkMothWeek_actionPerformed(e);
        if (this.chkMothWeek.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(true);
            this.chkQuarter.setSelected(true);
            this.chkMonth.setSelected(true);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.chkHalfYear.setEnabled(true);
            this.chkQuarter.setEnabled(true);
            this.chkMonth.setEnabled(true);
        }
        if (this.chkMothWeek.isSelected() && this.chkDay.isSelected()) {
            this.cbxSelfDefineRule.setSelected(false);
            this.cbxSelfDefineRule.setEnabled(false);
            this.kDSpinnerDay.setEnabled(false);
        } else if (this.chkMothWeek.isSelected() && !this.chkDay.isSelected()) {
            this.cbxSelfDefineRule.setEnabled(true);
            if (this.cbxSelfDefineRule.isSelected()) {
                this.kDSpinnerDay.setEnabled(true);
            }
        } else {
            this.cbxSelfDefineRule.setEnabled(false);
            this.kDSpinnerDay.setEnabled(false);
        }
    }

    @Override
    protected void chkDay_actionPerformed(ActionEvent e) throws Exception {
        super.chkDay_actionPerformed(e);
        if (this.chkDay.isSelected() && !this.chkYearWeek.isSelected()) {
            this.chkYear.setSelected(true);
            this.chkHalfYear.setSelected(true);
            this.chkQuarter.setSelected(true);
            this.chkMonth.setSelected(true);
            this.chkHalfYear.setEnabled(true);
            this.chkQuarter.setEnabled(true);
            this.chkMonth.setEnabled(true);
        } else if (!this.chkDay.isSelected()) {
            this.chkSelfDefined.setSelected(false);
        }
        if (this.chkDay.isSelected() && this.chkMothWeek.isSelected()) {
            this.resetSelfDefineRule();
        } else if (!this.chkDay.isSelected() && this.chkMothWeek.isSelected()) {
            this.cbxSelfDefineRule.setEnabled(true);
        }
    }

    @Override
    protected void chkSelfDefined_actionPerformed(ActionEvent e) throws Exception {
        super.chkSelfDefined_actionPerformed(e);
        if (this.chkSelfDefined.isSelected()) {
            this.chkMothWeek.setSelected(false);
            this.chkYearWeek.setSelected(false);
            this.chkTenday.setSelected(false);
            this.chkDay.setSelected(false);
            this.chkMothWeek.setEnabled(false);
            this.chkYearWeek.setEnabled(false);
            this.chkTenday.setEnabled(false);
            this.chkDay.setEnabled(false);
            this.resetSelfDefineRule();
        } else {
            this.chkMothWeek.setEnabled(true);
            this.chkYearWeek.setEnabled(true);
            this.chkTenday.setEnabled(true);
            this.chkDay.setEnabled(true);
        }
    }

    @Override
    protected void cbxSelfDefineRule_actionPerformed(ActionEvent e) throws Exception {
        if (this.cbxSelfDefineRule.isSelected()) {
            this.kDSpinnerDay.setEnabled(true);
        } else {
            this.kDSpinnerDay.setEnabled(false);
        }
    }

    @Override
    protected void kDSpinnerDay_stateChanged(ChangeEvent e) throws Exception {
    }
}

