/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPropertyException;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.client.AbstractBgPropertyEditUI;
import com.kingdee.eas.ma.base.client.BgPropertyParentDialog;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPropertyEditUI
extends AbstractBgPropertyEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BgPropertyEditUI.class);
    private CostCenterOrgUnitInfo orgUnitInfo = null;
    private BgPropertySortInfo propertySortInfo = null;
    private BgPropertyParentDialog bgPropParentDialog = null;

    public CostCenterOrgUnitInfo getOrgUnitInfo() {
        if (this.orgUnitInfo == null) {
            this.orgUnitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        }
        return this.orgUnitInfo;
    }

    public BgPropertySortInfo getPropertySortInfo() {
        if (this.propertySortInfo == null) {
            this.propertySortInfo = (BgPropertySortInfo)this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO);
        }
        return this.propertySortInfo;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        if (this.editData != null && this.editData.getBgPropertySort() != null) {
            this.getUIContext().put(BgBaseConstants.BGPROPSORT_INFO, this.editData.getBgPropertySort());
            if (this.editData.getBgPropertySort().getId() != null && this.bgPropParentDialog != null) {
                this.bgPropParentDialog.setSortId(this.editData.getBgPropertySort().getId().toString());
            }
        }
        super.loadFields();
    }

    protected void loadData() throws Exception {
        super.loadData();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgUnitInfo = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
        this.propertySortInfo = (BgPropertySortInfo)this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO);
        this.bgPropParentDialog = new BgPropertyParentDialog();
        this.bgPropParentDialog.setOldData(this.prmtParent.getData());
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
        if (this.editData.getBgPropertySort().getId() != null) {
            this.bgPropParentDialog.setSortId(this.editData.getBgPropertySort().getId().toString());
        }
        if (this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE) != null) {
            this.bgPropParentDialog.setSortSourceType(this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE).toString());
        }
        if (this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID) != null) {
            this.bgPropParentDialog.setMbgDimID(this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID).toString());
        } else {
            this.bgPropParentDialog.setMbgDimID(null);
        }
        if (this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS) != null) {
            this.bgPropParentDialog.setParentAndChildOrgUnitIds((Set)this.getUIContext().get(BgBaseConstants.ORGUNIT_IDS));
        } else {
            this.bgPropParentDialog.setParentAndChildOrgUnitIds(null);
        }
        if (this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID) != null) {
            this.bgPropParentDialog.setMbgDimID(this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID).toString());
        } else {
            this.bgPropParentDialog.setMbgDimID(null);
        }
        if (this.orgUnitInfo != null) {
            this.bgPropParentDialog.setOrgUnitInfo(this.orgUnitInfo);
        } else {
            this.bgPropParentDialog.setOrgUnitInfo(null);
        }
        if (this.getUIContext().get(BgBaseConstants.MBGVIEWINFO) != null) {
            this.bgPropParentDialog.setMbgViewInfo((MbgViewInfo)this.getUIContext().get(BgBaseConstants.MBGVIEWINFO));
        } else {
            this.bgPropParentDialog.setMbgViewInfo(null);
        }
        if (this.propertySortInfo != null) {
            this.bgPropParentDialog.setPropertySortInfo(this.propertySortInfo);
        } else {
            this.bgPropParentDialog.setPropertySortInfo(null);
        }
        this.prmtParent.setSelector((KDPromptSelector)this.bgPropParentDialog);
        this.prmtParent.setEditable(false);
        this.txtName.setRequired(true);
        if (this.propertySortInfo == null) {
            this.btnAddNew.setEnabled(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.initState();
    }

    protected void initState() {
        this.prmtOrgUnit.setEnabled(false);
        this.prmtSort.setEnabled(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
        }
    }

    protected List<BOSUuid> getAllChildOrgIds(OrgUnitInfo _orgUnitInfo) throws BOSException, EASBizException {
        ArrayList<BOSUuid> list = new ArrayList<BOSUuid>();
        list.add(_orgUnitInfo.getId());
        IObjectCollection _collection = this.getOrgAllChildren(_orgUnitInfo.getId());
        if (_collection != null && !_collection.isEmpty()) {
            int in = _collection.size();
            for (int i = 0; i < in; ++i) {
                CostCenterOrgUnitInfo _ccOrgUnitInfo = (CostCenterOrgUnitInfo)_collection.getObject(i);
                if (_ccOrgUnitInfo.isIsSealUp()) continue;
                list.add(_ccOrgUnitInfo.getId());
            }
            _collection.clear();
        }
        return list;
    }

    protected IObjectCollection getOrgAllChildren(BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null) {
            return new CostCenterOrgUnitCollection();
        }
        CostCenterOrgUnitInfo unitInfo = null;
        CostCenterOrgUnitCollection unitCollection = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("longnumber");
        ICostCenterOrgUnit iOrgUnit = CostCenterOrgUnitFactory.getRemoteInstance();
        unitInfo = (CostCenterOrgUnitInfo)iOrgUnit.getValue((IObjectPK)new ObjectUuidPK(orgUnitId), sic);
        if (unitInfo != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            view.setFilter(filter);
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("number"));
            view.setSorter(sort);
            unitCollection = iOrgUnit.getCostCenterOrgUnitCollection(view);
        }
        return unitCollection;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.propertySortInfo == null) {
            throw new BgPropertyException(BgPropertyException.SORTISNULL);
        }
        this.txtNumber.setEnabled(true);
        super.actionAddNew_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (this.editData.getId() != null) {
            this.bgPropParentDialog.setPropertyId(this.editData.getId().toString());
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        CostCenterOrgUnitInfo orgInfo = this.getOrgUnitInfo();
        List<BOSUuid> allChildOrg = this.getAllChildOrgIds((OrgUnitInfo)orgInfo);
        if (!allChildOrg.contains(this.editData.getOrgUnit().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"notModifyByOrg"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.initState();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        CostCenterOrgUnitInfo orgInfo = this.getOrgUnitInfo();
        List<BOSUuid> allChildOrg = this.getAllChildOrgIds((OrgUnitInfo)orgInfo);
        if (!allChildOrg.contains(this.editData.getOrgUnit().getId())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"notDeleteByOrg"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    protected void prmtParent_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtParent_dataChanged(e);
        this.initCurMemParentInfo(e.getOldValue());
    }

    private void initCurMemParentInfo(Object object) throws EASBizException, BOSException {
        Object parentObj = this.prmtParent.getData();
        if (parentObj == null) {
            this.editData.setParent(null);
            this.editData.setLongNumber(this.txtNumber.getText());
            this.editData.setLevel(1);
        } else {
            BgPropertyInfo parentInfo = null;
            if (parentObj instanceof BgAccountInfo) {
                parentInfo = (BgPropertyInfo)parentObj;
                this.editData.setParent(parentInfo);
                this.editData.setLongNumber(parentInfo.getLongNumber() + "!" + this.txtNumber.getText());
                this.editData.setLevel(parentInfo.getLevel() + 1);
            }
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"confirmDelete")));
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"numberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (BgDBUtils.length(this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"numberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"nameIsNull"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        BgPropertyInfo info = new BgPropertyInfo();
        info.setOrgUnit(this.getOrgUnitInfo());
        info.setBgPropertySort(this.getPropertySortInfo());
        return info;
    }

    protected IBgProperty getBizInterface() throws Exception {
        return BgPropertyFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("isLeaf");
        sic.add("level");
        sic.add("longNumber");
        sic.add("displayName");
        return sic;
    }
}

