/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.base.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgScenarioNodeCollection;
import com.kingdee.eas.ma.base.BgScenarioNodeInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.client.BGReportUI;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgScenarioImportUI
extends BgBaseImportUI {
    private static final long serialVersionUID = -2034525193057517865L;
    private static final Logger logger = CoreUIObject.getLogger(BgScenarioImportUI.class);
    public static final String RESOURCE = "com.kingdee.eas.ma.base.BgScenarioResource";
    Map<Integer, List<String>> errorMap = new HashMap<Integer, List<String>>();

    @Override
    protected String getImportTitle() {
        return BgCommCHelper.getMessageStr(RESOURCE, "titleScenario");
    }

    @Override
    protected String getTemplateTitle() {
        return BgCommCHelper.getMessageStr(RESOURCE, "importTemplate");
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().equals("");
    }

    protected BgScenarioInfo createNewData() {
        BgScenarioInfo itemInfo = new BgScenarioInfo();
        itemInfo.setId(BOSUuid.create((BOSObjectType)itemInfo.getBOSType()));
        OrgUnitInfo orgObject = SysContext.getSysContext().getCurrentOrgUnit();
        if (orgObject instanceof OrgUnitInfo) {
            itemInfo.setOrgUnit(orgObject.castToFullOrgUnitInfo());
        }
        return itemInfo;
    }

    @Override
    protected void importData(KDSSheet sheet) {
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        int row_0 = 0;
        int row_1 = 1;
        int row_2 = 2;
        int row_3 = 3;
        int row_4 = 4;
        int row_5 = 5;
        int row_6 = 6;
        String number = null;
        String name = null;
        String type = null;
        String actNumbers = null;
        String actNames = null;
        String description = null;
        String orgUnit = null;
        ArrayList<BgScenarioInfo> scenList = new ArrayList<BgScenarioInfo>();
        CoreBaseCollection colls = new CoreBaseCollection();
        int errorNum = this.getErrorNum();
        ArrayList errorLst = new ArrayList();
        List<Object> errorItem = new ArrayList();
        BgScenarioInfo scenInfo = null;
        int forCount = 0;
        this.progressBar.setMaximum(sheet.getRowCount());
        HashMap numberRowMap = new HashMap();
        try {
            HashMap<String, BgScenarioInfo> allMemberRelation = new HashMap<String, BgScenarioInfo>();
            BgScenarioCollection bgScenarioCollection = BgScenarioFactory.getRemoteInstance().getBgScenarioCollection();
            HashSet<String> existActNumnbers = new HashSet<String>();
            HashMap<String, BgScenarioInfo> existsMember = new HashMap<String, BgScenarioInfo>();
            HashMap<String, BgScenarioInfo> existsName = new HashMap<String, BgScenarioInfo>();
            for (int i = 0; i < bgScenarioCollection.size(); ++i) {
                String num = bgScenarioCollection.get(i).getNumber();
                String ename = bgScenarioCollection.get(i).getName();
                type = bgScenarioCollection.get(i).getType().getAlias();
                if (this.isActType(type)) {
                    existActNumnbers.add(num);
                }
                if (!existsMember.containsKey(num)) {
                    existsMember.put(num, bgScenarioCollection.get(i));
                }
                if (!existsName.containsKey(ename)) {
                    existsName.put(ename, bgScenarioCollection.get(i));
                }
                allMemberRelation.put(num, bgScenarioCollection.get(i));
            }
            HashSet<String> failNumberSet = new HashSet<String>();
            HashSet<String> actSucessNumberSet = new HashSet<String>();
            int in = sheet.getRowCount();
            for (int i = 1; i < in; ++i) {
                number = this.getNumber(sheet.getCell(i, row_0, false).getValue());
                name = this.getNumber(sheet.getCell(i, row_1, false).getValue());
                type = this.getNumber(sheet.getCell(i, row_2, false).getValue());
                if (existsMember.containsKey(number)) {
                    BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)existsMember.get(number);
                    type = String.valueOf(bgScenarioInfo.getType().getAlias());
                }
                if (!this.isLegalType(type)) {
                    failNumberSet.add(number);
                } else if (!this.isNull(number) && !BgNumberHelper.checkNumber(number)) {
                    failNumberSet.add(number);
                } else if (this.isNull(number) || this.isNull(name)) {
                    failNumberSet.add(number);
                }
                if (!this.isActType(type)) continue;
                actSucessNumberSet.add(number);
            }
            failNumberSet.retainAll(existActNumnbers);
            HashMap scen2ActRelation = new HashMap();
            HashMap<String, BgScenarioInfo> scenNodeRelation = new HashMap<String, BgScenarioInfo>();
            int in2 = sheet.getRowCount();
            block6: for (int i = 1; i < in2; ++i) {
                this.progressBar.setValue(i);
                ++forCount;
                number = this.getNumber(sheet.getCell(i, row_0, false).getValue());
                name = this.getNumber(sheet.getCell(i, row_1, false).getValue());
                type = this.getNumber(sheet.getCell(i, row_2, false).getValue());
                actNumbers = this.getNumber(sheet.getCell(i, row_3, false).getValue());
                actNames = this.getNumber(sheet.getCell(i, row_4, false).getValue());
                description = this.getNumber(sheet.getCell(i, row_5, false).getValue());
                orgUnit = this.getNumber(sheet.getCell(i, row_6, false).getValue());
                if (existsName.containsKey(name)) {
                    boolean isSameName = false;
                    if (existsMember.containsKey(number)) {
                        scenInfo = (BgScenarioInfo)existsMember.get(number);
                        if (!scenInfo.getName().equals(name)) {
                            isSameName = true;
                        }
                    } else {
                        isSameName = true;
                    }
                    if (isSameName && !"ActData".equals(number) && !"BgData".equals(number)) {
                        errorItem = new ArrayList();
                        errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "sameName"), i + 1, name));
                        this.addError(errorItem, i);
                        if (this.getErrorNum() != 1) continue;
                        break;
                    }
                }
                if (existsMember.containsKey(number)) {
                    scenInfo = (BgScenarioInfo)existsMember.get(number);
                    scenInfo.setDescription(description);
                    if (!"ActData".equals(number) && !"BgData".equals(number)) {
                        scenInfo.setName(name);
                    }
                } else {
                    scenInfo = this.createNewData();
                    scenInfo.setDescription(description);
                    scenInfo.setNumber(number);
                    scenInfo.setName(name);
                    if (this.isBudgetType(type)) {
                        scenInfo.setType(BgScenarioType.BudgetData);
                    } else if (this.isActType(type)) {
                        scenInfo.setType(BgScenarioType.ActualData);
                    }
                    if (!"ActData".equals(number) && !"BgData".equals(number)) {
                        scenInfo.setName(name);
                    }
                }
                if (scenInfo != null && !allMemberRelation.containsKey(scenInfo.getNumber())) {
                    allMemberRelation.put(scenInfo.getNumber(), scenInfo);
                }
                if (!this.isLegalType(type)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "typeUnExists"), i + 1, number));
                    this.addError(errorItem, i);
                    if (this.getErrorNum() != 1) continue;
                    break;
                }
                if (!this.isNull(number) && !BgNumberHelper.checkNumber(number)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "specialChar"), i + 1, number));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                if (this.isNull(number) || this.isNull(name)) {
                    errorItem = new ArrayList();
                    errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "isNull4NameOrNumber"), i + 1));
                    this.addError(errorItem, i);
                    if (errorNum != 1) continue;
                    break;
                }
                if (!StringUtils.isEmpty((String)actNumbers) && this.isBudgetType(type)) {
                    String[] split = actNumbers.split(",");
                    boolean isFailed = false;
                    for (int j = 0; j < split.length; ++j) {
                        String actNumItem = split[j];
                        if (StringUtils.isEmpty((String)actNumItem)) continue;
                        if (failNumberSet.contains(actNumItem) || !existActNumnbers.contains(actNumItem) && !actSucessNumberSet.contains(actNumItem)) {
                            isFailed = true;
                            errorItem = new ArrayList();
                            errorItem.add(MessageFormat.format(BgCommCHelper.getMessageStr(RESOURCE, "notExistsNumberAct"), i + 1, number, actNumItem));
                            this.addError(errorItem, i);
                            if (errorNum != 1) continue block6;
                            break;
                        }
                        if (!scen2ActRelation.containsKey(number)) {
                            scen2ActRelation.put(number, new HashSet());
                        }
                        ((Set)scen2ActRelation.get(number)).add(actNumItem);
                    }
                    if (!isFailed) {
                        scenList.add(scenInfo);
                        scenNodeRelation.put(number, scenInfo);
                    }
                } else if (this.isBudgetType(type) && StringUtils.isEmpty((String)actNumbers)) {
                    scenInfo.getActScenarios().clear();
                    scenList.add(scenInfo);
                } else {
                    scenList.add(scenInfo);
                }
                existsMember.put(number, scenInfo);
                existsName.put(name, scenInfo);
            }
            if (!scenNodeRelation.isEmpty()) {
                for (Map.Entry entry : scenNodeRelation.entrySet()) {
                    String numberKey = (String)entry.getKey();
                    BgScenarioInfo bgScenarioInfo = (BgScenarioInfo)entry.getValue();
                    if (!scen2ActRelation.containsKey(numberKey)) continue;
                    Set nodeNumberSet = (Set)scen2ActRelation.get(numberKey);
                    bgScenarioInfo.getActScenarios().clear();
                    BgScenarioNodeCollection nodes = new BgScenarioNodeCollection();
                    for (String actNumber : nodeNumberSet) {
                        if (!allMemberRelation.containsKey(actNumber)) continue;
                        BgScenarioInfo actInfo = (BgScenarioInfo)allMemberRelation.get(actNumber);
                        BgScenarioNodeInfo node = new BgScenarioNodeInfo();
                        node.setBgScenario(bgScenarioInfo);
                        node.setActScenario(actInfo);
                        nodes.add(node);
                    }
                    bgScenarioInfo.getActScenarios().addCollection(nodes);
                }
            }
            if (!scenList.isEmpty()) {
                BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[scenList.size()];
                for (int i = 0; i < scenList.size(); ++i) {
                    BatchExecuteParamsEntry entry;
                    if (scenList.get(i) == null) continue;
                    paramEntries[i] = entry = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{scenList.get(i)});
                }
                BatchExecuteResult result = BgScenarioFactory.getRemoteInstance().batchExecute("import4Scen", new Class[]{IObjectValue.class}, paramEntries);
                result.getBatchResult();
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        ArrayList txtlst = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(" ", MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_1"), forCount - this.errorMap.keySet().size()));
        txtlst.add(map);
        if (sheet.getRowCount() - colls.size() != 1 || !this.errorMap.isEmpty()) {
            map = new HashMap();
            if (errorNum == 1) {
                map.put(" ", BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_2", new String[]{String.valueOf(forCount - colls.size())}));
            } else if (this.errorMap.size() > 0) {
                map.put(" ", BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.BgAccountResource", "importMsg_2", new String[]{String.valueOf(this.errorMap.keySet().size())}));
            }
            txtlst.add(map);
        }
        if (this.errorMap.keySet() != null) {
            Object[] array = this.errorMap.keySet().toArray();
            Arrays.sort(array);
            for (int i = 0; i < array.length; ++i) {
                errorItem = this.errorMap.get(array[i]);
                if (errorItem == null) continue;
                for (int j = 0; j < errorItem.size(); ++j) {
                    map = new HashMap();
                    map.put(" ", errorItem.get(j));
                    errorLst.add(map);
                }
            }
        }
        txtlst.addAll(errorLst);
        ArrayList<String> listHeadTitle = new ArrayList<String>();
        listHeadTitle.add(" ");
        UIContext ctx = new UIContext((Object)this);
        ctx.put((Object)"LIST_CONTENT", txtlst);
        ctx.put((Object)"LIST_HEAD_TITLE", listHeadTitle);
        String invokeTime = BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date());
        ctx.put((Object)"INVOKE_TIME", (Object)invokeTime);
        ctx.put((Object)"UI_OWNER_TITLE", (Object)BgCommCHelper.getMessageStr(RESOURCE, "importTitle"));
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BGReportUI.class.getName(), (Map)ctx);
            uiWindow.show();
        }
        catch (UIException e) {
            logger.error((Object)e);
        }
    }

    private boolean isActType(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "act").equals(type);
    }

    private boolean isBudgetType(String type) {
        return BgCommCHelper.getMessageStr(RESOURCE, "budget").equals(type);
    }

    private boolean isLegalType(String type) {
        return this.isBudgetType(type) || this.isActType(type);
    }

    private void addError(List<String> errorItem, int i) {
        if (this.errorMap.containsKey(i + 1)) {
            this.errorMap.get(i + 1).addAll(errorItem);
        } else {
            this.errorMap.put(i + 1, errorItem);
        }
    }
}

