/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.client.AbstractBgVersionEditUI;
import com.kingdee.eas.ma.base.client.BgVersionBaseDialog;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BgVersionEditUI
extends AbstractBgVersionEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BgVersionEditUI.class);
    private CostCenterOrgUnitInfo unitInfo = SysContext.getSysContext().getCurrentCostUnit();
    private Set<String> periodNums = new HashSet<String>();

    public CostCenterOrgUnitInfo getUnitInfo() {
        return this.unitInfo;
    }

    public void setUnitInfo(CostCenterOrgUnitInfo unitInfo) {
        this.unitInfo = unitInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.contOrgUnit.setVisible(false);
        this.prmtParent.setEditable(false);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtNumber.setEnabled(false);
            this.prmtParent.setEditable(false);
            this.prmtParent.setEnabled(true);
            if (this.editData.getIsSysData() == 1) {
                this.prmtParent.setEnabled(false);
                this.txtName.setEnabled(false);
            }
        }
        this.prmtParent.setEditable(false);
        this.contParent.setVisible(false);
        this.contParent.setEnabled(false);
        this.prmtParent.setVisible(false);
        this.prmtParent.setEnabled(false);
        this.queryBgPeriodNums();
    }

    private void queryBgPeriodNums() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        BgPeriodDispCollection col = BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(evi);
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            BgPeriodDispInfo info = (BgPeriodDispInfo)iter.next();
            this.periodNums.add(info.getNumber());
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.txtNumber.setEnabled(true);
        this.txtName.setEnabled(true);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.setOprtState("ADDNEW");
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtOrgUnit.getValue() != null && !this.getUnitInfo().getId().toString().equalsIgnoreCase(((FullOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cannotEditVersion"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEnabled(false);
        if (this.editData.getIsSysData() == 1) {
            this.txtName.setEnabled(false);
        } else {
            this.txtName.setEnabled(true);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        if (dataObject instanceof BgVersionInfo) {
            this.editData = (BgVersionInfo)dataObject;
        }
        super.setDataObject(dataObject);
    }

    protected void initDataStatus() {
        super.initDataStatus();
        this.prmtParent.setAccessAuthority(0);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.enableVisible((JButton)this.btnAddNew, null);
            BgCommCHelper.enableVisible((JButton)this.btnEdit, null);
            BgCommCHelper.enableVisible((JButton)this.btnSubmit, null);
            BgCommCHelper.disableAction((JButton)this.btnSubmit);
            this.prmtParent.setEnabled(false);
            this.txtName.setEnabled(false);
        } else if (OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) {
            this.prmtParent.setEnabled(true);
        }
        BgVersionBaseDialog BgVersionDialog = new BgVersionBaseDialog();
        BgVersionDialog.setIsShowName(true);
        BgVersionDialog.setIsChooseOne(true);
        if (OprtState.EDIT.equals(this.getOprtState())) {
            BgVersionDialog.setLongNumber(this.editData.getLongNumber());
        }
        this.prmtParent.setSelector((KDPromptSelector)BgVersionDialog);
        if (this.editData.getIsSysData() == 1) {
            this.prmtParent.setEnabled(false);
            this.txtName.setEnabled(false);
        }
        if (this.editData != null && this.editData.isIsRollVersion()) {
            this.txtName.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        BgVersionInfo bgVersionInfo = new BgVersionInfo();
        bgVersionInfo.setId(BOSUuid.create((BOSObjectType)bgVersionInfo.getBOSType()));
        bgVersionInfo.setOrgUnit(this.getUnitInfo().castToFullOrgUnitInfo());
        return bgVersionInfo;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("versionid");
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("description");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("longNumber");
        sic.add("isSysData");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        sic.add("isRollVersion");
        return sic;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgVersionFactory.getRemoteInstance();
    }

    protected LanguageInfo getCurrentLanguage() {
        return new LanguageInfo(this.getCurrentLocale());
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        LanguageInfo currLang = this.getCurrentLanguage();
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "noNumber"));
                SysUtil.abort();
            } else {
                if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                    this.txtNumber.requestFocus(true);
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "haveEspecial"));
                    SysUtil.abort();
                }
                String[] split = this.txtNumber.getText().split("-");
                int in = split.length;
                for (int i = 0; i < in; ++i) {
                    if (!this.periodNums.contains(split[i])) continue;
                    this.txtNumber.requestFocus(true);
                    MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "checkNumberByRollRule"));
                    SysUtil.abort();
                }
            }
        }
        if (this.txtName.getItemBy(currLang).getData() == null || StringUtils.isEmpty((String)this.txtName.getItemBy(currLang).getData().toString())) {
            this.txtName.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "noName"));
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        BgCommCHelper.disableVisible((JButton)this.btnSave, (JMenuItem)this.menuItemSave);
        BgCommCHelper.disableVisible((JButton)this.btnCopy, (JMenuItem)this.menuItemCopy);
        BgCommCHelper.disableVisible((JButton)this.btnPrint, (JMenuItem)this.menuItemPrint);
        BgCommCHelper.disableVisible((JButton)this.btnPrintPreview, (JMenuItem)this.menuItemPrintPreview);
        BgCommCHelper.disableVisible((JButton)this.btnCancel, (JMenuItem)this.menuItemCancel);
        BgCommCHelper.disableVisible((JButton)this.btnCancelCancel, (JMenuItem)this.menuItemCancelCancel);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.prmtParent.setEnabled(false);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.setButtonStatas();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.setButtonStatas();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.setButtonStatas();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.setButtonStatas();
    }

    public void setButtonStatas() {
        String prmtUnitId = ((FullOrgUnitInfo)this.prmtOrgUnit.getValue()).getId().toString();
        if (!this.getUnitInfo().getId().toString().equals(prmtUnitId)) {
            BgCommCHelper.disableAction((JButton)this.btnEdit);
            BgCommCHelper.disableAction((JButton)this.btnRemove);
        } else {
            BgCommCHelper.enableAction((JButton)this.btnEdit);
            BgCommCHelper.enableAction((JButton)this.btnRemove);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BgVersionInfo parent = (BgVersionInfo)this.prmtParent.getData();
        if (parent != null) {
            boolean canChange;
            if (parent.getIsSysData() == 1) {
                this.prmtParent.setData(null);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantSelectSysData"));
                SysUtil.abort();
            }
            if (parent.getId().toString().equals(this.editData.getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantSelectSelf"));
                SysUtil.abort();
            }
            if (canChange = BgBaseFacadeFactory.getRemoteInstance().checkParent(parent)) {
                int level = parent.getLevel();
                String ParentLongNumber = parent.getLongNumber();
                this.editData.setParent(parent);
                this.editData.setLongNumber(ParentLongNumber + "!" + this.txtNumber.getText());
                this.editData.setLevel(level + 1);
                super.actionSubmit_actionPerformed(e);
            } else {
                this.prmtParent.setData(null);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "cantEditVerson"));
                SysUtil.abort();
            }
        } else {
            this.editData.setParent(null);
            super.actionSubmit_actionPerformed(e);
        }
    }
}

