/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.POIExportException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.KDTIOManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.client.AbstractImpAndExpSupportUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.tools.datatask.ErrorHandleModeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class ImpAndExpSupportUI
extends AbstractImpAndExpSupportUI {
    private static final Logger logger = CoreUIObject.getLogger(ImpAndExpSupportUI.class);
    protected boolean cancelActionFlag = false;
    protected StringBuffer showDetailMsg = new StringBuffer();
    protected ErrorHandleModeEnum mode = null;
    private static final long serialVersionUID = 471380673238861998L;
    public static final String res = "com.kingdee.eas.ma.base.ImpAndExpResource";
    public static final String IMPORT_RES = "com.kingdee.eas.tools.datatask.DatataskResource";

    public boolean isCancelActionFlag() {
        return this.cancelActionFlag;
    }

    public void setCancelActionFlag(boolean cancelActionFlag) {
        this.cancelActionFlag = cancelActionFlag;
    }

    public StringBuffer getShowDetailMsg() {
        return this.showDetailMsg;
    }

    public void setShowDetailMsg(StringBuffer showDetailMsg) {
        this.showDetailMsg = showDetailMsg;
    }

    public void recordError(String resource, String key, Object ... strings) {
        String msg = EASResource.getString((String)resource, (String)key, (Object[])strings);
        if (this.isAbort()) {
            MsgBox.showError((Component)((Object)this), (String)msg);
            SysUtil.abort();
        } else {
            this.showDetailMsg.append(msg).append("\n");
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnOpenFile.setIcon((Icon)((ImageIcon)ResourceBase.getIcon((String)"com.kingdee.eas.tools.datatask.ui.ImageResource.tbtn_open", (Locale)new Locale("L1"))));
        this.panelProgress.setVisible(false);
        this.setBtnState(true);
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            this.kDLabelContainer2.setVisible(false);
            this.btnConfirm.setText(BgCommCHelper.getMessageStr(IMPORT_RES, "export"));
            this.kDLabel1.setText(BgCommCHelper.getMessageStr(IMPORT_RES, "exporting"));
        } else {
            this.comboError.removeAllItems();
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
            this.comboError.addItem((Object)ErrorHandleModeEnum.ReturnRightnow);
            this.comboError.setSelectedItem((Object)ErrorHandleModeEnum.ReturnWhenFinish);
        }
    }

    @Override
    public void actionOpen_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        if (!StringUtils.isEmpty((String)filePath) && filePath != null) {
            this.txtFile.setText(filePath.toString());
            this.txtFile.setUserObject((Object)fileChooser.getSelectedFile());
        }
    }

    @Override
    public void btnExportTemplate_actionPerformed(ActionEvent e) throws Exception {
        boolean isSuccess;
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(this.getDialogTitle());
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setSelectedFile(new File(this.getDialogTitle()));
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDTable tbl = this.getKDTableTemplateData();
        if (!StringUtils.isEmpty((String)filePath) && (isSuccess = this.appendToExcel(filePath, tbl))) {
            MsgBox.showInfo((String)BgCommCHelper.getMessageStr(res, "templetExportSuccess"));
        }
    }

    public boolean isAbort() {
        return !ErrorHandleModeEnum.ReturnWhenFinish.equals((Object)this.mode);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtFile.getText())) {
            return;
        }
        if (!this.txtFile.getText().toLowerCase().endsWith(".xls")) {
            this.txtFile.setText(this.txtFile.getText() + ".xls");
        }
        this.mode = (ErrorHandleModeEnum)this.comboError.getSelectedItem();
        if (!((Boolean)this.getUIContext().get("isImport")).booleanValue()) {
            ProgressThread process = new ProgressThread(false);
            process.start();
        } else {
            ProgressThread process = new ProgressThread(true);
            process.start();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean appendToExcel(String filePath, KDTable tbl) throws Exception {
        File file = new File(filePath);
        KDTIOManager ioManager = tbl.getIOManager();
        KDSBook book = null;
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(5);
        try {
            this.progressBar.setValue(1);
            if (file.exists()) {
                int result = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr(IMPORT_RES, "fileHasExisted"));
                if (result != 0) return false;
                if (!file.delete()) {
                    MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr(IMPORT_RES, "openedfile"));
                    this.disableButtons();
                    return false;
                }
                file = new File(filePath);
                book = new KDSBook(file.getName());
            } else {
                book = new KDSBook(file.getName());
            }
            this.progressBar.setValue(2);
            book.addSheet(null, ioManager.saveToKDSSheet(book, true, false, this.getDialogTitle()));
            this.progressBar.setValue(3);
            ExportManager man = new ExportManager();
            this.progressBar.setValue(4);
            try {
                man.exportToExcel(book, filePath);
            }
            catch (POIExportException ex) {
                MsgBox.showInfo((String)BgCommCHelper.getMessageStr(res, "183_BgControlRuleEditUI"));
            }
            this.progressBar.setValue(5);
            return true;
        }
        catch (Exception err) {
            logger.error((Object)"mbg error:", (Throwable)err);
            this.handUIException(err);
        }
        return true;
    }

    private void setBtnState(boolean state) {
        this.btnCancel.setEnabled(state);
        this.btnConfirm.setEnabled(state);
        this.btnOpenFile.setEnabled(state);
        this.chkUpdate.setEnabled(state);
        this.btnExportTemplate.setEnabled(state);
        this.btnExportTemplate.setVisible(true);
    }

    protected void enableButtons() {
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.btnOpenFile.setEnabled(true);
        this.txtFile.setEnabled(true);
        this.btnExportTemplate.setEnabled(true);
        this.panelProgress.setVisible(false);
    }

    protected void disableButtons() {
        this.btnConfirm.setEnabled(false);
        this.btnCancel.setEnabled(false);
        this.btnOpenFile.setEnabled(false);
        this.txtFile.setEnabled(false);
        this.btnExportTemplate.setEnabled(false);
        this.panelProgress.setVisible(true);
    }

    public boolean destroyWindow() {
        this.setCancelActionFlag(true);
        return super.destroyWindow();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().hide();
        this.setCancelActionFlag(true);
    }

    public Icon getImage() {
        return EASResource.getIcon((String)"imgTransfers_pic260");
    }

    protected abstract String getDialogTitle();

    public KDTable getKDTableTemplateData() {
        return (KDTable)this.getUIContext().get("template");
    }

    public KDTable getKDTableTemplateAndTableData() {
        return (KDTable)this.getUIContext().get("data");
    }

    protected abstract void beforeImportData(KDSSheet var1);

    protected abstract void importData(KDSSheet var1);

    class ProgressThread
    extends Thread {
        private boolean isImport = false;

        public ProgressThread(boolean isImport) {
            this.isImport = isImport;
        }

        @Override
        public void run() {
            ImpAndExpSupportUI.this.disableButtons();
            String fileName = ImpAndExpSupportUI.this.txtFile.getText();
            if (this.isImport) {
                KDSBook book = null;
                try {
                    book = POIXlsReader.parse((String)fileName);
                }
                catch (Exception e1) {
                    SysUtil.abort();
                }
                if (book == null) {
                    MsgBox.showInfo((String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemImportResource", "notFile"));
                    SysUtil.abort();
                }
                KDSSheet sheet = book.getSheet((Object)new Integer(0));
                ImpAndExpSupportUI.this.beforeImportData(sheet);
                ImpAndExpSupportUI.this.importData(sheet);
                ImpAndExpSupportUI.this.getUIWindow().hide();
            } else {
                KDTable tbl = ImpAndExpSupportUI.this.getKDTableTemplateAndTableData();
                try {
                    boolean isSuccess = ImpAndExpSupportUI.this.appendToExcel(fileName, tbl);
                    if (isSuccess) {
                        MsgBox.showInfo((String)BgCommCHelper.getMessageStr(ImpAndExpSupportUI.IMPORT_RES, "exportSucceeded"));
                        ImpAndExpSupportUI.this.getUIWindow().hide();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"import Error", (Throwable)e);
                }
            }
            ImpAndExpSupportUI.this.enableButtons();
        }
    }
}

