/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.TreePopupMenuListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.TreePathUtil;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.base.IMbgExchangeRate;
import com.kingdee.eas.ma.base.IMbgExchangeRateScheme;
import com.kingdee.eas.ma.base.MbgExchangeRateFactory;
import com.kingdee.eas.ma.base.MbgExchangeRateInfo;
import com.kingdee.eas.ma.base.MbgExchangeRatePeriodTypeEnum;
import com.kingdee.eas.ma.base.MbgExchangeRateSchemeFactory;
import com.kingdee.eas.ma.base.MbgExchangeRateSchemeInfo;
import com.kingdee.eas.ma.base.client.AbstractMbgExchangeRateListUI;
import com.kingdee.eas.ma.base.client.MbgExchangeRateSchemeEditUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.MbgExchangeRateUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MbgExchangeRateListUI
extends AbstractMbgExchangeRateListUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgExchangeRateListUI.class);
    protected static final String COL_ID = "id";
    protected static final String COL_NUMBER = "number";
    protected static final String COL_PERIOD = "period";
    protected static final String COL_RATE = "rate";
    protected static final String COL_CREATOR_NAME = "creator.name";
    protected static final String COL_CREATETIME = "createTime";
    protected static final String COL_LASTUPDATEUSER_NAME = "lastUpdateUser.name";
    protected static final String COL_LASTUPDATEUSERTIME = "lastUpdateTime";
    protected static final String COL_ORGUNIT_NAME = "orgUnit.name";
    protected static final String COL_EXCHANGERATESCHEME_ID = "exchangeRateScheme.id";
    protected static final String COL_LASTUPDATEUSER_ID = "lastUpdateUser.id";
    protected static final String COL_ORGUNIT_ID = "orgUnit.id";
    protected static final String COL_CREATOR_ID = "creator.id";
    public String newMbgExchangeRateSchemeNum = null;

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getColumn(COL_RATE).getStyleAttributes().setLocked(false);
        this.init();
        this.loadHead();
        this.tblMain.getColumn(COL_RATE).setEditor((ICellEditor)this.getNumberEditor());
        this.tblMain.getColumn(COL_RATE).setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (object != null && object instanceof BigDecimal) {
                    BigDecimal value = (BigDecimal)object;
                    value = value.setScale((int)MbgExchangeRateListUI.this.getPrecision(), 4);
                    TextRender.sharedInstance().draw(graphics, clip, value.toString(), cellStyle);
                }
            }
        });
    }

    @Override
    public void actionPeriodAddNew_actionPerformed(ActionEvent e) throws Exception {
        MbgExchangeRateSchemeInfo rateSchemeInfo = this.getSelectSchemeInfo();
        IObjectPK pk = null;
        if (rateSchemeInfo != null) {
            pk = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"periodAddNew"), (BOSObjectType)rateSchemeInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(rateSchemeInfo.getId()), (String)(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"periodAddNew1") + rateSchemeInfo.getNumber() + " - " + rateSchemeInfo.getName()), (String)"mbg_rate_periodAddNew");
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"chose_scheme"));
            SysUtil.abort();
        }
        this.doPeriodAddNew();
        if (pk != null) {
            LogUtil.afterLog(null, pk);
        }
    }

    protected void doPeriodAddNew() throws Exception {
        if (this.comboPeriodType.getSelectedItem() instanceof MbgExchangeRatePeriodTypeEnum) {
            MbgExchangeRatePeriodTypeEnum periodTypeEnum = (MbgExchangeRatePeriodTypeEnum)((Object)this.comboPeriodType.getSelectedItem());
            LinkedHashMap<String, MbgExchangeRateInfo> rateMap = new LinkedHashMap<String, MbgExchangeRateInfo>();
            MbgExchangeRateInfo info = null;
            IRow row = null;
            int count = this.tblMain.getRowCount();
            if (count > 0) {
                for (int i = 0; i < count; ++i) {
                    row = this.tblMain.getRow(i);
                    info = this.getRateInfoByRow(row);
                    rateMap.put(info.getNumber(), info);
                }
            }
            boolean hasNew = false;
            List<String> periods = MbgExchangeRateUtils.getPeriodYears(periodTypeEnum);
            if (periods != null && !periods.isEmpty()) {
                for (int i = 0; i < periods.size(); ++i) {
                    if (rateMap.containsKey(periods.get(i))) continue;
                    rateMap.put(periods.get(i), this.createRateInfoByPeriodYear(periods.get(i)));
                    hasNew = true;
                }
            } else {
                return;
            }
            if (hasNew) {
                CoreBaseCollection colls = new CoreBaseCollection();
                MbgExchangeRateUtils.sortMap(rateMap);
                this.tblMain.removeRows(false);
                Iterator ite = rateMap.keySet().iterator();
                while (ite.hasNext()) {
                    info = (MbgExchangeRateInfo)rateMap.get(ite.next());
                    colls.add((CoreBaseInfo)info);
                }
                if (!colls.isEmpty()) {
                    this.getBizInterface().saveBatchData(colls);
                    this.tblMain.refresh();
                }
            }
        }
    }

    private MbgExchangeRateInfo createRateInfoByPeriodYear(String year) {
        String period = year + EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"year");
        if (year.equals("ZDY")) {
            period = EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"zdy_year");
        }
        MbgExchangeRateInfo info = new MbgExchangeRateInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setNumber(year);
        info.setPeriod(period);
        info.setExchangeRateScheme(this.getSelectSchemeInfo());
        info.setPeriodType((MbgExchangeRatePeriodTypeEnum)((Object)this.comboPeriodType.getSelectedItem()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    private MbgExchangeRateInfo getRateInfoByRow(IRow row) {
        MbgExchangeRateInfo info = new MbgExchangeRateInfo();
        if (row.getCell(COL_ID).getValue() != null) {
            info.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
        }
        if (row.getCell(COL_NUMBER).getValue() != null) {
            info.setNumber(row.getCell(COL_NUMBER).getValue().toString());
        }
        if (row.getCell(COL_PERIOD).getValue() != null) {
            info.setPeriod(row.getCell(COL_PERIOD).getValue().toString());
        }
        if (row.getCell(COL_RATE).getValue() != null) {
            info.setRate(new BigDecimal(row.getCell(COL_RATE).getValue().toString()));
        } else {
            info.setRate(null);
        }
        info.setCreator(new UserInfo());
        if (row.getCell(COL_CREATOR_ID).getValue() != null) {
            info.getCreator().setId(BOSUuid.read((String)row.getCell(COL_CREATOR_ID).getValue().toString()));
        }
        if (row.getCell(COL_CREATOR_NAME).getValue() != null) {
            info.getCreator().setName(row.getCell(COL_CREATOR_NAME).getValue().toString());
        }
        if (row.getCell(COL_CREATETIME).getValue() != null && row.getCell(COL_CREATETIME).getValue() instanceof Timestamp) {
            info.setCreateTime((Timestamp)row.getCell(COL_CREATETIME).getValue());
        }
        info.setLastUpdateUser(new UserInfo());
        if (row.getCell(COL_LASTUPDATEUSER_ID).getValue() != null) {
            info.getLastUpdateUser().setId(BOSUuid.read((String)row.getCell(COL_LASTUPDATEUSER_ID).getValue().toString()));
        }
        if (row.getCell(COL_LASTUPDATEUSER_NAME).getValue() != null) {
            info.getLastUpdateUser().setName(row.getCell(COL_LASTUPDATEUSER_NAME).getValue().toString());
        }
        if (row.getCell(COL_LASTUPDATEUSERTIME).getValue() != null && row.getCell(COL_LASTUPDATEUSERTIME).getValue() instanceof Timestamp) {
            info.setLastUpdateTime((Timestamp)row.getCell(COL_LASTUPDATEUSERTIME).getValue());
        }
        info.setOrgUnit(new FullOrgUnitInfo());
        if (row.getCell(COL_ORGUNIT_ID).getValue() != null) {
            info.getOrgUnit().setId(BOSUuid.read((String)row.getCell(COL_ORGUNIT_ID).getValue().toString()));
        }
        if (row.getCell(COL_ORGUNIT_NAME).getValue() != null) {
            info.getOrgUnit().setName(row.getCell(COL_ORGUNIT_NAME).getValue().toString());
        }
        return info;
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
        this.doSave(this.getSelectSchemeInfo());
    }

    protected void doSave(MbgExchangeRateSchemeInfo rateSchene) throws Exception {
        int count = this.tblMain.getRowCount();
        if (count > 0) {
            CoreBaseCollection colls = new CoreBaseCollection();
            IRow row = null;
            MbgExchangeRateInfo info = null;
            for (int i = 0; i < count; ++i) {
                row = this.tblMain.getRow(i);
                info = this.getRateInfoByRow(row);
                info.setExchangeRateScheme(rateSchene);
                row.setUserObject((Object)info);
                colls.add((CoreBaseInfo)info);
            }
            if (!colls.isEmpty()) {
                MbgExchangeRateSchemeInfo rateSchemeInfo = this.getSelectSchemeInfo();
                IObjectPK pk = null;
                if (rateSchemeInfo != null) {
                    pk = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"periodUpdate"), (BOSObjectType)rateSchemeInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(rateSchemeInfo.getId()), (String)(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"periodUpdate1") + rateSchemeInfo.getNumber() + " - " + rateSchemeInfo.getName()), (String)"mbg_rate_periodUpdate");
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"chose_scheme"));
                    SysUtil.abort();
                }
                this.getBizInterface().saveBatchData(colls);
                if (pk != null) {
                    LogUtil.afterLog(null, pk);
                }
            }
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_confirm"));
        if (re == 1 || re == 2) {
            return;
        }
        List<Integer> indexs = this.getSelectRowIndex();
        ArrayList<String> selectDel = new ArrayList<String>();
        IRow row = null;
        String rowId = null;
        int rowIndex = 0;
        CostCenterOrgUnitInfo ccoui = SysContext.getSysContext().getCurrentCostUnit();
        HashSet<String> difOrg = new HashSet<String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        for (int index = 0; index < indexs.size(); ++index) {
            rowIndex = indexs.get(index);
            row = this.tblMain.getRow(indexs.get(index).intValue());
            rowId = row.getCell(COL_ID).getValue().toString();
            String creatOrgId = row.getCell(COL_ORGUNIT_ID).getValue().toString();
            String period = row.getCell(COL_PERIOD).getValue().toString();
            if (rowId == null) continue;
            if (!creatOrgId.equalsIgnoreCase(ccoui.getId().toString())) {
                difOrg.add(rowId);
            } else {
                selectDel.add(rowId);
            }
            numberMap.put(rowId, period);
        }
        if (!selectDel.isEmpty()) {
            IObjectPK[] pkArray = new IObjectPK[selectDel.size()];
            for (int i = 0; i < selectDel.size(); ++i) {
                pkArray[i] = new ObjectUuidPK(selectDel.get(i).toString());
            }
            MbgExchangeRateFactory.getRemoteInstance().deleteBatchData(pkArray);
        }
        StringBuffer message = new StringBuffer();
        if (difOrg.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_success"));
            this.refresh(e);
        } else {
            Iterator iter = difOrg.iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                message.append(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.MbgExchangeRateResource", "remove_difOrg"), numberMap.get(id)));
                message.append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgVersionResource", "delete_failed"), (String)message.toString(), (int)1);
        }
        this.tblMain.refresh();
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void loadHead() throws Exception {
        if (this.getSelectSchemeInfo() != null) {
            MbgExchangeRateSchemeInfo rateScheme = this.getSelectSchemeInfo();
            if (StringUtils.isEmpty((String)rateScheme.getSourceCurrency().getName())) {
                rateScheme = this.getTreeInterface().getMbgExchangeRateSchemeInfo((IObjectPK)new ObjectUuidPK(rateScheme.getId()), this.getSelectorForTree());
            }
            this.prmtSourceCurrency.setDataNoNotify((Object)rateScheme.getSourceCurrency());
            this.prmtTargeCurrency.setDataNoNotify((Object)rateScheme.getTargeCurrency());
            this.comboPricision.setSelectedItem((Object)rateScheme.getPrecision());
        }
    }

    protected void init() {
        this.comboPeriodType.addItem((Object)MbgExchangeRatePeriodTypeEnum.unSelfDefined);
        this.comboPeriodType.addItem((Object)MbgExchangeRatePeriodTypeEnum.selfDefined);
        if (this.getSelectSchemeInfo() == null) {
            this.prmtSourceCurrency.setDataNoNotify(null);
            this.prmtTargeCurrency.setDataNoNotify(null);
        }
        this.initPrecision();
    }

    protected KDTDefaultCellEditor getNumberEditor() {
        KDFormattedTextField kdfTextField = new KDFormattedTextField();
        kdfTextField.setDataType(1);
        kdfTextField.setPrecision(this.getPrecision().intValue());
        kdfTextField.setSupportedEmpty(true);
        kdfTextField.setNegatived(false);
        return new MyCellEditor((JTextField)kdfTextField);
    }

    protected void initPrecision() {
        Object[] precisions = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.comboPricision.addItems(precisions);
    }

    protected Integer getPrecision() {
        if (this.comboPricision.getSelectedItem() != null) {
            return (Integer)this.comboPricision.getSelectedItem();
        }
        return 2;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        if (e != null && e.getOldLeadSelectionPath() != null && e.getOldLeadSelectionPath().getLastPathComponent() != null && e.getNewLeadSelectionPath() != null && e.getNewLeadSelectionPath().getLastPathComponent() != null) {
            MbgExchangeRateSchemeInfo newRateScheme = (MbgExchangeRateSchemeInfo)((KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject();
            MbgExchangeRateSchemeInfo oldRateScheme = (MbgExchangeRateSchemeInfo)((KDTreeNode)e.getOldLeadSelectionPath().getLastPathComponent()).getUserObject();
            if (newRateScheme != null && oldRateScheme != null && newRateScheme.getId() != oldRateScheme.getId()) {
                this.checkSave(oldRateScheme);
            }
        }
        super.treeMain_valueChanged(e);
        this.loadHead();
        this.tblMain.getColumn(COL_RATE).setEditor((ICellEditor)this.getNumberEditor());
    }

    @Override
    protected void comboPeriodType_actionPerformed(ActionEvent e) throws Exception {
        super.comboPeriodType_actionPerformed(e);
        this.refreshList();
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        FilterInfo filter = viewInfo.getFilter();
        if (filter == null) {
            filter = new FilterInfo();
            viewInfo.setFilter(filter);
        }
        if (this.comboPeriodType.getSelectedItem() instanceof MbgExchangeRatePeriodTypeEnum) {
            MbgExchangeRatePeriodTypeEnum periodTypeEnum = (MbgExchangeRatePeriodTypeEnum)((Object)this.comboPeriodType.getSelectedItem());
            FilterItemInfo itemInfo = new FilterItemInfo("periodType", (Object)periodTypeEnum.getValue(), CompareType.EQUALS);
            BgCommCHelper.replaceFilterItems(filter, itemInfo);
        }
        FilterInfo treeFilter = this.getTreeFilter(viewInfo);
        try {
            filter.mergeFilter(treeFilter, "and");
        }
        catch (BOSException e) {
            this.handUIException(e);
            logger.error((Object)"", (Throwable)e);
        }
        return super.getQueryExecutor(queryPK, viewInfo);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        IRow row = null;
        MbgExchangeRateInfo info = null;
        int count = this.tblMain.getRowCount();
        if (count > 0) {
            for (int index = 0; index < count; ++index) {
                row = this.tblMain.getRow(index);
                if (row.getUserObject() != null) {
                    return;
                }
                info = new MbgExchangeRateInfo();
                info.setId(BOSUuid.read((String)row.getCell(COL_ID).getValue().toString()));
                if (row.getCell(COL_RATE).getValue() instanceof BigDecimal) {
                    info.setRate((BigDecimal)row.getCell(COL_RATE).getValue());
                }
                row.setUserObject((Object)info);
            }
        }
    }

    protected FilterInfo getTreeFilter(EntityViewInfo viewInfo) {
        FilterItemInfo itemInfo = null;
        FilterInfo filter = viewInfo.getFilter();
        BgCommCHelper.replaceFilterItems(filter, itemInfo);
        return filter;
    }

    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = super.getDefaultFilterForTree();
        return filter;
    }

    protected MbgExchangeRateSchemeInfo getSelectSchemeInfo() {
        MbgExchangeRateSchemeInfo rateSchemeInfo = null;
        if (this.getSelectedTreeNode() != null && this.getSelectedTreeNode().getUserObject() != null) {
            rateSchemeInfo = (MbgExchangeRateSchemeInfo)this.getSelectedTreeNode().getUserObject();
        }
        return rateSchemeInfo;
    }

    public void checkTreeNodeSelected(ActionEvent e) {
        boolean isNotGroupAddNew;
        KDTreeNode treeNode = this.getSelectedTreeNode();
        ItemAction action = this.getActionFromActionEvent(e);
        boolean bl = isNotGroupAddNew = !action.equals(this.actionGroupAddNew);
        if (treeNode == null && isNotGroupAddNew) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"chose_scheme"));
            SysUtil.abort();
        }
        if (isNotGroupAddNew && (treeNode == null || !(treeNode.getUserObject() instanceof TreeBaseInfo))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Root_CannotSelected"));
            SysUtil.abort();
        }
        if (isNotGroupAddNew && treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            try {
                this.checkTreeObjectExists(e);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
                SysUtil.abort();
            }
        }
    }

    private void checkTreeObjectExists(ActionEvent e) throws Exception {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode.getUserObject() == null) {
            return;
        }
        if (!this.getTreeInterface().exists((IObjectPK)new ObjectUuidPK(((TreeBaseInfo)treeNode.getUserObject()).getId().toString()))) {
            this.refresh(e);
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    public void actionGroupAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupAddNew_actionPerformed(e);
    }

    @Override
    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (this.getSelectSchemeInfo() != null && this.getSelectSchemeInfo().getOrgUnit() != null && !orgUnitInfo.getId().toString().equals(this.getSelectSchemeInfo().getOrgUnit().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"edit_scheme_org"));
            SysUtil.abort();
        }
        super.actionGroupEdit_actionPerformed(e);
    }

    @Override
    public void actionGroupView_actionPerformed(ActionEvent e) throws Exception {
        super.actionGroupView_actionPerformed(e);
    }

    @Override
    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (this.getSelectSchemeInfo() != null) {
            if (this.getSelectSchemeInfo().getOrgUnit() != null && !orgUnitInfo.getId().toString().equals(this.getSelectSchemeInfo().getOrgUnit().getId().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"delete_scheme_org"));
                SysUtil.abort();
            } else if (MbgExchangeRateSchemeFactory.getRemoteInstance().isHasPeriodRate((IObjectPK)new ObjectUuidPK(this.getSelectSchemeInfo().getId()))) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"delete_scheme_rate"));
                SysUtil.abort();
            }
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    protected void initTree() throws Exception {
        super.initTree();
    }

    protected void prepareGroupUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareGroupUIContext(uiContext, e);
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.treeView.setShowButton(false);
        this.btnGroupMoveTree.setVisible(false);
        this.btnGroupMoveTree.setEnabled(false);
        this.btnMoveTree.setVisible(false);
        this.btnMoveTree.setEnabled(false);
    }

    protected void initPopmenu() {
        JPopupMenu menu = this.treeMain.getPopupMenu();
        EventListener[] ls = this.treeMain.getListeners(TreePopupMenuListener.class);
        if (ls == null || ls.length == 0) {
            menu.removeAll();
        }
        super.initPopmenu();
    }

    protected String getEditUIName() {
        return null;
    }

    protected IMbgExchangeRate getBizInterface() throws Exception {
        return MbgExchangeRateFactory.getRemoteInstance();
    }

    protected String getGroupEditUIName() {
        return MbgExchangeRateSchemeEditUI.class.getName();
    }

    protected String getGroupEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected String getRootName() {
        return null;
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        return null;
    }

    protected String getQueryFieldName() {
        return COL_EXCHANGERATESCHEME_ID;
    }

    protected boolean isSupportEASPivot() {
        return false;
    }

    protected boolean isCanOrderTable() {
        return false;
    }

    protected IMbgExchangeRateScheme getTreeInterface() throws Exception {
        return MbgExchangeRateSchemeFactory.getRemoteInstance();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
    }

    public void locateTbl(int locateIndex) {
        if (locateIndex > 0) {
            this.tblMain.getSelectManager().setActiveRowIndex(locateIndex);
            this.tblMain.getSelectManager().select(locateIndex, -1);
        }
        if (this.getTableLocate() != null) {
            this.getTableLocate().locate();
        }
    }

    protected SelectorItemCollection getSelectorForTree() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(COL_ID);
        sic.add("*");
        sic.add("targeCurrency.*");
        sic.add("sourceCurrency.*");
        sic.add(COL_ORGUNIT_ID);
        sic.add("orgUnit.number");
        sic.add(COL_ORGUNIT_NAME);
        return sic;
    }

    public void setSelectTreeNode() throws Exception {
        KDTreeNode root = (KDTreeNode)this.treeMain.getModel().getRoot();
        MbgExchangeRateSchemeInfo info = null;
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            KDTreeNode childAt = (KDTreeNode)root.getChildAt(i);
            if (childAt == null || !(childAt.getUserObject() instanceof MbgExchangeRateSchemeInfo) || !(info = (MbgExchangeRateSchemeInfo)childAt.getUserObject()).getNumber().toString().equals(this.newMbgExchangeRateSchemeNum)) continue;
            this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)childAt);
            break;
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        CacheServiceFactory.getInstance().discardQuery(this.mainQueryPK);
        ItemAction action = null;
        if (e != null) {
            action = this.getActionFromActionEvent(e);
        }
        if (action == null) {
            this.execQuery();
            return;
        }
        if (action.equals(this.actionView) && this.isModify) {
            this.execQuery();
            return;
        }
        if (action.equals(this.actionGroupEdit)) {
            TreePath oldPath = this.treeMain.getSelectionPath();
            this.initTree();
            this.treeMain.setSelectionPath(TreePathUtil.getNewTreePath((JTree)this.treeMain, (TreeModel)this.treeMain.getModel(), (TreePath)oldPath));
        } else {
            super.refresh(e);
        }
        if ((this.treeMain.getSelectionPath() == null || this.treeMain.getSelectionPath().getLastPathComponent() == this.treeMain.getModel().getRoot()) && this.treeMain.getRowCount() > 0) {
            this.treeMain.setSelectionRow(0);
        } else if (this.treeMain.getSelectionPath() == null) {
            this.tblMain.removeRows();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int clickCount;
        if (e.getType() == 1 ? (clickCount = e.getClickCount()) == 2 : e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1 && e.getColIndex() != 1) {
            return;
        }
        super.tblMain_tableClicked(e);
    }

    protected List<Integer> getSelectRowIndex() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        MbgExchangeRateSchemeInfo rateSchemeInfo = this.getSelectSchemeInfo();
        IObjectPK pk = null;
        if (rateSchemeInfo != null) {
            pk = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"print"), (BOSObjectType)rateSchemeInfo.getBOSType(), (IObjectPK)new ObjectUuidPK(rateSchemeInfo.getId()), (String)(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"print1") + rateSchemeInfo.getNumber() + " - " + rateSchemeInfo.getName()), (String)"mbg_rate_print");
        }
        super.actionPrint_actionPerformed(e);
        if (pk != null) {
            LogUtil.afterLog(null, pk);
        }
    }

    protected boolean isRowModify(IRow row) {
        boolean isRowModify = false;
        MbgExchangeRateInfo oldInfo = null;
        if (row.getUserObject() instanceof MbgExchangeRateInfo) {
            oldInfo = (MbgExchangeRateInfo)row.getUserObject();
            if (oldInfo.getRate() == null && row.getCell(COL_RATE).getValue() != null) {
                isRowModify = true;
            } else if (oldInfo.getRate() != null && row.getCell(COL_RATE).getValue() == null) {
                isRowModify = true;
            } else if (oldInfo.getRate() != null && row.getCell(COL_RATE).getValue() != null && oldInfo.getRate().compareTo((BigDecimal)row.getCell(COL_RATE).getValue()) != 0) {
                isRowModify = true;
            }
        }
        return isRowModify;
    }

    protected void checkSave(MbgExchangeRateSchemeInfo rateSchene) throws Exception {
        int size = this.tblMain.getRowCount();
        if (size > 0) {
            int rs;
            boolean isNeedSave = false;
            for (int i = 0; i < size; ++i) {
                IRow row = this.tblMain.getRow(i);
                if (row.getCell(COL_ID) == null || row.getCell(COL_ID).getValue() == null) {
                    isNeedSave = true;
                    break;
                }
                isNeedSave = this.isRowModify(row);
                if (isNeedSave) break;
            }
            if (isNeedSave && ((rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"needSave"))) == 0 || rs == 0)) {
                this.doSave(rateSchene);
            }
        }
    }

    @Override
    protected void comboPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboPeriodType_itemStateChanged(e);
        if (e != null && e.getStateChange() != 1) {
            return;
        }
        this.checkSave(this.getSelectSchemeInfo());
    }

    class MyCellEditor
    extends KDTDefaultCellEditor {
        public MyCellEditor(JTextField textField) {
            super(textField);
        }

        public Object getValue() {
            Object obj = super.getValue();
            if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
                return null;
            }
            return obj;
        }
    }
}

