/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.IMbgExchangeRateScheme;
import com.kingdee.eas.ma.base.MbgExchangeRateSchemeFactory;
import com.kingdee.eas.ma.base.MbgExchangeRateSchemeInfo;
import com.kingdee.eas.ma.base.client.AbstractMbgExchangeRateSchemeEditUI;
import com.kingdee.eas.ma.base.client.MbgExchangeRateListUI;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class MbgExchangeRateSchemeEditUI
extends AbstractMbgExchangeRateSchemeEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgExchangeRateSchemeEditUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initPrecision();
        this.setCurrencyViewInfo(this.prmtSourceCurrency);
        this.setCurrencyViewInfo(this.prmtTargeCurrency);
    }

    protected void setCurrencyViewInfo(KDBizPromptBox promptBox) throws Exception {
        EntityViewInfo viewInfo = promptBox.getEntityViewInfo();
        if (viewInfo == null) {
            viewInfo = new EntityViewInfo();
        }
        if (viewInfo.getFilter() == null) {
            viewInfo.setFilter(new FilterInfo());
        }
        viewInfo.setFilter("id not in( '11111111-1111-1111-1111-111111111111DEB58FDC', '22222222-2222-2222-2222-222222222222DEB58FDC') and deletedStatus = 1");
        promptBox.setEntityViewInfo(viewInfo);
    }

    protected void initPrecision() {
        Object[] precisions = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8};
        this.txtPrecision.addItems(precisions);
        if (this.editData != null) {
            if (this.editData.getPrecision() <= 0) {
                this.txtPrecision.setSelectedItem((Object)6);
            } else {
                this.txtPrecision.setSelectedItem((Object)this.editData.getPrecision());
            }
        } else {
            this.txtPrecision.setSelectedItem((Object)6);
        }
    }

    protected void loadData() throws Exception {
        super.loadData();
        this.disEnabelTxtNumber();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (OprtState.VIEW.equals(this.getOprtState())) {
            BgCommCHelper.disableAction((JButton)this.btnSubmit, null);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (this.editData.getOrgUnit() != null && !orgUnitInfo.getId().toString().equals(this.editData.getOrgUnit().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"edit_scheme_org"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.disEnabelTxtNumber();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo orgUnitInfo = SysContext.getSysContext().getCurrentOrgUnit();
        if (!orgUnitInfo.getId().toString().equals(this.editData.getOrgUnit().getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"delete_scheme_org"));
            SysUtil.abort();
        } else if (MbgExchangeRateSchemeFactory.getRemoteInstance().isHasPeriodRate((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"delete_scheme_rate"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        Object object = this.getUIContext().get("Owner");
        if (object instanceof MbgExchangeRateListUI) {
            ((MbgExchangeRateListUI)((Object)object)).newMbgExchangeRateSchemeNum = this.txtNumber.getText();
        }
        super.actionSubmit_actionPerformed(e);
        if (object instanceof MbgExchangeRateListUI) {
            ((MbgExchangeRateListUI)((Object)object)).initTree();
            ((MbgExchangeRateListUI)((Object)object)).setSelectTreeNode();
        }
    }

    protected void doBeforeSave(ActionEvent e) throws Exception {
        super.doBeforeSave(e);
        if (this.editData != null && this.txtPrecision.getSelectedItem() != null && this.txtPrecision.getSelectedItem() instanceof Integer) {
            this.editData.setPrecision((Integer)this.txtPrecision.getSelectedItem());
        }
    }

    private void disEnabelTxtNumber() throws Exception {
        if (OprtState.EDIT.equals(this.getOprtState()) || this.editData.getId() != null) {
            if (this.getBizInterface().isHasPeriodRate((IObjectPK)new ObjectUuidPK(this.editData.getId()))) {
                this.txtNumber.setEditable(false);
                this.txtNumber.setEnabled(false);
            } else {
                this.txtNumber.setEditable(true);
                this.txtNumber.setEnabled(true);
            }
        } else {
            this.txtNumber.setEditable(true);
            this.txtNumber.setEnabled(true);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        Object selectedItem;
        Object data;
        super.verifyInput(e);
        if (this.txtNumber.isEnabled()) {
            if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"NumberIsNull"));
                SysUtil.abort();
            } else if (!BgNumberHelper.checkNumber(this.txtNumber.getText())) {
                this.txtNumber.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgItemResource", "haveEspecial"));
                SysUtil.abort();
            }
        }
        if (BgDBUtils.length(this.txtNumber.getText()) > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"NumberIsOverMax", (Object[])new Object[]{80}));
            SysUtil.abort();
        }
        if ((data = ((MultiLangItem)(selectedItem = this.txtName.getModel().getSelectedItem())).getData()) == null || StringUtils.isEmpty((String)data.toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"NameIsNull"));
            SysUtil.abort();
        }
        if (this.prmtSourceCurrency.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"sourceCurrencyIsNull"));
            SysUtil.abort();
        }
        if (this.prmtTargeCurrency.getData() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"targeCurrencyIsNull"));
            SysUtil.abort();
        }
        if (((CurrencyInfo)this.prmtSourceCurrency.getData()).getId().equals((Object)((CurrencyInfo)this.prmtTargeCurrency.getData()).getId())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgExchangeRateResource", (String)"sAndtSame"));
            SysUtil.abort();
        }
    }

    protected IObjectValue createNewData() {
        MbgExchangeRateSchemeInfo info = new MbgExchangeRateSchemeInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        info.setOrgUnit(SysContext.getSysContext().getCurrentOrgUnit().castToFullOrgUnitInfo());
        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        info.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
        return info;
    }

    protected IMbgExchangeRateScheme getBizInterface() throws Exception {
        return MbgExchangeRateSchemeFactory.getRemoteInstance();
    }
}

