/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgDimSourceCollection;
import com.kingdee.eas.ma.base.BgDimSourceFactory;
import com.kingdee.eas.ma.base.BgDimSourceInfo;
import com.kingdee.eas.ma.base.BgImportSourceEnum;
import com.kingdee.eas.ma.base.BgSysSourceNumEnum;
import com.kingdee.eas.ma.base.BgUpperGatherEnum;
import com.kingdee.eas.ma.base.IBgDimSource;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgMemberNodeCollection;
import com.kingdee.eas.ma.base.MbgMemberNodeFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.MemberSegregationRuleEnum;
import com.kingdee.eas.ma.base.client.BgAccountSysImportUI;
import com.kingdee.eas.ma.base.client.BgSysImportUI;
import com.kingdee.eas.ma.base.client.LongTimeDialog;
import com.kingdee.eas.ma.base.client.NumberExpandInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.MbgDimHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MbgMemberSysImportUI
extends BgSysImportUI {
    private static final Logger logger = CoreUIObject.getLogger(BgAccountSysImportUI.class);
    private static final long serialVersionUID = 1L;
    private boolean isNeedCheckRf = true;
    private boolean hasHidedRows = false;
    private HashSet<String> refDataIds = null;
    private HashSet<String> rightIDSet = new HashSet();
    private HashSet<String> selectedLongNumber = new HashSet();
    private HashSet<Integer> selectedLevel = new HashSet();
    private HashMap<String, Object> leftNumberMap = new HashMap();
    private HashMap<String, Object> selectColls = new HashMap();
    private HashSet<String> selectedSetNum = new HashSet();
    private HashMap<String, TreeBaseInfo> addMemberMap = new HashMap();
    HashMap<String, TreeBaseInfo> leftMap = new HashMap();
    private HashMap<String, GeneralAsstActTypeInfo> tempAsstInfo = new HashMap();
    Map<String, String> assDataIds = new HashMap<String, String>();
    TreeBaseCollection memberCollsCache = new TreeBaseCollection();
    HashMap<String, TreeBaseInfo> rightMap = new HashMap();

    public HashMap<String, Object> getSelectColl() {
        return this.selectColls;
    }

    public HashMap<String, TreeBaseInfo> getAddMemberColls() {
        return this.addMemberMap;
    }

    @Override
    protected void init() {
        super.init();
        this.initSourceNumber();
        this.initMemberSource(this.kDCBSource);
        this.initMemberView(this.getUIContext().get("viewInfo"));
        this.initTblRight();
        this.initPrmtSourceMember();
        this.addEnterKeyListener();
    }

    private void initSourceNumber() {
        this.cbxSourceNumber.removeAllItems();
        this.cbxSourceNumber.addItem((Object)BgSysSourceNumEnum.number);
        this.cbxSourceNumber.addItem((Object)BgSysSourceNumEnum.longNumber);
        this.cbxSourceNumber.setSelectedIndex(0);
    }

    @Override
    protected void cbxSourceNumber_itemStateChanged(ItemEvent e) throws Exception {
        super.cbxSourceNumber_itemStateChanged(e);
        Object data = this.prmtSourceMember.getData();
        if (data != null && data instanceof GeneralAsstActTypeGroupInfo) {
            GeneralAsstActTypeGroupInfo info = (GeneralAsstActTypeGroupInfo)data;
            this.tblMain.removeRows();
            this.leftNumberMap.clear();
            this.reLoadGenaralAsst(info);
        }
    }

    private void addEnterKeyListener() {
        this.kdLeftSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 10) {
                        MbgMemberSysImportUI.this.btnLeftSearchAction();
                    }
                }
                catch (Exception exc) {
                    MbgMemberSysImportUI.this.handUIException(exc);
                }
            }
        });
        this.kdRightSearch.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    if (e.getKeyCode() == 10) {
                        MbgMemberSysImportUI.this.btnRightSearchAction();
                    }
                }
                catch (Exception exc) {
                    MbgMemberSysImportUI.this.handUIException(exc);
                }
            }
        });
    }

    private void initMemberView(Object object) {
    }

    private void initMemberSource(KDComboBox kDCBSource) {
        BgImportSourceEnum source;
        if (!(kDCBSource.getSelectedItem() instanceof BgImportSourceEnum) || BgImportSourceEnum.getEnum((source = (BgImportSourceEnum)((Object)kDCBSource.getSelectedItem())).toString()) == BgImportSourceEnum.systemData || BgImportSourceEnum.getEnum(source.toString()) == BgImportSourceEnum.selfDefineData) {
            // empty if block
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtSourceMember.setMyCommonUseEnabled(false);
        this.kDCBSource.setEnabled(true);
        this.kDCBSource.addItem((Object)BgImportSourceEnum.systemData);
        this.kDCBSource.addItem((Object)BgImportSourceEnum.selfDefineData);
        this.kDLabelContainer5.setVisible(false);
        this.kDLabelContainer4.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"dimView"));
        this.kdLeftSearch.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"));
        this.kdRightSearch.setText(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"));
    }

    @Override
    public void setUITitle(String title) {
        title = EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"memberSysImport");
        super.setUITitle(title);
    }

    protected void initPrmtSourceMember() {
        this.prmtSourceMember.setQueryInfo("com.kingdee.eas.ma.base.BaseDataSourceQuery");
        this.prmtSourceMember.setEditFormat("$bizName$");
        this.prmtSourceMember.setDisplayFormat("$bizName$");
        this.prmtSourceMember.setCommitFormat("$bizName$");
        this.prmtSourceMember.setEditable(false);
        Set<String> tableNames = this.getTableNames();
        if (tableNames != null && !tableNames.isEmpty()) {
            EntityViewInfo evi = this.prmtSourceMember.getEntityViewInfo();
            if (evi == null) {
                evi = new EntityViewInfo();
                evi.setFilter(new FilterInfo());
            }
            BgCommHelper.addFilterItem(evi.getFilter(), new FilterItemInfo("bizTable", tableNames, CompareType.INCLUDE));
            this.prmtSourceMember.setEntityViewInfo(evi);
        }
        if (this.getDefaultTableName() != null) {
            try {
                BgDimSourceCollection sources = BgDimSourceFactory.getRemoteInstance().getBgDimSourceCollection("where bizTable = '" + this.getDefaultTableName() + "'");
                if (sources != null && !sources.isEmpty()) {
                    this.prmtSourceMember.setData((Object)sources.get(0));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    protected String getDefaultTableName() {
        return null;
    }

    protected Set<String> getTableNames() {
        return null;
    }

    @Override
    protected void prmtCostCenter_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCostCenter_dataChanged(e);
        if (this.prmtSourceMember.getData() instanceof BgDimSourceInfo) {
            BgDimSourceInfo info = (BgDimSourceInfo)this.prmtSourceMember.getData();
            this.putDataToTable(info);
        }
    }

    @Override
    protected void kdCheckOrg_itemStateChanged(ItemEvent e) throws Exception {
        if (this.prmtSourceMember.getData() instanceof BgDimSourceInfo) {
            BgDimSourceInfo info = (BgDimSourceInfo)this.prmtSourceMember.getData();
            this.putDataToTable(info);
        }
    }

    private void putDataToTable(BgDimSourceInfo info) throws Exception {
        boolean isSelect = this.kdCheckOrg.isSelected();
        CostCenterOrgUnitInfo unitInfo = null;
        if (this.prmtCostCenter.getData() == null || !(this.prmtCostCenter.getData() instanceof CostCenterOrgUnitInfo)) {
            return;
        }
        unitInfo = (CostCenterOrgUnitInfo)this.prmtCostCenter.getData();
        IObjectCollection bizColls = this.getBizInterface().getBizCollection(info.getId().toString(), String.valueOf(isSelect), unitInfo);
        TreeBaseCollection bizColl = null;
        if (bizColls instanceof TreeBaseCollection) {
            bizColl = (TreeBaseCollection)bizColls;
            for (int i = 0; i < bizColl.size(); ++i) {
                if (bizColl.get(i).getLongNumber() == null) {
                    this.leftMap.put(bizColl.get(i).getNumber(), bizColl.get(i));
                    this.leftNumberMap.put(bizColl.get(i).getNumber(), bizColl.get(i));
                    continue;
                }
                this.leftMap.put(bizColl.get(i).getLongNumber(), bizColl.get(i));
                this.leftNumberMap.put(bizColl.get(i).getNumber(), bizColl.get(i));
            }
        }
        this.putDataToTable(bizColls, this.tblMain);
    }

    @Override
    protected void prmtSourceMember_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtSourceMember_dataChanged(e);
        this.tblMain.removeRows();
        this.leftNumberMap.clear();
        if (e.getNewValue() instanceof BgDimSourceInfo) {
            BgDimSourceInfo info = (BgDimSourceInfo)e.getNewValue();
            this.dealCheckBoxOrgContainSub(info.getBizTable());
            this.putDataToTable(info);
        } else if (e.getNewValue() instanceof GeneralAsstActTypeGroupInfo) {
            GeneralAsstActTypeGroupInfo info = (GeneralAsstActTypeGroupInfo)e.getNewValue();
            this.reLoadGenaralAsst(info);
        }
    }

    private void reLoadGenaralAsst(GeneralAsstActTypeGroupInfo info) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getId().toString(), CompareType.EQUALS));
        SorterItemCollection sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("longnumber");
        sort.setSortType(SortType.ASCEND);
        sic.add(sort);
        evi.setFilter(filter);
        evi.setSorter(sic);
        GeneralAsstActTypeCollection bizColls = GeneralAsstActTypeFactory.getRemoteInstance().getGeneralAsstActTypeCollection(evi);
        this.replaceGeneralAsstNumber(bizColls);
        for (int i = 0; i < bizColls.size(); ++i) {
            this.leftMap.put(bizColls.get(i).getLongNumber(), (TreeBaseInfo)bizColls.get(i));
            this.leftNumberMap.put(bizColls.get(i).getNumber(), bizColls.get(i));
        }
        this.putAsstDataToTable(bizColls, this.tblMain);
    }

    private void replaceGeneralAsstNumber(GeneralAsstActTypeCollection bizColls) {
        if (null == bizColls || bizColls.isEmpty()) {
            return;
        }
        Object selectedItem = this.cbxSourceNumber.getSelectedItem();
        if (selectedItem != null && BgSysSourceNumEnum.longNumber.equals(selectedItem)) {
            Map<String, GeneralAsstActTypeInfo> infoMap = this.getConvertAsstNumber(bizColls);
            StringBuilder builder = new StringBuilder();
            int in = bizColls.size();
            for (int i = 0; i < in; ++i) {
                GeneralAsstActTypeInfo info = bizColls.get(i);
                info.setNumber(infoMap.get(info.getId().toString()).getNumber());
                this.appendLongNumberByParent(info, infoMap, builder);
                info.setLongNumber(builder.toString());
                builder.setLength(0);
            }
        }
    }

    private void appendLongNumberByParent(GeneralAsstActTypeInfo info, Map<String, GeneralAsstActTypeInfo> infoMap, StringBuilder longNumber) {
        GeneralAsstActTypeInfo parent = info.getParent();
        if (null == parent) {
            longNumber = longNumber.insert(0, infoMap.get(info.getId().toString()).getNumber());
            return;
        }
        if (!infoMap.containsKey(info.getId().toString())) {
            return;
        }
        longNumber = longNumber.insert(0, infoMap.get(info.getId().toString()).getNumber()).insert(0, BgBaseConstants.SEP_ONE_STR);
        this.appendLongNumberByParent(parent, infoMap, longNumber);
    }

    private Map<String, GeneralAsstActTypeInfo> getConvertAsstNumber(GeneralAsstActTypeCollection bizColls) {
        HashMap<String, GeneralAsstActTypeInfo> infoMap = new HashMap<String, GeneralAsstActTypeInfo>();
        int in = bizColls.size();
        for (int i = 0; i < in; ++i) {
            GeneralAsstActTypeInfo info = bizColls.get(i);
            String longNumber = info.getLongNumber();
            String replace = longNumber.replace("!", ".");
            info.setNumber(replace);
            infoMap.put(info.getId().toString(), info);
        }
        return infoMap;
    }

    private void putAsstDataToTable(GeneralAsstActTypeCollection bizColls, KDTable tblMain) {
        if (bizColls == null || bizColls.isEmpty()) {
            return;
        }
        tblMain.removeRows();
        IRow addRow = null;
        GeneralAsstActTypeInfo asstInfo = null;
        NumberExpandInfo numberExpandInfo = null;
        int size = bizColls.size();
        for (int index = 0; index < size; ++index) {
            asstInfo = bizColls.get(index);
            addRow = tblMain.addRow();
            String id = BOSUuid.create((BOSObjectType)new MbgMemberInfo().getBOSType()).toString();
            this.assDataIds.put(asstInfo.getId().toString(), id);
            addRow.getCell("id").setValue((Object)id);
            addRow.getCell("number").setValue((Object)asstInfo.getNumber());
            addRow.getCell("name").setValue((Object)asstInfo.getName());
            addRow.getCell("longNumber").setValue((Object)asstInfo.getLongNumber());
            addRow.getCell("isLeaf").setValue((Object)asstInfo.isIsLeaf());
            addRow.getCell("level").setValue((Object)asstInfo.getLevel());
            addRow.getCell("parent").setValue((Object)this.getParentInfo(asstInfo.getLongNumber(), this.leftMap));
            addRow.setUserObject((Object)asstInfo);
            numberExpandInfo = new NumberExpandInfo();
            numberExpandInfo.setName(asstInfo.getName());
            numberExpandInfo.setNumber(asstInfo.getNumber());
            numberExpandInfo.setLongNumber(asstInfo.getLongNumber());
            numberExpandInfo.setLevel(asstInfo.getLevel());
            numberExpandInfo.setLeaf(asstInfo.isIsLeaf());
            numberExpandInfo.setShowNumber(true);
            numberExpandInfo.setExpandStatus(true);
            addRow.getCell("number").setValue((Object)numberExpandInfo);
            this.tempAsstInfo.put(asstInfo.getId().toString(), asstInfo);
        }
    }

    private void dealCheckBoxOrgContainSub(String bizTable) {
        if (!(bizTable.equals("T_BD_Material") || bizTable.equals("T_BD_Customer") || bizTable.equals("T_BD_Supplier") || bizTable.equals("T_BD_Project") || bizTable.equals("T_FA_Cat") || bizTable.equals("T_LCM_LCMLcmCat") || bizTable.equals("T_NCM_CostItem"))) {
            this.kdCheckOrg.setEnabled(false);
            this.kdCheckOrg.setEditable(false);
        } else {
            this.kdCheckOrg.setEnabled(true);
            this.kdCheckOrg.setEditable(true);
        }
    }

    private void initTblRight() {
        Object view = this.getUIContext().get("viewInfo");
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("unitInfo");
        if (view != null && view instanceof MbgViewInfo) {
            try {
                EntityViewInfo viewInfo = new EntityViewInfo();
                SelectorItemCollection sicc = new SelectorItemCollection();
                String selectorAll = System.getProperty("selector.all");
                if (StringUtils.isEmpty((String)selectorAll)) {
                    selectorAll = "true";
                }
                sicc.add(new SelectorItemInfo("id"));
                sicc.add(new SelectorItemInfo("number"));
                sicc.add(new SelectorItemInfo("name"));
                sicc.add(new SelectorItemInfo("level"));
                sicc.add(new SelectorItemInfo("aggregation"));
                sicc.add(new SelectorItemInfo("description"));
                sicc.add(new SelectorItemInfo("orgunit.id"));
                sicc.add(new SelectorItemInfo("isLeaf"));
                sicc.add(new SelectorItemInfo("longNumber"));
                sicc.add(new SelectorItemInfo("parent.name"));
                sicc.add(new SelectorItemInfo("orgunit.name"));
                sicc.add(new SelectorItemInfo("orgunit.number"));
                sicc.add(new SelectorItemInfo("orgunit.longnumber"));
                sicc.add(new SelectorItemInfo("parent.id"));
                sicc.add(new SelectorItemInfo("createTime"));
                sicc.add(new SelectorItemInfo("creator.name"));
                sicc.add(new SelectorItemInfo("isSystemDefault"));
                sicc.add(new SelectorItemInfo("parent.number"));
                sicc.add(new SelectorItemInfo("lastUpdateTime"));
                sicc.add(new SelectorItemInfo("lastUpdateUser.name"));
                sicc.add(new SelectorItemInfo("isEnabled"));
                sicc.add(new SelectorItemInfo("disabledDate"));
                sicc.add(new SelectorItemInfo("displayName"));
                sicc.add(new SelectorItemInfo("mbgDim.id"));
                sicc.add(new SelectorItemInfo("viewId"));
                viewInfo.setSelector(sicc);
                if (viewInfo.getFilter() == null) {
                    viewInfo.setFilter(new FilterInfo());
                }
                FilterItemInfo viewid = new FilterItemInfo("viewid", (Object)((MbgViewInfo)view).getId(), CompareType.EQUALS);
                viewInfo.getFilter().getFilterItems().add(viewid);
                FilterInfo filter = viewInfo.getFilter();
                MbgMemberCollection memberColls = MbgMemberFactory.getRemoteInstance().getMbgMemberCollection(viewInfo);
                for (int i = 0; i < memberColls.size(); ++i) {
                    this.rightNumSet.add(memberColls.get(i).getNumber());
                    this.rightNumMap.put(memberColls.get(i).getNumber(), memberColls.get(i));
                }
                if (((MbgViewInfo)view).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS)) {
                    Set<String> orgUnitIds = this.getParentAndChildrenOrgUnitIds((OrgUnitInfo)orgUnitInfo);
                    if (!orgUnitIds.isEmpty()) {
                        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE));
                    }
                } else if (((MbgViewInfo)view).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEORG)) {
                    FilterItemInfo orgItemInfo = null;
                    if (orgUnitInfo != null) {
                        EntityViewInfo evi = new EntityViewInfo();
                        evi.setFilter(new FilterInfo());
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("mbgMember.viewId", (Object)((MbgViewInfo)view).getId().toString(), CompareType.EQUALS));
                        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
                        MbgMemberNodeCollection coll = null;
                        try {
                            coll = MbgMemberNodeFactory.getRemoteInstance().getMbgMemberNodeCollection(evi);
                        }
                        catch (BOSException e) {
                            e.printStackTrace();
                        }
                        orgItemInfo = new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS);
                        BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
                        filter.getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)1, CompareType.EQUALS));
                        if (coll != null && !coll.isEmpty()) {
                            HashSet<String> memberids = new HashSet<String>();
                            for (int i = 0; i < coll.size(); ++i) {
                                memberids.add(coll.get(i).getMbgMember().getId().toString());
                            }
                            orgItemInfo = new FilterItemInfo("id", memberids, CompareType.INCLUDE);
                            BgCommCHelper.replaceFilterItems(filter, orgItemInfo);
                            viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 OR #3)");
                        } else {
                            viewInfo.getFilter().setMaskString("#0 and ( #1 OR #2 )");
                        }
                    }
                }
                SorterItemCollection sic = new SorterItemCollection();
                SorterItemInfo sortorSysDefault = new SorterItemInfo("isSystemDefault");
                sortorSysDefault.setSortType(SortType.DESCEND);
                sic.add(sortorSysDefault);
                viewInfo.setSorter(sic);
                SorterItemInfo sortorLongNum = new SorterItemInfo("longNumber");
                sortorLongNum.setSortType(SortType.ASCEND);
                sic.add(sortorLongNum);
                this.memberCollsCache = MbgMemberFactory.getRemoteInstance().getTreeBaseCollection(viewInfo);
                for (int i = 0; i < this.memberCollsCache.size(); ++i) {
                    this.rightMap.put(this.memberCollsCache.get(i).getLongNumber(), this.memberCollsCache.get(i));
                    this.rightIDSet.add(this.memberCollsCache.get(i).getId().toString());
                }
                this.putDataToTable((IObjectCollection)this.memberCollsCache, this.tblRight);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
        }
    }

    private IBgDimSource getBizInterface() throws BOSException {
        return BgDimSourceFactory.getRemoteInstance();
    }

    @Override
    protected void addPopMenu() {
        AbstractAction directChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgMemberSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = MbgMemberSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                MbgMemberInfo info = null;
                GeneralAsstActTypeInfo asstInfo = null;
                String longNumber = null;
                String longNumEx = null;
                int level = -1;
                int count = MbgMemberSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isDirectChild = false;
                    row = MbgMemberSysImportUI.this.tblMain.getRow(i);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        level = info.getLevel();
                    } else if (row.getUserObject() instanceof GeneralAsstActTypeInfo) {
                        asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                        longNumber = asstInfo.getLongNumber();
                        level = asstInfo.getLevel();
                    }
                    if (longNumber != null && longNumber.contains("!")) {
                        longNumEx = longNumber.substring(0, longNumber.lastIndexOf("!") + 1);
                        if (MbgMemberSysImportUI.this.selectedLongNumber.contains(longNumEx) || MbgMemberSysImportUI.this.selectedLongNumber.contains(longNumber)) {
                            isDirectChild = true;
                        }
                    }
                    if (!MbgMemberSysImportUI.this.selectedLevel.contains(level - 1) || !isDirectChild) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    MbgMemberSysImportUI.this.tblMain.getSelectManager().add(sb);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                        continue;
                    }
                    if (!(row.getUserObject() instanceof GeneralAsstActTypeInfo)) continue;
                    asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                    longNumber = asstInfo.getLongNumber();
                    MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                }
            }
        };
        AbstractAction allChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgMemberSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = MbgMemberSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                MbgMemberInfo info = null;
                String longNumber = null;
                GeneralAsstActTypeInfo asstInfo = null;
                int level = -1;
                int count = MbgMemberSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isChild = false;
                    row = MbgMemberSysImportUI.this.tblMain.getRow(i);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        level = info.getLevel();
                    } else if (row.getUserObject() instanceof GeneralAsstActTypeInfo) {
                        asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                        longNumber = asstInfo.getLongNumber();
                        level = asstInfo.getLevel();
                    }
                    for (String selectedLongNum : MbgMemberSysImportUI.this.selectedLongNumber) {
                        if (!(longNumber + "!").startsWith(selectedLongNum)) continue;
                        isChild = true;
                    }
                    if (!isChild) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    MbgMemberSysImportUI.this.tblMain.getSelectManager().add(sb);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                        continue;
                    }
                    if (!(row.getUserObject() instanceof GeneralAsstActTypeInfo)) continue;
                    asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                    longNumber = asstInfo.getLongNumber();
                    MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                }
            }
        };
        AbstractAction levelChildAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                MbgMemberSysImportUI.this.getAutoSelectValues();
                KDTSelectBlock sb = null;
                int columnCount = MbgMemberSysImportUI.this.tblMain.getColumnCount();
                IRow row = null;
                MbgMemberInfo info = null;
                GeneralAsstActTypeInfo asstInfo = null;
                int level = -1;
                String longNumber = null;
                int count = MbgMemberSysImportUI.this.tblMain.getRowCount();
                for (int i = 0; i < count; ++i) {
                    boolean isLevel = false;
                    row = MbgMemberSysImportUI.this.tblMain.getRow(i);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        level = info.getLevel();
                    } else if (row.getUserObject() instanceof GeneralAsstActTypeInfo) {
                        asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                        longNumber = asstInfo.getLongNumber();
                        level = asstInfo.getLevel();
                    }
                    if (MbgMemberSysImportUI.this.selectedLevel.contains(level)) {
                        isLevel = true;
                    }
                    if (!isLevel) continue;
                    sb = new KDTSelectBlock(i, 0, i, columnCount - 1);
                    MbgMemberSysImportUI.this.tblMain.getSelectManager().add(sb);
                    if (row.getUserObject() instanceof MbgMemberInfo) {
                        info = (MbgMemberInfo)row.getUserObject();
                        longNumber = info.getLongNumber();
                        MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                        continue;
                    }
                    if (!(row.getUserObject() instanceof GeneralAsstActTypeInfo)) continue;
                    asstInfo = (GeneralAsstActTypeInfo)row.getUserObject();
                    longNumber = asstInfo.getLongNumber();
                    MbgMemberSysImportUI.this.getSelectColl().put(longNumber, info);
                }
            }
        };
        this.enableTableCommonMenus(this.tblMain);
        KDTMenuManager menuManager = this.getMenuManager(this.tblMain);
        if (menuManager == null) {
            return;
        }
        KDMenuItem directChild = new KDMenuItem();
        directChild.setAction((Action)directChildAction);
        directChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"directChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)directChild, 0);
        KDMenuItem allChild = new KDMenuItem();
        allChild.setAction((Action)allChildAction);
        allChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"allChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)allChild, 1);
        KDMenuItem levelChild = new KDMenuItem();
        levelChild.setAction((Action)levelChildAction);
        levelChildAction.putValue("Name", EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"levelChild"));
        menuManager.getMenu().addSeparator();
        menuManager.getMenu().add((JMenuItem)levelChild, 2);
        JPopupMenu.Separator kdsp = new JPopupMenu.Separator();
        menuManager.getMenu().add((Component)kdsp, 3);
    }

    @Override
    protected void getAutoSelectValues() {
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return;
        }
        this.selectedLongNumber.clear();
        this.selectedLevel.clear();
        this.getSelectColl().clear();
        MbgMemberInfo info = null;
        GeneralAsstActTypeInfo asstInfo = null;
        KDTSelectBlock block = null;
        IRow curRow = null;
        boolean isHided = false;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                curRow = this.tblMain.getRow(r);
                isHided = curRow.getStyleAttributes().isHided();
                if (isHided) {
                    this.hasHidedRows = true;
                    continue;
                }
                if (this.tblMain.getRow(r).getUserObject() instanceof MbgMemberInfo) {
                    info = (MbgMemberInfo)this.tblMain.getRow(r).getUserObject();
                } else if (this.tblMain.getRow(r).getUserObject() instanceof GeneralAsstActTypeInfo) {
                    asstInfo = (GeneralAsstActTypeInfo)this.tblMain.getRow(r).getUserObject();
                }
                if (info != null) {
                    if (info.getLongNumber() == null) {
                        this.getSelectColl().put(info.getNumber(), info);
                    } else {
                        this.getSelectColl().put(info.getLongNumber(), info);
                    }
                    this.selectedSetNum.add(info.getNumber());
                    this.selectedLongNumber.add(info.getLongNumber() + "!");
                    this.selectedLevel.add(info.getLevel());
                    continue;
                }
                if (asstInfo == null) continue;
                this.getSelectColl().put(asstInfo.getLongNumber(), asstInfo);
                this.selectedSetNum.add(asstInfo.getNumber());
                this.selectedLongNumber.add(asstInfo.getLongNumber() + "!");
                this.selectedLevel.add(asstInfo.getLevel());
            }
        }
    }

    private void putDataToTable(IObjectCollection bizColls, KDTable table) {
        if (bizColls == null || bizColls.isEmpty()) {
            table.removeRows();
            return;
        }
        TreeBaseCollection bizColl = null;
        if (bizColls instanceof TreeBaseCollection) {
            bizColl = (TreeBaseCollection)bizColls;
        }
        if (bizColl == null) {
            return;
        }
        table.removeRows();
        IRow row = null;
        MbgMemberInfo memberInfo = null;
        NumberExpandInfo numberExpandInfo = null;
        boolean isTree = false;
        TreeBaseInfo treeBaseInfo = null;
        HashMap<String, TreeBaseInfo> tmpMap = new HashMap<String, TreeBaseInfo>();
        for (int i = 0; i < bizColl.size(); ++i) {
            treeBaseInfo = bizColl.get(i);
            tmpMap.put(treeBaseInfo.getLongNumber(), treeBaseInfo);
        }
        int size = bizColl.size();
        for (int index = 0; index < size; ++index) {
            memberInfo = (MbgMemberInfo)bizColl.get(index);
            row = table.addRow();
            row.getCell("id").setValue((Object)memberInfo.getId().toString());
            row.getCell("number").setValue((Object)memberInfo.getNumber());
            row.getCell("name").setValue((Object)memberInfo.getName());
            if (memberInfo.getLongNumber() != null) {
                isTree = true;
                row.getCell("longNumber").setValue((Object)memberInfo.getLongNumber());
                row.getCell("isLeaf").setValue((Object)memberInfo.isIsLeaf());
                row.getCell("level").setValue((Object)memberInfo.getLevel());
                row.getCell("displayName").setValue((Object)memberInfo.getDisplayName());
                row.getCell("parent").setValue((Object)this.getParentInfo(memberInfo.getLongNumber(), tmpMap));
                numberExpandInfo = new NumberExpandInfo();
                numberExpandInfo.setName(memberInfo.getName());
                numberExpandInfo.setNumber(memberInfo.getNumber());
                numberExpandInfo.setLongNumber(memberInfo.getLongNumber());
                numberExpandInfo.setLevel(memberInfo.getLevel());
                numberExpandInfo.setLeaf(memberInfo.isIsLeaf());
                numberExpandInfo.setShowNumber(true);
                memberInfo.setParent((MbgMemberInfo)this.getParentInfo(memberInfo.getLongNumber(), tmpMap));
            }
            row.setUserObject((Object)memberInfo);
            if (isTree && numberExpandInfo != null) {
                numberExpandInfo.setExpandStatus(true);
                row.getCell("number").setValue((Object)numberExpandInfo);
            }
            this.disableColorExistMember(row, isTree);
        }
    }

    private void disableColorExistMember(IRow row, boolean isTree) {
        if (row == null) {
            return;
        }
        Color disableColor = new Color(230, 230, 230);
        Object value = row.getCell("number").getValue();
        String number = null;
        if (isTree) {
            NumberExpandInfo info = (NumberExpandInfo)value;
            number = info.getNumber();
        } else {
            number = row.getCell("number").getValue().toString();
        }
        if (this.rightNumSet.contains(number)) {
            row.getStyleAttributes().setBackground(disableColor);
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.tblRight.checkParsed();
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblRight.getSelectManager().setSelectMode(10);
    }

    @Override
    protected void kDCBSource_itemStateChanged(ItemEvent e) throws Exception {
        super.kDCBSource_itemStateChanged(e);
        this.prmtSourceMember.setData(null);
        this.tblMain.removeRows();
        if ((BgImportSourceEnum)((Object)this.kDCBSource.getSelectedItem()) == BgImportSourceEnum.systemData) {
            this.prmtSourceMember.setQueryInfo("com.kingdee.eas.ma.base.BaseDataSourceQuery");
            this.prmtSourceMember.setEditFormat("$bizName$");
            this.prmtSourceMember.setDisplayFormat("$bizName$");
            this.prmtSourceMember.setCommitFormat("$bizName$");
            this.prmtSourceMember.setEditable(false);
            this.enableSourceNumber(false);
        } else if ((BgImportSourceEnum)((Object)this.kDCBSource.getSelectedItem()) == BgImportSourceEnum.selfDefineData) {
            this.prmtSourceMember.setQueryInfo("com.kingdee.eas.basedata.master.auxacct.app.GeneralGroupQuery");
            this.prmtSourceMember.setEditFormat("$Number$");
            this.prmtSourceMember.setDisplayFormat("$Name$");
            this.prmtSourceMember.setCommitFormat("$Name$");
            this.prmtSourceMember.setEditable(false);
            this.enableSourceNumber(true);
        }
    }

    private void enableSourceNumber(boolean b) {
        this.kDLabelContainer6.setVisible(b);
        this.cbxSourceNumber.setVisible(b);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1) {
            return;
        }
        this.actionSelect_actionPerformed(null);
    }

    @Override
    public void actionSelect_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelect_actionPerformed(e);
        int activeRow = this.tblRight.getSelectManager().getActiveRowIndex();
        IRow selectRow = this.tblRight.getRow(activeRow);
        int rightCount = this.tblRight.getRowCount();
        this.validateChooseItems(true, true);
        GeneralAsstActTypeInfo asstInfo = null;
        MbgMemberInfo memberInfo = null;
        int level = 1;
        String longNumber = null;
        if (selectRow.getUserObject() instanceof MbgMemberInfo) {
            longNumber = ((MbgMemberInfo)selectRow.getUserObject()).getLongNumber();
        }
        this.getAutoSelectValues();
        HashMap<String, Object> tmpMap = this.getSelectColl();
        ArrayList<String> numLst = new ArrayList<String>(tmpMap.keySet());
        Collections.sort(numLst);
        boolean isAsstInfo = false;
        isAsstInfo = this.verifyIsAsstInfo(tmpMap);
        boolean isCheckAll = false;
        Set<String> repeatNums = this.verifyIsRepeatNumber(isCheckAll);
        repeatNums = this.getRepeatNumberSet(false, repeatNums);
        Set<String> illegalityNumberSet = this.checkIllegalityNumberSet(false);
        if (illegalityNumberSet != null && !illegalityNumberSet.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"formatIsError", (Object[])new Object[]{illegalityNumberSet.toString()}));
            SysUtil.abort();
        }
        this.checkIsLostHira(isAsstInfo);
        this.checkRightRow((MbgMemberInfo)selectRow.getUserObject());
        IRow addRow = null;
        HashMap<String, MbgMemberInfo> tmpInfoMap = new HashMap<String, MbgMemberInfo>();
        Iterator<String> ite = numLst.iterator();
        while (ite.hasNext()) {
            if (isAsstInfo) {
                asstInfo = (GeneralAsstActTypeInfo)tmpMap.get(ite.next());
                memberInfo = new MbgMemberInfo();
                this.castAsstInfoToMemberInfo(asstInfo, memberInfo, tmpInfoMap);
            } else {
                memberInfo = (MbgMemberInfo)tmpMap.get(ite.next());
                memberInfo = (MbgMemberInfo)memberInfo.clone();
            }
            if (memberInfo == null || this.getAddMemberColls().containsKey(memberInfo.getNumber()) || repeatNums.contains(memberInfo.getNumber())) continue;
            this.checkNumberFormat(memberInfo.getNumber());
            addRow = this.tblRight.addRow(++activeRow);
            this.tblRight.setRowCount(rightCount++);
            if (!this.hasHidedRows) {
                boolean isLeaf = false;
                isLeaf = this.verifyCurMemIsLeaf(memberInfo);
                memberInfo.setIsLeaf(isLeaf);
                this.addNewLineBySelectInfo(addRow, memberInfo, (MbgMemberInfo)selectRow.getUserObject());
                NumberExpandInfo numberExpandInfo = new NumberExpandInfo();
                numberExpandInfo.setName(memberInfo.getName());
                numberExpandInfo.setNumber(memberInfo.getNumber());
                numberExpandInfo.setLongNumber(addRow.getCell("longNumber").getValue().toString());
                numberExpandInfo.setLevel(Integer.valueOf(addRow.getCell("level").getValue().toString()));
                numberExpandInfo.setLeaf(isLeaf);
                numberExpandInfo.setShowNumber(true);
                numberExpandInfo.setExpandStatus(true);
                addRow.getCell("number").setValue((Object)numberExpandInfo);
                memberInfo.setLevel((Integer)addRow.getCell("level").getValue());
                memberInfo.setLongNumber(addRow.getCell("longNumber").getValue().toString());
                this.getAddMemberColls().put(memberInfo.getNumber(), memberInfo);
                continue;
            }
            this.fillRowBaseInfo(addRow, memberInfo, true);
            addRow.getCell("longNumber").setValue((Object)(longNumber + "!" + memberInfo.getNumber()));
            addRow.getCell("parent").setValue((Object)((MbgMemberInfo)selectRow.getUserObject()));
            addRow.getCell("level").setValue((Object)(((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1));
            memberInfo.setLongNumber(addRow.getCell("longNumber").getValue().toString());
            memberInfo.setLevel((Integer)addRow.getCell("level").getValue());
            addRow.setUserObject((Object)memberInfo);
            NumberExpandInfo numberExpandInfo = this.setNumberExpandInfo(memberInfo, level, true);
            addRow.getCell("number").setValue((Object)numberExpandInfo);
            this.getAddMemberColls().put(memberInfo.getNumber(), memberInfo);
        }
        if (addRow != null && ((Boolean)selectRow.getCell("isLeaf").getValue()).booleanValue()) {
            selectRow.getCell("isLeaf").setValue((Object)false);
            ((NumberExpandInfo)selectRow.getCell("number").getValue()).setLeaf(false);
        }
        this.getSelectColl().clear();
    }

    private void checkNumberFormat(String number) {
        if (!BgNumberHelper.checkNumber(number)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"formatIsError", (Object[])new Object[]{number, this.toString()}));
            SysUtil.abort();
        }
    }

    private void checkIsLostHira(boolean isAsstInfo) {
        GeneralAsstActTypeInfo asstInfo = null;
        MbgMemberInfo memberInfo = null;
        String longNum = null;
        String[] longNumEx = null;
        HashMap<String, Object> tmpMap = this.getSelectColl();
        HashMap<String, MbgMemberInfo> tmpInfoMap = new HashMap<String, MbgMemberInfo>();
        Iterator<String> ite = tmpMap.keySet().iterator();
        while (ite.hasNext()) {
            int length;
            if (isAsstInfo) {
                asstInfo = (GeneralAsstActTypeInfo)tmpMap.get(ite.next());
                memberInfo = new MbgMemberInfo();
                this.castAsstInfoToMemberInfo(asstInfo, memberInfo, tmpInfoMap);
            } else {
                memberInfo = (MbgMemberInfo)tmpMap.get(ite.next());
            }
            Boolean hasDerectParent = false;
            Boolean hasInDerectParent = false;
            if (memberInfo.getLongNumber() == null) {
                return;
            }
            longNum = memberInfo.getLongNumber();
            if (!longNum.contains("!") || (length = (longNumEx = longNum.split("!")).length) < 3) continue;
            hasDerectParent = this.selectedSetNum.contains(longNumEx[length - 2]);
            for (int i = length - 3; i >= 0; --i) {
                if (!this.selectedSetNum.contains(longNumEx[i])) continue;
                hasInDerectParent = true;
                break;
            }
            if (hasDerectParent.booleanValue() || !hasInDerectParent.booleanValue()) continue;
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"lostParentNumber", (Object[])new Object[]{memberInfo.getNumber(), this.toString()}));
            SysUtil.abort();
        }
    }

    private void addNewLineBySelectInfo(IRow addRow, MbgMemberInfo memberInfo, MbgMemberInfo selectRowInfo) {
        String parLongnumebr = null;
        addRow.getCell("id").setValue((Object)memberInfo.getId().toString());
        addRow.getCell("number").setValue((Object)memberInfo.getNumber());
        addRow.getCell("name").setValue((Object)memberInfo.getName());
        addRow.getCell("isLeaf").setValue((Object)memberInfo.isIsLeaf());
        if (memberInfo.getLongNumber() != null) {
            parLongnumebr = memberInfo.getLongNumber();
            if (parLongnumebr.indexOf("!") < 0) {
                addRow.getCell("level").setValue((Object)(selectRowInfo.getLevel() + 1));
                addRow.getCell("longNumber").setValue((Object)(selectRowInfo.getLongNumber() + "!" + memberInfo.getNumber()));
                addRow.getCell("displayName").setValue((Object)(selectRowInfo.getDisplayName() + "_" + memberInfo.getDisplayName()));
                addRow.getCell("parent").setValue((Object)selectRowInfo);
            } else if (!this.getSelectColl().keySet().contains(memberInfo.getLongNumber().substring(0, memberInfo.getLongNumber().lastIndexOf("!")))) {
                addRow.getCell("level").setValue((Object)(selectRowInfo.getLevel() + 1));
                addRow.getCell("longNumber").setValue((Object)(selectRowInfo.getLongNumber() + "!" + memberInfo.getNumber()));
                addRow.getCell("displayName").setValue((Object)(selectRowInfo.getDisplayName() + "_" + memberInfo.getDisplayName()));
                addRow.getCell("parent").setValue((Object)selectRowInfo);
            } else if (this.getAddMemberColls().get(memberInfo.getParent().getNumber()) != null) {
                addRow.getCell("parent").setValue((Object)memberInfo.getParent());
                addRow.getCell("level").setValue((Object)(this.getAddMemberColls().get(memberInfo.getParent().getNumber()).getLevel() + 1));
                addRow.getCell("longNumber").setValue((Object)(this.getAddMemberColls().get(memberInfo.getParent().getNumber()).getLongNumber() + "!" + memberInfo.getNumber()));
                addRow.getCell("displayName").setValue((Object)(this.getAddMemberColls().get(memberInfo.getParent().getNumber()).getDisplayName() + "_" + memberInfo.getDisplayName()));
            } else {
                addRow.getCell("level").setValue((Object)(selectRowInfo.getLevel() + 1));
                addRow.getCell("longNumber").setValue((Object)(selectRowInfo.getLongNumber() + "!" + memberInfo.getNumber()));
                addRow.getCell("displayName").setValue((Object)(selectRowInfo.getDisplayName() + "_" + memberInfo.getDisplayName()));
                addRow.getCell("parent").setValue((Object)selectRowInfo);
            }
        } else {
            addRow.getCell("level").setValue((Object)(selectRowInfo.getLevel() + 1));
            addRow.getCell("longNumber").setValue((Object)(selectRowInfo.getLongNumber() + "!" + memberInfo.getNumber()));
            addRow.getCell("displayName").setValue((Object)(selectRowInfo.getDisplayName() + "_" + memberInfo.getName()));
            memberInfo.setDisplayName(selectRowInfo.getDisplayName() + "_" + memberInfo.getName());
            addRow.getCell("parent").setValue((Object)selectRowInfo);
        }
        addRow.setUserObject((Object)memberInfo);
    }

    private boolean verifyCurMemIsLeaf(MbgMemberInfo memberInfo) {
        boolean isLeaf = false;
        for (String str : this.getSelectColl().keySet()) {
            if (memberInfo.getLongNumber() != null) {
                if (str.indexOf(memberInfo.getLongNumber() + "!") >= 0) {
                    isLeaf = false;
                    break;
                }
                isLeaf = true;
                continue;
            }
            isLeaf = true;
            break;
        }
        return isLeaf;
    }

    private void castAsstInfoToMemberInfo(GeneralAsstActTypeInfo asstInfo, MbgMemberInfo memberInfo, HashMap<String, MbgMemberInfo> tmpInfoMap) {
        MbgMemberInfo parMemberInfo = null;
        if (this.assDataIds.containsKey(asstInfo.getId().toString())) {
            memberInfo.setId(BOSUuid.read((String)this.assDataIds.get(asstInfo.getId().toString())));
        } else {
            memberInfo.setId(asstInfo.getId());
        }
        memberInfo.setName(asstInfo.getName());
        memberInfo.setNumber(asstInfo.getNumber());
        memberInfo.setLongNumber(asstInfo.getLongNumber());
        memberInfo.setLevel(asstInfo.getLevel());
        memberInfo.setIsLeaf(asstInfo.isIsLeaf());
        tmpInfoMap.put(asstInfo.getLongNumber(), memberInfo);
        parMemberInfo = new MbgMemberInfo();
        if (asstInfo.getParent() != null) {
            if (tmpInfoMap.containsKey(this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getLongNumber())) {
                BOSUuid id = this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getId();
                if (this.assDataIds.containsKey(id.toString())) {
                    parMemberInfo.setId(BOSUuid.read((String)this.assDataIds.get(id.toString())));
                } else {
                    parMemberInfo.setId(id);
                }
            }
            parMemberInfo.setName(this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getName());
            parMemberInfo.setNumber(this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getNumber());
            parMemberInfo.setLongNumber(this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getLongNumber());
            parMemberInfo.setLevel(this.tempAsstInfo.get(asstInfo.getParent().getId().toString()).getLevel());
        }
        memberInfo.setParent(parMemberInfo);
    }

    private boolean verifyIsAsstInfo(HashMap<String, Object> tmpMap) {
        boolean isAsstInfo = false;
        for (String key : tmpMap.keySet()) {
            if (!(tmpMap.get(key) instanceof GeneralAsstActTypeInfo)) continue;
            isAsstInfo = true;
        }
        return isAsstInfo;
    }

    private Set<String> verifyIsRepeatNumber(boolean isCheckAll) {
        HashSet<String> repeatNums = new HashSet<String>();
        ArrayList<String> numLst = null;
        StringBuffer repeatStr = new StringBuffer();
        HashMap<String, Object> tmpMap = null;
        String number = null;
        Object obj = null;
        if (isCheckAll) {
            numLst = new ArrayList<String>(this.leftNumberMap.keySet());
        } else {
            tmpMap = this.getSelectColl();
        }
        Iterator<String> iterator = null;
        if (tmpMap != null) {
            iterator = tmpMap.keySet().iterator();
        } else if (numLst != null) {
            iterator = numLst.iterator();
        }
        if (iterator != null) {
            Iterator<String> ite = iterator;
            while (ite.hasNext()) {
                String longNumber = ite.next();
                obj = longNumber.indexOf("!") < 0 ? this.leftNumberMap.get(longNumber) : this.leftNumberMap.get(longNumber.substring(longNumber.lastIndexOf("!") + 1, longNumber.length()));
                if (obj instanceof MbgMemberInfo) {
                    number = ((MbgMemberInfo)obj).getNumber();
                } else if (obj instanceof GeneralAsstActTypeInfo) {
                    number = ((GeneralAsstActTypeInfo)obj).getNumber();
                }
                if (!this.getAddMemberColls().containsKey(number) && !this.rightNumSet.contains(number)) continue;
                repeatNums.add(number);
                repeatStr = repeatStr.append(number).append(",");
            }
        }
        if (repeatStr.length() <= 0 || repeatStr.toString().endsWith(",")) {
            // empty if block
        }
        return repeatNums;
    }

    private void validateChooseItems(boolean isVerifyLeft, boolean isVerifyRight) throws EASBizException, BOSException {
        int activeRow;
        if (isVerifyLeft && (activeRow = this.tblMain.getSelectManager().getActiveRowIndex()) == -1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"chooseleftMember"));
            SysUtil.abort();
        }
        if (isVerifyRight) {
            activeRow = this.tblRight.getSelectManager().getActiveRowIndex();
            if (activeRow == -1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"chooseRightMember"));
                SysUtil.abort();
            }
            KDTRange range = this.tblRight.getSelectManager().toRange();
            KDTSelectBlock block = null;
            if (range.size() == 1) {
                block = (KDTSelectBlock)range.get(0);
                if (block.getEndRow() - block.getBeginRow() >= 1) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"chooseRightMember"));
                    SysUtil.abort();
                }
            } else if (range.size() > 1) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"chooseRightMember"));
                SysUtil.abort();
            }
            IRow selectRow = this.tblRight.getRow(activeRow);
            Object numberInfo = this.tblRight.getRow(0).getCell("number").getValue();
            String preStr = null;
            if (numberInfo instanceof NumberExpandInfo) {
                preStr = ((NumberExpandInfo)numberInfo).getNumber() + "-01";
            }
            Object selectNumInfo = selectRow.getCell("number").getValue();
            String selectStr = null;
            if (selectNumInfo instanceof NumberExpandInfo) {
                selectStr = ((NumberExpandInfo)selectNumInfo).getNumber();
            }
            if (preStr != null && preStr.equals(selectStr)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantChoosePreMember"));
                SysUtil.abort();
            }
            Object view = this.getUIContext().get("viewInfo");
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("unitInfo");
            MbgMemberInfo info = (MbgMemberInfo)this.rightNumMap.get(selectStr);
            if (info != null) {
                if (view != null && view instanceof MbgViewInfo && ((MbgViewInfo)view).getSegregationRule().equals((Object)MemberSegregationRuleEnum.SEGREGATEEQUALS) && (info == null || info.getOrgunit().getLongNumber().startsWith(orgUnitInfo.getLongNumber() + "!"))) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"peersNotAddNew"));
                    SysUtil.abort();
                }
                if (info.isIsLeaf()) {
                    MbgMemberInfo leafinfo = new MbgMemberInfo();
                    leafinfo.setMbgDim(info.getMbgDim());
                    leafinfo.setViewId(info.getViewId());
                    leafinfo.setNumber(selectStr);
                    leafinfo.setLongNumber(((NumberExpandInfo)selectNumInfo).getLongNumber());
                    leafinfo.setName(((NumberExpandInfo)selectNumInfo).getName());
                    leafinfo.setParent(info);
                    boolean checkTmpData = MbgMemberFactory.getRemoteInstance().checkTmpData((IObjectValue)leafinfo);
                    if (checkTmpData) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"isExistTmpData", (Object[])new Object[]{info.getNumber(), info.getName()}));
                        SysUtil.abort();
                    } else {
                        Map maps = MbgMemberFactory.getRemoteInstance().checkBgData((IObjectValue)leafinfo, false);
                        if (maps != null && maps.get("dataIDSet") != null) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"sysImportHasData", (Object[])new Object[]{info.getNumber(), info.getName()}));
                            SysUtil.abort();
                        }
                    }
                }
            }
        }
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectAll_actionPerformed(e);
        this.validateChooseItems(false, true);
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                MbgMemberSysImportUI.this.selectAll();
                return null;
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        dialog.show();
    }

    private void selectAll() throws Exception {
        int leftCount = this.tblMain.getRowCount();
        int rightCount = this.tblRight.getRowCount();
        int level = 1;
        String longNumber = null;
        boolean isleaf = false;
        int activeRow = this.tblRight.getSelectManager().getActiveRowIndex();
        IRow selectRow = this.tblRight.getRow(activeRow);
        if (selectRow.getUserObject() instanceof MbgMemberInfo) {
            longNumber = ((MbgMemberInfo)selectRow.getUserObject()).getLongNumber();
            isleaf = ((MbgMemberInfo)selectRow.getUserObject()).isIsLeaf();
        }
        Set<String> repeatNums = this.verifyIsRepeatNumber(true);
        repeatNums = this.getRepeatNumberSet(true, repeatNums);
        Set<String> illegalityNumberSet = this.checkIllegalityNumberSet(true);
        if (illegalityNumberSet != null && !illegalityNumberSet.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"formatIsError", (Object[])new Object[]{illegalityNumberSet.toString()}));
            SysUtil.abort();
        }
        this.checkRightRow((MbgMemberInfo)selectRow.getUserObject());
        this.checkNumberFormat(((MbgMemberInfo)selectRow.getUserObject()).getNumber());
        IRow addRow = null;
        IRow curRow = null;
        MbgMemberInfo memberInfo = null;
        MbgMemberInfo parentMemberInfo = null;
        String parentNumber = null;
        GeneralAsstActTypeInfo asstInfo = null;
        boolean isHided = false;
        boolean hasHidedRows = false;
        int in = leftCount;
        for (int i = 0; i < in; ++i) {
            curRow = this.tblMain.getRow(i);
            isHided = curRow.getStyleAttributes().isHided();
            if (isHided) {
                hasHidedRows = true;
                continue;
            }
            if (curRow.getUserObject() instanceof MbgMemberInfo) {
                memberInfo = (MbgMemberInfo)((MbgMemberInfo)this.tblMain.getRow(i).getUserObject()).clone();
            } else if (this.tblMain.getRow(i).getUserObject() instanceof GeneralAsstActTypeInfo) {
                asstInfo = (GeneralAsstActTypeInfo)((GeneralAsstActTypeInfo)this.tblMain.getRow(i).getUserObject()).clone();
                memberInfo = new MbgMemberInfo();
                memberInfo.setId(BOSUuid.create((BOSObjectType)memberInfo.getBOSType()));
                memberInfo.setName(asstInfo.getName());
                memberInfo.setNumber(asstInfo.getNumber());
                memberInfo.setLongNumber(asstInfo.getLongNumber());
                memberInfo.setLevel(asstInfo.getLevel());
                memberInfo.setIsLeaf(asstInfo.isIsLeaf());
                if (memberInfo.getLongNumber().contains("!") && this.leftMap.keySet().contains(memberInfo.getLongNumber().substring(0, memberInfo.getLongNumber().lastIndexOf("!")))) {
                    parentNumber = memberInfo.getLongNumber().substring(0, memberInfo.getLongNumber().lastIndexOf("!"));
                    GeneralAsstActTypeInfo parentObj = (GeneralAsstActTypeInfo)this.leftMap.get(parentNumber);
                    parentMemberInfo = new MbgMemberInfo();
                    parentMemberInfo.setId(BOSUuid.create((BOSObjectType)parentMemberInfo.getBOSType()));
                    parentMemberInfo.setName(parentObj.getName());
                    parentMemberInfo.setNumber(parentObj.getNumber());
                    parentMemberInfo.setLongNumber(parentObj.getLongNumber());
                    parentMemberInfo.setLevel(parentObj.getLevel());
                    parentMemberInfo.setIsLeaf(parentObj.isIsLeaf());
                    memberInfo.setParent(parentMemberInfo);
                }
            }
            if (memberInfo == null || this.getAddMemberColls().containsKey(memberInfo.getNumber()) || repeatNums.contains(memberInfo.getNumber()) || !BgNumberHelper.checkNumber(memberInfo.getNumber())) continue;
            addRow = this.tblRight.addRow(++activeRow);
            this.tblRight.setRowCount(rightCount++);
            if (!hasHidedRows) {
                boolean isLeaf = false;
                isLeaf = this.checkCurMemIsleaf(memberInfo.getLongNumber());
                this.fillRowBaseInfo(addRow, memberInfo, isLeaf);
                if (memberInfo.getLongNumber() != null) {
                    addRow.getCell("longNumber").setValue((Object)(longNumber + "!" + memberInfo.getLongNumber()));
                    if (!memberInfo.getLongNumber().contains("!") || !this.leftMap.keySet().contains(memberInfo.getLongNumber().substring(0, memberInfo.getLongNumber().lastIndexOf("!")))) {
                        addRow.getCell("parent").setValue(selectRow.getUserObject());
                        addRow.getCell("level").setValue((Object)(((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1));
                        level = ((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1;
                    } else if (memberInfo.getParent() != null) {
                        if (this.getAddMemberColls().get(memberInfo.getParent().getNumber()) != null) {
                            addRow.getCell("parent").setValue((Object)memberInfo.getParent());
                            addRow.getCell("level").setValue((Object)(this.getAddMemberColls().get(memberInfo.getParent().getNumber()).getLevel() + 1));
                            level = this.getAddMemberColls().get(memberInfo.getParent().getNumber()).getLevel() + 1;
                        } else {
                            addRow.getCell("parent").setValue(selectRow.getUserObject());
                            addRow.getCell("level").setValue((Object)(((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1));
                            level = ((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1;
                        }
                    }
                } else {
                    addRow.getCell("longNumber").setValue((Object)(longNumber + "!" + memberInfo.getNumber()));
                    addRow.getCell("parent").setValue(selectRow.getUserObject());
                    addRow.getCell("level").setValue((Object)(((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1));
                    level = ((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1;
                }
                memberInfo.setLongNumber(addRow.getCell("longNumber").getValue().toString());
                addRow.setUserObject((Object)memberInfo);
                NumberExpandInfo numberExpandInfo = this.setNumberExpandInfo(memberInfo, level, isLeaf);
                addRow.getCell("number").setValue((Object)numberExpandInfo);
                memberInfo.setLevel((Integer)addRow.getCell("level").getValue());
                this.getAddMemberColls().put(memberInfo.getNumber(), memberInfo);
                continue;
            }
            this.fillRowBaseInfo(addRow, memberInfo, true);
            addRow.getCell("longNumber").setValue((Object)(longNumber + "!" + memberInfo.getNumber()));
            addRow.getCell("parent").setValue((Object)((MbgMemberInfo)selectRow.getUserObject()));
            addRow.getCell("level").setValue((Object)(((MbgMemberInfo)selectRow.getUserObject()).getLevel() + 1));
            memberInfo.setLongNumber(addRow.getCell("longNumber").getValue().toString());
            memberInfo.setLevel((Integer)addRow.getCell("level").getValue());
            addRow.setUserObject((Object)memberInfo);
            NumberExpandInfo numberExpandInfo = this.setNumberExpandInfo(memberInfo, level, true);
            addRow.getCell("number").setValue((Object)numberExpandInfo);
            this.getAddMemberColls().put(memberInfo.getNumber(), memberInfo);
        }
        if (addRow != null) {
            selectRow.getCell("isLeaf").setValue((Object)false);
            ((NumberExpandInfo)selectRow.getCell("number").getValue()).setLeaf(false);
        }
        this.getSelectColl().clear();
    }

    private Set<String> getRepeatNumberSet(boolean isAll, Set<String> repeatNums) {
        if (repeatNums == null) {
            repeatNums = new HashSet<String>();
        } else if (!repeatNums.isEmpty()) {
            return repeatNums;
        }
        int size = 0;
        KDTRange range = null;
        KDTSelectBlock block = null;
        if (isAll) {
            size = this.tblMain.getRowCount();
        } else {
            range = this.tblMain.getSelectManager().toRange();
            size = range.size();
        }
        HashSet<String> leftNumberSet = new HashSet<String>();
        IRow curRow = null;
        boolean isHided = false;
        if (repeatNums.isEmpty()) {
            for (int i = 0; i < size; ++i) {
                if (isAll) {
                    curRow = this.tblMain.getRow(i);
                } else {
                    if (range == null) continue;
                    block = (KDTSelectBlock)range.get(i);
                    for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                        curRow = this.tblMain.getRow(r);
                        isHided = curRow.getStyleAttributes().isHided();
                        if (isHided) {
                            this.hasHidedRows = true;
                            continue;
                        }
                        this.dealRepeatNumbers(repeatNums, leftNumberSet, curRow, r);
                    }
                    break;
                }
                isHided = curRow.getStyleAttributes().isHided();
                if (isHided) {
                    this.hasHidedRows = true;
                    continue;
                }
                this.dealRepeatNumbers(repeatNums, leftNumberSet, curRow, i);
            }
        }
        return repeatNums;
    }

    private void dealRepeatNumbers(Set<String> repeatNums, Set<String> leftNumberSet, IRow curRow, int i) {
        GeneralAsstActTypeInfo asstInfo;
        if (curRow.getUserObject() instanceof MbgMemberInfo) {
            MbgMemberInfo memberInfo = (MbgMemberInfo)((MbgMemberInfo)this.tblMain.getRow(i).getUserObject()).clone();
            if (memberInfo != null) {
                String number = memberInfo.getNumber();
                if (leftNumberSet.contains(number)) {
                    repeatNums.add(number);
                } else {
                    leftNumberSet.add(number);
                }
            }
        } else if (curRow.getUserObject() instanceof GeneralAsstActTypeInfo && (asstInfo = (GeneralAsstActTypeInfo)((GeneralAsstActTypeInfo)this.tblMain.getRow(i).getUserObject()).clone()) != null) {
            String number = asstInfo.getNumber();
            if (leftNumberSet.contains(number)) {
                repeatNums.add(number);
            } else {
                leftNumberSet.add(number);
            }
        }
    }

    private Set<String> checkIllegalityNumberSet(boolean isAll) {
        HashSet<String> illegalityNums = new HashSet<String>();
        String number = null;
        IRow curRow = null;
        int size = 0;
        KDTRange range = null;
        KDTSelectBlock block = null;
        boolean isHided = false;
        if (isAll) {
            size = this.tblMain.getRowCount();
        } else {
            range = this.tblMain.getSelectManager().toRange();
            size = range.size();
        }
        for (int i = 0; i < size; ++i) {
            if (isAll) {
                curRow = this.tblMain.getRow(i);
            } else {
                if (range == null) continue;
                block = (KDTSelectBlock)range.get(i);
                for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                    curRow = this.tblMain.getRow(r);
                    isHided = curRow.getStyleAttributes().isHided();
                    if (isHided) continue;
                    this.dealIllegalityNumbers(illegalityNums, number, curRow, r);
                }
                break;
            }
            isHided = curRow.getStyleAttributes().isHided();
            if (isHided) continue;
            this.dealIllegalityNumbers(illegalityNums, number, curRow, i);
        }
        return illegalityNums;
    }

    private void dealIllegalityNumbers(Set<String> illegalityNums, String number, IRow curRow, int i) {
        GeneralAsstActTypeInfo asstInfo;
        if (curRow.getUserObject() instanceof MbgMemberInfo) {
            MbgMemberInfo memberInfo = (MbgMemberInfo)((MbgMemberInfo)this.tblMain.getRow(i).getUserObject()).clone();
            if (memberInfo != null) {
                number = memberInfo.getNumber();
            }
        } else if (curRow.getUserObject() instanceof GeneralAsstActTypeInfo && (asstInfo = (GeneralAsstActTypeInfo)((GeneralAsstActTypeInfo)this.tblMain.getRow(i).getUserObject()).clone()) != null) {
            number = asstInfo.getNumber();
        }
        if (!StringUtils.isEmpty((String)number) && !BgNumberHelper.checkNumber(number)) {
            illegalityNums.add(number);
        }
    }

    private NumberExpandInfo setNumberExpandInfo(MbgMemberInfo memberInfo, int level, boolean isLeaf) {
        NumberExpandInfo numberExpandInfo = new NumberExpandInfo();
        numberExpandInfo.setName(memberInfo.getNumber());
        numberExpandInfo.setNumber(memberInfo.getNumber());
        numberExpandInfo.setLongNumber(memberInfo.getLongNumber());
        numberExpandInfo.setLevel(level);
        numberExpandInfo.setLeaf(isLeaf);
        numberExpandInfo.setShowNumber(true);
        numberExpandInfo.setExpandStatus(true);
        return numberExpandInfo;
    }

    private void fillRowBaseInfo(IRow addRow, MbgMemberInfo memberInfo, boolean isLeaf) {
        addRow.getCell("id").setValue((Object)memberInfo.getId().toString());
        addRow.getCell("number").setValue((Object)memberInfo.getNumber());
        addRow.getCell("name").setValue((Object)memberInfo.getName());
        addRow.getCell("parent").setValue((Object)memberInfo);
        addRow.getCell("isLeaf").setValue((Object)isLeaf);
    }

    private boolean checkCurMemIsleaf(String longNumber) {
        Set<String> numSet = this.leftMap.keySet();
        boolean isLeaf = false;
        for (String str : numSet) {
            if (longNumber != null) {
                if (str.indexOf(longNumber + "!") >= 0) {
                    isLeaf = false;
                    break;
                }
                isLeaf = true;
                continue;
            }
            isLeaf = true;
            break;
        }
        return isLeaf;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        void var8_10;
        super.actionSave_actionPerformed(e);
        IRow row = null;
        CoreBaseCollection addCols = new CoreBaseCollection();
        MbgMemberInfo memberInfo = null;
        HashSet<Object> lostFail = new HashSet();
        StringBuffer sb = new StringBuffer();
        lostFail = this.verifySelects();
        if (!lostFail.isEmpty()) {
            for (String string : lostFail) {
                sb.append(string + " ");
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"lostParentNumber", (Object[])new Object[]{sb, this.toString()}));
            SysUtil.abort();
        }
        HashMap<String, MbgMemberInfo> memberMap = new HashMap<String, MbgMemberInfo>();
        boolean bl = false;
        int count = this.tblRight.getRowCount();
        while (var8_10 < count) {
            row = this.tblRight.getRow((int)var8_10);
            memberInfo = new MbgMemberInfo();
            memberInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
            memberInfo.setName((String)row.getCell("name").getValue());
            memberInfo.setNumber(((NumberExpandInfo)row.getCell("number").getValue()).getNumber());
            memberInfo.setLongNumber(row.getCell("longNumber").getValue().toString());
            if (!this.rightMap.containsKey(memberInfo.getLongNumber())) {
                memberInfo.setLevel(Integer.valueOf(row.getCell("level").getValue().toString()));
                memberInfo.setIsLeaf(Boolean.valueOf(row.getCell("isLeaf").getValue().toString()));
                memberInfo.setAggregation(BgUpperGatherEnum.add);
                memberInfo.setViewId(BOSUuid.read((String)((MbgViewInfo)this.getUIContext().get("viewInfo")).getId().toString()));
                memberInfo.setDimId(BOSUuid.read((String)((MbgDimInfo)this.getUIContext().get("dimInfo")).getId().toString()));
                memberInfo.setMbgDim((MbgDimInfo)this.getUIContext().get("dimInfo"));
                memberInfo.setParent((MbgMemberInfo)row.getCell("parent").getValue());
                if (memberInfo.getParent() != null && memberMap.containsKey(memberInfo.getParent().getNumber())) {
                    memberInfo.setParent((MbgMemberInfo)memberMap.get(memberInfo.getParent().getNumber()));
                }
                memberInfo.setDisplayName(row.getCell("displayName").getValue() != null ? row.getCell("displayName").getValue().toString() : (String)row.getCell("name").getValue());
                memberInfo.setOrgunit((FullOrgUnitInfo)this.getUIContext().get("unitInfo"));
                memberInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                Timestamp ts = new Timestamp(System.currentTimeMillis());
                memberInfo.setCreateTime(ts);
                memberInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
                memberInfo.setLastUpdateTime(ts);
                memberInfo.setIsEnabled(true);
                MbgDimHelper.setCancelDate(memberInfo);
                memberMap.put(memberInfo.getNumber(), memberInfo);
                addCols.add((CoreBaseInfo)memberInfo);
            }
            ++var8_10;
        }
        if (!addCols.isEmpty()) {
            MbgMemberFactory.getRemoteInstance().saveBatchData(addCols);
            this.initTblRight();
            this.getSelectColl().clear();
            this.getAddMemberColls().clear();
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"sysImportSuccess"));
            this.showMessage();
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"chooseMemberFirst"));
        }
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        int i;
        super.actionDelete_actionPerformed(e);
        HashMap<Integer, String> rowNumberMap = new HashMap<Integer, String>();
        HashSet<String> selectLongNumber = new HashSet<String>();
        int acticeRowIndex = this.tblRight.getSelectManager().getActiveRowIndex();
        if (this.tblRight.getRowCount() == 0 || acticeRowIndex < 0) {
            return;
        }
        HashMap<String, Integer> parentLongNumbers = new HashMap<String, Integer>();
        KDTRange range = this.tblRight.getSelectManager().toRange();
        KDTSelectBlock block = null;
        MbgMemberInfo info = null;
        String[] lns = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                info = (MbgMemberInfo)this.tblRight.getRow(r).getUserObject();
                if (this.rightMap.containsKey(info.getLongNumber())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"cantRemoveSaveMember"));
                    SysUtil.abort();
                }
                selectLongNumber.add(info.getLongNumber() + "!");
                if (info.getLongNumber().indexOf("!") <= 0) continue;
                lns = info.getLongNumber().split("!");
                for (int ln = 0; ln < lns.length - 1; ++ln) {
                    parentLongNumbers.put(lns[ln], null);
                }
            }
        }
        MbgMemberInfo memberInfo = null;
        String longNumber = null;
        int count = this.tblRight.getRowCount();
        for (int i2 = 0; i2 < count; ++i2) {
            memberInfo = (MbgMemberInfo)this.tblRight.getRow(i2).getUserObject();
            longNumber = memberInfo.getLongNumber();
            for (String selectedLongNum : selectLongNumber) {
                if (!(longNumber + "!").startsWith(selectedLongNum)) continue;
                rowNumberMap.put(i2, memberInfo.getNumber());
            }
        }
        int deleteIndex = -1;
        Iterator it = rowNumberMap.keySet().iterator();
        while (it.hasNext()) {
            deleteIndex = (Integer)it.next();
            this.getAddMemberColls().remove(rowNumberMap.get(deleteIndex));
        }
        ArrayList rowIndexes = new ArrayList(rowNumberMap.keySet());
        Collections.sort(rowIndexes);
        for (i = rowIndexes.size() - 1; i >= 0; --i) {
            this.tblRight.removeRow(((Integer)rowIndexes.get(i)).intValue());
        }
        int count2 = this.tblRight.getRowCount();
        for (i = 0; i < count2; ++i) {
            memberInfo = (MbgMemberInfo)this.tblRight.getRow(i).getUserObject();
            if (parentLongNumbers.containsKey(memberInfo.getNumber())) {
                parentLongNumbers.put(memberInfo.getNumber(), new Integer(i));
            }
            if (memberInfo.getLongNumber().indexOf("!") <= 0) continue;
            lns = memberInfo.getLongNumber().split("!");
            for (int ln = 0; ln < lns.length - 1; ++ln) {
                parentLongNumbers.remove(lns[ln]);
            }
        }
        Integer rowIndex2 = null;
        for (Integer rowIndex2 : parentLongNumbers.values()) {
            if (rowIndex2 == null) continue;
            memberInfo = (MbgMemberInfo)this.tblRight.getRow(rowIndex2.intValue()).getUserObject();
            if (this.tblRight.getRow(rowIndex2.intValue()).getCell("number").getValue() instanceof NumberExpandInfo) {
                ((NumberExpandInfo)this.tblRight.getRow(rowIndex2.intValue()).getCell("number").getValue()).setLeaf(true);
            }
            memberInfo.setIsLeaf(true);
            this.tblRight.getRow(rowIndex2.intValue()).getCell("isLeaf").setValue((Object)true);
        }
    }

    @Override
    public void actionDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteAll_actionPerformed(e);
        this.tblRight.removeRows();
        this.putDataToTable((IObjectCollection)this.memberCollsCache, this.tblRight);
        if (this.getAddMemberColls().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"noRecordToDel"));
        }
        this.getAddMemberColls().clear();
    }

    @Override
    protected HashSet<String> verifySelects() {
        HashSet<String> returnSet = new HashSet<String>();
        if (this.getAddMemberColls().isEmpty()) {
            return returnSet;
        }
        String longNum = null;
        TreeBaseInfo info = null;
        ArrayList<String> numLst = new ArrayList<String>(this.getAddMemberColls().keySet());
        Collections.sort(numLst);
        HashSet<String> longNumSet = new HashSet<String>();
        Iterator<String> ite = numLst.iterator();
        while (ite.hasNext()) {
            longNumSet.add(this.getAddMemberColls().get(ite.next()).getLongNumber());
        }
        String[] longNumEx = null;
        Iterator ite2 = longNumSet.iterator();
        while (ite2.hasNext()) {
            int length;
            Boolean hasDerectParent = false;
            Boolean hasInDerectParent = false;
            longNum = (String)ite2.next();
            info = longNum.contains("!") ? this.getAddMemberColls().get(longNum.substring(longNum.lastIndexOf("!") + 1, longNum.length())) : this.getAddMemberColls().get(longNum);
            if (!longNum.contains("!") || (length = (longNumEx = longNum.split("!")).length) < 3) continue;
            hasDerectParent = numLst.contains(longNumEx[length - 2]);
            for (int i = length - 3; i >= 0; --i) {
                if (!numLst.contains(longNumEx[i])) continue;
                hasInDerectParent = true;
                break;
            }
            if (hasDerectParent.booleanValue() || !hasInDerectParent.booleanValue()) continue;
            returnSet.add(info.getNumber());
        }
        return returnSet;
    }

    protected boolean checkBeforeWindowClosing() {
        if (!this.getAddMemberColls().isEmpty()) {
            int rs = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"isToSave"));
            if (rs == 0 || rs == 0) {
                try {
                    this.actionSave_actionPerformed(null);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                    this.handUIExceptionAndAbort(e);
                }
                return false;
            }
            this.getAddMemberColls().clear();
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    @Override
    protected void btnLeftSearch_actionPerformed(ActionEvent e) throws Exception {
        this.btnLeftSearchAction();
    }

    private void btnLeftSearchAction() {
        this.searchAction(this.tblMain, this.kdLeftSearch.getText());
    }

    private void btnRightSearchAction() {
        this.searchAction(this.tblRight, this.kdRightSearch.getText());
    }

    private void searchAction(KDTable table, String searchText) {
        if (table == null) {
            return;
        }
        String txtStr = searchText;
        if (txtStr == null || txtStr.equals(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"))) {
            txtStr = "";
        }
        Object obj = null;
        String name = null;
        String number = null;
        IRow row = null;
        if (StringUtils.isEmpty((String)txtStr)) {
            int count = table.getRowCount();
            for (int index = 0; index < count; ++index) {
                row = table.getRow(index);
                row.getStyleAttributes().setHided(false);
            }
        } else {
            int count = table.getRowCount();
            for (int index = 0; index < count; ++index) {
                row = table.getRow(index);
                number = null;
                name = null;
                name = row.getCell("name").getValue().toString();
                obj = row.getCell("number").getValue();
                if (obj instanceof String) {
                    number = (String)obj;
                } else if (obj instanceof NumberExpandInfo) {
                    number = ((NumberExpandInfo)obj).getNumber();
                }
                if (name != null && name.indexOf(txtStr) >= 0 || number != null && number.indexOf(txtStr) >= 0) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                row.getStyleAttributes().setHided(true);
            }
        }
    }

    @Override
    protected void kdLeftSearch_focusLost(FocusEvent e) throws Exception {
        if (this.kdLeftSearch.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"))) {
            this.kdLeftSearch.setText("");
        }
        int selectIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        this.btnLeftSearchAction();
        if (selectIndex < this.tblMain.getRowCount() && selectIndex > 0) {
            this.tblMain.getSelectManager().select(selectIndex, 0);
        } else {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void kdRightSearch_focusLost(FocusEvent e) throws Exception {
        if (this.kdRightSearch.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"))) {
            this.kdRightSearch.setText("");
        }
        int selectIndex = this.tblRight.getSelectManager().getActiveRowIndex();
        this.btnRightSearchAction();
        if (selectIndex < this.tblRight.getRowCount() && selectIndex > 0) {
            this.tblRight.getSelectManager().select(selectIndex, 0);
        } else {
            this.tblRight.getSelectManager().select(0, 0);
        }
    }

    @Override
    protected void btnRightSearch_actionPerformed(ActionEvent e) throws Exception {
        this.btnRightSearchAction();
    }

    @Override
    protected void kdLeftSearch_focusGained(FocusEvent e) throws Exception {
        super.kdLeftSearch_focusGained(e);
        if (this.kdLeftSearch.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"))) {
            this.kdLeftSearch.setText("");
        }
    }

    @Override
    protected void kdRightSearch_focusGained(FocusEvent e) throws Exception {
        super.kdRightSearch_focusGained(e);
        if (this.kdRightSearch.getText().equals(EASResource.getString((String)"com.kingdee.eas.ma.base.MbgDimResource", (String)"inputFilter"))) {
            this.kdRightSearch.setText("");
        }
    }

    private void checkRightRow(MbgMemberInfo rightInfo) throws EASBizException, BOSException {
        if (rightInfo.getId() == null) {
            return;
        }
        if (this.refDataIds == null && this.isNeedCheckRf) {
            FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("unitInfo");
            this.refDataIds = (HashSet)MbgMemberFactory.getRemoteInstance().checkRef(this.rightIDSet, orgUnitInfo.getId().toString()).get("ref_data");
            if (this.refDataIds == null) {
                this.isNeedCheckRf = false;
            }
        }
        if (this.refDataIds != null && this.refDataIds.contains(rightInfo.getId().toString())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"rightRow_hasData", (Object[])new Object[]{rightInfo.getNumber()}));
            SysUtil.abort();
        }
    }

    private Set<String> getParentAndChildrenOrgUnitIds(OrgUnitInfo unitInfo) {
        if (unitInfo == null) {
            return new HashSet<String>();
        }
        String longNumber = unitInfo.getLongNumber();
        String[] tmpLongNumbers = longNumber.split("!");
        if (tmpLongNumbers.length == 1) {
            return new HashSet<String>();
        }
        HashSet<String> orgUnitIds = new HashSet<String>();
        longNumber = unitInfo.getLongNumber();
        Object[] parentNumbers = longNumber.split("!");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(Arrays.asList((Object[])parentNumbers)), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(unitInfo.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 or #1");
        evi.setFilter(filter);
        evi.setSelector(sic);
        CostCenterOrgUnitCollection costCenterColls = null;
        try {
            costCenterColls = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error");
        }
        if (costCenterColls == null) {
            return new HashSet<String>();
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitIds.add(costCenterColls.get(i).getId().toString());
        }
        return orgUnitIds;
    }
}

