/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.client.BgBaseImportUI;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommCHelper;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgPropertyImportUI
extends BgBaseImportUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(MbgPropertyImportUI.class);
    private Map<String, String> curPropertySortMap = new HashMap<String, String>();
    private Map<String, BgPropertyInfo> propertyNumberMap = new HashMap<String, BgPropertyInfo>();
    private Map<String, BgPropertyInfo> initPropertyNameMap = new HashMap<String, BgPropertyInfo>();

    @Override
    protected String getImportTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyImportTitle");
    }

    @Override
    protected String getTemplateTitle() {
        return EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"propertyTemplate");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void importData(KDSSheet sheet) {
        if (sheet == null) {
            return;
        }
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(sheet.getRowCount());
        Object number = null;
        Object name = null;
        Object parentNumber = null;
        Object parentName = null;
        Object propertyNumber = null;
        Object propertyName = null;
        Object description = null;
        Object orgUnit = null;
        int COL_NUMBER = 0;
        int COL_NAME = 1;
        int COL_PARENTNUMBER = 2;
        int COL_PARENTNAME = 3;
        int COL_PROPERTYNUMBER = 4;
        int COL_PROPERTYNAME = 5;
        int COL_DESCRIPTION = 6;
        int COL_ORGUNIT = 7;
        int importSize = 0;
        BgPropertyInfo propertyInfo = null;
        BgPropertyInfo propertyParInfo = null;
        BgPropertyInfo tmpPropertyInfo = null;
        BgPropertySortInfo bgPropertySortInfo = null;
        ArrayList<String> errorList = new ArrayList<String>();
        CoreBaseCollection updateColls = new CoreBaseCollection();
        boolean isReturnRightNow = 1 == this.getErrorNum();
        this.beforeImportData();
        int in = sheet.getRowCount();
        for (int i = 1; i < in; ++i) {
            boolean canImport;
            block22: {
                block23: {
                    block17: {
                        block18: {
                            block19: {
                                block20: {
                                    block21: {
                                        this.progressBar.setValue(i);
                                        number = sheet.getCell(i, COL_NUMBER, false).getValue();
                                        name = sheet.getCell(i, COL_NAME, false).getValue();
                                        parentNumber = sheet.getCell(i, COL_PARENTNUMBER, false).getValue();
                                        parentName = sheet.getCell(i, COL_PARENTNAME, false).getValue();
                                        propertyNumber = sheet.getCell(i, COL_PROPERTYNUMBER, false).getValue();
                                        propertyName = sheet.getCell(i, COL_PROPERTYNAME, false).getValue();
                                        description = sheet.getCell(i, COL_DESCRIPTION, false).getValue();
                                        orgUnit = sheet.getCell(i, COL_ORGUNIT, false).getValue();
                                        ++importSize;
                                        canImport = false;
                                        if (this.isNull(number)) break block17;
                                        if (!BgNumberHelper.checkNumber(number.toString())) break block18;
                                        if (this.isNull(name)) break block19;
                                        if (!this.curPropertySortMap.containsKey(propertyNumber)) break block20;
                                        if (!this.isNull(parentNumber) && !this.propertyNumberMap.containsKey(parentNumber + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyNumber)) break block21;
                                        canImport = true;
                                        if (description == null) break block22;
                                        break block23;
                                    }
                                    errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "parNumNotExist"), i + 1));
                                    if (!isReturnRightNow) continue;
                                    break;
                                }
                                errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "propertyIsNotExist"), i + 1));
                                if (!isReturnRightNow) continue;
                                break;
                            }
                            errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "containNullName"), i + 1));
                            if (!isReturnRightNow) continue;
                            break;
                        }
                        errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "containSpecialWord"), i + 1));
                        if (!isReturnRightNow) continue;
                        break;
                    }
                    errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "containSpecialWord"), i + 1));
                    if (!isReturnRightNow) continue;
                    break;
                }
                if (description.toString().length() > 255) {
                    errorList.add(MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "descriptionLimit"), i + 1));
                    if (!isReturnRightNow) continue;
                    break;
                }
            }
            if (!canImport) continue;
            propertyInfo = new BgPropertyInfo();
            propertyInfo.setNumber(number.toString());
            propertyInfo.setName(name.toString());
            bgPropertySortInfo = new BgPropertySortInfo();
            bgPropertySortInfo.setId(BOSUuid.read((String)this.curPropertySortMap.get(propertyNumber.toString())));
            bgPropertySortInfo.setNumber(propertyNumber.toString());
            propertyInfo.setBgPropertySort(bgPropertySortInfo);
            if (!this.isNull(parentNumber)) {
                propertyParInfo = this.propertyNumberMap.get(parentNumber.toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyNumber);
                propertyParInfo.setIsLeaf(false);
                propertyInfo.setParent(propertyParInfo);
                propertyInfo.setLongNumber(propertyParInfo.getLongNumber() + "!" + propertyInfo.getNumber());
                propertyInfo.setLevel(propertyParInfo.getLevel() + 1);
            } else {
                propertyInfo.setParent(null);
                propertyInfo.setLongNumber(propertyInfo.getNumber());
                propertyInfo.setLevel(1);
            }
            propertyInfo.setIsLeaf(true);
            propertyInfo.setDescription(description.toString());
            if (this.propertyNumberMap.containsKey(number.toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyNumber)) {
                if (this.propertyNumberMap.get(number.toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyNumber).getId() != null) {
                    propertyInfo.setId(this.propertyNumberMap.get(number.toString() + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyNumber).getId());
                } else {
                    for (int j = 0; j < updateColls.size(); ++j) {
                        tmpPropertyInfo = (BgPropertyInfo)updateColls.get(j);
                        if (!tmpPropertyInfo.getNumber().equals(number.toString())) continue;
                        tmpPropertyInfo.setBgPropertySort(propertyInfo.getBgPropertySort());
                        tmpPropertyInfo.setParent(propertyInfo.getParent());
                        tmpPropertyInfo.setDescription(propertyInfo.getDescription());
                        tmpPropertyInfo.setName(propertyInfo.getName());
                    }
                }
            } else {
                if (this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO) instanceof OrgUnitInfo) {
                    CostCenterOrgUnitInfo orgunit = (CostCenterOrgUnitInfo)this.getUIContext().get(BgBaseConstants.ORGUNIT_INFO);
                    propertyInfo.setOrgUnit(orgunit);
                }
                propertyInfo.setLastUpdateUser(SysContext.getSysContext().getCurrentUserInfo());
                propertyInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                propertyInfo.setCreator(SysContext.getSysContext().getCurrentUserInfo());
                propertyInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                propertyInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
            }
            updateColls.add((CoreBaseInfo)propertyInfo);
            this.propertyNumberMap.put(propertyInfo.getNumber() + BgBaseConstants.COMBINATE_SPLITER_TABLE + propertyInfo.getBgPropertySort().getNumber(), propertyInfo);
        }
        if (!updateColls.isEmpty()) {
            try {
                BgPropertyFactory.getRemoteInstance().saveBatchData(updateColls);
            }
            catch (Exception e) {
                logger.error((Object)"save BatchData error ", (Throwable)e);
            }
        }
        if (isReturnRightNow) {
            this.showReportResult(errorList, importSize);
        } else {
            this.showReportResult(errorList, sheet.getRowCount() - 1);
        }
        this.afterImport();
    }

    private void afterImport() {
        this.propertyNumberMap.clear();
        this.initPropertyNameMap.clear();
    }

    private void showReportResult(List<String> errorList, int sheetSize) {
        if (errorList.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPropertyResource", (String)"importSuccess"));
        } else {
            StringBuffer errorBuff = new StringBuffer();
            for (int i = 0; i < errorList.size(); ++i) {
                errorBuff.append(errorList.get(i)).append("\n");
            }
            MsgBox.showDetailAndOK((Component)((Object)this), (String)MessageFormat.format(BgCommCHelper.getMessageStr("com.kingdee.eas.ma.base.client.BgPropertyResource", "detailInfo"), sheetSize, sheetSize - errorList.size(), errorList.size()), (String)errorBuff.toString(), (int)2);
        }
    }

    private void beforeImportData() {
        this.curPropertySortMap.putAll(this.getPropertySortByBosType());
        this.propertyNumberMap.putAll(this.getPropertyMapByBosType());
    }

    private Map<String, BgPropertyInfo> getPropertyMapByBosType() {
        HashMap<String, BgPropertyInfo> propertyMap = new HashMap<String, BgPropertyInfo>();
        Object bgPropSortSource = this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE);
        Object mbgDimId = this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID);
        Object bgPropSortInfo = this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO);
        Object sortSet = this.getUIContext().get("sortSet");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("longnumber");
        sic.add("bgPropertySort.id");
        sic.add("bgPropertySort.number");
        sic.add("parent.id");
        sic.add("level");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        if (bgPropSortSource != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.sourceType", (Object)bgPropSortSource.toString(), CompareType.EQUALS));
        }
        if (this.getViewID() != null) {
            filter.getFilterItems().add(new FilterItemInfo("mbgDim.id", (Object)this.getViewID(), CompareType.EQUALS));
        }
        if (bgPropSortInfo != null && bgPropSortInfo instanceof BgPropertySortInfo) {
            filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.id", (Object)((BgPropertySortInfo)bgPropSortInfo).getId().toString(), CompareType.EQUALS));
        } else if (sortSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.id", sortSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgPropertyCollection sortCol = null;
        try {
            sortCol = BgPropertyFactory.getRemoteInstance().getBgPropertyCollection(view);
            for (int i = 0; i < sortCol.size(); ++i) {
                propertyMap.put(sortCol.get(i).getNumber() + BgBaseConstants.COMBINATE_SPLITER_TABLE + sortCol.get(i).getBgPropertySort().getNumber(), sortCol.get(i));
                this.initPropertyNameMap.put(sortCol.get(i).getName(), sortCol.get(i));
            }
        }
        catch (BOSException e) {
            logger.error((Object)"query bgproperty error", (Throwable)e);
        }
        return propertyMap;
    }

    private Map<String, String> getPropertySortByBosType() {
        HashMap<String, String> curPropertySort = new HashMap<String, String>();
        Object bgPropSortSource = this.getUIContext().get(BgBaseConstants.BGPROPSORT_SOURCE);
        Object mbgDimId = this.getUIContext().get(BgBaseConstants.BGMBGDIM_ID);
        Object bgPropSortInfo = this.getUIContext().get(BgBaseConstants.BGPROPSORT_INFO);
        Object sortSet = this.getUIContext().get("sortSet");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (bgPropSortSource != null) {
            filter.getFilterItems().add(new FilterItemInfo("sourceType", (Object)bgPropSortSource.toString(), CompareType.EQUALS));
        }
        if (this.getViewID() != null) {
            filter.getFilterItems().add(new FilterItemInfo("mbgDim.id", (Object)this.getViewID(), CompareType.EQUALS));
        }
        if (bgPropSortInfo != null && bgPropSortInfo instanceof BgPropertySortInfo) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)((BgPropertySortInfo)bgPropSortInfo).getId().toString(), CompareType.EQUALS));
        } else if (sortSet != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", sortSet, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        BgPropertySortCollection sortCol = null;
        try {
            sortCol = BgPropertySortFactory.getRemoteInstance().getBgPropertySortCollection(view);
            for (int i = 0; i < sortCol.size(); ++i) {
                curPropertySort.put(sortCol.get(i).getNumber(), sortCol.get(i).getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"query bgproperty error", (Throwable)e);
        }
        return curPropertySort;
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().equals("");
    }
}

