/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.BgBaseFacadeFactory;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.RefDimMemberEnum;
import com.kingdee.eas.ma.base.RefDimMemberResult;
import com.kingdee.eas.ma.base.RptSrcTypeEnum;
import com.kingdee.eas.ma.base.client.AbstractRefDimMemberQueryUI;
import com.kingdee.eas.ma.base.client.BgAccountListDialog;
import com.kingdee.eas.ma.base.client.MbgMemberDialag;
import com.kingdee.eas.ma.base.client.utils.BgPermissionUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RefDimMemberQueryUI
extends AbstractRefDimMemberQueryUI {
    private static final long serialVersionUID = -1953351607766168958L;
    private static final Logger logger = CoreUIObject.getLogger(RefDimMemberQueryUI.class);
    private static final String COL_NUMBER = "number";
    private static final String COL_NAME = "name";
    private static final String COL_BGORGUNIT = "bgOrgUnit";
    private static final String COL_BGSCHEME = "bgScheme";
    private static final String COL_DETAIL = "detail";
    private static final String COL_TYPE = "type";
    private Map<String, Object> resultMap = new HashMap<String, Object>();
    private RptSrcTypeEnum sourceType = RptSrcTypeEnum.PT_BUDGET_REPORT;
    private int viewType = 0;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object viewInfo = this.getUIContext().get("viewInfo");
        if (viewInfo == null) {
            return;
        }
        Object unitInfo = this.getUIContext().get("unitInfo");
        if (unitInfo == null || !(unitInfo instanceof OrgUnitInfo)) {
            return;
        }
        if (viewInfo instanceof MbgViewInfo) {
            this.viewType = 2;
        } else if (viewInfo instanceof BgAccountViewInfo) {
            this.viewType = 1;
        }
        this.sourceType = (RptSrcTypeEnum)((Object)this.getUIContext().get("sourceType"));
        Object id = this.getUIContext().get("id");
        String[] idAndType = this.initMemberDialog(viewInfo, unitInfo, id);
        this.resultMap = BgBaseFacadeFactory.getRemoteInstance().getRefDimMember(id.toString(), idAndType[0], Integer.valueOf(idAndType[1]));
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(COL_NUMBER).getStyleAttributes().setFontColor(Color.blue);
        this.tblMain.getColumn(COL_NUMBER).getStyleAttributes().setUnderline(true);
        this.initTree();
    }

    protected String[] initMemberDialog(Object viewInfo, Object unitInfo, Object id) throws EASBizException, BOSException, UuidException {
        String[] idAndType = new String[2];
        if (unitInfo instanceof OrgUnitInfo) {
            if (viewInfo instanceof MbgViewInfo) {
                MbgMemberInfo dimInfo = (MbgMemberInfo)MbgMemberFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id.toString())));
                MbgMemberDialag memberDialog = new MbgMemberDialag();
                memberDialog.setViewId(((MbgViewInfo)viewInfo).getId().toString());
                memberDialog.setMbgViewInfo((MbgViewInfo)viewInfo);
                memberDialog.setOrgUnitInfo((OrgUnitInfo)unitInfo);
                memberDialog.setFilteSys(true);
                this.prmtDimMember.setSelector((KDPromptSelector)memberDialog);
                this.prmtDimMember.setDataNoNotify((Object)dimInfo);
                idAndType[0] = ((MbgViewInfo)viewInfo).getId().toString();
                idAndType[1] = "2";
            } else if (viewInfo instanceof BgAccountViewInfo) {
                BgAccountInfo accinfo = (BgAccountInfo)BgAccountFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id.toString())));
                BgAccountListDialog accDialog = new BgAccountListDialog();
                accDialog.setBgAccountViewID(((BgAccountViewInfo)viewInfo).getId().toString());
                accDialog.setOldData(accinfo);
                this.prmtDimMember.setSelector((KDPromptSelector)accDialog);
                this.prmtDimMember.setDataNoNotify((Object)accinfo);
                idAndType[0] = ((BgAccountViewInfo)viewInfo).getId().toString();
                idAndType[1] = "1";
            }
            this.prmtDimMember.setEditable(false);
        }
        return idAndType;
    }

    protected void initTree() throws EASBizException, BOSException {
        Object refTypeSet = this.resultMap.get("REFTYPE_SET");
        if (refTypeSet != null && refTypeSet instanceof Set) {
            Set _refTypeSet = (Set)refTypeSet;
            if (_refTypeSet.isEmpty()) {
                this.leftTree.setModel(null);
                return;
            }
            DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
            root.setText(RefDimMemberEnum.all.getAlias());
            root.setUserObject((Object)RefDimMemberEnum.all);
            DefaultKingdeeTreeNode childNode = null;
            for (Integer type : _refTypeSet) {
                RefDimMemberEnum enums = this.getRefDimMemberType(type);
                childNode = new DefaultKingdeeTreeNode();
                childNode.setText(enums.getAlias());
                childNode.setUserObject((Object)enums);
                root.add((MutableTreeNode)childNode);
            }
            DefaultTreeModel leftModel = new DefaultTreeModel((TreeNode)root);
            this.leftTree.setModel((TreeModel)leftModel);
            this.leftTree.setSelectionNode(root);
            this.leftTree.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RefDimMemberQueryUI.this.treeLeftClick(e);
                }
            });
            this.filterData();
        } else {
            this.leftTree.setModel(null);
        }
    }

    private RefDimMemberEnum getRefDimMemberType(int type) {
        if (type == 1) {
            return RefDimMemberEnum.dimRelation;
        }
        if (type == 2) {
            return RefDimMemberEnum.bgTemplate;
        }
        if (type == 3) {
            return RefDimMemberEnum.bizCalc;
        }
        if (type == 4) {
            return RefDimMemberEnum.bgExamine;
        }
        if (type == 5) {
            return RefDimMemberEnum.bgForm;
        }
        if (type == 6) {
            return RefDimMemberEnum.bgdata;
        }
        return RefDimMemberEnum.bgForm;
    }

    protected void treeLeftClick(MouseEvent e) {
        this.filterData();
    }

    protected void filterData() {
        this.tblMain.removeRows();
        List listResults = (List)this.resultMap.get("REFDATA");
        if (listResults != null) {
            Object ob;
            RefDimMemberResult result = null;
            IRow row = null;
            for (int i = 0; i < listResults.size(); ++i) {
                result = (RefDimMemberResult)listResults.get(i);
                row = this.tblMain.addRow();
                row.getCell(COL_NUMBER).setValue((Object)result.getNumber());
                row.getCell(COL_NAME).setValue((Object)result.getName());
                row.getCell(COL_BGORGUNIT).setValue((Object)result.getBgOrgUnit());
                row.getCell(COL_BGSCHEME).setValue((Object)result.getBgScheme());
                row.getCell(COL_DETAIL).setValue((Object)result.getDetail());
                row.getCell(COL_TYPE).setValue((Object)this.getRefDimMemberType(result.getType()));
                row.setUserObject((Object)result);
            }
            TreePath lPath = this.leftTree.getSelectionPath();
            if (lPath != null && lPath.getLastPathComponent() instanceof DefaultKingdeeTreeNode && (ob = ((DefaultKingdeeTreeNode)lPath.getLastPathComponent()).getUserObject()) instanceof RefDimMemberEnum) {
                if (((RefDimMemberEnum)((Object)ob)).getValue() == 0) {
                    this.tblMain.getColumn(COL_TYPE).getStyleAttributes().setHided(false);
                    this.setFilterHide(0);
                } else {
                    this.tblMain.getColumn(COL_TYPE).getStyleAttributes().setHided(true);
                    this.setFilterHide(((RefDimMemberEnum)((Object)ob)).getValue());
                }
            }
        }
    }

    private void setFilterHide(int refType) {
        IRow row = null;
        String txt = this.txtSearch.getText();
        boolean isEmpty = StringUtils.isEmpty((String)txt);
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (refType == 0) {
                if (isEmpty) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                this.searchHideRow(row, txt);
                continue;
            }
            if (!(row.getCell(COL_TYPE).getValue() instanceof RefDimMemberEnum)) continue;
            RefDimMemberEnum type = (RefDimMemberEnum)((Object)row.getCell(COL_TYPE).getValue());
            if (type.getValue() == refType) {
                if (isEmpty) {
                    row.getStyleAttributes().setHided(false);
                    continue;
                }
                this.searchHideRow(row, txt);
                continue;
            }
            row.getStyleAttributes().setHided(true);
        }
    }

    private void searchHideRow(IRow row, String txt) {
        String schemeName = null;
        String number = null;
        String name = null;
        String orgName = null;
        String detail = null;
        schemeName = ((BgAccountInfo)row.getCell(COL_BGSCHEME).getValue()).getName();
        number = row.getCell(COL_NUMBER).getValue().toString();
        name = row.getCell(COL_NAME).getValue().toString();
        orgName = ((OrgUnitInfo)row.getCell(COL_BGORGUNIT).getValue()).getName();
        detail = row.getCell(COL_DETAIL).getValue().toString();
        if (schemeName.contains(txt) || number.contains(txt) || name.contains(txt) || orgName.contains(txt) || detail.contains(txt)) {
            row.getStyleAttributes().setHided(false);
        } else {
            row.getStyleAttributes().setHided(true);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    @Override
    protected void prmtDimMember_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() == null && e.getOldValue() != null) {
            String dimIsNull = EASResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"dimIsNull");
            dimIsNull = this.kDLabelContainer1.getBoundLabelText() + dimIsNull.substring(2);
            MsgBox.showInfo((Component)((Object)this), (String)dimIsNull);
            this.prmtDimMember.setDataNoNotify(e.getOldValue());
            return;
        }
        if (e.getNewValue() == null) {
            this.leftTree.setModel(null);
            this.tblMain.removeRows();
            return;
        }
        if (e.getOldValue() != null && e.getNewValue().equals(e.getOldValue())) {
            return;
        }
        if (this.viewType == 1) {
            if (e.getNewValue() instanceof BgAccountInfo) {
                BgAccountInfo info = (BgAccountInfo)e.getNewValue();
                this.resultMap = BgBaseFacadeFactory.getRemoteInstance().getRefDimMember(info.getId().toString(), info.getBgAccountView().getId().toString(), 1);
                this.initTree();
                this.filterData();
            }
        } else if (this.viewType == 2 && e.getNewValue() instanceof MbgMemberInfo) {
            MbgMemberInfo info = (MbgMemberInfo)e.getNewValue();
            this.resultMap = BgBaseFacadeFactory.getRemoteInstance().getRefDimMember(info.getId().toString(), info.getViewId().toString(), 2);
            this.initTree();
            this.filterData();
        }
    }

    @Override
    public void actionSearch_actionPerformed(ActionEvent e) throws Exception {
        super.actionSearch_actionPerformed(e);
        this.filterData();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1) {
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            int clickCount = e.getClickCount();
            String number = null;
            BgAccountInfo schemeInfo = null;
            OrgUnitInfo orgInfo = null;
            IRow row = null;
            if (clickCount == 1 && colIndex == 2) {
                row = this.tblMain.getRow(rowIndex);
                number = row.getCell(COL_NUMBER).getValue().toString();
                RefDimMemberEnum type = (RefDimMemberEnum)((Object)row.getCell(COL_TYPE).getValue());
                schemeInfo = (BgAccountInfo)row.getCell(COL_BGSCHEME).getValue();
                orgInfo = (OrgUnitInfo)row.getCell(COL_BGORGUNIT).getValue();
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)COL_NUMBER, (Object)number);
                uiContext.put((Object)"ref_form", (Object)schemeInfo);
                uiContext.put((Object)"orgUnit.name", (Object)orgInfo);
                uiContext.put((Object)"sourceType", (Object)this.sourceType);
                uiContext.put((Object)"isCsl", (Object)this.checkIsCsl(row));
                BgPermissionUtil.checkPermission(orgInfo, this.getPermission(this.sourceType, type));
                Class<?> util = null;
                try {
                    util = Class.forName("com.kingdee.eas.ma.mbg.client.RefDimMemberQueryLinkedUI");
                    Object _instance = util.newInstance();
                    Method method = util.getDeclaredMethod("dimMemberQueryLinkedUI", UIContext.class, RefDimMemberEnum.class);
                    method.invoke(_instance, new Object[]{uiContext, type});
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
            }
        }
    }

    public boolean checkIsCsl(IRow row) throws BOSException {
        RefDimMemberResult result;
        String refId;
        boolean isCsl = false;
        if (row != null && row.getUserObject() instanceof RefDimMemberResult && !StringUtils.isEmpty((String)(refId = (result = (RefDimMemberResult)row.getUserObject()).getRefId()))) {
            String bosType = BOSUuid.read((String)refId).getType().toString();
            String bizCalcBosType = "43A6BA6B";
            String bgExamineBosType = "2CED351E";
            IRowSet rs = null;
            try {
                if (bosType.equals(bizCalcBosType)) {
                    rs = SQLExecutorFactory.getRemoteInstance((String)("select FOrgTreeId from T_MBG_BizCalc where FID = '" + refId + "'")).executeSQL();
                } else if (bosType.equals(bgExamineBosType)) {
                    rs = SQLExecutorFactory.getRemoteInstance((String)("select FOrgTreeId from T_MBG_BgExamine where FID = '" + refId + "'")).executeSQL();
                }
                if (rs != null) {
                    while (rs.next()) {
                        isCsl = !StringUtils.isEmpty((String)rs.getString("FOrgTreeId"));
                    }
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(rs);
            }
        }
        return isCsl;
    }

    @Override
    protected void txtSearch_focusLost(FocusEvent e) throws Exception {
        super.txtSearch_focusLost(e);
        this.filterData();
    }

    private String getPermission(RptSrcTypeEnum sourceType, RefDimMemberEnum type) {
        if (type.getValue() == 1) {
            if (sourceType.getValue() == 69) {
                return "relationship01_list";
            }
            if (sourceType.getValue() == 67) {
                return "fm_relationship01_list";
            }
            if (sourceType.getValue() == 68) {
                return "exp_relationship01_list";
            }
        } else if (type.getValue() == 2) {
            if (sourceType.getValue() == 69) {
                return "mbg_template01_list";
            }
            if (sourceType.getValue() == 67) {
                return "fm_template01_list";
            }
            if (sourceType.getValue() == 68) {
                return "exp_template01_list";
            }
        } else if (type.getValue() == 3) {
            if (sourceType.getValue() == 69) {
                return "mbg_BizCalc01_list";
            }
            if (sourceType.getValue() == 67) {
                return "fm_BizCalc01_list";
            }
            if (sourceType.getValue() == 68) {
                return "exp_BizCalc01_list";
            }
        } else if (type.getValue() == 4) {
            if (sourceType.getValue() == 69) {
                return "mbg_BgExamine01_list";
            }
            if (sourceType.getValue() == 67) {
                return "fm_BgExamine01_list";
            }
            if (sourceType.getValue() == 68) {
                return "exp_BgExamine01_list";
            }
        } else if (type.getValue() == 5) {
            if (sourceType.getValue() == 69) {
                return "mbg_form01_list";
            }
            if (sourceType.getValue() == 67) {
                return "fm_form01_list";
            }
            if (sourceType.getValue() == 68) {
                return "exp_form01_list";
            }
        }
        return null;
    }
}

