/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.client.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.client.utils.IBgSchemeFilter;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public class BgBaseHelper {
    private static final String LONGNUMBER_NOTLIKE = "longNumberNotLike";
    private static TreeWillExpandListener treeListener = new TreeWillExpandListener(){

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            KDTree tree = (KDTree)event.getSource();
            TreePath path = event.getPath();
            if (tree.getModel().getRoot() == path.getLastPathComponent()) {
                throw new ExpandVetoException(event);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        }
    };

    public static void addIdFilter(CoreUI ui, EntityViewInfo evi) {
        Set canIds = (Set)ui.getUIContext().get("IDList");
        if (canIds == null) {
            return;
        }
        if (canIds.isEmpty()) {
            BgCommHelper.addFilterItem(evi.getFilter(), new FilterItemInfo("id", (Object)BgBaseConstants.nullID));
        } else {
            BgCommHelper.addFilterItem(evi.getFilter(), new FilterItemInfo("id", (Object)canIds, CompareType.INCLUDE));
        }
    }

    public static void addIdList(IUIObject win, UIContext uiContext, String dimNumber) {
        try {
            ((IBgSchemeFilter)Class.forName("com.kingdee.eas.ma.mbg.client.utils.DimensionMemberSelectHelper").newInstance()).addIdList(win, uiContext, dimNumber);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public static void addLongNumberFilter(Map context, FilterInfo filter) {
        if (context != null && filter != null && !StringUtils.isEmpty((String)((String)context.get(LONGNUMBER_NOTLIKE)))) {
            String longNumber = (String)context.get(LONGNUMBER_NOTLIKE);
            BgCommHelper.addFilterItem(filter, new FilterItemInfo("longNumber", (Object)longNumber, CompareType.NOTEQUALS));
            BgCommHelper.addFilterItem(filter, new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.NOTLIKE));
        }
    }

    public static void addLongNumberFilter(Map context, String longNumber) {
        if (context == null || StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        context.put(LONGNUMBER_NOTLIKE, longNumber);
    }

    public static void setNoLeaf(KDTree tree) {
        if (tree == null || tree.getModel() == null || tree.getModel().getRoot() == null) {
            return;
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getModel().getRoot();
        DefaultKingdeeTreeNode node = null;
        Enumeration em = root.breadthFirstEnumeration();
        while (em.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)em.nextElement();
            if (!(node.getUserObject() instanceof TreeBaseInfo) || !((TreeBaseInfo)node.getUserObject()).isIsLeaf()) continue;
            node.setCheckBoxEnabled(false);
            node.setCheckBoxVisible(false);
        }
    }

    public static void setRootCannotClose(KDTree tree) {
        if (tree == null) {
            return;
        }
        tree.addTreeWillExpandListener(treeListener);
    }

    public static void refreshParentListUI(CoreUI ui) {
        if (ui == null) {
            return;
        }
        Object parent = ui.getUIContext().get("Owner");
        if (parent instanceof ListUI) {
            try {
                ((ListUI)parent).refreshList();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void checkBatchPermission(CoreUI ownerUI, Set orgIds, IMetaDataPK uiPK, IMetaDataPK actionPK) throws EASBizException, BOSException {
        Set result = MetaDataFacadeFactory.getRemoteInstance().checkHasPermission(orgIds, uiPK, actionPK);
        if (result != null && !result.isEmpty()) {
            MsgBox.showInfo((Component)ownerUI, (String)((String)result.iterator().next()));
            SysUtil.abort();
        }
    }

    public static void setMaxDialog(IUIWindow uiWindow) {
        if (uiWindow instanceof UIModelDialog) {
            UIModelDialog dialog = (UIModelDialog)uiWindow;
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(dialog.getGraphicsConfiguration());
            Rectangle desktopBounds = new Rectangle(screenInsets.left, screenInsets.top, screenSize.width - screenInsets.left - screenInsets.right, screenSize.height - screenInsets.top - screenInsets.bottom);
            dialog.setResizable(true);
            dialog.setPreferredSize(new Dimension(desktopBounds.width, desktopBounds.height));
        }
    }
}

