/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.PropertyRefSourceCollection;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.PropertyRefSourceInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.Excel2007FileFilter;
import com.kingdee.eas.ma.base.utils.ExcelFile;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.filechooser.FileFilter;

public class BgAccountHelper {
    public static final String RES = "com.kingdee.eas.ma.base.BgAccountResource";
    public static final Color disableColor = new Color(230, 230, 230);
    public static final String SPLITTER_ONE = "_";
    public static final String SPLITTER_COMMA = ",";
    public static final String ACCOUNT_SHORT_NUM = "Acc:";
    public static final String BGACCOUNTVIEW_ID = "bgAccountView.id";
    public static final String UNITINFO = "unitInfo";
    public static final String VIEWINFO = "viewInfo";
    public static final String SELECTED_ACCOUNT = "SELECTED_ACCOUNT";
    public static final String ID = "id";
    public static final String NUMBER = "number";
    public static final String NAME = "name";
    public static final String PARENT = "parent.name";
    public static final String PARENT_ID = "parent.id";
    public static final String PARENT_NUMBER = "parent.number";
    public static final String PARENT_LONGNUMBER = "parent.longNumber";
    public static final String PARENT_LEVEL = "parent.level";
    public static final String LEVEL = "level";
    public static final String POL_ALGORITHM = "polAlgorithm";
    public static final String PERIOD_ALGORITHM = "periodAlgorithm";
    public static final String BGACCOUNTTYPE = "bgAccountType";
    public static final String BGACCOUNTDATATYPE = "bgAccountDataType";
    public static final String BGDECREDIT_ALGORITHM = "bgDecreditAlgorithm";
    public static final String BGACCOUNTSORT = "bgAccountSort.name";
    public static final String BGACCOUNTSORT_NUMBER = "bgAccountSort.number";
    public static final String BGACCOUNTSORT_ID = "bgAccountSort.id";
    public static final String BGPROPERTY_ID = "bgProperty.id";
    public static final String BGPROPERTY = "bgProperty.name";
    public static final String BGPROPERTY_NUMBER = "bgProperty.number";
    public static final String BGACCOUNTGROUPNUMBER = "group.number";
    public static final String BGACCOUNTGROUPNAME = "group.name";
    public static final String ISENABLED = "isEnabled";
    public static final String DISABLEDDATE = "disabledDate";
    public static final String CREATOR = "creator.name";
    public static final String CREATETIME = "createTime";
    public static final String ORGUNIT = "orgUnit.name";
    public static final String ISLEAF = "isLeaf";
    public static final String LONGNUMBER = "longNumber";
    public static final String DISPLAYNAME = "displayName";
    public static final String COSTCENTERINFO = "costCenterInfo";
    public static final String PROPERTYINFO = "propertyInfo";
    public static final String DISTRIBUTEROOTID = "distributeRootID";
    public static final String DEFAULT_GROUP_NUMBER = "ACG";
    public static final String SOURCE_TYPE = "SOURCE_TYPE";
    public static final String ACCGROUP = "ACCGROUP";
    public static final String DELETE_SUCCESS = "delete_success";
    public static final String DELETE_FAIL = "delete_fail";
    public static final String DELETE_RESULT = "delete_result";
    public static final String REF_DIMRELATION = "ref_dimRelation";
    public static final String REF_BIZ = "ref_biz";
    public static final String REF_TEMPLATE = "ref_template";
    public static final String REF_FORM = "ref_form";
    public static final String REF_DATA = "ref_data";
    public static final String T_BD_AccountView = "T_BD_AccountView";
    public static final String T_BC_ExpenseType = "T_BC_ExpenseType";
    public static final String T_BD_CashFlowItem = "T_BD_CashFlowItem";
    public static final String T_CAS_FundFlowItem = "T_CAS_FundFlowItem";
    public static final String T_CSL_RptItem = "T_CSL_RptItem";
    public static final String UPDATE_LOGITEM = "mbg_bgAccount_update";
    public static final String DELETE_LOGITEM = "mbg_bgAccount_delete";
    public static final String IMPORT_LOGITEM = "mbg_bgAccount_import";
    public static final String SYSIMPORT_LOGITEM = "mbg_bgAccount_sysImport";
    public static final String Export_LOGITEM = "mbg_bgAccount_Export";
    public static final String CANCEL_CHECK_NUMBER = "cancel_check_number";
    public static final String CANCEL_CHECK_ORG = "cancel_check_org";

    public static Set<String> getSrcNumbers(String SrcNumber, IObjectCollection colls) {
        HashSet<String> numbers = new HashSet<String>();
        if (colls == null || colls.isEmpty()) {
            return numbers;
        }
        for (int index = 0; index < colls.size(); ++index) {
            numbers.add(SrcNumber + BgBaseConstants.SEP_FOUR_STR + ((DataBaseInfo)colls.getObject(index)).getNumber());
        }
        return numbers;
    }

    public static StringBuffer processRefMsg(HashMap<String, HashSet<String>> returnMap, KDTable table) {
        StringBuffer detailMsg = new StringBuffer();
        if (returnMap == null || returnMap.isEmpty() || table == null) {
            return detailMsg;
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>();
        IRow row = null;
        String rowId = null;
        String rowNum = null;
        String keyStr2 = null;
        HashSet<String> valueSet = null;
        StringBuffer str = null;
        int size = table.getRowCount3();
        for (int index = 0; index < size; ++index) {
            row = table.getRow(index);
            if (row.getCell(ID).getValue() == null) continue;
            rowId = row.getCell(ID).getValue().toString();
            rowNum = row.getCell(NUMBER).getValue().toString();
            if (cacheMap.containsKey(rowId)) continue;
            cacheMap.put(rowId, rowNum);
        }
        for (String keyStr2 : returnMap.keySet()) {
            if (keyStr2.equalsIgnoreCase(DELETE_SUCCESS)) continue;
            valueSet = returnMap.get(keyStr2);
            if (valueSet != null && !valueSet.isEmpty()) {
                str = new StringBuffer();
                for (String refId : valueSet) {
                    if (!cacheMap.containsKey(refId)) continue;
                    str.append((String)cacheMap.get(refId) + SPLITTER_COMMA);
                }
            }
            if (str == null || str.length() <= 0) continue;
            detailMsg.append(EASResource.getString((String)RES, (String)keyStr2, (Object[])new Object[]{str}));
            detailMsg.append("\n");
        }
        return detailMsg;
    }

    public static void checkNumRepeat(HashSet<String> repeatNumSet) {
        if (!repeatNumSet.isEmpty()) {
            StringBuffer num = new StringBuffer();
            Iterator<String> ite = repeatNumSet.iterator();
            while (ite.hasNext()) {
                num.append(ite.next() + ", ");
            }
            num.setLength(num.length() - 1);
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)RES, (String)"NumberRepeat"), (String)num.toString(), (int)0);
            SysUtil.abort();
        }
    }

    public static boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"Confirm_Delete")));
    }

    public static List<Integer> getSelectRowIndex(KDTable tblMain) {
        KDTRange range = tblMain.getSelectManager().toRange();
        if (range.size() == 0) {
            return null;
        }
        ArrayList<Integer> selectRowIndex = new ArrayList<Integer>();
        KDTSelectBlock block = null;
        for (int index = 0; index < range.size(); ++index) {
            block = (KDTSelectBlock)range.get(index);
            for (int r = block.getBeginRow(); r <= block.getEndRow(); ++r) {
                selectRowIndex.add(r);
            }
        }
        Collections.sort(selectRowIndex);
        return selectRowIndex;
    }

    public static void removeEditHelper(KDTable table) {
        if (table != null) {
            ActionMap am = table.getActionMap();
            am.remove("Cut");
            am.remove("Paste");
            am.remove("Copy");
            am.remove("Delete");
        }
    }

    public static void isMutex_throwException(String id, String userID) throws BgAccountException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        boolean isMutex = false;
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean isRequest = iMC.requestObjIDForUpdate(id);
        if (isRequest) {
            iMC.releaseObjIDForUpdate(id);
        } else {
            isMutex = true;
        }
        if (isMutex) {
            throw new BgAccountException(BgAccountException.LOCK);
        }
    }

    public static void releaseMutexService(String id) {
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        iMC.releaseObjIDForUpdate(id);
    }

    public static String fileSelect(KDFileChooser fileChooser, CoreUI ui) {
        String filePath = null;
        ExcelFile xlsFilter = new ExcelFile();
        Excel2007FileFilter xlsxFilter = new Excel2007FileFilter();
        fileChooser.setFileFilter((FileFilter)xlsxFilter);
        fileChooser.setFileFilter((FileFilter)xlsFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setBounds(10, 10, 200, 200);
        if (fileChooser.showSaveDialog((Component)ui) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            FileFilter fileFilter = fileChooser.getFileFilter();
            if (filePath.lastIndexOf(".") != -1) {
                filePath = filePath.substring(0, filePath.lastIndexOf("."));
            }
            filePath = fileFilter == xlsxFilter ? filePath + ".xlsx" : filePath + ".xls";
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        return filePath;
    }

    public static PropertyRefSourceCollection getPropertyRefColls(Set<String> souceIds) throws BOSException {
        PropertyRefSourceCollection colls = null;
        if (souceIds != null && !souceIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceID", souceIds, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(ID);
            view.getSelector().add("sourceID");
            view.getSelector().add("propertyID");
            colls = PropertyRefSourceFactory.getRemoteInstance().getPropertyRefSourceCollection(view);
        }
        return colls;
    }

    public static Map<String, List<PropertyRefSourceInfo>> getPropertyRefMap(Set<String> souceIds) throws BOSException {
        HashMap<String, List<PropertyRefSourceInfo>> map = new HashMap<String, List<PropertyRefSourceInfo>>();
        PropertyRefSourceCollection colls = BgAccountHelper.getPropertyRefColls(souceIds);
        ArrayList lst = null;
        PropertyRefSourceInfo info = null;
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                if (!map.containsKey(info.getSourceID())) {
                    lst = new ArrayList();
                    map.put(info.getSourceID(), lst);
                }
                ((List)map.get(info.getSourceID())).add(info);
            }
        }
        return map;
    }

    public static void showCancelCancelFailMsg(CoreUI coreUI, Map resultMap, Boolean isCancel, List ids) {
        if (resultMap != null && !resultMap.isEmpty()) {
            String msg;
            String ban = EASResource.getString((String)RES, (String)"ban");
            String isEnabled = EASResource.getString((String)RES, (String)ISENABLED);
            String string = msg = isCancel != false ? ban : isEnabled;
            if (resultMap.containsKey(CANCEL_CHECK_NUMBER) || resultMap.containsKey(CANCEL_CHECK_ORG)) {
                int index;
                StringBuffer sb;
                Object[] nums;
                String checkNumbers = "";
                String checkOrgs = "";
                if (resultMap.containsKey(CANCEL_CHECK_NUMBER) && !((Map)resultMap.get(CANCEL_CHECK_NUMBER)).isEmpty()) {
                    nums = ((Map)resultMap.get(CANCEL_CHECK_NUMBER)).values().toArray();
                    sb = new StringBuffer();
                    for (index = 0; index < nums.length; ++index) {
                        sb.append(nums[index]);
                        if (index + 1 == nums.length) continue;
                        sb.append("\u3001");
                    }
                    checkNumbers = EASResource.getString((String)RES, (String)"cancelCancelFailMsg", (Object[])new String[]{sb.toString()});
                }
                nums = null;
                if (resultMap.containsKey(CANCEL_CHECK_ORG) && !((Map)resultMap.get(CANCEL_CHECK_ORG)).isEmpty()) {
                    nums = ((Map)resultMap.get(CANCEL_CHECK_ORG)).values().toArray();
                    sb = new StringBuffer();
                    for (index = 0; index < nums.length; ++index) {
                        sb.append(nums[index]);
                        if (index + 1 == nums.length) continue;
                        sb.append("\u3001");
                    }
                    checkOrgs = EASResource.getString((String)RES, (String)(isCancel != false ? "cancelOrg" : "cancelCancelOrg"), (Object[])new String[]{sb.toString()});
                }
                String showMsg = "";
                if (!StringUtils.isEmpty((String)checkNumbers)) {
                    showMsg = showMsg + checkNumbers;
                }
                if (!StringUtils.isEmpty((String)checkOrgs)) {
                    showMsg = !StringUtils.isEmpty((String)showMsg) ? showMsg + "\r\n" + checkOrgs : showMsg + checkOrgs;
                }
                if (!StringUtils.isEmpty((String)showMsg)) {
                    MsgBox.showDetailAndOK((Component)coreUI, (String)EASResource.getString((String)RES, (String)(nums != null && nums.length == ids.size() ? "allCancelCancelFail" : "partCancelCancelFail"), (Object[])new Object[]{msg}), (String)showMsg, (int)1);
                }
            } else {
                Object[] nums = resultMap.values().toArray();
                StringBuffer sb = new StringBuffer();
                for (int index = 0; index < nums.length; ++index) {
                    sb.append(nums[index]);
                    if (index + 1 == nums.length) continue;
                    sb.append("\u3001");
                }
                MsgBox.showDetailAndOK((Component)coreUI, (String)EASResource.getString((String)RES, (String)(nums.length == ids.size() ? "allCancelCancelFail" : "partCancelCancelFail"), (Object[])new Object[]{msg}), (String)EASResource.getString((String)RES, (String)"cancelCancelFailMsg", (Object[])new String[]{sb.toString()}), (int)1);
            }
        }
    }

    public static void setCancelDate(BgAccountInfo info) {
        if (info == null) {
            return;
        }
        if (info.getParent() != null && !info.getParent().isIsEnabled() && info.getParent().getDisabledDate() != null && info.isIsEnabled() && info.getDisabledDate() == null) {
            info.setIsEnabled(false);
            info.setDisabledDate(new Date(System.currentTimeMillis()));
        }
    }

    public static boolean hasPropValueChangeOnRow(BgPropertyCollection oldCol, BgPropertyCollection newCol) {
        if (oldCol == null && newCol == null || oldCol == newCol) {
            return false;
        }
        StringBuffer okey = new StringBuffer();
        if (oldCol != null) {
            oldCol.sort(NUMBER);
            Iterator ito = oldCol.iterator();
            while (ito.hasNext()) {
                okey.append(((BgPropertyInfo)ito.next()).getId() + SPLITTER_ONE);
            }
        }
        StringBuffer nkey = new StringBuffer();
        if (newCol != null) {
            newCol.sort(NUMBER);
            Iterator itn = newCol.iterator();
            while (itn.hasNext()) {
                nkey.append(((BgPropertyInfo)itn.next()).getId() + SPLITTER_ONE);
            }
        }
        return !okey.toString().equals(nkey.toString());
    }

    public static SelectorItemCollection getAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo(DISPLAYNAME));
        sic.add(new SelectorItemInfo(NAME));
        sic.add(new SelectorItemInfo(NUMBER));
        sic.add(new SelectorItemInfo(LEVEL));
        sic.add(new SelectorItemInfo(PARENT_ID));
        sic.add(new SelectorItemInfo(PARENT_NUMBER));
        sic.add(new SelectorItemInfo(PARENT));
        sic.add(new SelectorItemInfo(POL_ALGORITHM));
        sic.add(new SelectorItemInfo(PERIOD_ALGORITHM));
        sic.add(new SelectorItemInfo(BGACCOUNTDATATYPE));
        sic.add(new SelectorItemInfo(BGDECREDIT_ALGORITHM));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo(ORGUNIT));
        sic.add(new SelectorItemInfo(BGACCOUNTSORT_ID));
        sic.add(new SelectorItemInfo(BGACCOUNTSORT_NUMBER));
        sic.add(new SelectorItemInfo(BGACCOUNTSORT));
        sic.add(new SelectorItemInfo(BGACCOUNTTYPE));
        sic.add(new SelectorItemInfo(PARENT_ID));
        sic.add(new SelectorItemInfo(PARENT_NUMBER));
        sic.add(new SelectorItemInfo(PARENT));
        sic.add(new SelectorItemInfo(PARENT_LEVEL));
        sic.add(new SelectorItemInfo(PARENT_LONGNUMBER));
        sic.add(new SelectorItemInfo("parent.isEnabled"));
        sic.add(new SelectorItemInfo("parent.disabledDate"));
        sic.add(new SelectorItemInfo("parent.displayName"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo(BGACCOUNTVIEW_ID));
        sic.add(new SelectorItemInfo(DISTRIBUTEROOTID));
        sic.add(new SelectorItemInfo(ISENABLED));
        sic.add(new SelectorItemInfo(DISABLEDDATE));
        sic.add(new SelectorItemInfo("group.*"));
        return sic;
    }

    public static BgPropertyCollection getPropertyColls(Set propertyIds) throws BOSException {
        BgPropertyCollection colls = null;
        if (propertyIds != null && !propertyIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(ID, (Object)propertyIds, CompareType.INCLUDE));
            view.setFilter(filter);
            view.getSelector().add(ID);
            view.getSelector().add(NUMBER);
            view.getSelector().add(NAME);
            colls = BgPropertyFactory.getRemoteInstance().getBgPropertyCollection(view);
        }
        return colls;
    }
}

