/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.client.CodingRuleIntermilNOBox;
import com.kingdee.eas.base.codingrule.util.ParmCodingRule;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgParmCodingRule;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public final class BgCodeNumberCHelper {
    private static final Logger logger = Logger.getLogger(BgCodeNumberCHelper.class);

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId) {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId, property, null);
    }

    public static boolean hasCodeNumberLocal(IObjectValue model, String orgUnitId, String property, Context ctx) {
        return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId, property, null, ctx);
    }

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId, String property, String fieldName, Context ctx) {
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            result = codingRuleManager.isExist(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasCodeNumber(IObjectValue model, String orgUnitId, String property, String fieldName) {
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isExist(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    private static BgParmCodingRule getParmCodingRule(String fieldName) {
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        BgParmCodingRule pcr = new BgParmCodingRule();
        pcr.setCustomProperty(fieldName);
        return pcr;
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId) {
        boolean isAddView = false;
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId);
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId, String property) {
        return BgCodeNumberCHelper.hasDisplayNumber(model, orgUnitId, property, null);
    }

    public static boolean hasDisplayNumberLocal(IObjectValue model, String orgUnitId, String property, Context ctx) {
        return BgCodeNumberCHelper.hasDisplayNumber(model, orgUnitId, property, null, ctx);
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId, String property, String fieldName, Context ctx) {
        boolean isAddView = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
            codingRuleInfo.isIsModifiable();
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasDisplayNumber(IObjectValue model, String orgUnitId, String property, String fieldName) {
        boolean isAddView = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isAddView;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
            codingRuleInfo.isIsModifiable();
            if (codingRuleInfo != null && codingRuleInfo.isIsAddView()) {
                isAddView = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isAddView;
    }

    public static boolean hasModifyNumber(IObjectValue model, String orgUnitId) {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean result = false;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            result = codingRuleManager.isModifiable(model, orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return result;
    }

    public static boolean hasModifyNumber(IObjectValue model, String orgUnitId, String property, String fieldName) {
        boolean isModify = false;
        if (StringUtils.isEmpty((String)property)) {
            return BgCodeNumberCHelper.hasModifyNumber(model, orgUnitId);
        }
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return isModify;
        }
        CodingRuleInfo codingRuleInfo = null;
        ICodingRuleManager codingRuleManager = null;
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleInfo = codingRuleManager.getCodingRule(model, orgUnitId, property, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
            if (codingRuleInfo != null && codingRuleInfo.isIsModifiable()) {
                isModify = true;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        return isModify;
    }

    public static void applyNumber(KDTextField txtNumber, IObjectValue model, String orgUnitId, String property, boolean hasCodeNumber, boolean hasAddNewShow) {
        BgCodeNumberCHelper.applyNumber(txtNumber, model, orgUnitId, property, hasCodeNumber, hasAddNewShow, null);
    }

    public static void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, String property, boolean hasCodeNumber, boolean hasAddNewShow, String fieldName) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String customString = null;
            String number = "";
            if (iCodingRuleManager.isUseIntermitNumber(model, orgUnitId, property)) {
                if (iCodingRuleManager.isUserSelect(model, orgUnitId, property)) {
                    CodingRuleIntermilNOBox intermilNOF7 = new CodingRuleIntermilNOBox(model, orgUnitId, property, customString);
                    Object object = null;
                    if (iCodingRuleManager.isDHExist(model, orgUnitId, property)) {
                        intermilNOF7.show();
                        object = intermilNOF7.getData();
                    }
                    if (object != null) {
                        number = object.toString();
                    }
                } else {
                    number = iCodingRuleManager.getNumber(model, orgUnitId, property, customString, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
                }
            } else if (hasAddNewShow) {
                number = iCodingRuleManager.getNumber(model, orgUnitId, property, customString, (ParmCodingRule)BgCodeNumberCHelper.getParmCodingRule(fieldName));
            }
            BgCodeNumberCHelper.prepareNumber(txtField, model, fieldName, number, hasCodeNumber, hasAddNewShow);
            if (iCodingRuleManager.isModifiable(model, orgUnitId, property)) {
                BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            }
            return;
        }
        catch (Exception err) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_CodingRule"), (Throwable)err);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            return;
        }
    }

    public static String getNumberCodeRule(IObjectValue model, String orgUnitId, String property, String fieldName) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        String number = null;
        ICodingRuleManager icm = CodingRuleManagerFactory.getRemoteInstance();
        boolean hasCode = false;
        BgParmCodingRule pcr = null;
        if ("name".equals(fieldName)) {
            pcr = new BgParmCodingRule();
            pcr.setCustomProperty(fieldName);
        }
        if (hasCode = icm.isExist(model, orgUnitId, property, (ParmCodingRule)pcr)) {
            if (icm.isUseIntermitNumber(model, orgUnitId, property) && "number".equals(fieldName)) {
                number = icm.getNonbreakNumber(model, orgUnitId, property, fieldName);
            } else {
                CodingRuleInfo codingRule = icm.getCodingRule(model, orgUnitId, property, (ParmCodingRule)pcr);
                number = icm.getNumber(model, codingRule);
            }
        }
        return number;
    }

    public static String getNumberCodeRule(IObjectValue model, String orgUnitId, String property, String fieldName, Context ctx) throws BOSException, EASBizException {
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        if (StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        }
        String number = null;
        ICodingRuleManager icm = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        boolean hasCode = false;
        BgParmCodingRule pcr = null;
        if ("name".equals(fieldName)) {
            pcr = new BgParmCodingRule();
            pcr.setCustomProperty(fieldName);
        }
        if (hasCode = icm.isExist(model, orgUnitId, property, (ParmCodingRule)pcr)) {
            if (icm.isUseIntermitNumber(model, orgUnitId, property) && "number".equals(fieldName)) {
                number = icm.getNonbreakNumber(model, orgUnitId, property, fieldName);
            } else {
                CodingRuleInfo codingRule = icm.getCodingRule(model, orgUnitId, property, (ParmCodingRule)pcr);
                number = icm.getNumber(model, codingRule);
            }
        }
        return number;
    }

    public static void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, boolean hasCodeNumber, boolean hasAddNewShow) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (StringUtils.isEmpty((String)orgUnitId)) {
                orgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
            }
            String number = "";
            if (iCodingRuleManager.isUseIntermitNumber(model, orgUnitId)) {
                if (iCodingRuleManager.isUserSelect(model, orgUnitId)) {
                    CodingRuleIntermilNOBox intermilNOF7 = new CodingRuleIntermilNOBox(model, orgUnitId, null, null);
                    Object object = null;
                    if (iCodingRuleManager.isDHExist(model, orgUnitId)) {
                        intermilNOF7.show();
                        object = intermilNOF7.getData();
                    }
                    if (object != null) {
                        number = object.toString();
                    }
                } else {
                    number = iCodingRuleManager.readNumber(model, orgUnitId);
                }
            } else if (hasAddNewShow) {
                number = iCodingRuleManager.getNumber(model, orgUnitId);
            }
            BgCodeNumberCHelper.prepareNumber(txtField, model, null, number, hasCodeNumber, hasAddNewShow);
            if (iCodingRuleManager.isModifiable(model, orgUnitId)) {
                BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            }
            return;
        }
        catch (Exception err) {
            ExceptionHandler.handle((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_CodingRule"), (Throwable)err);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            BgCodeNumberCHelper.setNumberTextEnabled(txtField);
            return;
        }
    }

    private static void prepareNumber(KDTextField txtField, IObjectValue model, String fieldName, String number, boolean hasCodeNumber, boolean hasAddNewShow) {
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "number";
        }
        if (!StringUtils.isEmpty((String)number)) {
            model.setString(fieldName, number);
        }
        if (hasCodeNumber) {
            BgCodeNumberCHelper.setNumberTextDisable(txtField);
            if (hasAddNewShow) {
                txtField.setText(number);
            }
        }
    }

    private static void setNumberTextEnabled(KDTextField txtField) {
        txtField.setEnabled(true);
        txtField.setEditable(true);
    }

    private static void setNumberTextDisable(KDTextField txtField) {
        txtField.setEnabled(false);
        txtField.setEditable(false);
    }

    public static void dealNameCodeRule(KDTextField txtField, IObjectValue model, String orgUnitId, String property, String fieldName, EditUI ui) {
        boolean re;
        if (model == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        if (StringUtils.isEmpty((String)property)) {
            property = "sourceType";
        }
        if (StringUtils.isEmpty((String)fieldName)) {
            fieldName = "name";
        }
        if (re = BgCodeNumberCHelper.hasCodeNumber(model, orgUnitId, property, fieldName)) {
            txtField.setEnabled(false);
            re = BgCodeNumberCHelper.hasDisplayNumber(model, orgUnitId, property, fieldName);
            if (re) {
                if (ui != null) {
                    ui.storeFields();
                }
                BgCodeNumberCHelper.applyNumber(txtField, model, orgUnitId, property, true, true, fieldName);
            }
        }
    }

    public static void applyNumber(KDTextField txtField, IObjectValue model, String orgUnitId, BgCodeNumberHelper codeHelper) throws EASBizException, BOSException {
        CodingRuleIntermilNOBox intermilNOF7 = null;
        intermilNOF7 = codeHelper.isHasProperty() ? new CodingRuleIntermilNOBox(model, orgUnitId, codeHelper.getProperty(), null) : new CodingRuleIntermilNOBox(model, orgUnitId, null, null);
        codeHelper.applyNumber(txtField, model, orgUnitId, (KDPromptSelector)intermilNOF7);
    }

    public static void getNumberByCodingRule(KDTextField txtNumber, IObjectValue caller, String orgId, BgCodeNumberHelper codeHelper) throws EASBizException, BOSException {
        if (codeHelper.isHasCodeNumber()) {
            BgCodeNumberCHelper.applyNumber(txtNumber, caller, orgId, codeHelper);
        }
    }
}

