/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.MbgDimException;
import com.kingdee.eas.ma.base.client.BgOrgViewF7;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BgCommCHelper {
    public static final String bgBaseResource = "com.kingdee.eas.ma.base.client.BgBaseResource";
    public static final String bgItemResource = "com.kingdee.eas.ma.base.client.BgItemResource";
    public static final String bgElementResource = "com.kingdee.eas.ma.base.client.BgElementResource";
    public static final String bgScenarioResource = "com.kingdee.eas.ma.base.BgScenarioResource";
    public static final String bgPeriodResource = "com.kingdee.eas.ma.base.BgPeriodResource";
    public static final String bgOrgUnitResource = "com.kingdee.eas.ma.mbg.BgOrgUnitReource";
    public static final String bgVersionResource = "com.kingdee.eas.ma.base.client.BgVersionResource";
    public static final String dimensionResource = "com.kingdee.eas.ma.mbg.DimensionCommonResource";
    public static final String mbgExamineResource = "com.kingdee.eas.ma.mbg.client.BgExamineCheckResource";
    public static final String bgFormResource = "com.kingdee.eas.ma.mbg.client.BgFormResource";
    public static final String RESOURCE_DECOMPOSE = "com.kingdee.eas.ma.mbg.BgDecomposeResource";

    public static String getMessageStr(String sourceStr, String key) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key) : "";
    }

    public static String getMessageStr(String sourceStr, String key, Object[] params) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key, (Object[])params) : "";
    }

    public static String getMessageStr(String sourceStr, String key, List<String> params) {
        return !StringUtils.isEmpty((String)key) ? EASResource.getString((String)sourceStr, (String)key, (Object[])new Object[]{BgCommCHelper.getMessageStr(params)}) : "";
    }

    public static String getMessageStr(List<String> strList) {
        StringBuffer strs = new StringBuffer();
        if (strList != null && !strList.isEmpty()) {
            for (String tmpStr : strList) {
                strs.append(tmpStr + BgBaseConstants.SEP_THR_STR);
            }
            if (strs.length() > 0) {
                strs = strs.delete(strs.length() - 1, strs.length());
            }
        }
        return strs.toString();
    }

    public static void enable(JButton button, JMenuItem menuItem, ItemAction action) {
        BgCommCHelper.setVisible(button, menuItem, action, true);
        BgCommCHelper.setAction(button, menuItem, action, true);
    }

    public static void disable(JButton button, JMenuItem menuItem, ItemAction action) {
        BgCommCHelper.setVisible(button, menuItem, action, false);
        BgCommCHelper.setAction(button, menuItem, action, false);
    }

    public static void enableVisible(JButton button, JMenuItem menuItem) {
        BgCommCHelper.setVisible(button, menuItem, null, true);
        BgCommCHelper.setAction(button, menuItem, null, true);
    }

    public static void disableVisible(JButton button, JMenuItem menuItem) {
        BgCommCHelper.disableVisible(button, menuItem, null);
    }

    public static void disableVisible(JButton button, JMenuItem menuItem, ItemAction action) {
        BgCommCHelper.setVisible(button, menuItem, action, false);
        BgCommCHelper.setAction(button, menuItem, action, false);
    }

    public static void enableAction(JButton button) {
        BgCommCHelper.setAction(button, null, null, true);
    }

    public static void disableAction(JButton button) {
        BgCommCHelper.setAction(button, null, null, false);
    }

    public static void enableAction(JMenuItem menuItem) {
        BgCommCHelper.setAction(null, menuItem, null, true);
    }

    public static void disableAction(JMenuItem menuItem) {
        BgCommCHelper.setAction(null, menuItem, null, false);
    }

    public static void enableAction(ItemAction action) {
        BgCommCHelper.setAction(null, null, action, true);
    }

    public static void disableAction(ItemAction action) {
        BgCommCHelper.setAction(null, null, action, false);
    }

    public static void enableAction(JButton button, JMenuItem menuItem) {
        BgCommCHelper.setAction(button, menuItem, null, true);
    }

    public static void disableAction(JButton button, JMenuItem menuItem) {
        BgCommCHelper.setAction(button, menuItem, null, false);
    }

    public static void enableAction(JButton button, JMenuItem menuItem, ItemAction action) {
        BgCommCHelper.setAction(button, menuItem, action, true);
    }

    public static void disableAction(JButton button, JMenuItem menuItem, ItemAction action) {
        BgCommCHelper.setAction(button, menuItem, action, false);
    }

    public static void setAction(JButton button, JMenuItem menuItem, ItemAction action, boolean enabled) {
        if (button != null) {
            button.setEnabled(enabled);
        }
        if (menuItem != null) {
            menuItem.setEnabled(enabled);
        }
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    private static void setVisible(JButton button, JMenuItem menuItem, ItemAction action, boolean isVisible) {
        if (button != null) {
            button.setVisible(isVisible);
        }
        if (menuItem != null) {
            menuItem.setVisible(isVisible);
        }
        if (action != null) {
            action.setVisible(isVisible);
        }
    }

    public static void setDisable(Component component) {
        if (component != null) {
            component.setEnabled(false);
        }
    }

    public static void setEnable(Component component) {
        if (component != null) {
            component.setEnabled(true);
        }
    }

    public static void dealWorkButton(KDToolBar toolbar, String name, boolean action, boolean visible) {
        if (toolbar == null || StringUtils.isEmpty((String)name)) {
            return;
        }
        Component component2 = null;
        for (Component component2 : toolbar.getComponents()) {
            if (!name.equalsIgnoreCase(component2.getName())) continue;
            component2.setEnabled(action);
            component2.setVisible(visible);
            break;
        }
    }

    public static String transMapToString(Map map) {
        StringBuffer sb = new StringBuffer();
        BgCommCHelper.transMapToString(map, sb);
        return sb.toString();
    }

    private static void transMapToString(Map map, StringBuffer sb) {
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : map.entrySet()) {
            sb.append("{" + entry2.getKey().toString()).append("|").append(entry2.getValue() + "; ");
            if (entry2.getValue() instanceof Map) {
                BgCommCHelper.transMapToString((Map)entry2.getValue(), sb);
            }
            sb.append("}");
        }
    }

    public static boolean isCreator(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return false;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        return userId.equals(userInfo.getId().toString());
    }

    public static void setComBoxByBgElement(KDComboBox cbo) throws BOSException, EASBizException {
        if (cbo == null) {
            return;
        }
        cbo.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("number"));
        BgElementCollection colls = BgElementFactory.getRemoteInstance().getBgElementCollection(view);
        if (colls != null) {
            cbo.addItems(colls.toArray());
        }
    }

    public static IObjectValue getObjectByNumber(KDComboBox cbo, String number) {
        if (cbo == null || number == null) {
            return null;
        }
        IObjectValue obj = null;
        int in = cbo.getItemCount();
        for (int i = 0; i < in; ++i) {
            obj = (IObjectValue)cbo.getItemAt(i);
            if (!number.equals(obj.getString("number"))) continue;
            return obj;
        }
        return null;
    }

    public static boolean existFilterItems(FilterInfo filter, FilterItemInfo item) {
        boolean isExist = false;
        if (filter == null || item == null) {
            return isExist;
        }
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equals(item.getPropertyName().trim())) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    public static void replaceFilterItems(FilterInfo filter, FilterItemInfo item) {
        if (filter == null || item == null) {
            return;
        }
        boolean isReplace = false;
        if (filter.getFilterItems() != null) {
            FilterItemInfo fiInfo = null;
            FilterItemCollection fiCol = filter.getFilterItems();
            int n = fiCol.size();
            for (int i = 0; i < n; ++i) {
                fiInfo = fiCol.get(i);
                if (!fiInfo.getPropertyName().trim().equalsIgnoreCase(item.getPropertyName().trim())) continue;
                fiInfo.setCompareType(item.getCompareType());
                fiInfo.setCompareValue(item.getCompareValue());
                isReplace = true;
                break;
            }
            if (!isReplace) {
                fiCol.add(item);
                if (!StringUtils.isEmpty((String)filter.getMaskString())) {
                    String str = filter.getMaskString();
                    int itemsSize = fiCol.size();
                    if (itemsSize <= 1) {
                        filter.setMaskString("#0");
                    } else {
                        filter.setMaskString(str + " and (#" + String.valueOf(itemsSize - 1) + ")");
                    }
                }
            }
        }
    }

    public static void initOrgUnit(CoreUIObject owner, KDBizPromptBox prmtOrgUnit, Object orgUnit, String rootUnitId) {
        BgCommCHelper.initOrgUnit(owner, prmtOrgUnit, orgUnit, rootUnitId, false, null, null);
    }

    public static void initOrgUnit(CoreUIObject owner, KDBizPromptBox prmtOrgUnit, Object orgUnit, String rootUnitId, boolean isMultiSelect) {
        BgCommCHelper.initOrgUnit(owner, prmtOrgUnit, orgUnit, rootUnitId, isMultiSelect, null, null);
    }

    public static void initOrgUnit(CoreUIObject owner, KDBizPromptBox prmtOrgUnit, Object orgUnit, String rootUnitId, String permissionItem) {
        BgCommCHelper.initOrgUnit(owner, prmtOrgUnit, orgUnit, rootUnitId, false, permissionItem, null);
    }

    public static void initOrgUnit(CoreUIObject owner, KDBizPromptBox prmtOrgUnit, Object orgUnit, String rootUnitId, boolean isMultiSelect, String permissionItem, Set<String> selectedOrgIds) {
        BgCommCHelper.initOrgUnit(owner, prmtOrgUnit, orgUnit, rootUnitId, isMultiSelect, selectedOrgIds, permissionItem, null);
    }

    public static void initOrgUnit(CoreUIObject owner, KDBizPromptBox prmtOrgUnit, Object orgUnit, String rootUnitId, boolean isMultiSelect, Set<String> selectedOrgIds, String permissionItem, FilterInfo outerFilter) {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)owner);
        orgView.setTitle(BgCommCHelper.getMessageStr(bgBaseResource, "selectOrgUnit"));
        orgView.setRootUnitID(rootUnitId);
        orgView.setMultiSelect(isMultiSelect);
        orgView.setPermissionItem(permissionItem);
        if (selectedOrgIds != null && !selectedOrgIds.isEmpty()) {
            HashSet<String> tmpSet = new HashSet<String>();
            tmpSet.addAll(selectedOrgIds);
            orgView.setSelectedOrgIds(tmpSet);
        }
        if (outerFilter != null) {
            orgView.setOuterFilterInfo(outerFilter);
        }
        if (orgUnit instanceof OrgUnitInfo) {
            OrgUnitInfo org = (OrgUnitInfo)orgUnit;
            org.put("name", (Object)org.getName());
        }
        prmtOrgUnit.setData(orgUnit);
        prmtOrgUnit.setSelector((KDPromptSelector)orgView);
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String[] fields, String value, boolean isBlured) {
        if (fields == null || fields.length == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)BgCommCHelper.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgCommCHelper.disableTreeNodeByFilterCondition(root, fields, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    public static TreeModel deepCloneTreeModel(TreeModel model) {
        if (model.getRoot() != null) {
            DefaultKingdeeTreeNode newRoot = BgCommCHelper.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
            return new DefaultTreeModel((TreeNode)newRoot);
        }
        return new DefaultTreeModel(null);
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode newChildNode = BgCommCHelper.cloneTreeNode(childNode);
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String[] fields, String value, boolean isBlured) {
        if (root == null || fields == null || fields.length == 0) {
            return;
        }
        FullOrgUnitInfo unitInfo = null;
        DefaultKingdeeTreeNode node = null;
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            unitInfo = ((OrgStructureInfo)node.getUserObject()).getUnit();
            if (value == null || value.trim().length() == 0) continue;
            boolean isShow = false;
            for (int i = 0; i < fields.length; ++i) {
                if (!(unitInfo.get(fields[i]) instanceof String)) continue;
                if (isBlured) {
                    if (unitInfo.getString(fields[i]).indexOf(value) < 0) continue;
                    isShow = true;
                    break;
                }
                if (!unitInfo.getString(fields[i]).equals(value)) continue;
                isShow = true;
                break;
            }
            if (isShow) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    public static boolean isEqualsPK(IObjectValue o1, IObjectValue o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 == o2) {
            return true;
        }
        Object pk1 = o1.get(o1.getPKField());
        Object pk2 = o2.get(o2.getPKField());
        if (pk1 == null || pk2 == null) {
            return false;
        }
        return pk1.equals(pk2);
    }

    public static int getSelectedRowIndex(KDTable table) {
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)table);
        int selectIndex = -1;
        if (selectRows != null && selectRows.length > 0) {
            selectIndex = selectRows[0];
        }
        return selectIndex;
    }

    public static List<Integer> getSelectRowIndexes(KDTable table) {
        ArrayList<Integer> rows = new ArrayList<Integer>();
        int rowCount = table.getDataRequestManager().getDataRequestMode() == 0 ? table.getRowCount() : (table.getDataRequestManager().getDataRequestMode() == 1 ? table.getRowCount3() : table.getRowCount3());
        if (rowCount > 0 && table.getSelectManager().size() != 0) {
            for (int i = 0; i < table.getSelectManager().size(); ++i) {
                KDTSelectBlock block = table.getSelectManager().get(i);
                if (block != null && block.getMode() == 4) {
                    block.setTop(0);
                }
                int beginRow = BgCommCHelper.getBeginRow(block, table);
                int endRow = BgCommCHelper.getEndRow(block, table);
                for (int r = beginRow; r <= endRow; ++r) {
                    if (r < 0) continue;
                    rows.add(new Integer(r));
                }
            }
        }
        return rows;
    }

    public static int getBeginRow(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getTop();
    }

    public static int getEndRow(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getBottom();
    }

    public static void removeRows(KDTable table) {
        List<Integer> rows = BgCommCHelper.getSelectRowIndexes(table);
        if (rows == null || rows.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        BgCommCHelper.removeRows(table, rows);
    }

    public static void removeRows(KDTable table, List rows) {
        if (rows != null && !rows.isEmpty()) {
            Collections.sort(rows);
            for (int i = rows.size() - 1; i >= 0; --i) {
                table.removeRow(((Integer)rows.get(i)).intValue());
            }
        }
    }

    public static List<Integer> getSelectColIndexes(KDTable table) {
        ArrayList<Integer> cols = new ArrayList<Integer>();
        if (table.getColumnCount() > 0 && table.getSelectManager().size() != 0) {
            for (int i = 0; i < table.getSelectManager().size(); ++i) {
                KDTSelectBlock block = table.getSelectManager().get(i);
                if (block != null && block.getMode() == 2) continue;
                int beginCol = BgCommCHelper.getBeginCol(block, table);
                int endCol = BgCommCHelper.getEndCol(block, table);
                for (int c = beginCol; c <= endCol; ++c) {
                    cols.add(new Integer(c));
                }
            }
        }
        return cols;
    }

    public static int getBeginCol(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getLeft();
    }

    public static int getEndCol(KDTSelectBlock block, KDTable table) {
        if (block == null || table == null) {
            return -1;
        }
        return KDTSelectBlock.change((KDTable)table, (IBlock)block).getRight();
    }

    public static void moveTop(KDTable table) {
        int selectRowIndex = table.getSelectManager().getActiveRowIndex();
        if (selectRowIndex <= 0) {
            return;
        }
        IRow row = table.getRow(selectRowIndex);
        table.removeRow(selectRowIndex);
        table.addRow(0, row);
        table.getSelectManager().select(0, 0, 2);
    }

    public static void moveUp(KDTable table) {
        int selectRowIndex = table.getSelectManager().getActiveRowIndex();
        if (selectRowIndex <= 0) {
            return;
        }
        IRow row = table.getRow(selectRowIndex);
        table.removeRow(selectRowIndex);
        table.addRow(selectRowIndex - 1, row);
        table.getSelectManager().select(selectRowIndex - 1, 0, 2);
    }

    public static void moveDown(KDTable table) {
        int selectRowIndex = table.getSelectManager().getActiveRowIndex();
        if (selectRowIndex < 0 || selectRowIndex == table.getRowCount() - 1) {
            return;
        }
        IRow row = table.getRow(selectRowIndex);
        table.removeRow(selectRowIndex);
        table.addRow(selectRowIndex + 1, row);
        table.getSelectManager().select(selectRowIndex + 1, 0, 2);
    }

    public static void moveBottom(KDTable table) {
        int selectRowIndex = table.getSelectManager().getActiveRowIndex();
        if (selectRowIndex < 0 || selectRowIndex == table.getRowCount() - 1) {
            return;
        }
        IRow row = table.getRow(selectRowIndex);
        table.removeRow(selectRowIndex);
        table.addRow(table.getRowCount(), row);
        table.getSelectManager().select(table.getRowCount() - 1, 0, 2);
    }

    public static List<Integer> getSelectAllRowIndexes(KDTable tblMain) {
        if (tblMain == null || tblMain.getRowCount() == 0) {
            return null;
        }
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < tblMain.getRowCount(); ++i) {
            rows.add(i);
        }
        return rows;
    }

    public static String getStringValue(Object obj, String property) {
        Object value = BgCommCHelper.getValue(obj, property);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public static Object getValue(Object obj, String property) {
        if (obj == null || property == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        try {
            Method method = obj.getClass().getMethod("get" + property.substring(0, 1).toUpperCase() + property.substring(1), null);
            Object result = method.invoke(obj, (Object[])null);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setValue(Object obj, Object value, String property, Class paramClass) {
        if (obj == null || StringUtils.isEmpty((String)property) || paramClass == null) {
            return;
        }
        try {
            Method method = obj.getClass().getMethod("set" + property.substring(0, 1).toUpperCase() + property.substring(1), paramClass);
            method.invoke(obj, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object getValueByProperties(Object obj, String properties) {
        String[] keys = properties.split("\\.");
        for (int i = 0; i < keys.length; ++i) {
            if ((obj = BgCommCHelper.getValue(obj, keys[i])) != null) continue;
            return null;
        }
        return obj;
    }

    public static void verifyEmpty(JComponent component, Object obj, String name) throws EASBizException {
        if (BgCommHelper.isEmpty(obj)) {
            component.requestFocus();
            throw new MbgDimException(MbgDimException.VERIFYEMPTY, new Object[]{name});
        }
    }

    public static IMetaDataPK getActionPK(ItemAction action) {
        assert (action != null);
        String actionName = action.getActionName();
        if (StringUtils.isEmpty((String)actionName) && (actionName = action.getClass().getName()).indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        return new MetaDataPK(actionName);
    }
}

