/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeFactory;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.IBgPeriodDisp;
import com.kingdee.eas.ma.base.IBgPeriodType;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgPeriodDispHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.control.utils.BgControlParamUtils");

    public static BgPeriodCollection getPeriodColls(Context ctx, BOSUuid bgPeriodTypeId, int bgPeriodType, Date start, Date beover) throws BOSException, EASBizException {
        return BgPeriodDispHelper.getPeriodColls(ctx, bgPeriodTypeId, new Integer(bgPeriodType), start, beover);
    }

    public static BgPeriodCollection getPeriodColls(Context ctx, BOSUuid bgPeriodTypeId, Integer bgPeriodType, Date start, Date beover) throws BOSException, EASBizException {
        BgPeriodCollection bgPeriodCol;
        block16: {
            bgPeriodCol = new BgPeriodCollection();
            if (bgPeriodTypeId == null) {
                return bgPeriodCol;
            }
            BgPeriodTypeInfo bgPeriodTypeInfo = BgPeriodDispHelper.getBgPeriodTypeInfo(ctx, bgPeriodTypeId);
            boolean onlySelfDefinedPeriod = BgNPeriodHelper.isOnlySelfDefinedPeriod(bgPeriodTypeInfo);
            CalendarHelper helper = new CalendarHelper();
            helper.setTime(start);
            helper.processClearTime();
            start = helper.getTime();
            helper.setTime(beover);
            helper.processSetMaxTime();
            beover = helper.getTime();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("type.id", (Object)bgPeriodTypeId.toString(), CompareType.EQUALS));
            if (!onlySelfDefinedPeriod) {
                if (bgPeriodType != null) {
                    filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
                }
                if (start != null) {
                    filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)start, CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)beover, CompareType.LESS_EQUALS));
                }
            } else {
                if (start != null) {
                    filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)start, CompareType.GREATER_EQUALS));
                }
                if (start != null) {
                    filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)beover, CompareType.LESS_EQUALS));
                }
                if (beover != null) {
                    filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)start, CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)beover, CompareType.LESS_EQUALS));
                }
                filter.setMaskString("#0  and ((#1 and #2) or (#3 and #4))");
            }
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("bgPeriod.id");
            sic.add("name");
            sic.add("number");
            sic.add("longnumber");
            sic.add("periodType");
            sic.add("beginDate");
            sic.add("endDate");
            sic.add("isLeaf");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(new SorterItemInfo("longnumber"));
            BgPeriodDispCollection colls = null;
            colls = ctx == null ? BgPeriodDispFactory.getRemoteInstance().getBgPeriodDispCollection(view) : BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection(view);
            if (colls == null) break block16;
            if (onlySelfDefinedPeriod) {
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    if (bgPeriodType != null) {
                        if (colls.get(i).getPeriodType().getValue() == bgPeriodType.intValue()) {
                            bgPeriodCol.add(colls.get(i).toBgPeriodInfo());
                        }
                        if (bgPeriodType != 20 || colls.get(i).getPeriodType().getValue() != 19 || !colls.get(i).getLongNumber().equals(colls.get(i).getNumber())) continue;
                        bgPeriodCol.add(colls.get(i).toBgPeriodInfo());
                        continue;
                    }
                    bgPeriodCol.add(colls.get(i).toBgPeriodInfo());
                }
            } else {
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    bgPeriodCol.add(colls.get(i).toBgPeriodInfo());
                }
            }
        }
        return bgPeriodCol;
    }

    /*
     * Exception decompiling
     */
    public static List<String> getPeriodNums(Context ctx, Date date, Date startDate, Date beoverDate, int periodCycle, int periodType, BOSUuid bgPeriodTypeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean checkNoIn(int periodType, int periodCycle) {
        if (periodType == periodCycle) {
            return false;
        }
        if (BgPeriodHelper.ALL_PERSONAL.contains(periodType) || BgPeriodHelper.ALL_PERSONAL.contains(periodCycle)) {
            return true;
        }
        if (5 == periodType || 5 == periodCycle || 6 == periodType || 6 == periodCycle) {
            return true;
        }
        return periodType < periodCycle;
    }

    public static int getPeriodType(Context ctx, String bgPeriodNumber, BgPeriodDispCollection colls) {
        int bgPeriodType = -1;
        BgPeriodDispInfo period = null;
        HashMap<String, BgPeriodDispInfo> bgPeriodDispMap = new HashMap<String, BgPeriodDispInfo>();
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                period = colls.get(i);
                bgPeriodDispMap.put(period.getNumber(), period);
            }
        }
        if (bgPeriodDispMap.containsKey(bgPeriodNumber)) {
            bgPeriodType = ((BgPeriodDispInfo)bgPeriodDispMap.get(bgPeriodNumber)).getPeriodType().getValue();
        }
        return bgPeriodType;
    }

    public static BgPeriodDispCollection getPeriodDispColl(Context ctx) {
        BgPeriodDispCollection colls = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("periodType");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        try {
            colls = BgPeriodDispFactory.getLocalInstance(ctx).getBgPeriodDispCollection(view);
        }
        catch (BOSException ex) {
            logger.error((Object)"getPeriodType error:", (Throwable)ex);
        }
        return colls;
    }

    public static Map<String, Integer> getPeriodDispFiscalyear(Connection conn) throws BOSException, EASBizException {
        HashMap<String, Integer> PeriodFiscalyearMap = new HashMap<String, Integer>();
        if (conn == null) {
            return PeriodFiscalyearMap;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String dimNumber = null;
        int fiscalyear = 0;
        try {
            pstmt = conn.prepareStatement("select FNumber, FiscalYear from T_MBG_BgPeriodType");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dimNumber = rst.getString("FNumber");
                fiscalyear = rst.getInt("FiscalYear");
                PeriodFiscalyearMap.put(dimNumber, fiscalyear);
            }
        }
        catch (Exception ex) {
            try {
                throw new BOSException();
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return PeriodFiscalyearMap;
    }

    public static int getFiscalyear(Map<String, Integer> PeriodFiscalyearMap, String bgPeriodNmuber) {
        int fisCalyear = 0;
        if (PeriodFiscalyearMap == null || PeriodFiscalyearMap.isEmpty() || bgPeriodNmuber == null) {
            return fisCalyear;
        }
        if (PeriodFiscalyearMap.containsKey(bgPeriodNmuber)) {
            fisCalyear = PeriodFiscalyearMap.get(bgPeriodNmuber);
        }
        return fisCalyear;
    }

    public static BgPeriodDispCollection getPeriodDispColInfo(Context ctx, Date start, Date beover, int bgPeriodType) throws BOSException, EASBizException {
        return BgPeriodDispHelper.getPeriodDispColls(ctx, start, beover, bgPeriodType);
    }

    private static BgPeriodDispCollection getPeriodDispColls(Context ctx, Date start, Date beover, int bgPeriodType) throws BOSException, EASBizException {
        int startYear;
        CalendarHelper calendar = new CalendarHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        if (bgPeriodType == 1) {
            if (start != null) {
                items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 2) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startHalfYear = calendar.getCurrentlyHalfYear(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverHalfYear = calendar.getCurrentlyHalfYear(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(startHalfYear), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(beoverHalfYear), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(startHalfYear), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(beoverHalfYear), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(calendar.getCurrentlyHalfYear(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.halfYear", (Object)new Integer(calendar.getCurrentlyHalfYear(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 3) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startQuarter = calendar.getCurrentlyQuarter(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverQuarter = calendar.getCurrentlyQuarter(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(startQuarter), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(beoverQuarter), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(startQuarter), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(beoverQuarter), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(calendar.getCurrentlyQuarter(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.quarter", (Object)new Integer(calendar.getCurrentlyQuarter(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 4) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startMonth = calendar.getCurrentlyMonth(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverMonth = calendar.getCurrentlyMonth(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(startMonth), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(beoverMonth), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(startMonth), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(beoverMonth), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(calendar.getCurrentlyMonth(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.month", (Object)new Integer(calendar.getCurrentlyMonth(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 5) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 6) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 7) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 9) {
            if (start != null && beover != null) {
                int beoverYear;
                startYear = calendar.getCurrentlyYear(start);
                if (startYear == (beoverYear = calendar.getCurrentlyYear(beover))) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 8) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)start, CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)beover, CompareType.LESS_EQUALS));
            }
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("longnumber"));
        BgPeriodDispCollection bgPeriodDispCol = null;
        try {
            IBgPeriodDisp ibgPeriodDisp = (IBgPeriodDisp)BgPeriodDispHelper.getBizInterface(ctx);
            if (ibgPeriodDisp == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodDispCol = ibgPeriodDisp.getBgPeriodDispCollection(view);
            if (bgPeriodDispCol == null) {
                bgPeriodDispCol = new BgPeriodDispCollection();
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodDispCol;
    }

    public static ICoreBase getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgPeriodDispFactory.getRemoteInstance();
        }
        return BgPeriodDispFactory.getLocalInstance(ctx);
    }

    public static void getOnlySelfPeriodFilter(FilterInfo filter, BgSchemeInfo scheme, BgPeriodTypeInfo type) {
        if (filter == null || scheme == null || type == null) {
            return;
        }
        Date beginTime = BgNPeriodHelper.getDayBegin(scheme.getDateFrom());
        Date endTime = BgNPeriodHelper.getDayEnd(scheme.getDateTo());
        CalendarHelper helper = new CalendarHelper();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = df.format(beginTime);
        String endDate = df.format(endTime);
        String defaultBeginDateString = df.format(helper.getFirstDayOfYear(2000));
        String defaultEndDateString = df.format(helper.getLastDayOfYear(2099));
        String filterString = "select fid from T_MBG_BgPeriodDisp where ftypeId ='" + type.getId().toString() + "' and ((fbeginDate <={ts'" + endDate + "'} and fbeginDate>={ts'" + beginDate + "'}) or (fEndDate <={ts'" + endDate + "'} and fendDate>={ts'" + beginDate + "'}) or (fbeginDate ={ts'" + defaultBeginDateString + "'} and fendDate={ts'" + defaultEndDateString + "'}))";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterString, CompareType.INNER));
    }

    public static void getOnlySelfPeriodFilter(FilterInfo filter, Date beginTime, Date endTime, BgPeriodTypeInfo type) {
        if (filter == null || beginTime == null || endTime == null || type == null) {
            return;
        }
        CalendarHelper helper = new CalendarHelper();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String beginDate = df.format(beginTime);
        String endDate = df.format(endTime);
        String defaultBeginDateString = df.format(helper.getFirstDayOfYear(2000));
        String defaultEndDateString = df.format(helper.getLastDayOfYear(2099));
        String filterString = "select fid from T_MBG_BgPeriodDisp where ftypeId ='" + type.getId().toString() + "' and ((fbeginDate <={ts'" + endDate + "'} and fbeginDate>={ts'" + beginDate + "'}) or (fEndDate <={ts'" + endDate + "'} and fendDate>={ts'" + beginDate + "'}) or (fbeginDate ={ts'" + defaultBeginDateString + "'} and fendDate={ts'" + defaultEndDateString + "'}))";
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)filterString, CompareType.INNER));
    }

    public static BgPeriodTypeInfo getBgPeriodTypeInfo(Context ctx, BOSUuid bgPeriodTypeId) throws BOSException, EASBizException {
        SelectorItemCollection sic = BgPeriodDispHelper.getBgPeriodTypeSelecters();
        IBgPeriodType periodType = null;
        periodType = ctx == null ? BgPeriodTypeFactory.getRemoteInstance() : BgPeriodTypeFactory.getLocalInstance(ctx);
        BgPeriodTypeInfo bgPeriodTypeInfo = periodType.getBgPeriodTypeInfo((IObjectPK)new ObjectUuidPK(bgPeriodTypeId), sic);
        return bgPeriodTypeInfo;
    }

    public static SelectorItemCollection getBgPeriodTypeSelecters() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("longnumber");
        sic.add("fiscalYear");
        sic.add("year");
        sic.add("halfYear");
        sic.add("quarter");
        sic.add("month");
        sic.add("tenday");
        sic.add("yearWeek");
        sic.add("mothWeek");
        sic.add("day");
        sic.add("selfDefined");
        sic.add("creator.id");
        sic.add("creator.number");
        sic.add("creator.name");
        sic.add("parent.id");
        sic.add("createTime");
        sic.add("startYear");
        sic.add("endYear");
        sic.add("startMonth");
        sic.add("belongYear");
        sic.add("description");
        sic.add("selfDefineRule");
        sic.add("spinnerDay");
        sic.sort("createTime");
        return sic;
    }
}

