/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.eas.ma.base.BgPeriodException;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BgPeriodNVariableHelper {
    public static final String NUMBER_N = "N";
    private static final String NUMBER_n = "n";
    public static final String ERROR_Matching = "PeriodTypeNotMatching";
    public static final String EMPTY_STR = "";
    private static final String DEFAULT_STR = "0";
    public static final String BGDATA_VALUE = "bgData";
    public static final String BGITEMFORMUAL_VALUE = "BGITEMFORMUAL";
    public static final String BGACTUAL_VALUE = "bgActual";
    public static final String BGACTUALADD_VALUE = "bgActualAdd";
    public static final String VALUE_VALUE = "bgValue";
    public static final String CONVERT_TYPE_ALL = "ALL";
    public static final String CONVERT_TYPE_PART = "PART";
    public static final String PATTERN_PERIOD_N = "(N[\\s]?|\\+\\d{1,3}|\\-\\d{1,3})+";
    public static final String PATTERN_PERIOD_YEAR = "\\d{4}Y";

    public static String getParamValue(String param, int year) {
        int value;
        if (StringUtils.isEmpty((String)param)) {
            return param;
        }
        Matcher matcher = Pattern.compile(PATTERN_PERIOD_YEAR).matcher(param);
        if (matcher == null || !matcher.find()) {
            return param;
        }
        int startIndex = matcher.start();
        String left = EMPTY_STR;
        String thisStr = EMPTY_STR;
        String right = EMPTY_STR;
        int end = startIndex + 4;
        if (startIndex > 0) {
            left = param.substring(0, startIndex);
        }
        if (param.length() > startIndex + 5) {
            right = param.substring(startIndex + 5);
        }
        thisStr = (value = Integer.parseInt(param.substring(startIndex, end))) == year ? "N!Y" : (value > year ? "N+" + (value - year) + "!Y" : NUMBER_N + (value - year) + "!Y");
        return left + thisStr + right;
    }

    public static String getBgPeriodByN(String bgFormPeriod, String nPeriodNum, int bgFormPeriodType) throws BgPeriodException {
        if (StringUtils.isEmpty((String)bgFormPeriod) || StringUtils.isEmpty((String)nPeriodNum) || nPeriodNum.indexOf(".") < 0) {
            return nPeriodNum;
        }
        String _prefix = nPeriodNum.substring(0, nPeriodNum.indexOf("."));
        String _nPeriodNum = nPeriodNum.substring(nPeriodNum.indexOf(".") + 1);
        String _bgFormPeriod = bgFormPeriod.substring(bgFormPeriod.indexOf(".") + 1);
        if (!BgPeriodNVariableHelper.checkCanConvert(_nPeriodNum)) {
            return nPeriodNum;
        }
        if (8 == bgFormPeriodType) {
            return bgFormPeriod;
        }
        String[] nPeriodNums = _nPeriodNum.split("\\.");
        String tempStr = null;
        String[] tempStrs = null;
        String periodType = null;
        String targetPeriod = new String(_bgFormPeriod);
        if (nPeriodNums.length == 2 && Pattern.matches("[\\d]{1,6}D", nPeriodNums[1])) {
            tempStr = nPeriodNums[0];
            targetPeriod = BgPeriodNVariableHelper.processPeriodNVariable(tempStr, bgFormPeriodType, targetPeriod);
            try {
                int year = Integer.valueOf(targetPeriod.substring(0, 4));
                int period = Integer.valueOf(nPeriodNums[1].replaceAll("D", EMPTY_STR));
                targetPeriod = BgPeriodNVariableHelper.getPeriodByYearAndDay(year, period);
            }
            catch (Exception year) {
                // empty catch block
            }
            return _prefix + "." + targetPeriod;
        }
        int size = nPeriodNums.length;
        for (int i = 0; i < size; ++i) {
            tempStr = nPeriodNums[i];
            tempStrs = tempStr.split("!");
            if (tempStrs.length == 1) {
                if (i != 0) continue;
                if (_bgFormPeriod.length() > 5) {
                    targetPeriod = tempStr + targetPeriod.substring(5, _bgFormPeriod.length());
                    continue;
                }
                targetPeriod = tempStr;
                continue;
            }
            if (tempStrs.length == 2) {
                try {
                    periodType = tempStrs[1];
                    String partPeriod = _nPeriodNum.substring(_nPeriodNum.indexOf(periodType) + periodType.length());
                    targetPeriod = BgPeriodNVariableHelper.processPeriodNVariable(tempStr, bgFormPeriodType, targetPeriod);
                    if (partPeriod.indexOf("!") != -1) {
                        targetPeriod = targetPeriod + _bgFormPeriod.substring(_bgFormPeriod.indexOf(periodType) + periodType.length());
                        targetPeriod = BgPeriodNVariableHelper.rebuildPeriod(targetPeriod);
                        continue;
                    }
                    targetPeriod = targetPeriod + _nPeriodNum.substring(_nPeriodNum.indexOf(periodType) + periodType.length());
                    continue;
                }
                catch (BgPeriodException e) {
                    throw new BgPeriodException(BgPeriodException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
                }
            }
            throw new BgPeriodException(BgPeriodException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
        }
        if (BgPeriodNVariableHelper.checkIsDay(targetPeriod) || BgPeriodNVariableHelper.checkIsMonthWeek(targetPeriod)) {
            return _prefix + "." + BgPeriodNVariableHelper.rebuildPeriod(targetPeriod);
        }
        return _prefix + "." + targetPeriod;
    }

    private static String rebuildPeriod(String targetPeriod) {
        if (targetPeriod == null || targetPeriod.trim().length() == 0) {
            return EMPTY_STR;
        }
        if (Pattern.matches("[\\d]{4}Y.[\\d]{2}W", targetPeriod)) {
            int offset = Integer.valueOf(targetPeriod.substring(6, 8)) - 1;
            targetPeriod = targetPeriod.substring(0, 5) + "." + "01" + "W";
            targetPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber(targetPeriod, offset);
        }
        if (Pattern.matches("[\\d]{4}Y.[\\d]{2}M.[\\d]{2}D", targetPeriod)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.valueOf(targetPeriod.substring(0, 4)));
            calendar.set(2, Integer.valueOf(targetPeriod.substring(6, 8)) - 1);
            calendar.set(5, Integer.valueOf(targetPeriod.substring(10, 12)));
            targetPeriod = new SimpleDateFormat("yyyy'Y.'MM'M.'dd'D'").format(calendar.getTime());
        }
        return targetPeriod;
    }

    private static String processPeriodNVariable(String nPeriodNum, int bgFormPeriodType, String bgFormPeriod) throws BgPeriodException {
        String targetPeriod = null;
        String[] params = nPeriodNum.split("!");
        if (params.length != 2) {
            return nPeriodNum;
        }
        String offSetStr = params[0].trim().replaceAll(NUMBER_N, EMPTY_STR).replaceAll(NUMBER_n, EMPTY_STR).replaceAll("\\+", EMPTY_STR);
        String periodType = params[1].trim();
        if (!BgPeriodNVariableHelper.checkPeriodTypeIsValid(bgFormPeriod, periodType)) {
            throw new BgPeriodException(BgPeriodException.PERIODNVALUEISNOTVALID, new String[]{bgFormPeriod, nPeriodNum});
        }
        if (EMPTY_STR.equals(offSetStr)) {
            offSetStr = DEFAULT_STR;
        }
        int offSet = 0;
        try {
            offSet = Integer.valueOf(offSetStr);
        }
        catch (Exception e) {
            return nPeriodNum;
        }
        targetPeriod = BgNPeriodHelper.getOffsetBgPeriodNumber(BgPeriodNVariableHelper.getCurrentPeriod(bgFormPeriod, periodType), offSet);
        return targetPeriod;
    }

    private static boolean checkPeriodTypeIsValid(String bgFormPeriod, String periodType) {
        boolean isValid = false;
        if ("Y".equals(periodType)) {
            isValid = true;
        } else if ("HY".equals(periodType)) {
            if (bgFormPeriod.indexOf("HY") != -1 || bgFormPeriod.indexOf("Q") != -1 || bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("Q".equals(periodType)) {
            if (bgFormPeriod.indexOf("Q") != -1 || bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("M".equals(periodType)) {
            if (bgFormPeriod.indexOf("M") != -1 || bgFormPeriod.indexOf("D") != -1 || bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            }
        } else if ("TD".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") != -1 || bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        } else if ("D".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") != -1) {
                isValid = false;
            } else if (bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        } else if ("W".equals(periodType) || "MW".equals(periodType)) {
            if (bgFormPeriod.indexOf("MW") != -1) {
                isValid = true;
            } else if (bgFormPeriod.indexOf("W") != -1 || bgFormPeriod.indexOf("D") != -1) {
                isValid = true;
            }
        }
        return isValid;
    }

    public static boolean checkCanConvert(String nValue) {
        if (nValue == null) {
            return false;
        }
        String[] nValues = nValue.split("\\.");
        String periodNum = null;
        String periodType = null;
        String[] tempStrs = null;
        boolean hasPeriodNVariable = false;
        int size = nValues.length;
        for (int i = 0; i < size; ++i) {
            tempStrs = nValues[i].split("!");
            if (tempStrs.length == 1) {
                if (i == 0 || !tempStrs[0].startsWith(NUMBER_N) || tempStrs[0].indexOf("!") >= 0) continue;
                return false;
            }
            if (tempStrs.length == 2) {
                periodNum = tempStrs[0];
                periodType = tempStrs[1];
                if (Pattern.matches(PATTERN_PERIOD_N, periodNum)) {
                    if (!"Y".equals(periodType) && !"HY".equals(periodType) && !"Q".equals(periodType) && !"M".equals(periodType) && !"D".equals(periodType) && !"W".equals(periodType) && !"MW".equals(periodType) && !"TD".equals(periodType)) continue;
                    hasPeriodNVariable = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return hasPeriodNVariable;
    }

    private static String getCurrentPeriod(String bgFormPeriod, String periodType) {
        String currentPeriod = null;
        if (BgPeriodNVariableHelper.getBgFormPeriodLevel(bgFormPeriod) == 1) {
            currentPeriod = bgFormPeriod;
        } else if (bgFormPeriod.indexOf(periodType) != -1) {
            currentPeriod = bgFormPeriod.substring(0, bgFormPeriod.indexOf(periodType) + periodType.length());
        } else if ("HY".equals(periodType)) {
            if (bgFormPeriod.indexOf("Q") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theQuarterNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theHalfYearNum = DEFAULT_STR + (theQuarterNum + 2 - 1) / 2;
                currentPeriod = year + "." + theHalfYearNum + "HY";
            } else if (bgFormPeriod.indexOf("M") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theMonthNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theHalfYearNum = (theMonthNum + 6 - 1) / 6 + EMPTY_STR;
                if (theHalfYearNum.trim().length() == 1) {
                    theHalfYearNum = DEFAULT_STR + theHalfYearNum;
                }
                currentPeriod = year + "." + theHalfYearNum + "HY";
            }
        } else if ("Q".equals(periodType)) {
            if (bgFormPeriod.indexOf("M") != -1) {
                String year = bgFormPeriod.substring(0, 5);
                int theMonthNum = Integer.valueOf(bgFormPeriod.substring(6, 8));
                String theQuarterNum = DEFAULT_STR + (theMonthNum + 3 - 1) / 3;
                currentPeriod = year + "." + theQuarterNum + "Q";
            }
        } else if ("TD".equals(periodType)) {
            if (bgFormPeriod.indexOf("TD") == -1 && bgFormPeriod.indexOf("D") != -1) {
                String yearAndMonth = bgFormPeriod.substring(0, 9);
                int theDayNum = Integer.valueOf(bgFormPeriod.substring(10, 12));
                String theTenDayNum = null;
                theTenDayNum = theDayNum == 31 ? "03" : DEFAULT_STR + (theDayNum + 10 - 1) / 10;
                currentPeriod = yearAndMonth + "." + theTenDayNum + "TD";
            }
        } else if ("W".equals(periodType) && bgFormPeriod.indexOf("TD") == -1 && bgFormPeriod.indexOf("D") != -1) {
            Calendar calendar = Calendar.getInstance();
            int year = Integer.valueOf(bgFormPeriod.substring(0, 4));
            int month = Integer.valueOf(bgFormPeriod.substring(6, 8)) - 1;
            int day = Integer.valueOf(bgFormPeriod.substring(10, 12));
            String yearStr = bgFormPeriod.substring(0, 5);
            calendar.set(1, year);
            calendar.set(2, month);
            calendar.set(5, day);
            String theYearWeek = calendar.get(3) + EMPTY_STR;
            if (theYearWeek.trim().length() == 1) {
                theYearWeek = DEFAULT_STR + theYearWeek;
            }
            currentPeriod = yearStr + "." + theYearWeek + "W";
        }
        return currentPeriod;
    }

    private static int getBgFormPeriodLevel(String bgFormPeriod) {
        int level = 0;
        String[] parameter = null;
        parameter = bgFormPeriod.split("\\.");
        if (parameter != null) {
            level = parameter.length;
        }
        return level;
    }

    private static String getPeriodByYearAndDay(int year, int period) {
        String periodNumber = null;
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(6, period);
        String yearStr = calendar.get(1) + "Y.";
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String monthStr = null;
        String dayStr = null;
        monthStr = month < 10 ? DEFAULT_STR + month + "M." : month + "M.";
        dayStr = day < 10 ? DEFAULT_STR + day + "D" : day + "D";
        periodNumber = yearStr + monthStr + dayStr;
        return periodNumber;
    }

    public static boolean checkIsDay(String bgPeriodNumber) {
        return !StringUtils.isEmpty((String)bgPeriodNumber) && bgPeriodNumber.endsWith("D");
    }

    public static boolean checkIsMonthWeek(String bgPeriodNumber) {
        return !StringUtils.isEmpty((String)bgPeriodNumber) && bgPeriodNumber.endsWith("MW");
    }
}

