/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.utils.BgLocaleHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BgPeriodVariable {
    protected Calendar calendar = null;
    private static final Logger logger = CoreUIObject.getLogger(BgPeriodVariable.class);
    private int year = -1;
    private int halfYear = -2;
    private int quarter = -4;
    private int month = -12;
    private int type = 0;
    public static final int YEAR_NCOUNT = 4;
    public static int MONTHS_OF_YEAR = 12;
    public static int QUARTER_OF_YEAR = 4;
    public static int HALF_OF_YEAR = 2;
    public static int YEAR_OF_YEAR = 1;
    public static String YEAR = BgPeriodVariable.getResource("year");
    public static String HALFYEARUP = BgPeriodVariable.getResource("halfYear");
    public static String HALFYEARDOWN = BgPeriodVariable.getResource("halfYearDown");
    public static String QUARTER = BgPeriodVariable.getResource("quarter");
    public static String MONTH = BgPeriodVariable.getResource("month");
    public static String YEAR_STR = "Y";
    public static String HALFYEAR_STR = "HY";
    public static String QUARTER_STR = "Q";
    public static String MONTH_STR = "M";
    public static String DAY_STR = "D";
    public static String MONTHWEEK_STR = "MW";
    String[] valueOfYear = null;
    private Map<Integer, String> yearMap = new HashMap<Integer, String>();
    private Map<Integer, String> halfYearMap = new HashMap<Integer, String>();
    private Map<Integer, String> quarterMap = new HashMap<Integer, String>();
    private Map<Integer, String> monthMap = new HashMap<Integer, String>();
    private static List<String> bgPeriodDispNumber = null;
    public static final String PATTERN_PERIOD_YEAR = "\\d{4}" + YEAR;
    public static final String PATTERN_PERIOD_YEAR_N = "\\d{4}Y";

    public BgPeriodVariable() {
        this.calendar = Calendar.getInstance();
    }

    private static String getResource(String str) {
        return EASResource.getString((String)"com.kingdee.eas.ma.base.client.BgPeriodNSetResource", (String)str);
    }

    public Map<Integer, String> getYearMap() {
        return this.yearMap;
    }

    public Map<Integer, String> getHalfYearMap() {
        return this.halfYearMap;
    }

    public Map<Integer, String> getQuarterMap() {
        return this.quarterMap;
    }

    public Map<Integer, String> getMonthMap() {
        return this.monthMap;
    }

    public static List<String> getBgPeriodDispNumber() {
        if (bgPeriodDispNumber == null) {
            try {
                bgPeriodDispNumber = BgPeriodDispFactory.getRemoteInstance().getSelfPeriodDispNumber();
            }
            catch (Exception e) {
                bgPeriodDispNumber = new ArrayList<String>();
                logger.error((Object)"getSelfBgPeriodDispNumberError", (Throwable)e);
            }
        }
        return bgPeriodDispNumber;
    }

    public String[] initValueOfYear() {
        if (this.valueOfYear == null) {
            this.valueOfYear = new String[101];
            int yearNumMin = this.getCurrentlyYear() - 50;
            int num = -1;
            for (int i = 0; i <= 100; ++i) {
                this.valueOfYear[i] = yearNumMin + i + YEAR;
                num = yearNumMin + i;
                this.yearMap.put(num, this.valueOfYear[i]);
            }
        }
        return this.valueOfYear;
    }

    public String[] initValueOfHalfYear() {
        String[] valueOfYear = this.initValueOfYear();
        ArrayList<String> valueOfHalfYear = new ArrayList<String>();
        String numUp = "";
        String numDown = "";
        int numU = -1;
        int numD = -1;
        for (int i = 0; i < valueOfYear.length; ++i) {
            valueOfHalfYear.add(valueOfYear[i] + HALFYEARUP);
            valueOfHalfYear.add(valueOfYear[i] + HALFYEARDOWN);
            numUp = valueOfYear[i].substring(0, 4) + 1;
            numDown = valueOfYear[i].substring(0, 4) + 2;
            numU = Integer.parseInt(numUp);
            numD = Integer.parseInt(numDown);
            this.halfYearMap.put(numU, valueOfYear[i] + HALFYEARUP);
            this.halfYearMap.put(numD, valueOfYear[i] + HALFYEARDOWN);
        }
        String[] arrValueOfHalfYear = new String[valueOfHalfYear.size()];
        if (valueOfHalfYear.toArray(arrValueOfHalfYear) instanceof String[]) {
            arrValueOfHalfYear = valueOfHalfYear.toArray(arrValueOfHalfYear);
        }
        return arrValueOfHalfYear;
    }

    public String[] initValueOfQuarter() {
        String[] valueOfYear = this.initValueOfYear();
        ArrayList<String> valueOfQuarter = new ArrayList<String>();
        String numS = "";
        int num = -1;
        for (int i = 0; i < valueOfYear.length; ++i) {
            for (int j = 1; j <= 4; ++j) {
                valueOfQuarter.add(valueOfYear[i] + "0" + j + QUARTER);
                numS = valueOfYear[i].substring(0, 4) + "0" + j;
                num = Integer.parseInt(numS);
                this.quarterMap.put(num, valueOfYear[i] + "0" + j + QUARTER);
            }
        }
        String[] arrValueOfQuarter = new String[valueOfQuarter.size()];
        if (valueOfQuarter.toArray(arrValueOfQuarter) instanceof String[]) {
            arrValueOfQuarter = valueOfQuarter.toArray(arrValueOfQuarter);
        }
        return arrValueOfQuarter;
    }

    public String[] initValueOfMonth() {
        String[] valueOfYear = this.initValueOfYear();
        ArrayList<String> valueOfMonth = new ArrayList<String>();
        String numS = "";
        String k = "";
        int num = -1;
        for (int i = 0; i < valueOfYear.length; ++i) {
            for (int j = 1; j <= 12; ++j) {
                k = j < 10 ? "0" + j : "" + j;
                valueOfMonth.add(valueOfYear[i] + k + MONTH);
                numS = valueOfYear[i].substring(0, 4) + k;
                num = Integer.parseInt(numS);
                this.monthMap.put(num, valueOfYear[i] + k + MONTH);
            }
        }
        String[] arrValueOfMonth = new String[valueOfMonth.size()];
        if (valueOfMonth.toArray(arrValueOfMonth) instanceof String[]) {
            arrValueOfMonth = valueOfMonth.toArray(arrValueOfMonth);
        }
        return arrValueOfMonth;
    }

    public int getCurrentlyYear() {
        this.calendar.setTime(new Date());
        return this.calendar.get(1);
    }

    public String getSCurrentlyYear() {
        this.calendar.setTime(new Date());
        return this.calendar.get(1) + YEAR;
    }

    public int getCurrentlyHalfYear(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            int month = this.calendar.get(2) + 1;
            if (month >= 1 && month <= 6) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public String getSCurrentlyHalfYear(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            int month = this.calendar.get(2) + 1;
            if (month >= 1 && month <= 6) {
                return this.getSCurrentlyYear() + HALFYEARUP;
            }
            return this.getSCurrentlyYear() + HALFYEARDOWN;
        }
        return null;
    }

    public int getCurrentlyQuarter() {
        this.calendar.setTime(new Date());
        int month = this.calendar.get(2) + 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        return 4;
    }

    public String getSCurrentlyQuarter() {
        this.calendar.setTime(new Date());
        int month = this.calendar.get(2) + 1;
        if (month >= 1 && month <= 3) {
            return this.getSCurrentlyYear() + 1 + QUARTER;
        }
        if (month >= 4 && month <= 6) {
            return this.getSCurrentlyYear() + 2 + QUARTER;
        }
        if (month >= 7 && month <= 9) {
            return this.getSCurrentlyYear() + 3 + QUARTER;
        }
        return this.getSCurrentlyYear() + 4 + QUARTER;
    }

    public int getCurrentlyMonth() {
        this.calendar.setTime(new Date());
        return this.calendar.get(2) + 1;
    }

    public String getSCurrentlyMonth() {
        this.calendar.setTime(new Date());
        int num = this.calendar.get(2) + 1;
        return this.getSCurrentlyYear() + num + MONTH;
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public int getHalfYear() {
        return this.halfYear;
    }

    public void setHalfYear(int halfYear) {
        this.halfYear = halfYear;
    }

    public int getQuarter() {
        return this.quarter;
    }

    public void setQuarter(int quarter) {
        this.quarter = quarter;
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getcurrentlyDate(int value) {
        switch (value) {
            case 1: {
                return this.getSCurrentlyYear();
            }
            case 2: {
                return this.getSCurrentlyYear() + HALFYEARUP;
            }
            case 4: {
                return this.getSCurrentlyYear() + "0" + 1 + QUARTER;
            }
            case 12: {
                return this.getSCurrentlyYear() + "0" + 1 + MONTH;
            }
        }
        return null;
    }

    public static int parseIntPeriodYear(String value) {
        if (value == null) {
            return -1;
        }
        Matcher matcher = Pattern.compile(PATTERN_PERIOD_YEAR).matcher(value);
        if (matcher == null || !matcher.find()) {
            return -1;
        }
        int startIndex = matcher.start();
        int end = startIndex + 4;
        int yearValue = Integer.parseInt(value.substring(startIndex, end));
        return yearValue;
    }

    public static int parseIntPeriod(String value, int type) {
        if (value == null) {
            return -1;
        }
        int halfYearValue = 0;
        String halfValue = null;
        Matcher matcher = Pattern.compile(PATTERN_PERIOD_YEAR).matcher(value);
        if (matcher == null || !matcher.find()) {
            return -1;
        }
        if (type == 2) {
            int end;
            int startIndex = matcher.start() + 5;
            halfValue = value.substring(startIndex, end = startIndex + 3);
            if (halfValue.equals(HALFYEARUP)) {
                halfYearValue = 1;
            } else if (halfValue.equals(HALFYEARDOWN)) {
                halfYearValue = 2;
            }
            return halfYearValue;
        }
        if (type == 4) {
            int startIndex = value.indexOf(YEAR);
            int end = value.indexOf(QUARTER);
            int quarterValue = Integer.parseInt(value.substring(startIndex + 1, end));
            return quarterValue;
        }
        if (type == 12) {
            int startIndex = BgLocaleHelper.getCurrentLocale() == "en_US" ? value.indexOf(YEAR) + 3 : value.indexOf(YEAR);
            int end = value.indexOf(MONTH);
            int monthValue = Integer.parseInt(value.substring(startIndex + 1, end));
            return monthValue;
        }
        return -1;
    }

    public static String parseStringPeriod(String value, int type) {
        if (value == null) {
            return "";
        }
        int halfYearValue = 0;
        String halfValue = null;
        Matcher matcher = Pattern.compile(PATTERN_PERIOD_YEAR).matcher(value);
        if (matcher == null || !matcher.find()) {
            return "";
        }
        if (type == 2) {
            int end;
            int startIndex = matcher.start() + 5;
            halfValue = value.substring(startIndex, end = startIndex + 3);
            if (halfValue.equals(HALFYEARUP)) {
                halfYearValue = 1;
            } else if (halfValue.equals(HALFYEARDOWN)) {
                halfYearValue = 2;
            }
            return "" + halfYearValue;
        }
        if (type == 4) {
            int startIndex = value.indexOf(YEAR);
            int end = value.indexOf(QUARTER);
            int quarterValue = Integer.parseInt(value.substring(startIndex + 1, end));
            return "0" + quarterValue;
        }
        if (type == 12) {
            int startIndex = BgLocaleHelper.getCurrentLocale() == "en_US" ? value.indexOf(YEAR) + 3 : value.indexOf(YEAR);
            int end = value.indexOf(MONTH);
            int monthValue = Integer.parseInt(value.substring(startIndex + 1, end));
            String monthStringValue = "";
            monthStringValue = monthValue < 10 ? "0" + monthValue : "" + monthValue;
            return monthStringValue;
        }
        return "";
    }

    public static String getBgPeriodParam(String param, BgPeriodVariable bgPeriodVariable) {
        if (bgPeriodVariable.getType() == 1) {
            return BgPeriodVariable.getParamValue(param, bgPeriodVariable.getYear());
        }
        if (bgPeriodVariable.getType() == 2) {
            return BgPeriodVariable.getHalfYearParamValue(param, bgPeriodVariable.getYear(), bgPeriodVariable.getHalfYear());
        }
        if (bgPeriodVariable.getType() == 4) {
            return BgPeriodVariable.getQuarterParamValue(param, bgPeriodVariable.getYear(), bgPeriodVariable.getQuarter());
        }
        if (bgPeriodVariable.getType() == 12) {
            return BgPeriodVariable.getMonthParamValue(param, bgPeriodVariable.getYear(), bgPeriodVariable.getMonth());
        }
        return null;
    }

    public static String getBgPeriodName(String bgPeirodNum, BgPeriodVariable bgPeriodVariable) {
        String _bgPeirodNum = BgPeriodVariable.getBgPeriodParam(bgPeirodNum, bgPeriodVariable);
        if (!StringUtils.isEmpty((String)_bgPeirodNum)) {
            String type = _bgPeirodNum.substring(0, _bgPeirodNum.indexOf(46) + 1);
            _bgPeirodNum = _bgPeirodNum.substring(_bgPeirodNum.indexOf(46) + 1);
            if ((_bgPeirodNum = _bgPeirodNum.replaceFirst("Y", BgPeriodEnum.YEAR.getAlias())).indexOf("HY") >= 0) {
                _bgPeirodNum = _bgPeirodNum.replaceFirst("HY", BgPeriodEnum.HALFYEAR.getAlias());
            } else if (_bgPeirodNum.indexOf("Q") >= 0) {
                _bgPeirodNum = _bgPeirodNum.replaceFirst("Q", BgPeriodEnum.QUARTER.getAlias());
            } else if (_bgPeirodNum.indexOf("M") >= 0) {
                _bgPeirodNum = _bgPeirodNum.replaceFirst("M", BgPeriodEnum.MONTH.getAlias());
            }
            _bgPeirodNum = type + _bgPeirodNum;
        }
        return _bgPeirodNum;
    }

    public static Matcher getMatcher(String param) {
        if (StringUtils.isEmpty((String)param)) {
            return null;
        }
        Matcher matcher = Pattern.compile(PATTERN_PERIOD_YEAR_N).matcher(param);
        if (matcher == null || !matcher.find()) {
            return null;
        }
        return matcher;
    }

    private static String getYearStr(int value, int year) {
        String thisStr = "";
        thisStr = value == year ? "N!Y" : (value > year ? "N+" + (value - year) + "!Y" : "N" + (value - year) + "!Y");
        return thisStr;
    }

    private static String getHalfYear(int halfYear, int halfYearValue) {
        String halfYearStr = "";
        int num = halfYearValue - halfYear;
        halfYearStr = num == 0 ? ".N!HY" : (num > 0 ? ".N+" + num + "!HY" : ".N" + num + "!HY");
        return halfYearStr;
    }

    private static String getQuarter(int quarter, int quarterValue) {
        String quarterStr = "";
        int num = quarterValue - quarter;
        quarterStr = num == 0 ? ".N!Q" : (num > 0 ? ".N+" + num + "!Q" : ".N" + num + "!Q");
        return quarterStr;
    }

    private static String getMonth(int month, int monthValue) {
        String monthStr = "";
        int num = monthValue - month;
        monthStr = num == 0 ? ".N!M" : (num > 0 ? ".N+" + num + "!M" : ".N" + num + "!M");
        return monthStr;
    }

    private static String getWeek(int week, int weekValue) {
        String weekStr = "";
        int num = weekValue - week;
        weekStr = num == 0 ? ".N!W" : (num > 0 ? ".N+" + num + "!W" : ".N" + num + "!W");
        return weekStr;
    }

    private static String getDay(int day, int dayValue) {
        String dayStr = "";
        int num = dayValue - day;
        dayStr = num == 0 ? ".N!D" : (num > 0 ? ".N+" + num + "!D" : ".N" + num + "!D");
        return dayStr;
    }

    public static String getParamValue(String param, int year) {
        Matcher matcher = BgPeriodVariable.getMatcher(param);
        if (matcher == null) {
            return param;
        }
        int startIndex = matcher.start();
        String left = "";
        String thisStr = "";
        String right = "";
        int end = startIndex + 4;
        if (startIndex > 0) {
            left = param.substring(0, startIndex);
        }
        if (param.length() > startIndex + 5) {
            right = param.substring(startIndex + 5);
        }
        int value = Integer.parseInt(param.substring(startIndex, end));
        thisStr = BgPeriodVariable.getYearStr(value, year);
        return left + thisStr + right;
    }

    public static String getHalfYearParamValue(String param, int year, int halfYear) {
        Matcher matcher = BgPeriodVariable.getMatcher(param);
        if (matcher == null) {
            return param;
        }
        int startIndex = matcher.start();
        String str = "";
        String leftStr = "";
        String yearStr = "";
        String halfYearStr = "";
        String lastStr = "";
        String selfStr = "";
        int end = startIndex + 4;
        int halfYearValue = -1;
        if (startIndex > 0) {
            leftStr = param.substring(0, startIndex);
        }
        int yearValue = Integer.parseInt(param.substring(startIndex, end));
        if (BgPeriodVariable.getBgPeriodDispNumber().contains(param)) {
            if (param.indexOf(YEAR_STR) != -1) {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
                selfStr = param.substring(end + 1);
                return leftStr + yearStr + selfStr;
            }
        } else if (param.length() > startIndex + 6) {
            if (yearValue > 0) {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
            }
            if (QUARTER_STR.equals(lastStr = (str = param.substring(startIndex + 6)).substring(2)) || MONTH_STR.equals(lastStr)) {
                return param;
            }
            halfYearValue = Integer.parseInt(str = str.substring(0, str.indexOf(lastStr)));
            if (halfYearValue > 0) {
                halfYearStr = BgPeriodVariable.getHalfYear(halfYear, halfYearValue);
            }
        } else {
            yearStr = BgPeriodVariable.getYearStr(yearValue, year);
        }
        return leftStr + yearStr + halfYearStr;
    }

    public static String getQuarterParamValue(String param, int year, int quarter) {
        Matcher matcher = BgPeriodVariable.getMatcher(param);
        if (matcher == null) {
            return param;
        }
        int startIndex = matcher.start();
        String str = "";
        String leftStr = "";
        String yearStr = "";
        String quarterStr = "";
        String lastStr = "";
        String selfStr = "";
        int end = startIndex + 4;
        int quarterValue = -1;
        if (startIndex > 0) {
            leftStr = param.substring(0, startIndex);
        }
        int yearValue = Integer.parseInt(param.substring(startIndex, end));
        if (BgPeriodVariable.getBgPeriodDispNumber().contains(param)) {
            if (param.indexOf(YEAR_STR) != -1) {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
                selfStr = param.substring(end + 1);
                return leftStr + yearStr + selfStr;
            }
        } else if (param.length() > startIndex + 6) {
            if (yearValue > 0) {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
            }
            if (MONTH_STR.equals(lastStr = (str = param.substring(startIndex + 6)).substring(2))) {
                return param;
            }
            quarterValue = Integer.parseInt(str = str.substring(0, str.indexOf(lastStr)));
            if (quarterValue > 0) {
                if (QUARTER_STR.equals(lastStr)) {
                    quarterStr = BgPeriodVariable.getQuarter(quarter, quarterValue);
                } else if (HALFYEAR_STR.equals(lastStr)) {
                    quarter = quarter <= HALF_OF_YEAR ? 1 : 2;
                    quarterStr = BgPeriodVariable.getHalfYear(quarter, quarterValue);
                }
            }
        } else {
            yearStr = BgPeriodVariable.getYearStr(yearValue, year);
        }
        return leftStr + yearStr + quarterStr;
    }

    public static String getMonthParamValue(String param, int year, int month) {
        Matcher matcher = BgPeriodVariable.getMatcher(param);
        if (matcher == null) {
            return param;
        }
        int startIndex = matcher.start();
        String str = "";
        String leftStr = "";
        String yearStr = "";
        String monthStr = "";
        String lastStr = "";
        String selfStr = "";
        String dayStr = "";
        int end = startIndex + 4;
        int monthValue = -1;
        if (startIndex > 0) {
            leftStr = param.substring(0, startIndex);
        }
        int yearValue = Integer.parseInt(param.substring(startIndex, end));
        if (BgPeriodVariable.getBgPeriodDispNumber().contains(param)) {
            if (param.indexOf(YEAR_STR) != -1) {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
                selfStr = param.substring(end + 1);
                return leftStr + yearStr + selfStr;
            }
        } else {
            if (param.endsWith(DAY_STR) || param.endsWith(MONTHWEEK_STR)) {
                dayStr = param.substring(param.indexOf("M.") + 1);
                param = param.substring(0, param.indexOf("M.") + 1);
            }
            if (param.length() > startIndex + 6) {
                if (yearValue > 0) {
                    yearStr = BgPeriodVariable.getYearStr(yearValue, year);
                }
                str = param.substring(startIndex + 6);
                lastStr = str.substring(2);
                monthValue = Integer.parseInt(str = str.substring(0, str.indexOf(lastStr)));
                if (monthValue > 0) {
                    if (MONTH_STR.equals(lastStr)) {
                        monthStr = BgPeriodVariable.getMonth(month, monthValue);
                    } else if (QUARTER_STR.equals(lastStr)) {
                        if (month <= 3) {
                            month = 1;
                        } else if (3 < month && month <= 6) {
                            month = 2;
                        } else if (6 < month && month <= 9) {
                            month = 3;
                        } else if (9 < month && month <= 12) {
                            month = 4;
                        }
                        monthStr = BgPeriodVariable.getQuarter(month, monthValue);
                    } else if (HALFYEAR_STR.equals(lastStr)) {
                        if (month <= 6) {
                            month = 1;
                        } else if (6 < month && month <= 12) {
                            month = 2;
                        }
                        monthStr = BgPeriodVariable.getHalfYear(month, monthValue);
                    }
                }
            } else {
                yearStr = BgPeriodVariable.getYearStr(yearValue, year);
            }
        }
        return leftStr + yearStr + monthStr + dayStr;
    }
}

