/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.NodeFactory;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.IBgProperty;
import com.kingdee.eas.ma.base.IBgPropertySort;
import java.awt.Color;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class BgPropertyUtils {
    private static Color COLOR_DEFAULT = Color.BLACK;
    private static Color COLOR_SELECT = new Color(88, 195, 249, 200);
    public static final String NUMBER = "number";
    public static final String NAME = "name";

    public static Color getCOLOR_DEFAULT() {
        return COLOR_DEFAULT;
    }

    public static Color getCOLOR_SELECT() {
        return COLOR_SELECT;
    }

    private static BgPropertySortCollection getAllSortsByType(String type) throws BOSException, EASBizException {
        if (type == null) {
            return null;
        }
        HashSet sortSet = new HashSet();
        IBgPropertySort iPropertySort = BgPropertySortFactory.getRemoteInstance();
        BgPropertySortCollection sortCol = null;
        Object sortId = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcetype", (Object)type, CompareType.EQUALS));
        view.setFilter(filter);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo(NUMBER));
        view.setSorter(sort);
        sortCol = iPropertySort.getBgPropertySortCollection(view);
        return sortCol;
    }

    private static BgPropertyCollection getPropertyCollById(String id) throws BOSException {
        IBgProperty iBgProperty = BgPropertyFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(NUMBER);
        sic.add(NAME);
        sic.add("longNumber");
        sic.add("level");
        sic.add("isLeaf");
        sic.add("parent.id");
        sic.add("parent.Number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.level");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        filter.getFilterItems().add(new FilterItemInfo("bgpropertysort.id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return iBgProperty.getBgPropertyCollection(view);
    }

    public static DefaultKingdeeTreeNode buildMutiPropertyTree(NodeFactory nodeFactory) throws EASBizException, BOSException {
        int i;
        DefaultKingdeeTreeNode rootTreeNode = null;
        DefaultKingdeeTreeNode curSortNode = null;
        DefaultKingdeeTreeNode subTreeNode = null;
        DefaultKingdeeTreeNode parentNode = null;
        BgPropertySortInfo curSortInfo = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        HashMap<String, DefaultKingdeeTreeNode> nodePropertyMap = new HashMap<String, DefaultKingdeeTreeNode>();
        BgPropertySortInfo sortInfo = new BgPropertySortInfo();
        BOSUuid rootId = BOSUuid.create((BOSObjectType)sortInfo.getBOSType());
        sortInfo.setId(rootId);
        rootTreeNode = nodeFactory.create((Object)sortInfo);
        BgPropertySortCollection sortCol = BgPropertyUtils.getAllSortsByType("33F82845");
        HashSet sortSet = new HashSet();
        String sortId = null;
        BgPropertyCollection propertyCol = null;
        BgPropertyInfo propertyInfo = null;
        BgPropertyInfo parentInfo = null;
        if (sortCol == null) {
            return null;
        }
        if (sortCol.size() == 0) {
            return nodeFactory.create(null);
        }
        int size = sortCol.size();
        for (i = 0; i < size; ++i) {
            curSortInfo = sortCol.get(i);
            sortId = curSortInfo.getId().toString();
            subTreeNode = nodeFactory.create((Object)curSortInfo);
            subTreeNode.setCheckBoxVisible(false);
            subTreeNode.setCheckBoxEnabled(false);
            subTreeNode.setChecked(false);
            rootTreeNode.add((MutableTreeNode)subTreeNode);
            nodeMap.put(sortId, subTreeNode);
        }
        size = sortCol.size();
        for (i = 0; i < size; ++i) {
            curSortInfo = sortCol.get(i);
            sortId = curSortInfo.getId().toString();
            curSortNode = (DefaultKingdeeTreeNode)nodeMap.get(sortId);
            propertyCol = BgPropertyUtils.getPropertyCollById(sortId);
            int len = propertyCol.size();
            for (int j = 0; j < len; ++j) {
                propertyInfo = propertyCol.get(j);
                parentInfo = propertyInfo.getParent();
                if (parentInfo != null && parentInfo.getId() != null) continue;
                parentNode = nodeFactory.create((Object)propertyInfo);
                curSortNode.add((MutableTreeNode)parentNode);
                parentNode.setCheckBoxVisible(true);
                nodePropertyMap.put(propertyInfo.getId().toString(), parentNode);
            }
            String parentID = null;
            int len2 = propertyCol.size();
            for (int j = 0; j < len2; ++j) {
                propertyInfo = propertyCol.get(j);
                parentInfo = propertyInfo.getParent();
                subTreeNode = nodeFactory.create((Object)propertyInfo);
                subTreeNode.setCheckBoxVisible(true);
                if (nodePropertyMap.containsKey(propertyInfo.getId().toString())) continue;
                if (parentInfo != null && parentInfo.getId() != null && nodePropertyMap.containsKey(parentID = parentInfo.getId().toString())) {
                    parentNode = (DefaultKingdeeTreeNode)nodePropertyMap.get(parentID);
                    parentNode.add((MutableTreeNode)subTreeNode);
                }
                nodePropertyMap.put(propertyInfo.getId().toString(), subTreeNode);
            }
        }
        return rootTreeNode;
    }

    public static DefaultKingdeeTreeNode buildMutiPropertyTree() throws EASBizException, BOSException {
        return BgPropertyUtils.buildMutiPropertyTree(new NodeFactory(){

            public DefaultKingdeeTreeNode create(Object obj) {
                return new DefaultKingdeeTreeNode(obj);
            }
        });
    }

    public static TreeModel buildTreeModel() throws Exception {
        DefaultKingdeeTreeNode rootNode = BgPropertyUtils.buildMutiPropertyTree();
        DefaultTreeModel model = null;
        if (rootNode != null) {
            model = new DefaultTreeModel((TreeNode)rootNode);
        }
        return model;
    }

    public static boolean canTheNodeBeSelected(DefaultKingdeeTreeNode node) {
        return node.isCheckBoxVisible() && node.isCheckBoxEnabled();
    }

    public static void setPropertyTreeChecked(DefaultKingdeeTreeNode root, boolean selected) {
        if (root == null) {
            return;
        }
        if (BgPropertyUtils.canTheNodeBeSelected(root)) {
            root.setChecked(selected);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (BgPropertyUtils.canTheNodeBeSelected(node)) {
                node.setChecked(selected);
            }
            if (node.isLeaf()) continue;
            BgPropertyUtils.setPropertyTreeChecked(node, selected);
        }
    }

    public static Map<String, HashSet<String>> getPropertyTreeChecked(DefaultKingdeeTreeNode root) {
        BgPropertyInfo propertyInfo = null;
        DefaultKingdeeTreeNode node = null;
        String sortId = null;
        String propertyId = null;
        HashSet<String> propertySet = null;
        HashMap<String, HashSet<String>> chooseMap = new HashMap<String, HashSet<String>>();
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node.getUserObject() == null || node.getUserObject() instanceof BgPropertySortInfo) continue;
            propertyInfo = (BgPropertyInfo)node.getUserObject();
            propertyId = propertyInfo.getId().toString();
            sortId = propertyInfo.getBgPropertySort().getId().toString();
            if (!node.isChecked()) continue;
            if (!chooseMap.containsKey(sortId)) {
                propertySet = new HashSet<String>();
                propertySet.add(propertyId);
                chooseMap.put(sortId, propertySet);
                continue;
            }
            ((HashSet)chooseMap.get(sortId)).add(propertyId);
        }
        return chooseMap;
    }

    public static void setPropertyTreeEnabled(DefaultKingdeeTreeNode root, boolean enabled) {
        if (root == null) {
            return;
        }
        if (BgPropertyUtils.canTheNodeBeSelected(root)) {
            root.setCheckBoxEnabled(enabled);
        }
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int index = 0; index < count; ++index) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(index);
            if (BgPropertyUtils.canTheNodeBeSelected(node)) {
                node.setCheckBoxEnabled(enabled);
            }
            if (node.isLeaf()) continue;
            BgPropertyUtils.setPropertyTreeChecked(node, enabled);
        }
    }

    public static TreeModel clipAndCloneTreeModel(TreeModel model, String[] fields, String value, boolean isBlured) {
        if (fields == null || fields.length == 0) {
            return model;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)BgPropertyUtils.deepCloneTreeModel(model);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        if (root.getUserObject() != null) {
            BgPropertyUtils.disableTreeNodeByFilterCondition(root, fields, value, isBlured);
            OrgF7InnerUtils.clipTreeNodeByColor((DefaultKingdeeTreeNode)root);
        }
        return treeModel;
    }

    private static TreeModel deepCloneTreeModel(TreeModel model) {
        if (model.getRoot() != null) {
            DefaultKingdeeTreeNode newRoot = BgPropertyUtils.cloneTreeNode((DefaultKingdeeTreeNode)model.getRoot());
            return new DefaultTreeModel((TreeNode)newRoot);
        }
        return new DefaultTreeModel(null);
    }

    private static void disableTreeNodeByFilterCondition(DefaultKingdeeTreeNode root, String[] fields, String value, boolean isBlured) {
        BgPropertyInfo propertyInfo = null;
        DefaultKingdeeTreeNode node = null;
        String sortId = null;
        HashSet<String> set = new HashSet<String>();
        Enumeration nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (node.getUserObject() instanceof BgPropertySortInfo) continue;
            propertyInfo = (BgPropertyInfo)node.getUserObject();
            if (value == null || value.trim().length() == 0) continue;
            boolean isShow = false;
            for (int i = 0; i < fields.length; ++i) {
                String numberOrName = null;
                if (NUMBER.equalsIgnoreCase(fields[i])) {
                    numberOrName = propertyInfo.getNumber();
                } else if (NAME.equalsIgnoreCase(fields[i])) {
                    numberOrName = propertyInfo.getName();
                }
                if (numberOrName == null) continue;
                if (isBlured) {
                    if (numberOrName.indexOf(value) < 0) continue;
                    isShow = true;
                    sortId = propertyInfo.getBgPropertySort().getId().toString();
                    set.add(sortId);
                    break;
                }
                if (!numberOrName.equals(value)) continue;
                isShow = true;
                break;
            }
            if (isShow) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
        nodeEnum = root.breadthFirstEnumeration();
        while (nodeEnum.hasMoreElements()) {
            BgPropertySortInfo sortInfo;
            node = (DefaultKingdeeTreeNode)nodeEnum.nextElement();
            if (!(node.getUserObject() instanceof BgPropertySortInfo) || set.contains((sortInfo = (BgPropertySortInfo)node.getUserObject()).getId().toString())) continue;
            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
        }
    }

    private static DefaultKingdeeTreeNode cloneTreeNode(DefaultKingdeeTreeNode node) {
        DefaultKingdeeTreeNode newNode = new DefaultKingdeeTreeNode(node.getUserObject());
        int n = node.getChildCount();
        for (int i = 0; i < n; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            DefaultKingdeeTreeNode newChildNode = BgPropertyUtils.cloneTreeNode(childNode);
            if (newChildNode.getUserObject() instanceof BgPropertySortInfo) {
                newChildNode.setCheckBoxVisible(false);
            }
            newNode.add((MutableTreeNode)newChildNode);
        }
        return newNode;
    }
}

