/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.IBgVersion;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BgVersionHelper {
    public static int DEF_VERSION_VALUE = 1;
    public static final String SYS_VERSION_NUMBER = "Ve";
    public static final String SYS_VERSION_ID = "fTNjgVF9TXy80oY2shobskGwJT4=";

    private static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isLeaf");
        sic.add("longnumber");
        sic.add("versionId");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("isRollVersion");
        return sic;
    }

    public static BgVersionInfo getVersion(Context ctx, String number) throws BOSException {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        IBgVersion iversion = null;
        iversion = ctx == null ? BgVersionFactory.getRemoteInstance() : BgVersionFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgVersionHelper.getSelector());
        BgVersionCollection colls = iversion.getBgVersionCollection(view);
        if (colls != null && !colls.isEmpty()) {
            return colls.get(0);
        }
        return null;
    }

    public static BgVersionCollection getVersionColls(Context ctx, Set<String> numbers) throws BOSException {
        if (numbers.isEmpty()) {
            return null;
        }
        IBgVersion iversion = null;
        iversion = ctx == null ? BgVersionFactory.getRemoteInstance() : BgVersionFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgVersionHelper.getSelector());
        BgVersionCollection colls = iversion.getBgVersionCollection(view);
        return colls;
    }

    public static List<BgVersionInfo> getAllVersion(Context ctx) throws BOSException {
        ArrayList<BgVersionInfo> versions = new ArrayList<BgVersionInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgVersionHelper.getSelector());
        view.getSorter().add(new SorterItemInfo("number"));
        IBgVersion iBgVersion = ctx != null ? BgVersionFactory.getLocalInstance(ctx) : BgVersionFactory.getRemoteInstance();
        BgVersionCollection colls = iBgVersion.getBgVersionCollection(view);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                versions.add(colls.get(i));
            }
        }
        return versions;
    }

    public static BgVersionCollection getVersionColls(Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgVersionHelper.getSelector());
        if (ctx == null) {
            return BgVersionFactory.getRemoteInstance().getBgVersionCollection(view);
        }
        return BgVersionFactory.getLocalInstance(ctx).getBgVersionCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BgVersionCollection getVersionColls(Connection conn, Locale locale) throws SQLException {
        BgVersionCollection colls = new BgVersionCollection();
        if (conn == null || locale == null) {
            return colls;
        }
        IRowSet rst = null;
        BgVersionInfo version = null;
        try {
            rst = BgDBUtils.executeQuery(conn, "select t.FID, t.FNumber, t.FLongNumber, t.FName_" + locale + " AS FName, t.FVersionId, t.FParentId, t.FIsLeaf, p.FNumber AS PNumber,t.FIsRollVersion from T_MBG_BgVersion t left join T_MBG_BgVersion p on t.FParentId = p.FID");
            while (rst.next()) {
                version = new BgVersionInfo();
                version.setId(BOSUuid.read((String)rst.getString("FID")));
                version.setNumber(rst.getString("FNumber"));
                version.setLongNumber(rst.getString("FLongNumber"));
                version.setName(rst.getString("FName"));
                version.setVersionId(rst.getInt("FVersionId"));
                version.setIsLeaf(rst.getBoolean("FIsLeaf"));
                version.setIsRollVersion(rst.getBoolean("FIsRollVersion"));
                if (!StringUtils.isEmpty((String)rst.getString("FParentId"))) {
                    version.setParent(new BgVersionInfo());
                    version.getParent().setId(BOSUuid.read((String)rst.getString("FParentId")));
                    version.getParent().setNumber(rst.getString("PNumber"));
                }
                colls.add(version);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return colls;
    }

    public static Map<String, String[]> getVersionLongNum(Connection conn, Locale locale) throws SQLException {
        HashMap<String, String[]> dataMap = new HashMap<String, String[]>();
        if (conn == null || locale == null) {
            return dataMap;
        }
        String[] verStrs = null;
        BgVersionInfo version = null;
        BgVersionCollection colls = BgVersionHelper.getVersionColls(conn, locale);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            version = colls.get(i);
            verStrs = new String[4];
            verStrs[0] = version.getNumber();
            verStrs[1] = version.getLongNumber();
            verStrs[2] = version.getName();
            dataMap.put(version.getNumber(), verStrs);
        }
        return dataMap;
    }

    public static Map<String, BgVersionInfo> getVersionObjMap(Context ctx) throws BOSException {
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        if (ctx == null) {
            return versionMap;
        }
        BgVersionCollection colls = BgVersionHelper.getVersionColls(ctx);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(version.getNumber(), version);
            }
        }
        return versionMap;
    }

    public static Map<String, BgVersionInfo> getVersionObjMap(Connection conn, Locale locale) throws SQLException {
        HashMap<String, BgVersionInfo> versionMap = new HashMap<String, BgVersionInfo>();
        if (conn == null || locale == null) {
            return versionMap;
        }
        BgVersionCollection colls = BgVersionHelper.getVersionColls(conn, locale);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(version.getNumber(), version);
            }
        }
        return versionMap;
    }

    public static Map<String, String> getVersionMap(Context ctx) throws BOSException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        BgVersionCollection colls = BgVersionHelper.getVersionColls(ctx);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(String.valueOf(version.getVersionId()), version.getNumber());
            }
        }
        return versionMap;
    }

    public static Map<String, String> getVersionMap(Connection conn, Locale locale) throws SQLException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        if (conn == null || locale == null) {
            return versionMap;
        }
        BgVersionCollection colls = BgVersionHelper.getVersionColls(conn, locale);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(String.valueOf(version.getVersionId()), version.getNumber());
            }
        }
        return versionMap;
    }

    public static Map<String, String> getVersionInnMap(Context ctx) throws BOSException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        if (ctx == null) {
            return versionMap;
        }
        BgVersionCollection colls = BgVersionHelper.getVersionColls(ctx);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(String.valueOf(version.getNumber()), String.valueOf(version.getVersionId()));
            }
        }
        return versionMap;
    }

    public static Map<Integer, String> getVersionInnIdMap(Context ctx) throws BOSException {
        HashMap<Integer, String> versionMap = new HashMap<Integer, String>();
        if (ctx == null) {
            return versionMap;
        }
        BgVersionCollection colls = BgVersionHelper.getVersionColls(ctx);
        if (colls != null) {
            BgVersionInfo version = null;
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                version = colls.get(i);
                versionMap.put(version.getVersionId(), version.getNumber());
            }
        }
        return versionMap;
    }

    public static BgVersionInfo getSysVersionInfo(Context ctx) throws BOSException {
        BgVersionCollection colls = null;
        IBgVersion iBgVersion = null;
        iBgVersion = ctx == null ? BgVersionFactory.getRemoteInstance() : BgVersionFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)SYS_VERSION_NUMBER, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)BgVersionHelper.getSelector());
        colls = iBgVersion.getBgVersionCollection(view);
        return colls.get(0);
    }
}

