/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.eas.ma.base.utils.ICalendarTime;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class CalendarHelper
implements ICalendarTime {
    protected Calendar calendar = null;
    public static int MONTHS_OF_YEAR = 12;
    public static int QUARTER_OF_YEAR = 4;
    public static int HALF_OF_YEAR = 2;
    public static int YEAR_OF_YEAR = 1;

    public Calendar getCalendar() {
        return this.calendar;
    }

    public CalendarHelper() {
        this.calendar = Calendar.getInstance();
    }

    public CalendarHelper(Date date) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTime(date);
    }

    public CalendarHelper(Locale locale) {
        this.calendar = Calendar.getInstance(locale);
    }

    public void setTime(Date date) {
        this.calendar.setTime(date);
    }

    public Date getTime() {
        return this.calendar.getTime();
    }

    public int computeToDate(Date day, Date compareDay) {
        long point = 0L;
        long compare = 0L;
        if (day == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(day);
        }
        this.processClearTime(this.calendar);
        point = this.calendar.getTimeInMillis();
        if (compareDay == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(compareDay);
        }
        this.processClearTime(this.calendar);
        compare = this.calendar.getTimeInMillis();
        if (point == compare) {
            return 0;
        }
        if (point < compare) {
            return 1;
        }
        return -1;
    }

    public int computeToTime(Date time, Date compareTime) {
        long point = 0L;
        long compare = 0L;
        if (time == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(time);
        }
        point = this.calendar.getTimeInMillis();
        if (compareTime == null) {
            this.calendar.setTime(new Date());
        } else {
            this.calendar.setTime(compareTime);
        }
        compare = this.calendar.getTimeInMillis();
        if (point == compare) {
            return 0;
        }
        if (point < compare) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    @Override
    public int getCurrentlyYear() {
        this.calendar.setTime(new Date());
        return this.calendar.get(1);
    }

    @Override
    public int getCurrentlyYear(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            return this.calendar.get(1);
        }
        return 0;
    }

    public int getCurrentlyHalfYear(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            int month = this.calendar.get(2) + 1;
            if (month >= 1 && month <= 6) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    @Override
    public int getDaysOfYear(int year) {
        this.calendar.set(year, 0, 1);
        return this.calendar.getActualMaximum(6);
    }

    @Override
    public int getMonthsOfYear() {
        return MONTHS_OF_YEAR;
    }

    @Override
    public int getWeeksOfYear(int year, boolean isYearWeek) {
        int weeks = 0;
        if (isYearWeek) {
            this.calendar.set(year, 12, 1);
            this.calendar.add(6, -1);
            weeks = this.calendar.getActualMaximum(3);
            if (weeks > this.calendar.get(3)) {
                ++weeks;
            }
        } else {
            int count = MONTHS_OF_YEAR;
            for (int index = 1; index <= count; ++index) {
                this.calendar.set(year, this.processMonth(index), 1);
                weeks += this.calendar.getActualMaximum(4);
            }
        }
        return weeks;
    }

    @Override
    public Date getFirstDayOfYear(int year) {
        this.calendar.set(year, 0, 1);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfYear(int year, int startTime, boolean isStrideYear) {
        if (isStrideYear) {
            this.calendar.set(year - 1, 11, startTime);
        } else {
            this.calendar.set(year, 0, 1);
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    @Override
    public Date getLastDayOfYear(int year) {
        this.calendar.set(year, 12, 1);
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfYear(int year, int startTime, boolean isStrideYear) {
        if (isStrideYear) {
            this.calendar.set(year, 11, startTime);
        } else {
            this.calendar.set(year, 12, 1);
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfYear(int year, boolean second) {
        if (second) {
            this.calendar.set(year, 12, 1, 23, 59, 59);
        } else {
            this.calendar.set(year, 12, 1);
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getNewDateAddSecond(Timestamp timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String time = df.format(timestamp);
        time = time + " 23:59:59";
        return Timestamp.valueOf(time);
    }

    public Date getFirstDayOfHalfYear(int year, int halfYear) {
        if (halfYear == 1) {
            this.calendar.set(year, 0, 1);
        } else {
            this.calendar.set(year, 6, 1);
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getLastDayOfHalfYear(int year, int halfYear) {
        if (halfYear == 1) {
            this.calendar.set(year, 6, 1);
        } else {
            this.calendar.set(year, 12, 1);
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    @Override
    public int getQuarterOfYear() {
        return QUARTER_OF_YEAR;
    }

    @Override
    public int getCurrentlyQuarter() {
        this.calendar.setTime(new Date());
        int month = this.calendar.get(2) + 1;
        if (month >= 1 && month <= 3) {
            return 1;
        }
        if (month >= 4 && month <= 6) {
            return 2;
        }
        if (month >= 7 && month <= 9) {
            return 3;
        }
        return 4;
    }

    public int getCurrentlyQuarter(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            int month = this.calendar.get(2) + 1;
            if (month >= 1 && month <= 3) {
                return 1;
            }
            if (month >= 4 && month <= 6) {
                return 2;
            }
            if (month >= 7 && month <= 9) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    public Date getLastDayOfQuarterBySelfDefined(int year, int quarter, int startMonth) {
        switch (quarter) {
            case 1: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    start = startMonth + 3 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                start = startMonth + 3;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 2: {
                if (startMonth + 6 > 12) {
                    int start = startMonth + 6 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 6;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 3: {
                if (startMonth + 9 > 12) {
                    int start = startMonth + 9 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 9;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            default: {
                if (startMonth + 12 > 12) {
                    int start = startMonth + 12 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 12;
                this.calendar.set(year, start - 1, 1);
            }
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfQuarterBySelfDefined(int year, int quarter, int startMonth) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, startMonth - 1, 1);
                break;
            }
            case 2: {
                int start = -1;
                if (startMonth + 3 > 12) {
                    start = startMonth + 3 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                start = startMonth + 3;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            case 3: {
                if (startMonth + 6 > 12) {
                    int start = startMonth + 6 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 6;
                this.calendar.set(year, start - 1, 1);
                break;
            }
            default: {
                if (startMonth + 9 > 12) {
                    int start = startMonth + 9 - 12;
                    this.calendar.set(year + 1, start - 1, 1);
                    break;
                }
                int start = startMonth + 9;
                this.calendar.set(year, start - 1, 1);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    @Override
    public Date getFirstDayOfQuarter(int year, int quarter) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, 0, 1);
                break;
            }
            case 2: {
                this.calendar.set(year, 3, 1);
                break;
            }
            case 3: {
                this.calendar.set(year, 6, 1);
                break;
            }
            default: {
                this.calendar.set(year, 9, 1);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfQuarter(int year, int quarter, int startTime, boolean isStrideYear) {
        switch (quarter) {
            case 1: {
                if (isStrideYear) {
                    this.calendar.set(year - 1, 11, startTime);
                    break;
                }
                this.calendar.set(year, 0, 1);
                break;
            }
            case 2: {
                if (startTime == 1) {
                    this.calendar.set(year, 3, 1);
                    break;
                }
                this.calendar.set(year, 2, startTime);
                break;
            }
            case 3: {
                if (startTime == 1) {
                    this.calendar.set(year, 6, 1);
                    break;
                }
                this.calendar.set(year, 5, startTime);
                break;
            }
            default: {
                if (startTime == 1) {
                    this.calendar.set(year, 9, 1);
                    break;
                }
                this.calendar.set(year, 8, startTime);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    @Override
    public Date getLastDayOfQuarter(int year, int quarter) {
        switch (quarter) {
            case 1: {
                this.calendar.set(year, 3, 1);
                break;
            }
            case 2: {
                this.calendar.set(year, 6, 1);
                break;
            }
            case 3: {
                this.calendar.set(year, 9, 1);
                break;
            }
            default: {
                this.calendar.set(year, 12, 1);
            }
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfQuarter(int year, int quarter, int startTime, boolean isStrideYear) {
        switch (quarter) {
            case 1: {
                if (startTime == 1) {
                    this.calendar.set(year, 3, 1);
                    break;
                }
                this.calendar.set(year, 2, startTime);
                break;
            }
            case 2: {
                if (startTime == 1) {
                    this.calendar.set(year, 6, 1);
                    break;
                }
                this.calendar.set(year, 5, startTime);
                break;
            }
            case 3: {
                if (startTime == 1) {
                    this.calendar.set(year, 9, 1);
                    break;
                }
                this.calendar.set(year, 8, startTime);
                break;
            }
            default: {
                if (isStrideYear) {
                    this.calendar.set(year, 11, startTime);
                    break;
                }
                this.calendar.set(year, 12, 1);
            }
        }
        this.calendar.add(6, -1);
        return this.calendar.getTime();
    }

    @Override
    public int getCurrentlyMonth() {
        this.calendar.setTime(new Date());
        return this.calendar.get(2) + 1;
    }

    public int getCurrentlyMonth(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            return this.calendar.get(2) + 1;
        }
        return 0;
    }

    public int getCurrentlyWeek() {
        return this.getCurrentlyWeek(new Date());
    }

    public static void main(String[] args) {
        System.out.println(new CalendarHelper().getCurrentlyWeek(new Date()));
    }

    public int getCurrentlyWeek(Date date) {
        Date _date = date != null ? this.getStartDate(date) : this.getStartDate(new Date());
        Date _tmpDate = this.getStartDate(this.getLastDayOfWeek(this.getCurrentlyYear(_date), 1));
        if (this.getStartDate(_date).compareTo(_tmpDate) > 0) {
            int maxWeeks = this.getWeeksOfYear(this.getCurrentlyYear(_date), true);
            this.calendar.setTime(_tmpDate);
            for (int i = 2; i <= maxWeeks; ++i) {
                this.calendar.add(3, 1);
                if (this.calendar.getTime().compareTo(_date) < 0) continue;
                return i;
            }
        }
        return 1;
    }

    public int getCurrentlyDay() {
        return this.getCurrentlyWeek(new Date());
    }

    public int getCurrentlyDay(Date date) {
        if (date != null) {
            this.calendar.setTime(date);
            return this.calendar.get(5);
        }
        return 0;
    }

    @Override
    public int getDaysOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        return this.calendar.getActualMaximum(5);
    }

    @Override
    public int getWeeksOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        return this.calendar.getActualMaximum(4);
    }

    @Override
    public Date getFirstDayOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfMonth(int year, int month, int startTime, boolean isStrideYear) {
        int calendarSign = this.processMonth(month);
        if (0 == calendarSign || startTime == 1) {
            if (isStrideYear) {
                this.calendar.set(year - 1, 11, startTime);
            } else {
                this.calendar.set(year, calendarSign, 1);
            }
        } else {
            this.calendar.set(year, calendarSign - 1, 1);
            int actualMaximum = this.calendar.getActualMaximum(5);
            if (startTime > actualMaximum) {
                this.calendar.set(year, calendarSign, 1);
            } else {
                this.calendar.set(year, calendarSign - 1, startTime);
            }
        }
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getFirstDayOfMonthTenDays(int year, int month, int tenDays) {
        if (tenDays == 1) {
            this.calendar.set(year, this.processMonth(month), 1);
        } else if (tenDays == 2) {
            this.calendar.set(year, this.processMonth(month), 11);
        } else {
            this.calendar.set(year, this.processMonth(month), 1);
        }
        return this.calendar.getTime();
    }

    public Date getLastDayOfMonthTenDays(int year, int month, int tenDays) {
        if (tenDays == 1) {
            this.calendar.set(year, this.processMonth(month), 10);
        } else if (tenDays == 2) {
            this.calendar.set(year, this.processMonth(month), 20);
        } else {
            this.calendar.set(1, year);
            this.calendar.set(2, this.processMonth(month));
            this.calendar.set(5, this.calendar.getActualMaximum(5));
        }
        return this.calendar.getTime();
    }

    @Override
    public Date getLastDayOfMonth(int year, int month) {
        this.calendar.set(year, this.processMonth(month), 1);
        this.calendar.add(6, this.calendar.getActualMaximum(5) - 1);
        return this.calendar.getTime();
    }

    public Date getLastDayOfMonth(int year, int month, int startTime, boolean isStrideYear) {
        int calendarSign = this.processMonth(month);
        if (11 != calendarSign && startTime != 1) {
            this.calendar.set(year, calendarSign, 1);
            int actualMaximum = this.calendar.getActualMaximum(5);
            if (startTime > actualMaximum) {
                this.calendar.set(year, calendarSign, actualMaximum);
            } else {
                this.calendar.set(year, calendarSign, startTime);
                this.calendar.add(6, -1);
            }
        } else if (isStrideYear) {
            this.calendar.set(year, calendarSign, startTime);
            this.calendar.add(6, -1);
        } else {
            this.calendar.set(year, calendarSign, 1);
            this.calendar.add(6, this.calendar.getActualMaximum(5) - 1);
        }
        return this.calendar.getTime();
    }

    @Override
    public Date getFirstDayOfWeek(int year, int week) {
        this.calendar.set(year, 0, 1);
        if (week <= 1) {
            return this.calendar.getTime();
        }
        this.calendar.set(year, 12, 1);
        this.calendar.add(6, -1);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(3);
        if (WEEKS_OF_MONTH > this.calendar.get(3)) {
            ++WEEKS_OF_MONTH;
        }
        this.calendar.set(year, 0, 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        this.calendar.add(6, 1 - DAY_IN_WEEK);
        if (week > WEEKS_OF_MONTH) {
            week = WEEKS_OF_MONTH;
        }
        this.calendar.add(3, week - 1);
        return this.calendar.getTime();
    }

    @Override
    public Date getLastDayOfWeek(int year, int week) {
        this.calendar.set(year, 12, 1);
        this.calendar.add(6, -1);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(3);
        if (WEEKS_OF_MONTH > this.calendar.get(3)) {
            ++WEEKS_OF_MONTH;
        }
        if (week >= WEEKS_OF_MONTH) {
            return this.calendar.getTime();
        }
        this.calendar.set(year, 0, 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        this.calendar.add(6, 0 - DAY_IN_WEEK);
        if (week < 1) {
            week = 1;
        }
        this.calendar.add(3, week);
        return this.calendar.getTime();
    }

    @Override
    public Date getFirstDayOfWeek(int year, int month, int week) {
        this.calendar.set(year, this.processMonth(month), 1);
        if (week <= 1) {
            return this.calendar.getTime();
        }
        int DAY_IN_WEEK = this.calendar.getFirstDayOfWeek();
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(4);
        this.calendar.set(4, WEEKS_OF_MONTH);
        this.calendar.set(7, DAY_IN_WEEK);
        return this.calendar.getTime();
    }

    @Override
    public Date getLastDayOfWeek(int year, int month, int week) {
        this.calendar.set(year, this.processMonth(month), 1);
        int DAY_IN_WEEK = this.calendar.get(7);
        int WEEKS_OF_MONTH = this.calendar.getActualMaximum(4);
        if (week >= WEEKS_OF_MONTH) {
            this.calendar.add(6, this.calendar.getActualMaximum(5) - 1);
            return this.calendar.getTime();
        }
        this.calendar.add(6, 0 - DAY_IN_WEEK);
        if (week < 1) {
            week = 1;
        }
        this.calendar.add(3, week);
        return this.calendar.getTime();
    }

    public Date setDay(int year, int month, int day) {
        this.calendar.set(year, this.processMonth(month), day);
        return this.calendar.getTime();
    }

    public Date getStartDate(Date day) {
        this.calendar.setTime(day);
        this.processClearTime(this.calendar);
        return this.calendar.getTime();
    }

    public Date getBeoverDate(Date day) {
        this.calendar.setTime(day);
        this.processSetMaxTime(this.calendar);
        return this.calendar.getTime();
    }

    public int[] getYear(int sYear, int eYear) {
        int yearNum = eYear - sYear;
        if (yearNum != 0) {
            int[] rtnAry = new int[yearNum + 1];
            for (int i = 0; i < yearNum + 1; ++i) {
                rtnAry[i] = sYear + i;
            }
            return rtnAry;
        }
        return new int[]{sYear};
    }

    private int processMonth(int month) {
        if (month <= 1) {
            return 0;
        }
        if (month >= 12) {
            return 11;
        }
        int CALENDAR_PROCESS = 0;
        switch (month) {
            case 2: {
                CALENDAR_PROCESS = 1;
                break;
            }
            case 3: {
                CALENDAR_PROCESS = 2;
                break;
            }
            case 4: {
                CALENDAR_PROCESS = 3;
                break;
            }
            case 5: {
                CALENDAR_PROCESS = 4;
                break;
            }
            case 6: {
                CALENDAR_PROCESS = 5;
                break;
            }
            case 7: {
                CALENDAR_PROCESS = 6;
                break;
            }
            case 8: {
                CALENDAR_PROCESS = 7;
                break;
            }
            case 9: {
                CALENDAR_PROCESS = 8;
                break;
            }
            case 10: {
                CALENDAR_PROCESS = 9;
                break;
            }
            case 11: {
                CALENDAR_PROCESS = 10;
            }
        }
        return CALENDAR_PROCESS;
    }

    private void processClearTime(Calendar cal) {
        if (cal instanceof Calendar) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        }
    }

    public void processClearTime() {
        this.calendar.set(11, 0);
        this.calendar.set(12, 0);
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
    }

    private void processSetMaxTime(Calendar cal) {
        if (cal instanceof Calendar) {
            this.calendar.set(11, 23);
            this.calendar.set(12, 59);
            this.calendar.set(13, 59);
            this.calendar.set(14, 0);
        }
    }

    public void processSetMaxTime() {
        this.calendar.set(11, 23);
        this.calendar.set(12, 59);
        this.calendar.set(13, 59);
        this.calendar.set(14, 0);
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }
}

