/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.base.utils;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.export.KDTables2KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import java.util.Iterator;
import java.util.Set;

public final class ReportUtils {
    public static ReportUtils getInstance() {
        return new ReportUtils();
    }

    public Book tranToBook(KDTable kdTable) {
        return new KdfToBook().getBook(Book.Manager.getNewBook((String)"book", (int)1), new KDTable[]{kdTable});
    }

    public Book tranToBook(KDTable kdTable, boolean isIncludeHead) {
        Book book = Book.Manager.getNewBook((String)"book", (int)1);
        if (kdTable == null) {
            return book;
        }
        Sheet sheet = book.getSheet(0);
        sheet.appendSSA(kdTable.getSSA());
        Cell cell = null;
        ICell kdCell = null;
        MergeBlocks merger = null;
        Set blockSet = null;
        int headCount = kdTable.getHeadRowCount();
        int rowCount = kdTable.getRowCount();
        int colCount = kdTable.getColumnCount();
        if (isIncludeHead) {
            for (int rowIndex = 0; rowIndex < headCount; ++rowIndex) {
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    kdCell = kdTable.getHeadRow(rowIndex).getCell(colIndex);
                    if (kdCell == null) continue;
                    cell = sheet.getCell(rowIndex, colIndex, true);
                    this.synchCell(cell, kdCell);
                }
            }
            blockSet = kdTable.getHeadMergeManager().getMergeBlockSet();
            Iterator iter = blockSet.iterator();
            while (iter.hasNext()) {
                if (merger == null) {
                    merger = sheet.getSheetOption().getMerger(true);
                }
                KDTMergeBlock mb = (KDTMergeBlock)iter.next();
                merger.insert((Object)CellBlock.getNewCellBlock((int)mb.getTop(), (int)mb.getLeft(), (int)mb.getBottom(), (int)mb.getRight()));
            }
        } else {
            headCount = 0;
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                kdCell = kdTable.getCell(rowIndex, colIndex);
                if (kdCell == null) continue;
                cell = sheet.getCell(headCount + rowIndex, colIndex, true);
                this.synchCell(cell, kdCell);
            }
        }
        blockSet = kdTable.getMergeManager().getMergeBlockSet();
        Iterator iter = blockSet.iterator();
        while (iter.hasNext()) {
            if (merger == null) {
                merger = sheet.getSheetOption().getMerger(true);
            }
            KDTMergeBlock mb = (KDTMergeBlock)iter.next();
            merger.insert((Object)CellBlock.getNewCellBlock((int)(headCount + mb.getTop()), (int)mb.getLeft(), (int)(headCount + mb.getBottom()), (int)mb.getRight()));
        }
        return book;
    }

    public KDSBook transToKdsBook(KDTable[] tables) throws Exception {
        return KDTables2KDSBook.getInstance().exportKDTablesToMultiSheet(tables);
    }

    public void synchSheetValue(KDTable table, KDSSheet kdsSheet) {
        this.synchSheetValue(table, kdsSheet, 0, 0);
    }

    public void synchSheetValue(KDTable table, KDSSheet kdsSheet, int rowOffset, int colOffset) {
        if (table == null || kdsSheet == null) {
            return;
        }
        KDSCell kdsCell = null;
        ICell kdCell = null;
        int rowCount = kdsSheet.getExpandedRows() + 1;
        int colCount = kdsSheet.getExpandedColumns() + 1;
        for (int rowIndex = rowOffset; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = colOffset; colIndex < colCount; ++colIndex) {
                kdsCell = kdsSheet.getCell(rowIndex, colIndex, false);
                if (kdsCell == null) continue;
                kdCell = table.getCell(rowIndex - rowOffset, colIndex - colOffset);
                this.synchCellValue(kdCell, kdsCell);
            }
        }
    }

    public void synchCell(ICell kdCell, KDSCell kdsCell) {
        if (kdCell == null || kdsCell == null) {
            return;
        }
        kdCell.getKDTCell().setSSA(kdsCell.getSSA());
        kdCell.getKDTCell().setStyle(kdsCell.getStyle());
        this.synchCellValue(kdCell, kdsCell);
    }

    public void synchCellValue(ICell kdCell, KDSCell kdsCell) {
        if (kdCell == null || kdsCell == null) {
            return;
        }
        Object obj = kdsCell.getValue();
        if (obj != null) {
            kdCell.setValue(obj);
        }
    }

    public void synchCell(Cell cell, ICell kdCell) {
        if (cell == null || kdCell == null) {
            return;
        }
        if (kdCell.getValue() != null) {
            cell.setValue(new Variant(kdCell.getValue()));
        }
        if (kdCell.getExpressions() != null) {
            cell.setFormula(kdCell.getExpressions());
        }
        cell.setSSA((ShareStyleAttributes)kdCell.getStyleAttributes());
    }
}

