/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.AbstractBgExchangeRateInfo;
import com.kingdee.eas.ma.bg.BgExchangeRateException;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.RowSet;

public class BgExchangeRateInfo
extends AbstractBgExchangeRateInfo
implements Serializable {
    public BgExchangeRateInfo() {
    }

    protected BgExchangeRateInfo(String pkField) {
        super(pkField);
    }

    public static boolean checkPeriodIntersected(PeriodInfo periodFrom1, PeriodInfo periodTo1, PeriodInfo periodFrom2, PeriodInfo periodTo2) {
        return BgExchangeRateInfo.comparePeriod(periodTo1, periodFrom2) >= 0 && BgExchangeRateInfo.comparePeriod(periodTo2, periodFrom1) >= 0;
    }

    public static int comparePeriod(PeriodInfo period1, PeriodInfo period2) {
        if (period1.getPeriodYear() - period2.getPeriodYear() == 0) {
            return period1.getPeriodYear() - period2.getPeriodYear();
        }
        return period1.getPeriodNumber() - period2.getPeriodNumber();
    }

    public static boolean checkRate(BigDecimal rate) {
        return rate.compareTo(new BigDecimal("0")) > 0;
    }

    public static void checkMaturity(BgExchangeRateInfo bgExRateInfo) throws BgExchangeRateException {
        if (bgExRateInfo.getCompany() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getSrcCurrency() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getDesCurrency() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getRate() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getValidPeriodFrom() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getValidPeriodTo() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getCreator() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
        if (bgExRateInfo.getCreateTime() == null) {
            throw new BgExchangeRateException(BgExchangeRateException.CHECKBLANK, new Object[0]);
        }
    }

    public static boolean checkPeriodAcross(Connection conn, BgExchangeRateInfo bgExRateInfo) throws BOSException, EASBizException {
        boolean result = false;
        PeriodInfo from = bgExRateInfo.getValidPeriodFrom();
        PeriodInfo to = bgExRateInfo.getValidPeriodTo();
        BOSUuid companyId = bgExRateInfo.getCompany().getId();
        BOSUuid srcCurrencyId = bgExRateInfo.getSrcCurrency().getId();
        BOSUuid desCurrencyId = bgExRateInfo.getDesCurrency().getId();
        try {
            int startYear = from.getPeriodYear() * 100 + from.getPeriodNumber();
            String strTypeId = from.getPeriodType().getId().toString();
            int endYear = to.getPeriodYear() * 100 + to.getPeriodNumber();
            String strTypeId1 = to.getPeriodType().getId().toString();
            StringBuffer strBuffer = new StringBuffer("SELECT b.fperiodyear fromYear,b.fperiodnumber fromNumber,c.fperiodyear toYear,c.fperiodnumber toNumber FROM T_BG_BgExchangeRate a INNER JOIN T_BD_Period b ON a.FValidPeriodFromID = b.FID ");
            strBuffer.append(" INNER JOIN T_BD_Period c ON a.FValidPeriodToID = c.FID ");
            strBuffer.append(" where b.FTypeId ='" + strTypeId + "'");
            strBuffer.append(" and c.FTypeId ='" + strTypeId + "'");
            strBuffer.append(" and a.FCompanyId = '" + companyId.toString() + "'");
            strBuffer.append(" and a.FSrcCurrencyId = '" + srcCurrencyId.toString() + "'");
            strBuffer.append(" and a.FDesCurrencyId = '" + desCurrencyId.toString() + "'");
            BOSUuid fid = bgExRateInfo.getId();
            if (fid != null) {
                strBuffer.append(" and a.FID !='" + fid.toString() + "'");
            }
            RowSet rowSet = SQLUtils.getJdbcRowSet((Connection)conn, (String)strBuffer.toString());
            while (rowSet.next()) {
                int toNumber;
                int fromYear = rowSet.getInt(1);
                int fromNumber = rowSet.getInt(2);
                int toYear = rowSet.getInt(3);
                if (toYear * 100 + (toNumber = rowSet.getInt(4)) < startYear || fromYear * 100 + fromNumber > endYear) continue;
                result = true;
                break;
            }
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPeriodSerial(Connection conn, BOSUuid per) throws BOSException {
        int result = 0;
        String sql = "select  fperiodYear*100+ fperiodNumber from t_bd_period  where fid=?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, per.toString());
            rs = stmt.executeQuery();
            if (rs.next()) {
                result = rs.getInt(1);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            SQLUtils.cleanup(rs, (Statement)stmt);
        }
        return result;
    }
}

