/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.IBgProvider;
import java.math.BigDecimal;

public class BgFormulaProxy {
    protected Context ctx;
    protected String bgSchemeId;

    public BgFormulaProxy(Context ctx, String schemeId) {
        this.ctx = ctx;
        this.bgSchemeId = schemeId;
    }

    public BigDecimal bgFormula(String orgNumber, String bgTypeNumber, String bgElementNumber, String bgDimensionNumber, String bgItem, String currencyNumber, String periodString) {
        String year = null;
        String period = null;
        if (!periodString.equals("AllPeriod")) {
            BgPeriodNode bgPeriodNode = new BgPeriodNode();
            bgPeriodNode.readFormulaFormat(periodString);
            year = String.valueOf(bgPeriodNode.getPeriod().getPeriodYear());
            period = String.valueOf(bgPeriodNode.getPeriod().getPeriodNumber());
        }
        BigDecimal result = new BigDecimal("0");
        try {
            IBgProvider iBgProvider = this.getBgInterface();
            result = iBgProvider.parseBgFormula(this.bgSchemeId, bgTypeNumber, orgNumber, bgElementNumber, bgDimensionNumber, bgItem, currencyNumber, year, period);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    public BigDecimal bgFormula(String orgNumber, String bgTypeNumber, String bgElementNumber, String bgDimAndItem, String currencyNumber, String periodString) {
        BigDecimal result = new BigDecimal("0");
        try {
            IBgProvider iBgProvider = this.getBgInterface();
            result = iBgProvider.paseBgFormulaMul(this.bgSchemeId, bgTypeNumber, orgNumber, bgElementNumber, bgDimAndItem, currencyNumber, periodString);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    public BigDecimal bgAcct(String bgTypeNumber, String orgNumber, String bgElementNumber, String bgDimensionNumber, String bgItem, String currencyNumber, String year, String period) {
        BigDecimal result = new BigDecimal("0");
        String field = "FBgValue";
        try {
            IBgProvider iBgProvider = this.getBgInterface();
            result = iBgProvider.parseRptFormula(field, bgTypeNumber, orgNumber, bgElementNumber, bgDimensionNumber, bgItem, currencyNumber, year, period);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    public BigDecimal bgAcct(String bgTypeNumber, String orgNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, String year, String period) {
        BigDecimal result = new BigDecimal("0");
        String field = "FBgValue";
        try {
            IBgProvider iBgProvider = this.getBgInterface();
            result = iBgProvider.parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, year, period);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    public BigDecimal bgBalance(String bgTypeNumber, String orgNumber, String bgElementNumber, String strDimAndItemNum, String currencyNumber, String year, String period) {
        BigDecimal result = new BigDecimal("0");
        String field = "FBgBalance";
        try {
            IBgProvider iBgProvider = this.getBgInterface();
            result = iBgProvider.parseRptFormulaMul(field, bgTypeNumber, orgNumber, bgElementNumber, strDimAndItemNum, currencyNumber, year, period);
        }
        catch (Exception e) {
            e.getMessage();
        }
        return result;
    }

    private IBgProvider getBgInterface() throws BOSException {
        IBgProvider iBgProvider = null;
        iBgProvider = this.ctx == null ? BgProviderFactory.getRemoteInstance() : BgProviderFactory.getLocalInstance(this.ctx);
        return iBgProvider;
    }
}

