/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Vector;

public class BgInitUsableDataHelper {
    public static void initUsableData(Context ctx, IObjectValue bgForm, BOSUuid periodId) throws BOSException, EASBizException {
        BgEntryCollection currentBgEntries;
        IBgFormDA ibfda = BgFormDAFactory.getLocalInstance(ctx);
        BgFormInfo bfi = new BgFormInfo();
        bfi = ibfda.getSingleForm((IObjectPK)new ObjectUuidPK(bgForm.getBOSUuid("id")));
        IPeriod ip = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = ip.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        Vector periodNodeVector = BgPeriodRange.getPeriodNodes(bfi.getBgEntries());
        BgPeriodNode currentBgPeriodNode = null;
        int index = -1;
        for (int i = 0; i < periodNodeVector.size(); ++i) {
            BgPeriodNode bpn = (BgPeriodNode)periodNodeVector.get(i);
            if (BgPeriodNode.comparePeriod(bpn.getPeriod(), period) != 0) continue;
            currentBgPeriodNode = bpn;
            index = i;
            break;
        }
        if (currentBgPeriodNode == null) {
            return;
        }
        BgPeriodNode prePeriodNode = null;
        for (int i = index - 1; i > 0; --i) {
            BgPeriodNode bpn = (BgPeriodNode)periodNodeVector.get(i);
            if (!bpn.isLeaf()) continue;
            prePeriodNode = bpn;
            break;
        }
        if ((currentBgEntries = bfi.getBgEntries(currentBgPeriodNode.getPeriod(), currentBgPeriodNode.getBgCycle())) == null) {
            return;
        }
        BgEntryCollection preBgEntries = null;
        if (prePeriodNode != null && (preBgEntries = bfi.getBgEntries(prePeriodNode.getPeriod(), prePeriodNode.getBgCycle())) == null) {
            return;
        }
        Hashtable totalTable = BgInitUsableDataHelper.getTotalValueTable(bfi);
        BgInitUsableDataHelper.caculateCtrlData(currentBgEntries, preBgEntries, totalTable);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        iBgForm.update((IObjectPK)new ObjectUuidPK(bfi.getId()), (CoreBaseInfo)bfi);
    }

    private static void caculateCtrlData(BgEntryCollection currentBgEntries, BgEntryCollection preBgEntries, Hashtable totalTable) {
        int size = currentBgEntries.size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bei = currentBgEntries.get(i);
            for (int j = 0; j < bei.getBgData().size(); ++j) {
                BgDataInfo bdi = bei.getBgData().get(j);
                if (preBgEntries == null) {
                    bdi.setBgLastBalance(new BigDecimal("0"));
                } else {
                    BgDataInfo preBdi = preBgEntries.get(i).getBgData().get(j);
                    if (preBdi.getBgLastBalance() == null) {
                        preBdi.setBgLastBalance(new BigDecimal("0"));
                    }
                    if (preBdi.getBgUsableValue() == null) {
                        preBdi.setBgUsableValue(new BigDecimal("0"));
                    }
                    if (preBdi.getBizActual() == null) {
                        preBdi.setBizActual(new BigDecimal("0"));
                    }
                    bdi.setBgLastBalance(preBdi.getBgUsableValue().subtract(preBdi.getBizActual()));
                }
                switch (bdi.getInt("bgCtrlType")) {
                    case 10: {
                        bdi.setBgUsableValue(bdi.getBgValue());
                        break;
                    }
                    case 11: {
                        bdi.setBgUsableValue(bdi.getBgValue().add(bdi.getBgLastBalance()));
                        break;
                    }
                    case 12: {
                        String key = BgInitUsableDataHelper.getBgDataIdentityKey(bei, bdi);
                        BigDecimal theTatol = (BigDecimal)totalTable.get(key);
                        if (theTatol == null) {
                            bdi.setBgUsableValue(new BigDecimal("0"));
                            break;
                        }
                        bdi.setBgUsableValue(theTatol);
                        break;
                    }
                }
                if (bdi.getBgUsableValue() == null) {
                    bdi.setBgUsableValue(new BigDecimal("0"));
                }
                bdi.setBizActual(new BigDecimal("0"));
                bdi.setBgActual(new BigDecimal("0"));
                bdi.setBgBalance(bdi.getBgUsableValue().subtract(bdi.getBizActual()));
            }
        }
    }

    private static Hashtable getTotalValueTable(BgFormInfo bfi) {
        Hashtable<String, BigDecimal> totalTable = new Hashtable<String, BigDecimal>();
        int size = bfi.getBgEntries().size();
        for (int i = 0; i < size; ++i) {
            BgEntryInfo bei = bfi.getBgEntries().get(i);
            for (int j = 0; j < bei.getBgData().size(); ++j) {
                BgDataInfo bdi = bei.getBgData().get(j);
                if (bdi.getBgValue() == null) continue;
                String key = BgInitUsableDataHelper.getBgDataIdentityKey(bei, bdi);
                BigDecimal theValue = (BigDecimal)totalTable.get(totalTable);
                if (theValue == null) {
                    totalTable.put(key, bdi.getBgValue());
                    continue;
                }
                totalTable.put(key, theValue.add(bdi.getBgValue()));
            }
        }
        return totalTable;
    }

    private static String getBgDataIdentityKey(BgEntryInfo bei, BgDataInfo bdi) {
        return bei.getBgItemsKey() + bdi.getElementKey();
    }
}

