/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowCollection;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;

public class BgRptTpHelper {
    public static final String TOTALASSETS = "TotalAssets";
    public static final String TOTALLIABILITIESANDEQUITY = "TotalLiabilitiesAndEquity";
    public static final String BEGINROW = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"BeginRow");
    public static final String ENDROW = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgTemplateResource", (String)"EndRow");
    public static final String TOTALFORMULADISPLAY = BEGINROW + "(n1) " + ENDROW + "(n2)";

    public static SelectorItemCollection getFullDataSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgRptTpRows"));
        return sic;
    }

    public static EntityViewInfo getFullDataEntityView(String bgTemplateId) {
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("bgRptTpRows"));
        evi.getSelector().add(new SelectorItemInfo("bgTemplate.id"));
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgTemplateId));
        evi.setFilter(fi);
        return evi;
    }

    public static String number2TotalFormula(int beginRow, int endRow) {
        StringBuffer strBuffer = new StringBuffer(20);
        strBuffer.append("(");
        strBuffer.append(String.valueOf(BgRptTpHelper.minInteger(beginRow, endRow)));
        strBuffer.append(":");
        strBuffer.append(String.valueOf(BgRptTpHelper.maxInteger(beginRow, endRow)));
        strBuffer.append(")");
        return strBuffer.toString();
    }

    public static String totalFormula2KdtableFormat(String totalFormula, BgRptTemplateRowCollection bgRptTpRowCollection, int rowIndex, int columnIndex) {
        StringBuffer sb = new StringBuffer();
        int beginRow = 0;
        int endRow = 0;
        String[] strArr = StringUtils.split((String)totalFormula, (int)43);
        for (int i = 0; i < strArr.length; ++i) {
            String strTemp = strArr[i].trim();
            strArr[i] = strTemp = strTemp.substring(1, strTemp.length() - 1);
        }
        for (int j = 0; j < strArr.length; ++j) {
            String[] rowArray = StringUtils.split((String)strArr[j], (int)58);
            beginRow = Integer.parseInt(rowArray[0]);
            endRow = Integer.parseInt(rowArray[1]);
            int size = bgRptTpRowCollection.size();
            if (beginRow > size || endRow > size) {
                return sb.toString();
            }
            for (int i = beginRow; i <= endRow; ++i) {
                BgRptTemplateRowInfo btri = bgRptTpRowCollection.get(i - 1);
                if (i == rowIndex) continue;
                if (sb.length() == 0) {
                    sb.append("=");
                } else if (bgRptTpRowCollection.get(i - 1).getInt("direction") == 1) {
                    sb.append("+");
                } else {
                    sb.append("-");
                }
                sb.append(" cell(" + i + "," + columnIndex + ").getValue() ");
            }
        }
        return sb.toString();
    }

    public static String totalFormula2TemplateDisplay(String totalFormula) {
        String[] numberArray = StringUtils.split((String)totalFormula, (String)",");
        if (numberArray.length != 2) {
            return "";
        }
        return BgRptTpHelper.number2TemplateDisplay(numberArray[0], numberArray[1]);
    }

    public static String number2TemplateDisplay(int beginRow, int endRow) {
        String result = "(" + String.valueOf(BgRptTpHelper.minInteger(beginRow, endRow)) + ":" + String.valueOf(BgRptTpHelper.maxInteger(beginRow, endRow)) + ")";
        return result;
    }

    public static String number2TemplateDisplay(String beginRow, String endRow) {
        String result = "(" + beginRow + ":" + endRow + ")";
        return result;
    }

    private static int maxInteger(int a, int b) {
        return a > b ? a : b;
    }

    private static int minInteger(int a, int b) {
        return a < b ? a : b;
    }
}

