/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.ma.bg.VOPredicate;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;

public class HashSearchEngine
implements VOPredicate {
    private String[] keys;
    private IObjectValue vo;
    private Map map = null;

    public HashSearchEngine(IObjectValue[] coll, String[] keys) {
        this.keys = keys;
        this.map = new HashMap();
        for (int i = 0; i < coll.length; ++i) {
            this.map.put(this.getKeyString(coll[i]), coll[i]);
        }
    }

    @Override
    public boolean evaluate(IObjectValue iter) {
        String key = this.getKeyString(iter);
        this.vo = (IObjectValue)this.map.get(key);
        return this.vo != null;
    }

    private String getKeyString(IObjectValue iter) {
        StringBuffer sb = new StringBuffer(this.keys.length * 10);
        for (int i = 0; i < this.keys.length; ++i) {
            Object val = iter.get(this.keys[i]);
            sb.append("_");
            if (val == null) {
                sb.append("null");
                continue;
            }
            if (val instanceof IObjectValue) {
                IObjectValue new_val = (IObjectValue)val;
                Object pk = new_val.get("id");
                if (pk == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(pk);
                continue;
            }
            if (val instanceof BigDecimal) {
                NumberFormat fmt = NumberFormat.getInstance();
                sb.append(fmt.format(val));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }

    public IObjectValue getResult() {
        return this.vo;
    }
}

