/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgApproveTypeEnum;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogFactory;
import com.kingdee.eas.ma.bg.BgFormLogHelper;
import com.kingdee.eas.ma.bg.BgFormLogInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgInstantApproveFactory;
import com.kingdee.eas.ma.bg.BgInstantApproveInfo;
import com.kingdee.eas.ma.bg.BgInstantApproveTargetEnum;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgFormLog;
import com.kingdee.eas.ma.bg.IBgInstantApprove;
import com.kingdee.eas.ma.bg.client.AbstractBgAllApproveUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;

public class BgAllApproveUI
extends AbstractBgAllApproveUI {
    @Override
    public void loadFields() {
        super.loadFields();
        this.kDTable1.checkParsed();
        this.initData();
        UserInfo user = (UserInfo)SysContext.getSysContext().getCurrentUser();
        this.kDBizPromptBoxUser.setValue((Object)user);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        this.kDDatePickerTime.setValue((Object)time);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void onbtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.onbtnConfirm_actionPerformed(e);
        int count = this.kDTable1.getRowCount();
        boolean isOK = false;
        for (int i = 0; i < count; ++i) {
            IRow iRow = this.kDTable1.getRow(i);
            Boolean isSelect = (Boolean)iRow.getCell("select").getValue();
            if (!isSelect.booleanValue()) continue;
            BgFormInfo bgForm = (BgFormInfo)iRow.getUserObject();
            this.storeBgFormLog(bgForm);
            this.approve(bgForm);
            isOK = true;
        }
        if (isOK) {
            MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"ApproveEnd"));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void onBtnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.onBtnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadFields();
    }

    protected void initData() {
        Map map = this.getUIContext();
        Hashtable hash = (Hashtable)map.get("ID");
        Enumeration enums = hash.elements();
        while (enums.hasMoreElements()) {
            BgFormInfo bgForm = (BgFormInfo)enums.nextElement();
            int state = bgForm.getState().getValue();
            if (state != 9 && state != 1) continue;
            this.putDataToTable(bgForm);
        }
    }

    protected void putDataToTable(BgFormInfo bgFormInfo) {
        IRow iRow = this.kDTable1.addRow();
        iRow.getCell("select").setValue((Object)new Boolean(false));
        iRow.getCell("number").setValue((Object)bgFormInfo.getNumber());
        iRow.getCell("name").setValue((Object)bgFormInfo.getName());
        iRow.getCell("orgUnit").setValue((Object)bgFormInfo.getOrgUnit().getName());
        iRow.setUserObject((Object)bgFormInfo);
    }

    protected void approve(BgFormInfo bgForm) throws EASBizException, BOSException {
        BgInstantApproveInfo approveInfo = new BgInstantApproveInfo();
        BgInstantApproveTargetEnum targetType = BgInstantApproveTargetEnum.BgForm;
        approveInfo.setApproveTargetType(targetType);
        BOSUuid targetId = bgForm.getId();
        approveInfo.setApproveTargetID(targetId);
        approveInfo.setIsApproved(BgApproveTypeEnum.Pass);
        IBgInstantApprove iBg = BgInstantApproveFactory.getRemoteInstance();
        iBg.executeApprove(approveInfo, bgForm.getId().toString());
        IBgFormDA ibd = BgFormDAFactory.getRemoteInstance();
        ibd.updateBgFormStatus((IObjectPK)new ObjectUuidPK(bgForm.getId()), BgFormStateEnum.Approved);
    }

    protected void storeBgFormLog(BgFormInfo bgForm) throws EASBizException, BOSException {
        BgOperationEnum bgOpr = BgOperationEnum.AllApprove;
        UserInfo user = (UserInfo)this.kDBizPromptBoxUser.getValue();
        BgFormLogInfo bgLog = BgFormLogHelper.addNewLogByBgForm(null, bgForm, bgOpr, user);
        IBgFormLog iLog = BgFormLogFactory.getRemoteInstance();
        iLog.addnew(bgLog);
    }
}

