/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgAlyRptManagerFactory;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.IBgAlyRptManager;
import com.kingdee.eas.ma.bg.client.AbstractBgBalanceRptUI;
import com.kingdee.eas.ma.bg.client.BgCtrlDetailRptUI;
import com.kingdee.eas.ma.bg.client.BgResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;

public abstract class BgBalanceRptUI
extends AbstractBgBalanceRptUI {
    @Override
    protected IRowSet getData(EntityViewInfo ev) throws EASBizException, BOSException {
        IBgAlyRptManager manager = BgAlyRptManagerFactory.getRemoteInstance();
        IRowSet rs = manager.getBalanceRowSet(ev);
        return rs;
    }

    @Override
    protected void displayData(IRowSet rs) throws BOSException, EASBizException, SQLException {
        IRow row;
        String id = null;
        rs.beforeFirst();
        while (rs.next()) {
            String newId = rs.getString(1);
            if (newId == null || newId.equals(id)) continue;
            row = this.tblMain.addRow();
            id = rs.getString(1);
            row.getCell(0).setValue((Object)id);
            row.getCell(1).setValue((Object)this.getOrgUnit(rs.getString(2)));
            row.getCell(1).setUserObject((Object)rs.getString(2));
            row.getCell(2).setValue((Object)this.getBgType(rs.getString(3)));
            String strPeriod = rs.getString(4);
            row.getCell(3).setValue((Object)strPeriod.trim());
            for (int i = 0; i < this.bgDimSize; ++i) {
                if (this.fillDims(row, rs, i)) continue;
                --this.bgDimSize;
            }
        }
        for (int r = 0; r < this.tblMain.getRowCount(); ++r) {
            row = this.tblMain.getRow(r);
            this.fillData(rs, row);
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        IRowSet rs = this.getData(this.queryEV);
        if (rs.size() == 0) {
            return;
        }
        this.initData(rs);
        this.insertDimsColls();
        this.insertElemColls();
        this.displayData(rs);
        this.initStat(this.startIndex);
        rs.beforeFirst();
        rs.last();
        String periodStr = rs.getString(4).trim();
        int rowCount = this.tblMain.getRowCount();
        int colCount = this.tblMain.getColumnCount();
        BigDecimal one = new BigDecimal(1);
        for (int i = 0; i < colCount; ++i) {
            Object obj = this.tblMain.getHeadRow(1).getCell(i).getValue();
            if (obj == null || !obj.toString().equals(BgResource.getString("FBGUSABLEVALUE"))) continue;
            BigDecimal value = new BigDecimal(0);
            for (int j = 0; j < rowCount; ++j) {
                if (!((String)this.tblMain.getRow(j).getCell(3).getValue()).equals(periodStr)) continue;
                value = value.add((BigDecimal)this.tblMain.getRow(j).getCell(i).getValue());
            }
            value = value.divide(one, 2, 6);
            this.tblMain.getGroupManager().getStatRowTemplate(1).getCell(i).setExpressions(null);
            this.tblMain.getGroupManager().getStatRowTemplate(0).getCell(i).setExpressions(null);
            this.tblMain.getGroupManager().getStatRowTemplate(-1).getCell(i).setExpressions(null);
            this.tblMain.getGroupManager().getStatRowTemplate(1).getCell(i).setValue((Object)value);
            this.tblMain.getGroupManager().getStatRowTemplate(0).getCell(i).setValue((Object)value);
            this.tblMain.getGroupManager().getStatRowTemplate(-1).getCell(i).setValue((Object)value);
        }
        BigDecimal divideParam = new BigDecimal(1);
        for (int m = 0; m < rowCount; ++m) {
            for (int n = colCount - 7; n < colCount; ++n) {
                BigDecimal valuemn = new BigDecimal(0);
                if (this.tblMain.getCell(m, n).getValue() != null) {
                    valuemn = (BigDecimal)this.tblMain.getCell(m, n).getValue();
                }
                valuemn = valuemn.divide(divideParam, 2, 6);
                this.tblMain.getCell(m, n).setValue((Object)valuemn);
            }
        }
    }

    @Override
    protected void insertElemField(int i) {
        this.insertElemeColl(i, "FBgLastBalance");
        this.insertElemeColl(i, "FBgValue");
        this.insertElemeColl(i, "FBGUSABLEVALUE");
        this.insertElemeColl(i, "FBgActual");
        this.insertElemeColl(i, "FBgBalance");
    }

    @Override
    public void initStat(int firstIndex) {
        super.initStat(firstIndex);
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDetail_actionPerformed(e);
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        EntityViewInfo ev = (EntityViewInfo)this.queryEV.clone();
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("ev", ev);
        ctx.put("Owner", (Object)this);
        FilterItemCollection filters = ev.getFilter().getFilterItems();
        filters.add(new FilterItemInfo("bizOrgUnitIDs", (Object)this.getCompanyIds(this.tblMain)));
        String s = this.getDispPeriod(this.tblMain, 3);
        if (s == null) {
            MsgBox.showError((Component)((Object)this), (String)BgResource.getString("cannotSelectStateRow"));
            return;
        }
        String year = null;
        String beginNumber = null;
        String endNumber = null;
        if (this.dispPeriodType == 12) {
            year = s.substring(0, 4);
            beginNumber = "0";
            endNumber = "12";
        } else if (this.dispPeriodType == 3) {
            int quarter = Integer.parseInt(s.substring(5, 6));
            year = s.substring(0, 4);
            beginNumber = String.valueOf(quarter * 3 - 2);
            endNumber = String.valueOf(quarter * 3);
        } else if (this.dispPeriodType == 1) {
            endNumber = beginNumber = s.substring(5, 7);
            year = s.substring(0, 4);
        }
        BgHelper.getFilterItem(filters, "beginPeriodYear").setCompareValue((Object)year);
        BgHelper.getFilterItem(filters, "beginPeriodMonth").setCompareValue((Object)beginNumber);
        BgHelper.getFilterItem(filters, "endPeriodYear").setCompareValue((Object)year);
        BgHelper.getFilterItem(filters, "endPeriodMonth").setCompareValue((Object)endNumber);
        String bgTypeId = (String)BgHelper.getFilterValue(filters, "bgType");
        Integer integ = new Integer(20);
        BgHelper.getFilterItem(filters, "alyType").setCompareValue((Object)integ);
        IUIWindow dispUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(BgCtrlDetailRptUI.class.getName(), ctx);
        String uiTitle = dispUI.getUIObject().getUITitle();
        dispUI.show();
    }

    protected String getDispPeriod(KDTable table, int index) {
        StringBuffer sb = new StringBuffer();
        int size = table.getSelectManager().size();
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        IRow row = table.getRow(selectBlock.getTop());
        if (row.isStat()) {
            return null;
        }
        return row.getCell(index).getValue().toString();
    }

    protected String getCompanyIds(KDTable table) {
        StringBuffer sb = new StringBuffer();
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock == null) {
            return null;
        }
        IRow row = table.getRow(selectBlock.getTop());
        if (row == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        sb.append("'");
        sb.append(row.getCell(1).getUserObject());
        sb.append("'");
        return sb.toString();
    }

    protected String getSelectedIds(KDTable table, int number) {
        StringBuffer sb = new StringBuffer();
        int size = table.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock selectBlock = table.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                sb.append("'");
                sb.append(table.getRow(j).getCell(number).getValue());
                sb.append("',");
            }
        }
        sb.append("''");
        return sb.toString();
    }

    @Override
    public void setIcon() {
        super.setIcon();
        this.btnViewCtrlDetail.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
    }
}

