/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDataCollection;
import com.kingdee.eas.ma.bg.BgDataFactory;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import com.kingdee.eas.ma.bg.BgEntryFactory;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgProviderFactory;
import com.kingdee.eas.ma.bg.IBgData;
import com.kingdee.eas.ma.bg.IBgEntry;
import com.kingdee.eas.ma.bg.IBgProvider;
import com.kingdee.eas.ma.bg.client.AbstractBgBalanceViewUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class BgBalanceViewUI
extends AbstractBgBalanceViewUI {
    private CurrencyInfo[] currencyInfos;
    private String bgValueCol;
    private String bgBalanceCol;
    private String currency;

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(BgResource.getString("ViewBgBalance"));
        BgDataCollection bgDataColl = (BgDataCollection)((Object)this.getUIContext().get("bgDataColl"));
        if (bgDataColl.size() == 0) {
            MsgBox.showWarning((Component)this.getParent(), (String)BgResource.getString("NoBudge"));
            this.abort();
        }
        this.getDisplayData(bgDataColl);
    }

    public void getDisplayData(BgDataCollection collection) throws EASBizException, BOSException {
        Object[] dispDataAry = new Object[collection.size()];
        this.currencyInfos = new CurrencyInfo[collection.size()];
        Object[] dimAry = new Object[collection.size()];
        IBgEntry iBgEntry = BgEntryFactory.getRemoteInstance();
        ICurrency iCurr = CurrencyFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("bgItem1.*"));
        sic.add(new SelectorItemInfo("bgItem2.*"));
        sic.add(new SelectorItemInfo("bgItem3.*"));
        sic.add(new SelectorItemInfo("bgItem4.*"));
        sic.add(new SelectorItemInfo("bgItem5.*"));
        sic.add(new SelectorItemInfo("bgItem6.*"));
        for (int i = 0; i < collection.size(); ++i) {
            Vector<Object> dispDataVec = new Vector<Object>();
            BgDataInfo bgDataInfo = collection.get(i);
            BOSUuid bgEntryId = bgDataInfo.getBgEntry().getId();
            BgEntryInfo bgEntryInfo = iBgEntry.getBgEntryInfo((IObjectPK)new ObjectUuidPK(bgEntryId), sic);
            Map dimMap = this.getDimensionInfo(bgEntryInfo);
            dimAry[i] = dimMap;
            Iterator iter = dimMap.values().iterator();
            while (iter.hasNext()) {
                dispDataVec.add((BgItemInfo)iter.next());
            }
            dispDataVec.add(BgClientHelper.getDecimalFormat().format(bgDataInfo.getBgValue()));
            dispDataVec.add(BgClientHelper.getDecimalFormat().format(this.getEnableBgBalance(bgDataInfo)));
            this.currencyInfos[i] = iCurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(bgDataInfo.getCurrency().getId()));
            dispDataAry[i] = dispDataVec;
        }
        List maxDimList = this.getMaxDim(dimAry);
        if (maxDimList != null && maxDimList.size() > 0) {
            dispDataAry = this.formatDispData(maxDimList, dispDataAry);
        }
        this.setHeader(maxDimList);
        this.setData(dispDataAry);
    }

    public List getMaxDim(Object[] dimAry) {
        ArrayList<Object> maxDimList = new ArrayList<Object>();
        for (int i = 0; i < dimAry.length; ++i) {
            Map dimMap = (Map)dimAry[i];
            Set keySet = dimMap.keySet();
            Object[] keyAry = keySet.toArray();
            for (int j = 0; j < keyAry.length; ++j) {
                Object key = keyAry[j];
                if (maxDimList.contains(key)) continue;
                maxDimList.add(key);
            }
        }
        return maxDimList;
    }

    public Object[] formatDispData(List maxDimList, Object[] dispDataAry) {
        int colNum = maxDimList.size() + 2;
        for (int i = 0; i < dispDataAry.length; ++i) {
            Vector datas = (Vector)dispDataAry[i];
            Vector<Object> newDatas = new Vector<Object>();
            for (int j = 0; j < colNum; ++j) {
                newDatas.add("");
            }
            for (int p = 0; p < maxDimList.size(); ++p) {
                BgDimensionEnum dim = (BgDimensionEnum)((Object)maxDimList.get(p));
                for (int j = 0; j < datas.size() - 2; ++j) {
                    BgItemInfo bgItemInfo = (BgItemInfo)datas.get(j);
                    BgDimensionEnum itemDim = bgItemInfo.getBgDimension();
                    if (itemDim != dim) continue;
                    newDatas.setElementAt(bgItemInfo, p);
                }
            }
            newDatas.setElementAt(datas.get(datas.size() - 1), newDatas.size() - 1);
            newDatas.setElementAt(datas.get(datas.size() - 2), newDatas.size() - 2);
            dispDataAry[i] = newDatas;
        }
        return dispDataAry;
    }

    private void setHeader(List maxDimList) {
        if (maxDimList != null && maxDimList.size() > 0) {
            this.bgValueCol = "bgValueCol";
            this.bgBalanceCol = "bgBalanceCol";
            this.currency = "currency";
            this.tblMain.checkParsed();
            this.tblMain.getStyleAttributes().setLocked(true);
            IColumn iColumn = null;
            IRow headRow = this.tblMain.addHeadRow();
            int i = 0;
            Iterator iter = maxDimList.iterator();
            while (iter.hasNext()) {
                iColumn = this.tblMain.addColumn();
                iColumn.setKey("col" + i);
                headRow.getCell("col" + i).setValue((Object)((BgDimensionEnum)((Object)iter.next())));
                ++i;
            }
            iColumn = this.tblMain.addColumn();
            iColumn.setKey(this.bgValueCol);
            iColumn = this.tblMain.addColumn();
            iColumn.setKey(this.bgBalanceCol);
            iColumn = this.tblMain.addColumn();
            iColumn.setKey(this.currency);
            headRow.getCell(this.bgValueCol).setValue((Object)BgResource.getString("bgValue"));
            headRow.getCell(this.bgBalanceCol).setValue((Object)BgResource.getString("enableBgBalance"));
            headRow.getCell(this.currency).setValue((Object)BgResource.getString("Currency"));
            this.tblMain.getSelectManager().setSelectMode(2);
        }
    }

    private void setData(Object[] dispDataAry) {
        for (int i = 0; i < dispDataAry.length; ++i) {
            Vector datas = (Vector)dispDataAry[i];
            IRow row = this.tblMain.addRow();
            for (int j = 0; j < datas.size(); ++j) {
                row.getCell(j).setValue(datas.get(j));
            }
            row.getCell(this.currency).setValue((Object)this.currencyInfos[i]);
        }
    }

    private BigDecimal getEnableBgBalance(BgDataInfo bgDataInfo) throws EASBizException, BOSException {
        IBgProvider iBgProvider = BgProviderFactory.getRemoteInstance();
        BigDecimal enBgBalance = iBgProvider.getEnableBalance(bgDataInfo.getId());
        return enBgBalance;
    }

    private Map getDimensionInfo(BgEntryInfo entryInfo) {
        BgItemInfo bgItemInfo6;
        BgItemInfo bgItemInfo5;
        BgItemInfo bgItemInfo4;
        BgItemInfo bgItemInfo3;
        BgItemInfo bgItemInfo2;
        HashMap<BgDimensionEnum, BgItemInfo> dimMap = new HashMap<BgDimensionEnum, BgItemInfo>();
        String itemIds = entryInfo.getBgItemIds();
        BgItemInfo bgItemInfo1 = entryInfo.getBgItem1();
        if (bgItemInfo1 != null) {
            dimMap.put(bgItemInfo1.getBgDimension(), bgItemInfo1);
        }
        if ((bgItemInfo2 = entryInfo.getBgItem2()) != null) {
            dimMap.put(bgItemInfo2.getBgDimension(), bgItemInfo2);
        }
        if ((bgItemInfo3 = entryInfo.getBgItem3()) != null) {
            dimMap.put(bgItemInfo3.getBgDimension(), bgItemInfo3);
        }
        if ((bgItemInfo4 = entryInfo.getBgItem4()) != null) {
            dimMap.put(bgItemInfo4.getBgDimension(), bgItemInfo4);
        }
        if ((bgItemInfo5 = entryInfo.getBgItem5()) != null) {
            dimMap.put(bgItemInfo5.getBgDimension(), bgItemInfo5);
        }
        if ((bgItemInfo6 = entryInfo.getBgItem6()) != null) {
            dimMap.put(bgItemInfo6.getBgDimension(), bgItemInfo6);
        }
        return dimMap;
    }

    private BgDataCollection getBgDataCollection(BgCtrlParam[] params) throws EASBizException, BOSException {
        BgDataCollection collection = new BgDataCollection();
        if (params != null && params.length > 0) {
            IBgData iBgData = BgDataFactory.getRemoteInstance();
            for (int i = 0; i < params.length; ++i) {
                BgCtrlParam param = params[i];
                Object[] keyAry = param.getDatas().keySet().toArray();
                for (int j = 0; j < keyAry.length; ++j) {
                    BgElementEnum key = (BgElementEnum)((Object)keyAry[j]);
                    BgCtrlData bizData = param.getData(key);
                    BOSUuid bgDataId = bizData.getBgDataId();
                    if (bgDataId == null) continue;
                    BgDataInfo bgData = iBgData.getBgDataInfo((IObjectPK)new ObjectUuidPK(bgDataId));
                    collection.add(bgData);
                }
            }
        }
        return collection;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void setIcon() {
    }
}

