/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgTreeF7PromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDataTypeEnum;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgRptTemplateInfo;
import com.kingdee.eas.ma.bg.BgRptTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnCollection;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTemplateRowInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.DataProviderClient;
import com.kingdee.eas.ma.bg.ReferencedCurrencyInfo;
import com.kingdee.eas.ma.bg.ReferencedDimensionCollection;
import com.kingdee.eas.ma.bg.ReferencedDimensionInfo;
import com.kingdee.eas.ma.bg.client.BgAdjustFormTreeListUI;
import com.kingdee.eas.ma.bg.client.BgApproveListUI;
import com.kingdee.eas.ma.bg.client.BgFormActualTreeListUI;
import com.kingdee.eas.ma.bg.client.BgFormListUI;
import com.kingdee.eas.ma.bg.client.BgFormValueTreeListUI;
import com.kingdee.eas.ma.bg.client.BgRollFormTreeListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;

public class BgClientHelper {
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(0xF6F6B6);
    public static final Color KDTABLE_SUBTOTAL_BG_COLOR = new Color(16119270);
    public static final Color KDTABLE_DIMENSION_BG_COLOR = Color.WHITE;
    public static final String kdTableNumberFtm = "%-.2n";
    public static final String kdTablePercentFtm = "%r{0.00}p";
    public static final String kdTableDateFtm = "%{yyyy-MM-dd}t";
    public static HashMap mapPrecOfCurrency = new HashMap(32);
    public static final int SUBTOTAL = 16119270;
    public static final int TOTAL = 0xF6F6B6;
    public static final int TOTAL1 = 16185013;
    public static final int PASTRECORD = 16771687;
    public static final String COMPRESSED_OBJECT_BOSTYPE = "COMPRESS";
    public static final Color PASTRECORD_COLOR = new Color(16771687);
    public static final Color TOTAL_COLOR = new Color(0xF6F6B6);
    public static final Color TOTAL1_COLOR = new Color(16185013);

    public static void initDefaultCreator(KDBizPromptBox kDBizPromptBox) {
        if (SysContext.getSysContext().getCurrentUser() == null) {
            kDBizPromptBox.setData((Object)new DataProviderClient().getUseInfo());
        } else {
            kDBizPromptBox.setData(SysContext.getSysContext().getCurrentUser());
        }
    }

    public static String getNumberFtm(BOSUuid currencyId) {
        return "%r-[ ]15." + BgClientHelper.getPrecOfCurrency(currencyId) + "n";
    }

    public static String getNumberFtm() {
        return "%r-[ ]{###,###,###.##}15.2n";
    }

    public static int getPrecOfCurrency(BOSUuid currencyId) {
        if (mapPrecOfCurrency.size() == 0) {
            BgClientHelper.setPrecOfCurrenty(mapPrecOfCurrency);
        }
        if (!mapPrecOfCurrency.containsKey(currencyId)) {
            return 10;
        }
        return (Integer)mapPrecOfCurrency.get(currencyId);
    }

    public static void checkIsOnCU(CoreUI ui, FullOrgUnitInfo org, CtrlUnitInfo orgCtrl) throws BOSException, EASBizException {
        if (org == null) {
            return;
        }
        IFullOrgUnit iFull = FullOrgUnitFactory.getRemoteInstance();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        org = iFull.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(org.getId()), sic);
        if (!org.getCU().getId().toString().equals(orgCtrl.getId().toString())) {
            MsgBox.showWarning((Component)ui, (String)"\u8bf7\u5728\u5f53\u524d\u63a7\u5236\u5355\u5143\u4e0b\u64cd\u4f5c\uff01");
            SysUtil.abort();
        }
    }

    private static void setPrecOfCurrenty(HashMap map) {
        String str = "select fid,fprecision from t_bd_currency";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                map.put(BOSUuid.read((String)rs.getString(1)), new Integer(rs.getInt(2)));
            }
        }
        catch (BOSException bose) {
            return;
        }
        catch (SQLException sqle) {
            return;
        }
    }

    public static void initOrgF7(BgTypeInfo bgTypeInfo, KDBizPromptBox bizPromptOrgUnit) {
        BgClientHelper.initOrgF7(bgTypeInfo, bizPromptOrgUnit, false);
    }

    public static void applyMutexService(Component ui, String id, String userID) {
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        boolean isRequest = iMC.requestObjIDForUpdate(id, userID);
        if (!isRequest) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"lockInfo"));
            SysUtil.abort();
        }
    }

    public static void initOrgF7(BgTypeInfo bgTypeInfo, KDBizPromptBox bizPromptOrgUnit, boolean isMultiChoose) {
        bizPromptOrgUnit.setData(null);
        bizPromptOrgUnit.setEnabled(true);
        bizPromptOrgUnit.setEnabledMultiSelection(isMultiChoose);
        OrgType[] orgType = new OrgType[]{OrgType.Company};
        OrgTreeF7PromptBox box = new OrgTreeF7PromptBox(null, orgType);
        bizPromptOrgUnit.setEditFormat("$name$");
        bizPromptOrgUnit.setDisplayFormat("$name$");
        bizPromptOrgUnit.setSelector((KDPromptSelector)box);
        box.show();
    }

    public static DefaultKingdeeTreeNode getPeriodTreeRoot(BgEntryCollection bgEntries) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        Iterator iter = bgEntries.iterator();
        while (iter.hasNext()) {
            BgEntryInfo bgEntryInfo = (BgEntryInfo)iter.next();
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getPeriodTreeRoot(PeriodInfo periodInfoFrom, PeriodInfo periodInfoTo) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        DefaultKingdeeTreeNode yearRoot = null;
        DefaultKingdeeTreeNode seasonRoot = null;
        Vector vector = new BgPeriodRange(periodInfoFrom, periodInfoTo).getPeriodNodesInRange();
        for (int i = 0; i < vector.size(); ++i) {
            BgPeriodNode tmpBgPeriodNode = (BgPeriodNode)vector.get(i);
            DefaultKingdeeTreeNode tmpTreeNode = new DefaultKingdeeTreeNode((Object)tmpBgPeriodNode);
            if (tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Year)) {
                root.add((MutableTreeNode)tmpTreeNode);
                yearRoot = tmpTreeNode;
                continue;
            }
            if (tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Season)) {
                if (yearRoot != null) {
                    yearRoot.add((MutableTreeNode)tmpTreeNode);
                }
                seasonRoot = tmpTreeNode;
                continue;
            }
            if (!tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Period) || seasonRoot == null) continue;
            seasonRoot.add((MutableTreeNode)tmpTreeNode);
        }
        return root;
    }

    public static DefaultKingdeeTreeNode getPeriodTreeRoot(Vector vector) {
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode();
        DefaultKingdeeTreeNode yearRoot = null;
        DefaultKingdeeTreeNode seasonRoot = null;
        for (int i = 0; i < vector.size(); ++i) {
            BgPeriodNode tmpBgPeriodNode = (BgPeriodNode)vector.get(i);
            DefaultKingdeeTreeNode tmpTreeNode = new DefaultKingdeeTreeNode((Object)tmpBgPeriodNode);
            if (tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Year)) {
                root.add((MutableTreeNode)tmpTreeNode);
                yearRoot = tmpTreeNode;
                continue;
            }
            if (tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Season)) {
                if (yearRoot != null) {
                    yearRoot.add((MutableTreeNode)tmpTreeNode);
                }
                seasonRoot = tmpTreeNode;
                continue;
            }
            if (!tmpBgPeriodNode.getBgCycle().equals((Object)BgCycleTypeEnum.Period) || seasonRoot == null) continue;
            seasonRoot.add((MutableTreeNode)tmpTreeNode);
        }
        return root;
    }

    public static boolean checkInProInst(String id) throws BOSException {
        boolean result = false;
        ProcessInstInfo[] procInsts = EnactmentServiceFactory.createRemoteEnactService().getProcessInstanceByHoldedObjectId(id);
        for (int i = 0; i < procInsts.length; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            result = true;
            break;
        }
        return result;
    }

    public static BgPeriodNode getCurrentBgPeriodNode(KDTree treeBgPeriod) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeBgPeriod.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() == null) {
            return null;
        }
        return (BgPeriodNode)node.getUserObject();
    }

    public static BgPeriodNode getEndBgPeriodNode(KDTree treeBgPeriod) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)treeBgPeriod.getPathForRow(treeBgPeriod.getRowCount() - 1).getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.getUserObject() == null) {
            return null;
        }
        return (BgPeriodNode)node.getUserObject();
    }

    public static void initBgFormTable(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        BgClientHelper.initBgFormTable_distribute(bgTpInfo, kdTable);
        kdTable.getHeadMergeManager().mergeBlock(0, 0, kdTable.getHeadRowCount() - 1, kdTable.getColumnCount() - 1, 3);
    }

    public static void initBgFormTable_distribute(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        int i;
        BgClientHelper.clearTable(kdTable);
        System.out.println("id:" + bgTpInfo.getId());
        IRow mainHeadRow = kdTable.addHeadRow();
        IRow multiCurrencyHeadRow = null;
        BgClientHelper.initBgItemColumnAndRow(bgTpInfo, kdTable);
        int columnCursor = kdTable.getColumnCount();
        BgTemplateColumnCollection tpCols = bgTpInfo.getBgTpColumns();
        boolean isMultiCurrency = bgTpInfo.getRefCurrencies().size() > 1;
        CurrencyInfo soloCurrency = null;
        if (!isMultiCurrency && bgTpInfo.getRefCurrencies().size() > 0) {
            soloCurrency = bgTpInfo.getRefCurrencies().get(0).getCurrency();
        }
        int size = tpCols.size();
        for (i = 0; i < size; ++i) {
            BgTemplateColumnInfo bgTpColInfo = tpCols.get(i);
            BgElementInfo bgElementInfo = bgTpColInfo.getBgElement();
            if (bgElementInfo.getDataType().equals((Object)BgDataTypeEnum.Amount) && isMultiCurrency) {
                if (multiCurrencyHeadRow == null) {
                    multiCurrencyHeadRow = kdTable.addHeadRow();
                }
                Iterator currencyIter = bgTpInfo.getRefCurrencies().iterator();
                while (currencyIter.hasNext()) {
                    ReferencedCurrencyInfo refCyInfo = (ReferencedCurrencyInfo)currencyIter.next();
                    CurrencyInfo cyInfo = refCyInfo.getCurrency();
                    IColumn ic = kdTable.addColumn(columnCursor);
                    ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(cyInfo.getId()));
                    ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    ic.setMergeable(false);
                    ic.setKey(BgHelper.getBgElementKey(bgElementInfo, cyInfo));
                    mainHeadRow.getCell(columnCursor).setValue((Object)bgElementInfo.getName());
                    multiCurrencyHeadRow.getCell(columnCursor).setValue((Object)cyInfo.getName());
                    ++columnCursor;
                }
                continue;
            }
            IColumn ic = kdTable.addColumn(columnCursor);
            if (soloCurrency != null) {
                ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(soloCurrency.getId()));
            } else {
                ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm());
            }
            ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            ic.setMergeable(false);
            ic.setKey(bgElementInfo.getNumber());
            mainHeadRow.getCell(columnCursor).setValue((Object)bgElementInfo.getName());
            ++columnCursor;
        }
        if (multiCurrencyHeadRow != null) {
            for (i = 0; i < kdTable.getColumnCount(); ++i) {
                if (multiCurrencyHeadRow.getCell(i) == null || multiCurrencyHeadRow.getCell(i).getValue() != null) continue;
                multiCurrencyHeadRow.getCell(i).setValue(mainHeadRow.getCell(i).getValue());
            }
        }
    }

    public static void clearTable(KDTable kdTable) {
        kdTable.removeHeadRows();
        kdTable.removeRows();
        kdTable.removeColumns();
    }

    public static void initBgItemColumn(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        ReferencedDimensionCollection visibleRefDims = bgTpInfo.getVisibleDims();
        Iterator visibleRefDimsIter = visibleRefDims.iterator();
        int columnCursor = 0;
        while (visibleRefDimsIter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
            String refName = refDimInfo.getBgDimension().getName();
            IColumn ic = null;
            if (kdTable.getColumnIndex(refName) == -1) {
                ic = kdTable.addColumn(columnCursor);
                ic.setWidth(110);
                ic.setKey(refName);
            } else {
                ic = kdTable.getColumn(refName);
            }
            kdTable.getHeadRow(0).getCell(columnCursor).setValue((Object)refDimInfo.getBgDimension().getAlias(SysContext.getSysContext().getLocale()));
            ic.getStyleAttributes().setLocked(true);
            ++columnCursor;
        }
    }

    public static void initBgItemColumnAndRow(BgTemplateInfo bgTpInfo, KDTable kdTable) {
        ReferencedDimensionCollection visibleRefDims = bgTpInfo.getVisibleDims();
        Iterator visibleRefDimsIter = visibleRefDims.iterator();
        int columnCursor = 0;
        while (visibleRefDimsIter.hasNext()) {
            ReferencedDimensionInfo refDimInfo = (ReferencedDimensionInfo)visibleRefDimsIter.next();
            String refName = refDimInfo.getBgDimension().getName();
            IColumn ic = null;
            if (kdTable.getColumnIndex(refName) == -1) {
                ic = kdTable.addColumn(columnCursor);
                ic.setWidth(200);
                ic.setKey(refName);
            } else {
                ic = kdTable.getColumn(refName);
            }
            kdTable.getHeadRow(0).getCell(columnCursor).setValue((Object)refDimInfo.getBgDimension().getAlias(SysContext.getSysContext().getLocale()));
            ic.getStyleAttributes().setLocked(true);
            ++columnCursor;
        }
        int itemColumnsNum = visibleRefDims.size();
        Iterator iter = bgTpInfo.getBgTpRows().iterator();
        while (iter.hasNext()) {
            BgTemplateRowInfo bgTpRowInfo = (BgTemplateRowInfo)iter.next();
            IRow ir = kdTable.addRow();
            ir.setUserObject((Object)BgHelper.getBgItemsKey(new Object[]{bgTpRowInfo.getBgItem1(), bgTpRowInfo.getBgItem2(), bgTpRowInfo.getBgItem3(), bgTpRowInfo.getBgItem4(), bgTpRowInfo.getBgItem5(), bgTpRowInfo.getBgItem6()}));
            for (int i = 0; i < itemColumnsNum; ++i) {
                ICell cell = ir.getCell(i);
                String valueKey = "bgItem" + String.valueOf(i + 1);
                BgItemInfo bgItemInfo = (BgItemInfo)bgTpRowInfo.get(valueKey);
                if (bgItemInfo == null) {
                    cell.setValue(null);
                    continue;
                }
                cell.setValue((Object)bgItemInfo);
            }
        }
        if (itemColumnsNum == 1) {
            BgClientHelper.treeFormTable(kdTable);
        }
        kdTable.getMergeManager().mergeBlock(0, 0, kdTable.getRowCount() - 1, itemColumnsNum - 1, 1);
    }

    public static void treeFormTable(KDTable kdTable) {
        kdTable.getTreeColumn().setOrientation(0);
        int maxDepth = 0;
        for (int i = 0; i < kdTable.getRowCount(); ++i) {
            BgItemInfo bgItemInfo = (BgItemInfo)kdTable.getRow(i).getCell(0).getValue();
            if (bgItemInfo == null) {
                return;
            }
            if (bgItemInfo.getLongNumber() == null) continue;
            int depth = StringUtils.occurencesOf((String)bgItemInfo.getItemNumber(), (char)'.');
            kdTable.getRow(i).setTreeLevel(depth);
            if (maxDepth >= depth) continue;
            maxDepth = depth;
        }
        kdTable.getTreeColumn().setDepth(maxDepth);
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo() {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        try {
            Object comobj = SysContext.getSysContext().getProperty((Object)"CompanyId");
            ObjectUuidPK compk = new ObjectUuidPK(BOSUuid.read((String)comobj.toString()));
            ICompanyOrgUnit iCompanyOrgUint = CompanyOrgUnitFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            companyOrgUnitInfo = iCompanyOrgUint.getCompanyOrgUnitInfo((IObjectPK)compk, sic);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return companyOrgUnitInfo;
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (AbstractObjectValue.class.isInstance(anObject)) {
            AbstractObjectValue newObject = (AbstractObjectValue)anObject;
            boolean found = false;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                if (!newObject.equalsPK((IObjectValue)((AbstractObjectValue)cbo.getItemAt(i)))) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    public static void initBgRptFormTable(BgRptTemplateInfo bgRptTpInfo, KDTable kdTable) {
        BgClientHelper.clearTable(kdTable);
        IRow mainHeadRow = kdTable.addHeadRow();
        BgClientHelper.initBgRptItemColumnAndRow(bgRptTpInfo, kdTable);
        int columnCursor = kdTable.getColumnCount();
        Iterator bgElementIter = bgRptTpInfo.getBgTemplate().getBgType().getElements().iterator();
        CurrencyInfo soloCurrency = null;
        if (bgRptTpInfo.getBgTemplate().getRefCurrencies().size() == 1) {
            soloCurrency = bgRptTpInfo.getBgTemplate().getRefCurrencies().get(0).getCurrency();
        }
        while (bgElementIter.hasNext()) {
            BgElementInfo bgElementInfo = (BgElementInfo)bgElementIter.next();
            IColumn ic = kdTable.addColumn(columnCursor);
            if (soloCurrency != null) {
                ic.getStyleAttributes().setNumberFormat(BgClientHelper.getNumberFtm(soloCurrency.getId()));
            }
            ic.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            ic.setKey(bgElementInfo.getNumber());
            mainHeadRow.getCell(columnCursor).setValue((Object)bgElementInfo.getName());
            ++columnCursor;
        }
    }

    private static void initBgRptItemColumnAndRow(BgRptTemplateInfo bgRptTpInfo, KDTable kdTable) {
        if (bgRptTpInfo == null || bgRptTpInfo.getBgRptTpRows() == null) {
            return;
        }
        int columnCursor = 0;
        IColumn ic = kdTable.addColumn(columnCursor);
        ic.setKey("");
        kdTable.getHeadRow(0).getCell(columnCursor).setValue((Object)"\u62a5\u8868\u9879\u76ee");
        Iterator iter = bgRptTpInfo.getBgRptTpRows().iterator();
        while (iter.hasNext()) {
            BgRptTemplateRowInfo bgRptTpRowInfo = (BgRptTemplateRowInfo)iter.next();
            IRow ir = kdTable.addRow();
            ir.setUserObject((Object)bgRptTpRowInfo);
            ICell cell = ir.getCell(0);
            if (bgRptTpRowInfo.getPrefix() == null) {
                cell.setValue((Object)bgRptTpRowInfo.getName());
            } else {
                cell.setValue((Object)(bgRptTpRowInfo.getPrefix() + bgRptTpRowInfo.getName()));
            }
            cell.setUserObject((Object)bgRptTpRowInfo);
        }
        kdTable.getColumn(0).getStyleAttributes().setLocked(true);
    }

    public static Set getSelectedRows(KDTable table) {
        ArrayList arrayList = table.getSelectManager().getBlocks();
        TreeSet<Integer> set = new TreeSet<Integer>();
        int size = arrayList.size();
        for (int i = 0; i < size; ++i) {
            KDTBlock block = (KDTBlock)arrayList.get(i);
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int j = top; j <= bottom; ++j) {
                Integer theInteger = new Integer(j);
                set.add(theInteger);
            }
        }
        return set;
    }

    public static boolean verifyTooBigger(String value, double target) {
        boolean result = false;
        try {
            double big = Double.parseDouble(value);
            if (big >= target) {
                result = true;
            }
        }
        catch (NumberFormatException e) {
            result = true;
        }
        return result;
    }

    public static boolean verifyNumberPrecision(String value, int precision, int scale) {
        double top;
        boolean result = true;
        BigDecimal number = new BigDecimal(value);
        double unscale = number.unscaledValue().abs().doubleValue();
        if (unscale > (top = Math.pow(10.0, precision) - 1.0) || number.scale() > scale) {
            result = false;
        }
        return result;
    }

    public static boolean verifyIsNumber(String value) {
        boolean result = true;
        try {
            BigDecimal bigDecimal = new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static boolean verifyIsInteger(String value) {
        boolean result = true;
        try {
            int n = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            result = false;
        }
        return result;
    }

    public static boolean verifyIsPlus(String value) throws NumberFormatException {
        boolean result = true;
        float big = Float.parseFloat(value);
        if (big <= 0.0f) {
            result = false;
        }
        return result;
    }

    public static boolean verifyIsPlus1(String value) throws NumberFormatException {
        boolean result = true;
        float big = Float.parseFloat(value);
        if (big < 0.0f) {
            result = false;
        }
        return result;
    }

    public static DecimalFormat getDecimalFormat() {
        DecimalFormat format = new DecimalFormat("#.##");
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(2);
        return format;
    }

    public static DecimalFormat getDecimalFormat(int length) {
        DecimalFormat format = new DecimalFormat("#.##");
        if (length == 3) {
            format = new DecimalFormat("#.###");
        } else if (length == 4) {
            format = new DecimalFormat("#.####");
        }
        format.setMaximumFractionDigits(length);
        format.setMinimumFractionDigits(length);
        return format;
    }

    public static void checkSubOrgs(Component com, String[] lNumber) {
        int i;
        int i2;
        int size = lNumber.length;
        int[] qty = new int[size - 1];
        int[] dd = new int[6];
        Vector[] vec = new Vector[6];
        for (int i3 = 0; i3 < 6; ++i3) {
            vec[i3] = new Vector(4);
        }
        String superNumber = lNumber[size - 1];
        int superQty = superNumber.split("!").length;
        for (i2 = 0; i2 < qty.length; ++i2) {
            String strErr;
            String number = lNumber[i2];
            qty[i2] = number.split("!").length;
            if (qty[i2] <= superQty) {
                strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg");
                MsgBox.showWarning((Component)com, (String)strErr);
                SysUtil.abort();
            }
            if (number.indexOf(superNumber) != -1) continue;
            strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg1");
            MsgBox.showWarning((Component)com, (String)strErr);
            SysUtil.abort();
        }
        for (i2 = 0; i2 < dd.length; ++i2) {
            dd[i2] = 0;
        }
        for (i2 = 0; i2 < qty.length; ++i2) {
            if (qty[i2] == 1) {
                dd[0] = 1;
            }
            if (qty[i2] == 2) {
                dd[1] = 1;
            }
            if (qty[i2] == 3) {
                dd[2] = 1;
            }
            if (qty[i2] == 4) {
                dd[3] = 1;
            }
            if (qty[i2] == 5) {
                dd[4] = 1;
            }
            if (qty[i2] != 6) continue;
            dd[5] = 1;
        }
        int begin = -1;
        int end = 0;
        for (int i4 = 0; i4 < dd.length; ++i4) {
            if (dd[i4] == 1 && begin == -1) {
                begin = i4;
            }
            if (dd[i4] != 1) continue;
            end = i4;
        }
        if (begin == -1) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg");
            MsgBox.showWarning((Component)com, (String)strErr);
            SysUtil.abort();
        }
        for (i = begin; i <= end; ++i) {
            if (dd[i] != 0) continue;
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg2");
            MsgBox.showWarning((Component)com, (String)strErr);
            SysUtil.abort();
        }
        for (i = 0; i < qty.length; ++i) {
            if (qty[i] == 1) {
                vec[0].addElement(lNumber[i]);
                continue;
            }
            if (qty[i] == 2) {
                vec[1].addElement(lNumber[i]);
                continue;
            }
            if (qty[i] == 3) {
                vec[2].addElement(lNumber[i]);
                continue;
            }
            if (qty[i] == 4) {
                vec[3].addElement(lNumber[i]);
                continue;
            }
            if (qty[i] == 5) {
                vec[4].addElement(lNumber[i]);
                continue;
            }
            if (qty[i] != 6) continue;
            vec[5].addElement(lNumber[i]);
        }
        if (begin == end && superQty != begin) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg2");
            MsgBox.showWarning((Component)com, (String)strErr);
            SysUtil.abort();
        }
        for (int i5 = end; i5 > begin; --i5) {
            Object[] obj1 = vec[i5].toArray();
            Object[] obj2 = vec[i5 - 1].toArray();
            for (int m = 0; m < obj1.length; ++m) {
                boolean isOk = false;
                String number1 = (String)obj1[m];
                for (int n = 0; n < obj2.length; ++n) {
                    String number2 = (String)obj2[n];
                    if (number1.indexOf(number2) == -1) continue;
                    isOk = true;
                    break;
                }
                if (isOk) continue;
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectedSubOrg2");
                MsgBox.showWarning((Component)com, (String)strErr);
                SysUtil.abort();
            }
        }
    }

    public static boolean checkSubOrgUnit(FullOrgUnitCollection subOrgC, FullOrgUnitCollection selectOrgC) {
        boolean isYes = false;
        int size = subOrgC.size();
        int selectSize = selectOrgC.size();
        for (int i = 0; i < selectSize; ++i) {
            FullOrgUnitInfo orgUnitSelect = selectOrgC.get(i);
            boolean isExist = false;
            for (int j = 0; j < size; ++j) {
                FullOrgUnitInfo orgUnitSub = subOrgC.get(j);
                if (!orgUnitSelect.getId().equals((Object)orgUnitSub.getId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            isYes = true;
            break;
        }
        return isYes;
    }

    public static boolean isSubmitByAction(ActionEvent e) {
        boolean isSave = false;
        String str = "";
        if (e.getSource() instanceof KDWorkButton) {
            KDWorkButton btn = (KDWorkButton)e.getSource();
            str = btn.getAction().toString();
        } else if (e.getSource() instanceof KDMenuItem) {
            KDMenuItem item = (KDMenuItem)e.getSource();
            str = item.getAction().toString();
        }
        int index = str.indexOf("ActionSubmit");
        if (index != -1) {
            isSave = true;
        }
        return isSave;
    }

    public static Date getServerTime() {
        java.sql.Date result = null;
        String str = "select distinct getdate() ftime from t_bg_bgform ";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                result = rs.getDate(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public static void refreshBgFormList(CoreUI ui) throws Exception {
        Container parent;
        CoreUI listUI = null;
        if (ui instanceof EditUI) {
            listUI = (CoreUI)ui.getUIContext().get("Owner");
        } else if (ui instanceof ListUI) {
            listUI = ui;
        }
        if (listUI != null && listUI instanceof ListUI && (parent = ((ListUI)listUI).getParent()) != null && parent instanceof KDTabbedPane) {
            KDTabbedPane tabb = (KDTabbedPane)parent;
            int n = tabb.getTabCount();
            for (int i = 0; i < n; ++i) {
                Component component = tabb.getComponentAt(i);
                if (!(component instanceof BgFormListUI) && !(component instanceof BgApproveListUI) && !(component instanceof BgAdjustFormTreeListUI) && !(component instanceof BgRollFormTreeListUI) && !(component instanceof BgFormValueTreeListUI) && !(component instanceof BgFormActualTreeListUI)) continue;
                ((ListUI)component).refreshList();
            }
        }
    }
}

