/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.bg.BgAlyRptManagerFactory;
import com.kingdee.eas.ma.bg.BgAuditStyleEnum;
import com.kingdee.eas.ma.bg.BgConstants;
import com.kingdee.eas.ma.bg.BgDataManagerFactory;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.IBgAlyRptManager;
import com.kingdee.eas.ma.bg.IBgDataManager;
import com.kingdee.eas.ma.bg.client.AbstractBgCtrlDetailRptUI;
import com.kingdee.eas.ma.bg.client.BgResource;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Map;

public class BgCtrlDetailRptUI
extends AbstractBgCtrlDetailRptUI {
    private boolean init;

    @Override
    public void actionGetActual_actionPerformed(ActionEvent e) throws Exception {
        super.actionGetActual_actionPerformed(e);
        IBgDataManager man = BgDataManagerFactory.getRemoteInstance();
        man.gatherBgActual();
    }

    @Override
    protected IRowSet getData(EntityViewInfo ev) throws EASBizException, BOSException {
        IBgAlyRptManager manager = BgAlyRptManagerFactory.getRemoteInstance();
        IRowSet rs = manager.getCtrlDetailRowSet(ev);
        return rs;
    }

    @Override
    protected void displayData(IRowSet rs) throws BOSException, EASBizException, SQLException {
        String id = null;
        rs.beforeFirst();
        while (rs.next()) {
            String newId = rs.getString(1);
            if (newId == null || newId.equals(id)) continue;
            IRow row = this.tblMain.addRow();
            id = rs.getString(1);
            row.getCell(0).setValue((Object)id);
            row.getCell(1).setValue((Object)this.getOrgUnit(rs.getString(2)));
            row.getCell(2).setValue((Object)this.getBgType(rs.getString(3)));
            String strPeriod = rs.getString(4);
            row.getCell(3).setValue((Object)strPeriod.trim());
            row.getCell("currency").setValue((Object)this.getCurrency(rs.getString("FBIZCURRENCYID")));
            row.getCell("bizDate").setValue((Object)rs.getString("FBizDate"));
            row.getCell("billType").setValue((Object)this.getBillType(rs.getString("FSrcBillTypeID")));
            row.getCell("billType").setUserObject((Object)rs.getString("FSrcBillTypeID"));
            row.getCell("billNumber").setValue((Object)rs.getString("FSrcBillNumber"));
            row.getCell("billNumber").setUserObject((Object)rs.getString("FSrcBillID"));
            row.getCell("auditStyle").setValue((Object)BgAuditStyleEnum.getEnum(rs.getInt("FBgAuditStyle")));
            row.setUserObject((Object)(rs.getString("FDimSerial") + rs.getString("FBIZCURRENCYID")));
            for (int i = 0; i < this.bgDimSize; ++i) {
                if (this.fillDims(row, rs, i)) continue;
                --this.bgDimSize;
            }
        }
        int rowCount = this.tblMain.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            IRow row = this.tblMain.getRow(r);
            this.fillData(rs, row);
        }
    }

    @Override
    protected void insertElemColls() {
        for (int i = 0; i < this.elementList.size(); ++i) {
            int index = this.tblMain.getColumnCount();
            this.insertElemField(i);
            this.tblMain.getHeadMergeManager().mergeBlock(0, index, 0, this.tblMain.getColumnCount() - 1);
        }
    }

    @Override
    protected void insertElemField(int i) {
        this.insertElemeColl(i, "FBgValue");
        this.insertElemeColl(i, "FBizData0");
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        IRowSet rs = this.getData(this.queryEV);
        if (rs.size() == 0) {
            return;
        }
        this.initData(rs);
        this.insertDimsColls();
        this.insertElemColls();
        this.displayData(rs);
        this.initStat(this.startIndex);
        IColumn column = this.tblMain.getColumn("bizDate");
        column.getStyleAttributes().setNumberFormat("%{yyyy-MM-dd}t");
        column.setGroup(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                try {
                    if (BgCtrlDetailRptUI.this.init) {
                        return;
                    }
                    BgCtrlDetailRptUI.this.init = true;
                    BgCtrlDetailRptUI.this.initBgBalance();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    @Override
    public void initBgBalance() {
        int cellIndex = this.tblMain.getColumnIndex("auditStyle") + 1;
        int currencySize = this.cache_currencyColl.size();
        boolean isStat = false;
        for (int i = 1; i < this.tblMain.getRowCount(); ++i) {
            BigDecimal val;
            BigDecimal dValue;
            BigDecimal oValue;
            int j;
            IRow row1;
            IRow row = this.tblMain.getRow(i);
            if (!isStat) {
                row1 = this.tblMain.getRow(i - 1);
                for (j = 0; j < currencySize; ++j) {
                    oValue = this.getCellBigDecimalValue(row1.getCell(cellIndex + j));
                    dValue = this.getCellBigDecimalValue(row1.getCell(cellIndex + j + currencySize));
                    if (!BgHelper.equals(row.getUserObject(), row1.getUserObject())) continue;
                    val = oValue.subtract(dValue);
                    if (val != null && !val.equals(BgConstants.ZERO)) {
                        row.getCell(cellIndex + j).setValue((Object)val);
                        continue;
                    }
                    row.getCell(cellIndex + j).setValue(null);
                }
            }
            if (row.isStat()) {
                row1 = this.tblMain.getRow(i - 1);
                for (j = 0; j < currencySize; ++j) {
                    oValue = this.getCellBigDecimalValue(row1.getCell(cellIndex + j));
                    dValue = this.getCellBigDecimalValue(row1.getCell(cellIndex + j + currencySize));
                    val = oValue.subtract(dValue);
                    if (oValue != null && !val.equals(BgConstants.ZERO) && !isStat) {
                        row.getCell(cellIndex + j).setValue((Object)val);
                        continue;
                    }
                    row.getCell(cellIndex + j).setValue(null);
                }
            }
            isStat = row.isStat();
        }
    }

    private BigDecimal getCellBigDecimalValue(ICell cell) {
        Object cValue = cell.getValue();
        BigDecimal oValue = cValue == null ? new BigDecimal("0") : new BigDecimal(cValue.toString());
        return oValue;
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewBill_actionPerformed(e);
        if (this.tblMain.getSelectManager().get() == null) {
            return;
        }
        int top = this.tblMain.getSelectManager().get().getTop();
        if (top == -1) {
            return;
        }
        if (this.tblMain.getRow(top).getCell("billNumber") == null || this.tblMain.getRow(top).getCell("billNumber").getUserObject() == null) {
            MsgBox.showError((Component)((Object)this), (String)BgResource.getString("cannotSelectStateRow"));
            return;
        }
        String id = this.tblMain.getRow(top).getCell("billNumber").getUserObject().toString();
        String typeId = this.tblMain.getRow(top).getCell("billType").getUserObject().toString();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        BOSObjectType bosType = new BOSObjectType(typeId);
        IDynamicObject doCtrl = DynamicObjectFactory.getRemoteInstance();
        try {
            doCtrl.getValue(bosType, "select id where id='" + id + "'");
        }
        catch (DataAccessException exp) {
            MsgBox.showError((String)BgResource.getString("billNoExist"));
            return;
        }
        EntityObjectInfo entity = loader.getEntity(bosType);
        String editUi = entity.getExtendedProperty("editUI");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(editUi, (Map)uiContext, null, "VIEW");
        uiWindow.show();
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    @Override
    public void setIcon() {
        super.setIcon();
        this.btnViewBill.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewbill"));
    }
}

