/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellScriptEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTCellScriptListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.ma.bg.BgAssistantDimensionEnum;
import com.kingdee.eas.ma.bg.BgDataInfo;
import com.kingdee.eas.ma.bg.BgEntryCollection;
import com.kingdee.eas.ma.bg.BgEntryInfo;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormHelper;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgFormStateHelper;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgOrgHelper;
import com.kingdee.eas.ma.bg.BgPeriodNode;
import com.kingdee.eas.ma.bg.BgPeriodRange;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgTemplateFormulaProxy;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.client.AbstractBgDistributeEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDeclareClientHelper;
import com.kingdee.eas.ma.bg.client.BgDistributeEditHelper;
import com.kingdee.eas.ma.bg.client.BgDistributeScaleEditUI;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.ma.bg.client.BgPastRecordEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;

public class BgDistributeEditUI
extends AbstractBgDistributeEditUI {
    private static final String HRBUDGET = "HRBudget";
    private static final String PERCENT = "Percent";
    private BgFormEditHelper bgFormEditHelper = new BgFormEditHelper();
    private BgDeclareClientHelper bgDecClientHelper = new BgDeclareClientHelper();
    private BgDistributeEditHelper bgDistEditHelper = new BgDistributeEditHelper();
    protected boolean isItemMatched = true;
    private boolean isInit = false;
    Hashtable itemMatchTable = null;
    String scaleType = null;
    Hashtable simpleScaleTable = null;
    Vector periodNodeVector;
    protected Hashtable columnSubjectTable;
    private BgTemplateInfo bgTemplateInfoTotal = null;
    private FullOrgUnitInfo orgUnitInfoTotal = null;
    private BgFormInfo bgFormInfoTotal = null;
    private BgSchemeInfo bgSchemeInfo = null;
    private BgFormCollection bgFormCollectionSub = new BgFormCollection();
    private FullOrgUnitCollection orgUnitCollectionSub = new FullOrgUnitCollection();
    private BgFormCollection bgFormCollectionAll = new BgFormCollection();
    private FullOrgUnitCollection orgUnitCollectionAll = new FullOrgUnitCollection();
    private Vector vecScale = null;
    private boolean isExist = false;

    @Override
    public void loadFields() {
        this.kdtDistributeData.checkParsed();
        this.kdtDistributeData.setFormulaMode(1);
        try {
            this.initDataByIntroduction();
        }
        catch (EASBizException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (BOSException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        catch (SQLException e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        this.kDTextFieldBgType.setText(this.bgFormInfoTotal.getBgType().getName());
        this.kDTextFieldBgScheme.setText(this.bgSchemeInfo.getName());
        BgClientHelper.treeFormTable(this.kdtDistributeData);
        StringBuffer strSubOrgName = new StringBuffer();
        int size = this.orgUnitCollectionSub.size();
        for (int i = 0; i < size; ++i) {
            FullOrgUnitInfo orgUnitInfoTemp = this.orgUnitCollectionSub.get(i);
            strSubOrgName.append(orgUnitInfoTemp.getNumber() + " " + orgUnitInfoTemp.getName());
            if (i == size - 1) continue;
            strSubOrgName.append("   ");
        }
        this.setControlEditor();
        this.initPeriodNodeVector();
        BgFormEditHelper.initPeriodTree(this.treePeriod, this.periodNodeVector);
        this.kdtDistributeData.getScriptManager().addKDTCellScriptListener(new KDTCellScriptListener(){

            public void cellScriptBegin(KDTCellScriptEvent arg0) {
            }

            public void cellScriptEnd(KDTCellScriptEvent arg0) {
                int editedRowIndex = arg0.getRowIndex();
                int editedColIndex = arg0.getColIndex();
                ICell cell = BgDistributeEditUI.this.kdtDistributeData.getRow(editedRowIndex).getCell(editedColIndex);
                Object theObj = cell.getValue();
                if (!(theObj instanceof String)) {
                    return;
                }
                String theValue = (String)theObj;
                if (theValue == null) {
                    return;
                }
                if (BgClientHelper.verifyIsNumber(theValue)) {
                    BgDistributeEditUI.this.bgDistEditHelper.updateCell(BgDistributeEditUI.this.kdtDistributeData, editedRowIndex, editedColIndex);
                }
            }
        });
    }

    public IIDList getIDListForAll() {
        IIDList result = super.getIDListForAll();
        if (result == null) {
            result = new RealModeIDList();
        }
        return result;
    }

    public void goLeaf() {
        if (this.treePeriod.getRowCount() > 0) {
            this.treePeriod.setSelectionRow(0);
            if (this.treePeriod.getModel().getChildCount(this.treePeriod.getLastSelectedPathComponent()) != 0) {
                this.treePeriod.setSelectionRow(1);
                if (this.treePeriod.getModel().getChildCount(this.treePeriod.getLastSelectedPathComponent()) != 0) {
                    this.treePeriod.setSelectionRow(2);
                }
            }
        }
    }

    private void initPeriodNodeVector() {
        this.periodNodeVector = BgPeriodRange.getPeriodNodes(this.bgFormInfoTotal.getBgEntries());
    }

    private void refreshPeriod(BgPeriodNode bgPeriodNode) {
        BgItemCollection bgItemColl;
        if (bgPeriodNode == null) {
            return;
        }
        this.bgDecClientHelper.setKDTableLockByPeriodNode(this.kdtDistributeData, bgPeriodNode);
        this.bgDistEditHelper.fillData(this.bgFormInfoTotal, this.bgFormCollectionAll, bgPeriodNode, this.kdtDistributeData);
        this.bgDistEditHelper.fillScaleData(this.kdtDistributeData);
        if (!bgPeriodNode.isLeaf()) {
            this.setScaleByOrgUnit(this.orgUnitInfoTotal);
            this.bgDistEditHelper.reCalculatePerent(this.kdtDistributeData, (OrgUnitInfo)this.orgUnitInfoTotal, this.bgFormCollectionSub.size(), this.vecScale);
        }
        this.bgDecClientHelper.setKDTableLockByPeriodNode(this.kdtDistributeData, bgPeriodNode);
        if (bgPeriodNode.getBgCycle().getValue() != 1 && bgPeriodNode.getBgCycle().getValue() != 2) {
            this.bgDecClientHelper.lockedRowByOrg(this.kdtDistributeData, this.orgUnitInfoTotal, this.bgTemplateInfoTotal, true);
            this.bgDecClientHelper.setColumnLocked(this.kdtDistributeData, this.bgTemplateInfoTotal, true);
        }
        if ((bgItemColl = this.bgDecClientHelper.getNotListProjectByBgTemplate(this.bgTemplateInfoTotal)).size() > 0) {
            this.isExist = true;
            this.bgDecClientHelper.setListProjectLocked(this.kdtDistributeData, bgItemColl, true);
        }
        if (bgPeriodNode.isLeaf()) {
            this.sumDistributeData();
        }
    }

    protected IObjectPK getOrgPK() {
        FullOrgUnitInfo inOrgUnitInfo = (FullOrgUnitInfo)this.getUIContext().get("permi_org");
        if (inOrgUnitInfo.isIsCompanyOrgUnit()) {
            ObjectUuidPK orgPk = new ObjectUuidPK(inOrgUnitInfo.getId());
            return orgPk;
        }
        return super.getOrgPK();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    @Override
    protected void treePeriod_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treePeriod_valueChanged(e);
        BgPeriodNode bgPeriodNode = BgClientHelper.getCurrentBgPeriodNode(this.treePeriod);
        this.refreshPeriod(bgPeriodNode);
        if (!this.isInit) {
            bgPeriodNode = BgClientHelper.getEndBgPeriodNode(this.treePeriod);
            this.refreshPeriod(bgPeriodNode);
            this.isInit = true;
            bgPeriodNode = BgClientHelper.getCurrentBgPeriodNode(this.treePeriod);
            this.refreshPeriod(bgPeriodNode);
        }
    }

    protected IObjectValue createNewData() {
        return new BgFormInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return BgFormHelper.getEditDataSelectors();
    }

    @Override
    protected void btnSetApportion_actionPerformed(ActionEvent e) throws Exception {
        super.btnSetApportion_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SubOrgCollection", (Object)this.orgUnitCollectionSub);
        uiContext.put((Object)"SimpleScaleTable", (Object)this.simpleScaleTable);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDistributeScaleEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.scaleType = ((BgDistributeScaleEditUI)uiWindow.getUIObject()).getScaleType();
        this.scaleType = "SimpleScale";
        if (this.scaleType != null && this.scaleType.equals("SimpleScale")) {
            this.simpleScaleTable = ((BgDistributeScaleEditUI)uiWindow.getUIObject()).getSimpleScaleTable();
            if (this.simpleScaleTable == null) {
                return;
            }
            this.bgDistEditHelper.applySimpleScale(this.bgFormInfoTotal, this.bgFormCollectionSub, this.simpleScaleTable);
        }
        this.refreshTree();
    }

    private void refreshTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treePeriod.getModel().getRoot();
        DefaultKingdeeTreeNode node = null;
        BgPeriodNode bgNode = null;
        Enumeration enums = root.breadthFirstEnumeration();
        while (enums.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)enums.nextElement();
            bgNode = (BgPeriodNode)node.getUserObject();
            if (bgNode == null) continue;
            this.refreshPeriod(bgNode);
        }
        this.treePeriod.setSelectionRow(0);
        BgDeclareClientHelper.goFirstChild(this.treePeriod);
    }

    @Override
    protected void kdtDistributeData_editStopped(KDTEditEvent e) throws Exception {
        super.kdtDistributeData_editStopped(e);
        int editedRowIndex = e.getRowIndex();
        int editedColIndex = e.getColIndex();
        String value = (String)this.kdtDistributeData.getRow(editedRowIndex).getCell(editedColIndex).getValue();
        if (value == null) {
            return;
        }
        if (!BgClientHelper.verifyIsNumber(value = value.trim())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
            this.kdtDistributeData.getEditManager().editCellAt(editedRowIndex, editedColIndex);
            return;
        }
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        value = format.format(new BigDecimal(value));
        this.kdtDistributeData.getRow(editedRowIndex).getCell(editedColIndex).setValue((Object)new BigDecimal(value));
        ICell cell = this.kdtDistributeData.getRow(editedRowIndex).getCell(editedColIndex);
        IColumn column = this.kdtDistributeData.getColumn(editedColIndex);
        if (column.getKey().endsWith(PERCENT)) {
            this.bgDistEditHelper.updateCell(this.kdtDistributeData, editedRowIndex, editedColIndex);
            this.sumDistributeData();
        } else {
            this.sumDistributeData();
            this.bgDistEditHelper.updateCell(this.kdtDistributeData, editedRowIndex, editedColIndex);
        }
    }

    private void sumDistributeData() {
        if (!this.isExist) {
            return;
        }
        Hashtable hashHead = this.bgDecClientHelper.getHead(this.bgTemplateInfoTotal);
        Vector vecSumIndex = this.bgDistEditHelper.getScaleCol(this.kdtDistributeData);
        int sizeSum = vecSumIndex.size();
        for (int j = 0; j < sizeSum; ++j) {
            int colIndex = (Integer)vecSumIndex.get(j) - 1;
            this.bgDecClientHelper.setHeadSumValue(this.kdtDistributeData, this.orgUnitInfoTotal.getNumber(), hashHead, colIndex);
        }
    }

    private void printAllKey() {
        for (int k = 0; k < this.kdtDistributeData.getRowCount(); ++k) {
            IRow iRow = this.kdtDistributeData.getRow(k);
        }
    }

    private void pastRecordShow() {
        BgDataInfo bgDataInfo;
        BgDeclareClientHelper bgDeclareClientHelper;
        HashMap treeMap;
        int nRowIndex = this.kdtDistributeData.getSelectManager().getActiveRowIndex();
        int nColumnIndex = this.kdtDistributeData.getSelectManager().getActiveColumnIndex();
        IRow iRow = this.kdtDistributeData.getRow(nRowIndex);
        ICell iCell = iRow.getCell(nColumnIndex);
        Object obj = iCell.getUserObject();
        if (obj instanceof BgDataInfo && (treeMap = (bgDeclareClientHelper = new BgDeclareClientHelper()).getPartRecordByBgDataInfo(iRow, bgDataInfo = (BgDataInfo)obj)) != null && treeMap.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"bgPastRecord", (Object)treeMap);
            String strClassName = BgPastRecordEditUI.class.getName();
            try {
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(strClassName, (Map)uiContext, null, OprtState.VIEW);
                uiWindow.show();
            }
            catch (UIException e) {
                this.handUIException(e);
            }
        }
    }

    @Override
    protected void onKDWorkButtonView_actionPerformed(ActionEvent e) throws Exception {
        this.pastRecordShow();
    }

    protected void initDataByIntroduction() throws EASBizException, BOSException, SQLException {
        this.initBgFormInfo();
        if (!BgDeclareClientHelper.checkChildrenVlaid(this.bgTemplateInfoTotal.getId(), this.bgFormCollectionSub)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"templateNotMatch"));
            SysUtil.abort();
        }
        if (!BgDistributeEditHelper.checkBgCycleBigger(this.bgFormInfoTotal, this.bgFormCollectionSub)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"BgCycleNotSame"));
            SysUtil.abort();
        }
        if (this.bgFormInfoTotal.getBgType().getNumber().trim().compareToIgnoreCase(HRBUDGET) == 0) {
            this.checkHRBudget();
        }
        this.kDBizPromptBoxCurrency.setEnabledMultiSelection(true);
        BgFormEditHelper.bandCurrencyInfo(this.kDBizPromptBoxCurrency, this.bgTemplateInfoTotal);
        this.initKDTable(this.kdtDistributeData, this.bgTemplateInfoTotal);
    }

    private void initBgFormInfo() throws EASBizException, BOSException, SQLException {
        String id = this.getUIContext().get("ID").toString();
        ObjectUuidPK pk = new ObjectUuidPK(id);
        FullOrgUnitCollection inOrgs = (FullOrgUnitCollection)this.getUIContext().get("EditOrg");
        IBgFormDA iBgFormDa = BgFormDAFactory.getRemoteInstance();
        this.bgFormCollectionAll = iBgFormDa.getCollectionForDistribute((IObjectPK)pk, inOrgs, true);
        Iterator iter = this.bgFormCollectionAll.iterator();
        while (iter.hasNext()) {
            BgFormInfo tmpBgFormInfo = (BgFormInfo)iter.next();
            if (tmpBgFormInfo.getId() != null && tmpBgFormInfo.getId().toString().equals(id)) {
                this.bgFormInfoTotal = tmpBgFormInfo;
                this.editData = tmpBgFormInfo;
                this.bgSchemeInfo = tmpBgFormInfo.getBgScheme();
                this.bgTemplateInfoTotal = tmpBgFormInfo.getBgTemplate();
                this.orgUnitInfoTotal = tmpBgFormInfo.getOrgUnit();
            } else {
                this.bgFormCollectionSub.add(tmpBgFormInfo);
                this.orgUnitCollectionSub.add(tmpBgFormInfo.getOrgUnit());
            }
            this.orgUnitCollectionAll.add(tmpBgFormInfo.getOrgUnit());
        }
        iter = this.bgFormCollectionSub.iterator();
        String totalNumber = this.bgFormInfoTotal.getNumber();
        String totalName = this.bgFormInfoTotal.getName();
        while (iter.hasNext()) {
            BgFormInfo tmpBgFormInfo = (BgFormInfo)iter.next();
            if (tmpBgFormInfo.getId() != null) continue;
            this.setFormNumberAndName(tmpBgFormInfo);
            tmpBgFormInfo.setState(BgFormStateEnum.Edited);
        }
    }

    private void checkHRBudget() {
        this.checkDistributeConditionForHRBudget();
    }

    private void checkDistributeConditionForHRBudget() {
        BgSchemeInfo subScheme = null;
        int size = this.bgFormCollectionSub.size();
        for (int i = 0; i < size; ++i) {
            boolean offSpring;
            subScheme = this.bgFormCollectionSub.get(i).getBgScheme();
            if (subScheme == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"schemeNotMatch"));
                SysUtil.abort();
            }
            if (this.bgSchemeInfo.getId().toString().compareToIgnoreCase(subScheme.getId().toString()) == 0 || (offSpring = this.isOffSpring(this.bgSchemeInfo, subScheme))) continue;
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"schemeNotMatch"));
            SysUtil.abort();
        }
    }

    private boolean isOffSpring(BgSchemeInfo parentScheme, BgSchemeInfo scheme) {
        BgSchemeInfo tmpParent = null;
        String id = "";
        String parentId = parentScheme.getId().toString();
        while ((tmpParent = scheme.getParentScheme()) != null) {
            id = tmpParent.getId().toString();
            if (parentId.compareToIgnoreCase(id) == 0) {
                return true;
            }
            scheme = tmpParent;
        }
        return false;
    }

    private void setFormNumberAndName(BgFormInfo tmpBgFormInfo) throws BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String theNumber = null;
        try {
            theNumber = iCodingRuleManager.getNumber((IObjectValue)new BgTemplateInfo(), tmpBgFormInfo.getOrgUnit().getId().toString());
        }
        catch (Exception e) {
            theNumber = null;
        }
        if (theNumber == null) {
            theNumber = tmpBgFormInfo.getOrgUnit().getNumber() + "_" + tmpBgFormInfo.getBgType().getNumber() + "_" + BgHelper.getTimeString();
        }
        tmpBgFormInfo.setNumber(theNumber);
        tmpBgFormInfo.setName(tmpBgFormInfo.getOrgUnit().getName() + "_" + tmpBgFormInfo.getBgType().getName() + "_" + BgHelper.getTimeString());
    }

    public void initKDTable(KDTable kdtable, BgTemplateInfo bgTemplateInfo) {
        BgClientHelper.initBgFormTable_distribute(bgTemplateInfo, kdtable);
        if (this.orgUnitCollectionSub == null || this.orgUnitCollectionSub.size() == 0) {
            return;
        }
        this.bgDecClientHelper.insertOrgDim(kdtable, this.orgUnitCollectionAll, bgTemplateInfo, false);
        this.bgDistEditHelper.insertPercentColumn(bgTemplateInfo, this.kdtDistributeData);
        kdtable.getMergeManager().setMergeMode(0);
        this.bgDecClientHelper.setCurrentRowColorByOrg(kdtable, this.orgUnitInfoTotal);
        int colCount = kdtable.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            String strColKey = kdtable.getColumnKey(i);
            if (!strColKey.endsWith(PERCENT)) continue;
            kdtable.getColumn(i).setMergeable(false);
        }
        kdtable.getHeadMergeManager().setMergeMode(3);
        this.periodNodeVector = BgPeriodRange.getPeriodNodes(this.editData.getBgEntries());
        this.initKdtRelation(kdtable, this.editData, this.columnSubjectTable, this.periodNodeVector, this.orgUnitCollectionSub.size());
        kdtable.getMergeManager().setMergeMode(1);
    }

    public void initKdtRelation(KDTable table, BgFormInfo editData, Hashtable columnSubjectTable, Vector periodNodeVector, int size) {
        table.getScriptManager().addFunctionProvider((Object)new BgTemplateFormulaProxy(editData));
        columnSubjectTable = BgFormEditHelper.generateColumnSubjectTable(editData, table, periodNodeVector);
        BgFormEditHelper.initRowRelation(editData.getBgTemplate(), table, size);
    }

    public void onLoad() throws Exception {
        this.loadFields();
        this.setIcon();
        this.bgDecClientHelper.goLeaf(this.treePeriod);
        this.bgDecClientHelper.lockedRowByOrg(this.kdtDistributeData, this.orgUnitInfoTotal, this.bgTemplateInfoTotal, true);
        this.bgDecClientHelper.setColumnLocked(this.kdtDistributeData, this.bgTemplateInfoTotal, true);
        this.btnEdit.setVisible(false);
        this.refreshTree();
        int parentCycle = this.bgFormInfoTotal.getBgTemplate().getBgCycle().getValue();
        int m = this.bgFormCollectionSub.size();
        for (int i = 0; i < m; ++i) {
            BgFormInfo formInfo = this.bgFormCollectionSub.get(i);
            BgEntryCollection entryColl = formInfo.getBgEntries();
            int n = entryColl.size();
            for (int j = 0; j < n; ++j) {
                BgEntryInfo entryInfo = entryColl.get(j);
                if (entryInfo.getBgCycle().getValue() < parentCycle) {
                    entryInfo.setIsLeafPeriod(false);
                    continue;
                }
                entryInfo.setIsLeafPeriod(true);
            }
        }
    }

    public void setIcon() {
        this.btnSetApportion.setIcon(EASResource.getIcon((String)"imgTbtn_definedistributeratio"));
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnRemove.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
    }

    protected void setControlEditor() {
        this.kDWorkButtonViewPastRecord.setVisible(false);
    }

    @Override
    public void storeFields() {
        boolean isModifiableByJunior = this.bgFormInfoTotal.isModifiableByJunior();
        Iterator iterator = this.bgFormCollectionSub.iterator();
        while (iterator.hasNext()) {
            BgFormInfo bgFormInfoTemp = (BgFormInfo)iterator.next();
            bgFormInfoTemp.setModifiableByJunior(isModifiableByJunior);
        }
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    protected void initOldData(IObjectValue arg0) {
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.doSave();
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.doSave();
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    private void doSave() throws BOSException, EASBizException {
        int i;
        this.refreshTree();
        boolean isEqual = true;
        int nSave = 0;
        if (!isEqual) {
            nSave = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"valueNotEqualIsSave"));
        }
        if (nSave != 0) {
            SysUtil.abort();
        }
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        int size = this.bgFormCollectionSub.size();
        Hashtable<String, BgOperationEnum> hash = new Hashtable<String, BgOperationEnum>();
        String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsDistribute");
        this.checkState(this.bgFormInfoTotal, true, strMsg);
        for (int i2 = 0; i2 < size; ++i2) {
            BgFormInfo bgFormInfoTemp = this.bgFormCollectionSub.get(i2);
            this.checkState(bgFormInfoTemp, false, strMsg);
            this.bgDistEditHelper.splitNotListProjectToList(bgFormInfoTemp);
            bgFormInfoTemp.setDataSource(BgFormDataSourceEnum.SUPERIORSPLIT);
            bgFormInfoTemp.setState(BgFormStateEnum.Distributing);
            bgFormInfoTemp.setHasEffected(true);
            hash.put(bgFormInfoTemp.getOrgUnit().getId().toString(), BgOperationEnum.Distribute);
        }
        CtrlUnitInfo cuInfo = BgOrgHelper.getDefCU();
        for (i = 0; i < this.bgFormCollectionSub.size(); ++i) {
            this.bgFormCollectionSub.get(i).setCU(cuInfo);
        }
        int m = this.bgFormCollectionSub.size();
        for (i = 0; i < m; ++i) {
            BgFormInfo formInfo = this.bgFormCollectionSub.get(i);
            int cycle = formInfo.getBgTemplate().getBgCycle().getValue();
            BgEntryCollection entryColl = formInfo.getBgEntries();
            Object[] entryArray = entryColl.toArray();
            int n = entryArray.length;
            for (int j = 0; j < n; ++j) {
                BgEntryInfo entryInfo = (BgEntryInfo)entryArray[j];
                if (entryInfo.getBgCycle().getValue() > cycle) {
                    entryColl.remove(entryInfo);
                    continue;
                }
                if (entryInfo.getBgCycle().getValue() == cycle) {
                    entryInfo.setIsLeafPeriod(true);
                    continue;
                }
                if (entryInfo.getBgCycle().getValue() >= cycle) continue;
                entryInfo.setIsLeafPeriod(false);
            }
        }
        IObjectPK kdsPk = iBgForm.updateWithRecord_declare(this.bgFormCollectionSub, hash);
        IBgKDS iBgKDS = BgKDSFactory.getRemoteInstance();
        iBgKDS.distributeWF(BOSUuid.read((String)kdsPk.toString()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        this.getUIWindow().close();
    }

    private void reInitBgFormInfo() {
        this.bgFormCollectionSub.clear();
        this.bgFormCollectionAll.clear();
        try {
            this.initBgFormInfo();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    private void setScaleByOrgUnit(FullOrgUnitInfo currOrgUnit) {
        if (this.vecScale == null) {
            this.vecScale = this.bgDistEditHelper.getScaleCol(this.kdtDistributeData);
        }
        if (this.vecScale.size() == 0) {
            return;
        }
        DecimalFormat format = BgClientHelper.getDecimalFormat();
        int rowCount = this.kdtDistributeData.getRowCount();
        String strColumnKey = BgAssistantDimensionEnum.SUB_ORGUNIT.getName();
        for (int i = 0; i < rowCount; ++i) {
            IRow iRow = this.kdtDistributeData.getRow(i);
            FullOrgUnitInfo org = (FullOrgUnitInfo)iRow.getCell(strColumnKey).getUserObject();
            if (!org.getId().equals((Object)currOrgUnit.getId())) continue;
            for (int j = 0; j < this.vecScale.size(); ++j) {
                BigDecimal bigCurr;
                int columnIndex = (Integer)this.vecScale.elementAt(j);
                int colValueInex = columnIndex - 1;
                BigDecimal bigDecimal = bigCurr = iRow.getCell(colValueInex).getValue() instanceof BigDecimal ? (BigDecimal)iRow.getCell(colValueInex).getValue() : new BigDecimal((String)iRow.getCell(colValueInex).getValue());
                if (bigCurr.compareTo(new BigDecimal("0")) < 1) {
                    iRow.getCell(columnIndex).setValue((Object)format.format(new BigDecimal("0.00")));
                    continue;
                }
                iRow.getCell(columnIndex).setValue((Object)format.format(new BigDecimal("100.00")));
            }
        }
    }

    private BigDecimal getLowerBgValue(FullOrgUnitInfo orgUnitInfo, String orgColkey, int rowIndex, int colIndex) {
        IRow iRow;
        FullOrgUnitInfo org;
        BigDecimal bigSum = new BigDecimal("0");
        int rowCount = this.kdtDistributeData.getRowCount();
        for (int i = rowIndex + 1; i < rowCount && !(org = (FullOrgUnitInfo)(iRow = this.kdtDistributeData.getRow(i)).getCell(orgColkey).getUserObject()).getId().equals((Object)orgUnitInfo.getId()); ++i) {
            Object obj = iRow.getCell(colIndex).getValue();
            if (!(obj instanceof BigDecimal)) continue;
            bigSum = bigSum.add((BigDecimal)obj);
        }
        return bigSum;
    }

    protected void checkState(BgFormInfo bgForm, boolean isCurr, String strMsg) {
        BgFormStateHelper bsh = new BgFormStateHelper();
        int state = bgForm.getState().getValue();
        if (bgForm.getId() == null) {
            state = -1;
        }
        boolean isOk = false;
        boolean isProm = false;
        try {
            if (isCurr) {
                isOk = bsh.isDistCurrForm(state);
                isProm = bsh.isDistCurrProm(state);
            } else {
                isOk = bsh.isDistSubForm(state);
                isProm = bsh.isDistSubProm(state);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (!isOk) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strSub = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"SubBgForm");
            String strState = bgForm.getNumber() + ":" + bgForm.getState().getAlias();
            if (isProm) {
                int confirm = -1;
                confirm = isCurr ? MsgBox.showConfirm2((Component)((Object)this), (String)(str + strState + strResState + strMsg)) : MsgBox.showConfirm2((Component)((Object)this), (String)(strSub + strState + strResState + strMsg));
                if (confirm == 2) {
                    SysUtil.abort();
                }
            } else {
                String str1 = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotDistribute");
                if (isCurr) {
                    MsgBox.showInfo((Component)((Object)this), (String)(str + strState + strResState + str1));
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)(strSub + strState + strResState + str1));
                }
                SysUtil.abort();
            }
        }
    }
}

