/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgDistributeScaleEditUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Iterator;

public class BgDistributeScaleEditUI
extends AbstractBgDistributeScaleEditUI {
    public static final String SUBORGCOLLECTION = "SubOrgCollection";
    public static final String SIMPLESCALETABLE = "SimpleScaleTable";
    public static final String SCALETYPE = "ScaleType";
    public static final String SCALETYPE_LASTDECLARE = "LastDeclare";
    public static final String SCALETYPE_SIMPLESCALE = "SimpleScale";
    private Hashtable simpleScaleTable = null;
    private String scaleType = null;

    public void onLoad() throws Exception {
        this.kdtScale.checkParsed();
        super.onLoad();
        this.loadFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.simpleScaleTable = (Hashtable)this.getUIContext().get(SIMPLESCALETABLE);
        if (this.getUIContext().get(SUBORGCOLLECTION) instanceof FullOrgUnitCollection) {
            FullOrgUnitCollection orgCollection = (FullOrgUnitCollection)this.getUIContext().get(SUBORGCOLLECTION);
            this.initTable(orgCollection);
        } else {
            OrgUnitCollection orgs = (OrgUnitCollection)this.getUIContext().get(SUBORGCOLLECTION);
            this.initTable(orgs);
        }
    }

    private void initTable(FullOrgUnitCollection orgCollection) {
        this.kdtScale.removeRows();
        for (FullOrgUnitInfo orgInfo : orgCollection) {
            IRow row = this.kdtScale.addRow();
            row.getCell(0).setValue((Object)orgInfo.getName());
            row.getCell(0).setUserObject((Object)orgInfo);
            String strId = orgInfo.getId().toString();
            if (this.simpleScaleTable == null) continue;
            BigDecimal bigScale = (BigDecimal)this.simpleScaleTable.get(strId);
            row.getCell(1).setValue((Object)bigScale.toString());
        }
    }

    private void initTable(OrgUnitCollection orgCollection) {
        this.kdtScale.removeRows();
        Iterator iter = orgCollection.iterator();
        OrgUnitInfo orgInfo = null;
        while (iter.hasNext()) {
            orgInfo = (OrgUnitInfo)iter.next();
            IRow row = this.kdtScale.addRow();
            row.getCell(0).setValue((Object)orgInfo.getName());
            row.getCell(0).setUserObject((Object)orgInfo);
            String strId = orgInfo.getId().toString();
            if (this.simpleScaleTable == null) continue;
            BigDecimal bigScale = (BigDecimal)this.simpleScaleTable.get(strId);
            row.getCell(1).setValue((Object)bigScale.toString());
        }
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        int rowCount = this.kdtScale.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String value1 = (String)this.kdtScale.getRow(i).getCell(1).getValue();
            if (value1 == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"inputScale"));
                this.kdtScale.getEditManager().editCellAt(0, 1);
                return;
            }
            if (!BgClientHelper.verifyIsNumber(value1)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
                this.kdtScale.getEditManager().editCellAt(0, 1);
                return;
            }
            if (!BgClientHelper.verifyIsPlus(value1)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputPlus"));
                this.kdtScale.getEditManager().editCellAt(0, 1);
                return;
            }
            DecimalFormat format = BgClientHelper.getDecimalFormat();
            value1 = format.format(new BigDecimal(value1));
            this.kdtScale.getRow(i).getCell(1).setValue((Object)value1);
        }
        this.scaleType = SCALETYPE_SIMPLESCALE;
        this.simpleScaleTable = this.generateSimpleScaleTable();
        if (!this.checkScale()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgDistributeResource", (String)"errorScale"));
            SysUtil.abort();
        }
        this.getUIWindow().close();
    }

    private Hashtable generateSimpleScaleTable() {
        Hashtable<String, BigDecimal> result = new Hashtable<String, BigDecimal>();
        int size = this.kdtScale.getRowCount();
        for (int i = 0; i < size; ++i) {
            IRow row = this.kdtScale.getRow(i);
            FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)row.getCell(0).getUserObject();
            String scaleString = null;
            if (row.getCell(1).getValue() != null) {
                scaleString = row.getCell(1).getValue().toString();
            }
            if (scaleString == null) {
                scaleString = "0.00";
            }
            BigDecimal scaleValue = new BigDecimal(scaleString);
            result.put(orgInfo.getId().toString(), scaleValue);
        }
        return result;
    }

    private boolean checkScale() {
        int rowCount = this.kdtScale.getRowCount();
        float value = 0.0f;
        for (int i = 0; i < rowCount; ++i) {
            value += Float.parseFloat((String)this.kdtScale.getRow(i).getCell(1).getValue());
        }
        return !(value - 100.0f > 0.0f) && !(value - 100.0f < 0.0f);
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.scaleType = null;
        this.simpleScaleTable = null;
        this.getUIWindow().hide();
    }

    public String getScaleType() {
        return this.scaleType;
    }

    public Hashtable getSimpleScaleTable() {
        return this.simpleScaleTable;
    }

    public void setScaleType(String string) {
        this.scaleType = string;
    }

    public void setSimpleScaleTable(Hashtable hashtable) {
        this.simpleScaleTable = hashtable;
    }
}

