/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.ma.bg.BgElementInfo;
import com.kingdee.eas.ma.bg.BgTemplateColumnInfo;
import com.kingdee.eas.ma.bg.BgTemplateHelper;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JPanel;

public class BgElementF7SelectorForRpt
extends KDDialog
implements KDPromptSelector {
    protected boolean isOK = false;
    KDButton btnOk = null;
    KDButton btnCancel = null;
    Vector vec = null;
    FormulaWizardUI formulaWizardUI = null;
    private KDTable kdtable = null;
    private final String NUMBER = "number";
    private final String NAME = "name";
    private final String BGTYPE = "bgType";

    public BgElementF7SelectorForRpt() throws HeadlessException {
        this.setTitle(EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgItemF7SelectorResource", (String)"BgElement"));
        this.kdtable = this.initKDtable();
        this.kdtable.getStyleAttributes().setLocked(true);
        this.kdtable.setBounds(10, 20, 380, 200);
        this.kdtable.setVisible(true);
        KDPanel jp = new KDPanel();
        jp.setLayout(null);
        jp.add((Component)this.kdtable);
        String strConfirm = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"confirm");
        this.btnOk = new KDButton("OK");
        this.btnOk.setText(strConfirm);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgElementF7SelectorForRpt.this.close(true);
            }
        });
        this.btnOk.setEnabled(true);
        this.btnOk.setBounds(100, 230, 80, 26);
        jp.add((Component)this.btnOk);
        String strCancel = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"cancel");
        this.btnCancel = new KDButton("CANCEL");
        this.btnCancel.setText(strCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgElementF7SelectorForRpt.this.close(false);
            }
        });
        this.btnCancel.setBounds(200, 230, 80, 26);
        this.btnCancel.setEnabled(true);
        jp.add((Component)this.btnCancel);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        c.add((Component)jp, "Center");
        this.setSize(400, 300);
    }

    public boolean isCanceled() {
        return !this.isOK;
    }

    public Object getData() {
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            return iRow.getUserObject();
        }
        return null;
    }

    public static void main(String[] args) {
        BgElementF7SelectorForRpt bgElementF7Selector = new BgElementF7SelectorForRpt();
        bgElementF7Selector.show();
    }

    public Vector getVec() {
        return this.vec;
    }

    public void setVec(Vector vector) {
        this.vec = vector;
    }

    public void show() {
        this.setModal(true);
        if (this.getFormulaWizardUI() != null) {
            FormulaWizardUI wizard = this.getFormulaWizardUI();
            JPanel paramPanel = wizard.getParameterPane();
            KDTextField o1 = (KDTextField)paramPanel.getComponent(2);
            KDBizPromptBox box = (KDBizPromptBox)paramPanel.getComponent(1);
            String strOrgNumber = o1.getText();
            KDTextField o2 = (KDTextField)paramPanel.getComponent(5);
            String strBgTypeNumber = o2.getText();
            if (strOrgNumber.equals("") || strBgTypeNumber.equals("")) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgItemF7SelectorResource", (String)"NoOrgAndBgType"));
                SysUtil.abort();
            }
            FullOrgUnitInfo org = (FullOrgUnitInfo)box.getValue();
            this.putDataToKDTable(strBgTypeNumber, strOrgNumber, org);
        }
        super.show();
    }

    private void close(boolean isOk) {
        int currRow = this.kdtable.getSelectManager().getActiveRowIndex();
        if (currRow != -1) {
            IRow iRow = this.kdtable.getRow(currRow);
            BgElementInfo bgElementInfo = (BgElementInfo)iRow.getUserObject();
            this.getFormulaWizardUI().setDataObject("bgElement", (IObjectValue)bgElementInfo);
        }
        this.isOK = isOk;
        this.setVisible(false);
    }

    public KDTable initKDtable() {
        if (this.kdtable == null) {
            this.kdtable = new KDTable();
        }
        this.kdtable.checkParsed();
        IColumn iColumn = this.kdtable.addColumn();
        iColumn.setKey("number");
        IColumn iColumn1 = this.kdtable.addColumn();
        iColumn1.setKey("name");
        IColumn iColumn2 = this.kdtable.addColumn();
        iColumn2.setKey("bgType");
        IRow iRow = this.kdtable.addHeadRow();
        String strNumber = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"number");
        String strName = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"name");
        String strBgtype = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"bgType");
        iRow.getCell("number").setValue((Object)strNumber);
        iRow.getCell("name").setValue((Object)strName);
        iRow.getCell("bgType").setValue((Object)strBgtype);
        this.kdtable.getSelectManager().setSelectMode(2);
        return this.kdtable;
    }

    public void putDataToKDTable(String strBgTypeNumber, String strOrgNumber, FullOrgUnitInfo org) {
        block7: {
            try {
                if (strBgTypeNumber == null || strBgTypeNumber.length() == 0) {
                    String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                    MsgBox.showWarning((Component)((Object)this), (String)strErr);
                    return;
                }
                IBgType iBgType = BgTypeFactory.getRemoteInstance();
                BgTypeInfo bgTypeInfo = iBgType.getValueByNumber(strBgTypeNumber);
                if (bgTypeInfo != null) {
                    BgTemplateInfo bgTemplateInfo = BgTemplateHelper.findTempByBgTypeAndOrgNum(bgTypeInfo, org);
                    if (bgTemplateInfo == null) {
                        return;
                    }
                    Iterator iterator = bgTemplateInfo.getBgTpColumns().iterator();
                    this.kdtable.removeRows();
                    while (iterator.hasNext()) {
                        BgTemplateColumnInfo bgTemplateColumnInfo = (BgTemplateColumnInfo)iterator.next();
                        BgElementInfo bgElementInfo = bgTemplateColumnInfo.getBgElement();
                        IRow iRow = this.kdtable.addRow();
                        iRow.setUserObject((Object)bgElementInfo);
                        ICell iCell1 = iRow.getCell("number");
                        iCell1.setValue((Object)bgElementInfo.getNumber());
                        ICell iCell2 = iRow.getCell("name");
                        iCell2.setValue((Object)bgElementInfo.getName());
                        ICell iCell3 = iRow.getCell("bgType");
                        iCell3.setValue((Object)bgTypeInfo.getName());
                    }
                    break block7;
                }
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSchemeResource", (String)"pleaseSelectBgType");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                return;
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public FormulaWizardUI getFormulaWizardUI() {
        return this.formulaWizardUI;
    }

    public void setFormulaWizardUI(FormulaWizardUI wizardUI) {
        this.formulaWizardUI = wizardUI;
    }
}

