/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgClientUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.bg.BgExchangeRateException;
import com.kingdee.eas.ma.bg.BgExchangeRateFactory;
import com.kingdee.eas.ma.bg.BgExchangeRateInfo;
import com.kingdee.eas.ma.bg.client.AbstractBgExchangeRateEdit;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class BgExchangeRateEdit
extends AbstractBgExchangeRateEdit {
    private ICompanyOrgUnit com;
    private ResourceBundleHelper myResHelper = new ResourceBundleHelper(BgExchangeRateEdit.class.getName());
    public int editYear = 0;
    public int editNumber = 0;
    public DecimalFormat format = BgClientHelper.getDecimalFormat(4);

    @Override
    public void loadFields() {
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnSubmit.setVisible(true);
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        OrgClientUtils.setOrgPrompt((IUIObject)this, (KDBizPromptBox)this.bizPromptCompany, (OrgType[])CompanyType, (boolean)false);
        super.loadFields();
        this.dteCreate.setValue((Object)new Date(System.currentTimeMillis()));
        this.bizPromptCreator.setData(SysContext.getSysContext().getCurrentUser());
        if ("ADDNEW".equals(this.getOprtState())) {
            BgClientHelper.initDefaultCreator(this.bizPromptCreator);
            try {
                String id = (String)SysContext.getSysContext().getProperty((Object)"CurCompanyId");
                if (id != null && !id.equals("")) {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitInfo info = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id));
                    this.bizPromptCompany.setValue((Object)info);
                }
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            this.ftxtRate.setText(new BigDecimal("1").toString());
        } else {
            if (this.editData.getValidPeriodFrom() != null && this.editData.getValidPeriodTo() != null) {
                this.ftxtValidYearFrom.setValue((Object)new Integer(this.editData.getValidPeriodFrom().getPeriodYear()));
                this.ftxtValidPeriodFrom.setValue((Object)new Integer(this.editData.getValidPeriodFrom().getPeriodNumber()));
                this.ftxtValidYearTo.setValue((Object)new Integer(this.editData.getValidPeriodTo().getPeriodYear()));
                this.ftxtValidPeriodTo.setValue((Object)new Integer(this.editData.getValidPeriodTo().getPeriodNumber()));
            }
            this.ftxtRate.setText(this.format.format(this.editData.getRate()));
        }
    }

    @Override
    public void storeFields() {
        try {
            super.storeFields();
            this.editData.setCreator((UserInfo)this.bizPromptCreator.getData());
            this.editData.setCreateTime(this.dteCreate.getTimestamp());
        }
        catch (Exception e) {
            e.getMessage();
        }
        try {
            this.storePeriod();
        }
        catch (Exception e) {
            this.handUIException(e);
            SysUtil.abort();
        }
        try {
            this.editData.setRate(new BigDecimal(this.ftxtRate.getText().toString()));
        }
        catch (NumberFormatException e) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"inputNumber"));
            SysUtil.abort();
        }
    }

    private void storePeriod() throws EASBizException, BOSException {
        if (this.editData.getCompany() == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = this.editData.getCompany();
        PeriodInfo periodDefault = PeriodUtils.getPeriodInfo((Date)new Date(System.currentTimeMillis()), (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo periodFrom = PeriodUtils.getPeriodInfo((int)((Integer)this.ftxtValidYearFrom.getValue()), (int)((Integer)this.ftxtValidPeriodFrom.getValue()), (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo periodTo = PeriodUtils.getPeriodInfo((int)((Integer)this.ftxtValidYearTo.getValue()), (int)((Integer)this.ftxtValidPeriodTo.getValue()), (CompanyOrgUnitInfo)companyInfo);
        if (periodFrom == null || periodTo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"InvalidPeriod"));
            SysUtil.abort();
        }
        if (!PeriodUtils.PeriodCompare((PeriodInfo)periodTo, (PeriodInfo)periodDefault)) {
            throw new BgExchangeRateException(BgExchangeRateException.ENDSMALLDEFAULT);
        }
        this.editData.setValidPeriodFrom(periodFrom);
        this.editData.setValidPeriodTo(periodTo);
        this.editData.setValidTimeFrom(new Timestamp(periodFrom.getBeginDate().getTime()));
        this.editData.setValidTimeTo(new Timestamp(periodTo.getEndDate().getTime()));
    }

    protected IObjectValue createNewData() {
        return new BgExchangeRateInfo();
    }

    protected ICoreBase getBizInterface() throws BOSException {
        return BgExchangeRateFactory.getRemoteInstance();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.editData.getCompany() == null) {
            this.bizPromptCompany.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"companyNull"));
            SysUtil.abort();
        }
        if (this.editData.getSrcCurrency() == null) {
            this.bizPromptSrcCurrency.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"srcCurrencyNull"));
            SysUtil.abort();
        }
        if (this.editData.getDesCurrency() == null) {
            this.bizPromptDesCurrency.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"desCurrencyNull"));
            SysUtil.abort();
        }
        if (this.editData.getRate() == null) {
            this.ftxtRate.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"rateNull"));
            SysUtil.abort();
        }
        this.checkRate();
        if (this.editData.getRate().compareTo(new BigDecimal("0")) != 1) {
            this.ftxtRate.requestFocus(true);
            throw new BgExchangeRateException(BgExchangeRateException.INVALIDRATE);
        }
        this.verifyPeriod();
        if (this.editData.getCreator() == null) {
            this.bizPromptCreator.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"creator")});
        }
    }

    private void verifyPeriod() throws Exception {
        int beginYear = (Integer)this.ftxtValidYearFrom.getValue();
        int beginNumber = (Integer)this.ftxtValidPeriodFrom.getValue();
        int endYear = (Integer)this.ftxtValidYearTo.getValue();
        int endNumber = (Integer)this.ftxtValidPeriodTo.getValue();
        if (beginYear > endYear || beginYear == endYear && beginNumber > endNumber) {
            this.ftxtValidYearFrom.requestFocus(true);
            throw new BgExchangeRateException(BgExchangeRateException.BEGINBIGGEREND);
        }
        if (this.getOprtState().equals("EDIT")) {
            this.ftxtValidYearTo.requestFocus(true);
            if (endYear < this.editYear || endYear == this.editYear && endNumber < this.editNumber) {
                throw new BgExchangeRateException(BgExchangeRateException.ENDSMALLDEFAULT1);
            }
        }
    }

    @Override
    protected void bizPromptDesCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptDesCurrency_dataChanged(e);
        if (!this.bizPromptDesCurrency.isEnabled()) {
            return;
        }
        if (this.checkIsSameCurrency()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"ErrorDesSrcEqual"));
            this.bizPromptDesCurrency.setData(null);
            return;
        }
        this.setDefaultExChangeRate();
    }

    @Override
    protected void bizPromptSrcCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptSrcCurrency_dataChanged(e);
        if (!this.bizPromptSrcCurrency.isEnabled()) {
            return;
        }
        if (this.checkIsSameCurrency()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"ErrorSrcDesEqual"));
            this.bizPromptDesCurrency.setData(null);
            return;
        }
        this.setDefaultExChangeRate();
    }

    private boolean checkIsSameCurrency() {
        boolean result = false;
        if (this.bizPromptSrcCurrency.getData() != null && this.bizPromptDesCurrency.getData() != null) {
            CurrencyInfo srcCyInfo = (CurrencyInfo)this.bizPromptSrcCurrency.getData();
            CurrencyInfo desCyInfo = (CurrencyInfo)this.bizPromptDesCurrency.getData();
            result = srcCyInfo.getId().equals((Object)desCyInfo.getId());
        }
        return result;
    }

    protected void setDefaultExChangeRate() throws EASBizException, BOSException {
        if (!"ADDNEW".equals(this.getOprtState())) {
            return;
        }
        if (this.bizPromptCompany.getData() == null || this.bizPromptSrcCurrency.getData() == null || this.bizPromptDesCurrency.getData() == null) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)this.bizPromptCompany.getData();
        CurrencyInfo srcCyInfo = (CurrencyInfo)this.bizPromptSrcCurrency.getData();
        CurrencyInfo desCyInfo = (CurrencyInfo)this.bizPromptDesCurrency.getData();
        ExchangeTableInfo exchangeTableInfo = companyInfo.getBaseExchangeTable();
        if (exchangeTableInfo == null) {
            if (this.com == null) {
                this.com = CompanyOrgUnitFactory.getRemoteInstance();
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getId());
            companyInfo = this.com.getCompanyOrgUnitInfo((IObjectPK)pk, sic);
            exchangeTableInfo = companyInfo.getBaseExchangeTable();
        }
        if (exchangeTableInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"ErrorNoExTable"));
            this.ftxtRate.setText("0");
            return;
        }
        IExchangeRate iExchangeRate = ExchangeRateFactory.getRemoteInstance();
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = iExchangeRate.getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableInfo.getId()), (IObjectPK)new ObjectUuidPK(srcCyInfo.getId()), (IObjectPK)new ObjectUuidPK(desCyInfo.getId()), null);
        if (exchangeRateInfo != null) {
            if (exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                this.ftxtRate.setText(this.format.format(1.0f / exchangeRateInfo.getConvertRate().floatValue()));
            } else if (exchangeRateInfo.getExchangeAux().getConvertMode().equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                this.ftxtRate.setText(this.format.format(exchangeRateInfo.getConvertRate()));
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgExchangeRateResource", (String)"ErrorNoRate"));
            this.ftxtRate.setText("0");
        }
    }

    @Override
    protected void bizPromptCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptCompany_dataChanged(e);
        if (!this.bizPromptCompany.isEnabled()) {
            return;
        }
        if (this.bizPromptCompany.getData() == null) {
            return;
        }
        this.setDefaultExChangeRate();
        Date now = new Date(System.currentTimeMillis());
        PeriodInfo periodInfo = null;
        try {
            periodInfo = PeriodUtils.getPeriodInfo((Date)now, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.bizPromptCompany.getValue()));
        }
        catch (NullPointerException e1) {
            throw new BgExchangeRateException(BgExchangeRateException.NOPERIOD);
        }
        if (periodInfo == null) {
            throw new BgExchangeRateException(BgExchangeRateException.NOPERIOD);
        }
        this.ftxtValidYearFrom.setValue((Object)new Integer(periodInfo.getPeriodYear()));
        this.ftxtValidPeriodFrom.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
        this.ftxtValidYearTo.setValue((Object)new Integer(periodInfo.getPeriodYear() + 1));
        this.ftxtValidPeriodTo.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
    }

    public boolean checkBeforeWindowClosing() {
        return true;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("rate"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("validPeriodFrom.*"));
        sic.add(new SelectorItemInfo("validPeriodTo.*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("srcCurrency.id"));
        sic.add(new SelectorItemInfo("srcCurrency.number"));
        sic.add(new SelectorItemInfo("srcCurrency.name"));
        sic.add(new SelectorItemInfo("desCurrency.id"));
        sic.add(new SelectorItemInfo("desCurrency.number"));
        sic.add(new SelectorItemInfo("desCurrency.name"));
        return sic;
    }

    public void onLoad() throws Exception {
        this.configTimeSpinner(this.ftxtValidYearFrom, true);
        this.configTimeSpinner(this.ftxtValidYearTo, true);
        this.configTimeSpinner(this.ftxtValidPeriodFrom, false);
        this.configTimeSpinner(this.ftxtValidPeriodTo, false);
        this.bizPromptCompany.setEnabled(false);
        super.onLoad();
        if (!this.getOprtState().equals("ADDNEW") && this.getOprtState().equals("EDIT")) {
            this.editYear = (Integer)this.ftxtValidYearTo.getValue();
            this.editNumber = (Integer)this.ftxtValidPeriodTo.getValue();
        }
    }

    private void configTimeSpinner(KDSpinner spinner, boolean b) {
        if (b) {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            SpinnerNumberModel numberModel = new SpinnerNumberModel(year, 1000, 3000, 1);
            spinner.setModel((SpinnerModel)numberModel);
        } else {
            SpinnerNumberModel numberModel = new SpinnerNumberModel(1, 1, 30, 1);
            spinner.setModel((SpinnerModel)numberModel);
        }
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor((JSpinner)spinner);
        DecimalFormat decFormat = numberEditor.getFormat();
        decFormat.setDecimalSeparatorAlwaysShown(false);
        decFormat.setGroupingUsed(false);
        decFormat.setMaximumIntegerDigits(4);
        decFormat.setMaximumFractionDigits(0);
        JFormattedTextField tempFtf = numberEditor.getTextField();
        NumberFormatter numFormatter = (NumberFormatter)tempFtf.getFormatter();
        numFormatter.setAllowsInvalid(false);
        numFormatter.setOverwriteMode(true);
        ((DefaultFormatterFactory)tempFtf.getFormatterFactory()).setEditFormatter(numFormatter);
        tempFtf.setFormatterFactory(tempFtf.getFormatterFactory());
        spinner.setEditor((JComponent)numberEditor);
    }

    @Override
    protected void ftxtRate_focusLost(FocusEvent e) throws Exception {
        super.ftxtRate_focusLost(e);
    }

    private void checkRate() {
        String value = this.ftxtRate.getText();
        if (!BgClientHelper.verifyIsNumber(value = this.format.format(new BigDecimal(value)))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"inputNumber"));
            this.ftxtRate.requestFocus();
            this.ftxtRate.setText(value);
            SysUtil.abort();
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.getUIWindow().close();
    }
}

