/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.client.AbstractBgFormDeclareEditUI;
import com.kingdee.eas.ma.bg.client.BgFormEditHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Hashtable;

public class BgFormDeclareEditUI
extends AbstractBgFormDeclareEditUI {
    @Override
    public void loadFields() {
        BgFormEditHelper.loadFields(this);
        this.kdtBgFormData.getDataRequestManager().setDataRequestMode(0);
        this.kdtBgFormData.getMergeManager().setMergeMode(0);
        this.kdtBgFormData.getGroupManager().setGroup(true);
        if (!this.editData.getBgType().isIsRptBgForm()) {
            for (int i = 0; i < this.editData.getBgTemplate().getVisibleDims().size(); ++i) {
                this.kdtBgFormData.getColumn(i).setGroup(true);
                this.kdtBgFormData.getColumn(i).setMergeable(true);
            }
        }
    }

    @Override
    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        BgTypeInfo inBgTypeInfo = (BgTypeInfo)this.getUIContext().get("BgType");
        if (inBgTypeInfo == null) {
            StringBuffer sb = new StringBuffer(128);
            sb.append(" select ");
            sb.append(" T.FID, T.FNumber, T.FName_");
            sb.append(SysContext.getSysContext().getLocale());
            sb.append(" AS FName from t_bg_bgform F ");
            sb.append(" inner join t_bg_bgtype T on F.FBgTypeID = T.FID");
            sb.append(" where  F.fid='");
            sb.append(this.getUIContext().get("ID"));
            sb.append("'");
            ISQLExecutor excu = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
            IRowSet rs = excu.executeSQL();
            rs.beforeFirst();
            if (rs.next()) {
                inBgTypeInfo = new BgTypeInfo();
                inBgTypeInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                inBgTypeInfo.setName(rs.getString("FName"));
                inBgTypeInfo.setNumber(rs.getString("FNumber"));
            }
        }
        this.bgTypeNumber = inBgTypeInfo.getNumber();
        FullOrgUnitCollection inOrgs = (FullOrgUnitCollection)this.getUIContext().get("EditOrg");
        IBgFormDA iBgFormDA = BgFormDAFactory.getRemoteInstance();
        BgFormInfo info = iBgFormDA.getBgFormForDecalre(pk, inOrgs);
        return info;
    }

    @Override
    protected void doSave(ActionEvent e) throws Exception {
        try {
            this.checkBgFormValid();
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            IBgFormDA iBgFormDa = BgFormDAFactory.getRemoteInstance();
            Hashtable<String, BgOperationEnum> hash = new Hashtable<String, BgOperationEnum>();
            BgFormCollection bgFormCollection = new BgFormCollection();
            this.editData.setDataSource(BgFormDataSourceEnum.SUBORDINATEDECLARE);
            this.editData.setState(BgFormStateEnum.Edited);
            bgFormCollection.add(this.editData);
            hash.put(this.editData.getOrgUnit().getId().toString(), BgOperationEnum.Gather);
            iBgForm.updateWithRecord_declare(bgFormCollection, hash);
            IBgKDS iBgKDS = BgKDSFactory.getRemoteInstance();
            iBgKDS.updateBgForm(this.editData.getId());
            iBgFormDa.updateBgFormStatus((IObjectPK)new ObjectUuidPK(this.editData.getId()), BgFormStateEnum.Edited);
            this.save = true;
        }
        catch (BOSException ex) {
            this.handUIException(ex);
        }
        catch (EASBizException ex) {
            this.handUIException(ex);
        }
    }

    private void checkBgFormValid() {
        BgFormStateEnum bgFormState = this.editData.getState();
        if (bgFormState.getValue() == 2 || bgFormState.getValue() == 5 || bgFormState.getValue() == 7 || bgFormState.getValue() == 14 || bgFormState.getValue() == 4) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"curBgForm");
            str = str + bgFormState.toString();
            str = str + EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"canNotBeDeclared");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            SysUtil.abort();
        }
    }
}

