/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.ma.bg.BgCycleTypeEnum;
import com.kingdee.eas.ma.bg.BgDisHelper;
import com.kingdee.eas.ma.bg.BgFormCollection;
import com.kingdee.eas.ma.bg.BgFormDAFactory;
import com.kingdee.eas.ma.bg.BgFormFactory;
import com.kingdee.eas.ma.bg.BgFormHelper;
import com.kingdee.eas.ma.bg.BgFormInfo;
import com.kingdee.eas.ma.bg.BgFormLogHelper;
import com.kingdee.eas.ma.bg.BgFormProcessFactory;
import com.kingdee.eas.ma.bg.BgFormStateEnum;
import com.kingdee.eas.ma.bg.BgFormStateHelper;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgKDSFactory;
import com.kingdee.eas.ma.bg.BgOperationEnum;
import com.kingdee.eas.ma.bg.BgSchemeInfo;
import com.kingdee.eas.ma.bg.BgSplitFactory;
import com.kingdee.eas.ma.bg.BgTemplateCollection;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeFactory;
import com.kingdee.eas.ma.bg.BgTypeHelper;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.BgV2DistributeFactory;
import com.kingdee.eas.ma.bg.IBgForm;
import com.kingdee.eas.ma.bg.IBgFormDA;
import com.kingdee.eas.ma.bg.IBgFormProcess;
import com.kingdee.eas.ma.bg.IBgKDS;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgType;
import com.kingdee.eas.ma.bg.IBgV2Distribute;
import com.kingdee.eas.ma.bg.client.AbstractBgFormListUI;
import com.kingdee.eas.ma.bg.client.BgClientHelper;
import com.kingdee.eas.ma.bg.client.BgDistributeScaleEditUI;
import com.kingdee.eas.ma.bg.client.BgFormSplitEditUI;
import com.kingdee.eas.ma.bg.client.BgSetSplitRateUI;
import com.kingdee.eas.ma.bg.client.BgSubOrgUnitSelectorUI;
import com.kingdee.eas.ma.bg.client.BgV2FormEditUI;
import com.kingdee.eas.ma.bg.client.BgV2FormHeadUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class BgFormListUI
extends AbstractBgFormListUI {
    BgTypeInfo selectedBgTypeInfo;
    private int state;

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        try {
            queryExecutor.setParameter(1, (Object)this.getOrgUnitId());
        }
        catch (BOSException e) {
            e.getMessage();
        }
        return queryExecutor;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddNewV2_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgV2FormEditUI.class.getName();
    }

    protected String getMyEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    private void initSelectedBgTypeInfo() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null) {
            return;
        }
        int rowIndex = selectBlock.getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("bgType.id").getValue();
        String number = (String)row.getCell("bgType.number").getValue();
        String name = (String)row.getCell("bgType.name").getValue();
        this.selectedBgTypeInfo = new BgTypeInfo();
        this.selectedBgTypeInfo.setId(BOSUuid.read((String)id));
        this.selectedBgTypeInfo.setNumber(number);
        this.selectedBgTypeInfo.setName(name);
    }

    public void checkEnable(OrgUnitCollection orgs) throws EASBizException, BOSException {
        boolean isGroupModel = BgHelper.isGroupModel();
        this.initSelectedBgTypeInfo();
        if (!isGroupModel) {
            this.checkBgTypeForDisperseModel(this.selectedBgTypeInfo);
            for (int i = 0; i < orgs.size(); ++i) {
                OrgUnitInfo orgUnitInfo = orgs.get(i);
                if (!orgUnitInfo.isIsCompanyOrgUnit()) continue;
                String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"CanNotToSubCompany");
                MsgBox.showWarning((Component)((Object)this), (String)strErr);
                SysUtil.abort();
            }
        }
    }

    public void checkBgTypeForDisperseModel(BgTypeInfo bgTypeInfo) throws EASBizException, BOSException {
        boolean isPass = true;
        String strNum = bgTypeInfo.getNumber();
        if (strNum.equals("IncomeBudget") || strNum.equals("ExpenseBudget") || strNum.equals("AccountBudget") || strNum.equals("ProjectBudget")) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"CanNotDeclareInDisperseModel");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
    }

    @Override
    public void actionDispose_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        int orgView = (Integer)orgUnitInfo.get("treeType");
        OrgUnitCollection subOrgs = this.getDisposeSubOrgs(orgUnitInfo.getId().toString(), OrgViewType.getEnum((int)orgView));
        if (subOrgs == null || subOrgs.size() == 0) {
            return;
        }
        this.checkEnable(subOrgs);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"SubOrgCollection", (Object)subOrgs);
        Hashtable simpleScaleTable = null;
        uiContext.put((Object)"SimpleScaleTable", simpleScaleTable);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgDistributeScaleEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        simpleScaleTable = ((BgDistributeScaleEditUI)uiWindow.getUIObject()).getSimpleScaleTable();
        if (simpleScaleTable == null) {
            SysUtil.abort();
        }
        SimpleTimer timer = new SimpleTimer();
        String formId = this.getSelectedKeyValue();
        IBgV2Distribute iBgDis = BgV2DistributeFactory.getRemoteInstance();
        BgFormInfo bgFormTotal = iBgDis.getBgFormForDisChk(formId);
        BgTemplateInfo bgTemplateInfoTotal = bgFormTotal.getBgTemplate();
        BgSchemeInfo bgSchemeInfo = bgFormTotal.getBgScheme();
        FullOrgUnitInfo org2 = null;
        IBgFormDA iBgDa = BgFormDAFactory.getRemoteInstance();
        BgFormCollection coll = new BgFormCollection();
        for (FullOrgUnitInfo org2 : subOrgs) {
            BgFormInfo subBgFormInfo = iBgDis.getBgFormForDisChk(bgFormTotal.getBgType().getId().toString(), org2.getId().toString(), bgSchemeInfo.getId().toString(), bgTemplateInfoTotal.getId().toString());
            if (subBgFormInfo == null) continue;
            coll.add(subBgFormInfo);
            this.checkDistState(subBgFormInfo, false);
            if (!BgDisHelper.checkChildrenVlaid(bgTemplateInfoTotal.getId(), coll)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u4e0b\u7ea7\u6ca1\u6709\u5f15\u7528\u4e0a\u7ea7\u7684\u6a21\u677f\u6216\u8005\u4e0b\u7ea7\u7684\u6a21\u677f\u4e0d\u662f\u4ece\u4e0a\u7ea7\u6a21\u677f\u5206\u914d\u800c\u6765\uff01");
                SysUtil.abort();
            }
            if (!BgDisHelper.checkBgCycleBigger(bgFormTotal, coll)) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u4e0a\u4e0b\u7ea7\u9884\u7b97\u6a21\u677f\u7f16\u5236\u5468\u671f\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5206\u89e3\uff01");
                SysUtil.abort();
            }
            if (subBgFormInfo.getId() != null) {
                IBgKDS iBgKDS = BgKDSFactory.getRemoteInstance();
                iBgKDS.updateBgFormState(subBgFormInfo.getId(), 8);
            }
            coll.clear();
        }
        IBgFormProcess iPross = BgFormProcessFactory.getRemoteInstance();
        iPross.distributeBgForm(formId, subOrgs, simpleScaleTable);
        System.out.println("-----------------distribute time: " + timer.getTime());
        MsgBox.showInfo((Component)((Object)this), (String)"\u5206\u89e3\u6210\u529f\uff01");
    }

    public void checkDistState(BgFormInfo bgForm, boolean isCurr) throws BOSException, EASBizException {
        BgFormStateHelper bsh = new BgFormStateHelper();
        int state = bgForm.getState().getValue();
        if (bgForm.getId() == null) {
            state = -1;
        }
        boolean isOk = false;
        boolean isProm = false;
        if (isCurr) {
            isOk = bsh.isDistCurrForm(state);
            isProm = bsh.isDistCurrProm(state);
        } else {
            isOk = bsh.isDistSubForm(state);
            isProm = bsh.isDistSubProm(state);
        }
        if (!isOk && !isProm) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strSub = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"SubBgForm");
            String strState = bgForm.getNumber() + ":" + bgForm.getState().getAlias();
            String str1 = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotDistribute");
            if (isCurr) {
                MsgBox.showInfo((Component)((Object)this), (String)(str + strState + strResState + str1));
                SysUtil.abort();
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)(strSub + strState + strResState + str1));
                SysUtil.abort();
            }
        }
    }

    private String waringMessage(FullOrgUnitCollection orgUnitCollectionSub) {
        BgTypeInfo bgTypeInfo = this.getSelectedBgType();
        String typeName = bgTypeInfo.getName();
        String orgType = "";
        String strTmp = null;
        for (int i = 0; i < orgUnitCollectionSub.size(); ++i) {
            strTmp = NewOrgViewHelper.convert((OrgViewType)OrgViewType.getEnum((int)((Integer)orgUnitCollectionSub.get(i).get("treeType")))).getAlias();
            if (orgType.indexOf(strTmp) != -1) continue;
            orgType = orgType + strTmp + ",";
        }
        orgType = orgType.substring(0, orgType.length() - 1);
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"CantDistribute");
        return typeName + "<--->" + orgType + ":" + msg;
    }

    @Override
    public void actionDeclare_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        int orgView = (Integer)orgUnitInfo.get("treeType");
        OrgUnitCollection subOrgs = this.getDeclareSubOrgs(orgUnitInfo.getId().toString(), OrgViewType.getEnum((int)orgView));
        if (subOrgs == null || subOrgs.size() == 0) {
            return;
        }
        this.checkCanBeDeclaredorSplited(this.getSelectedBgType(), (OrgUnitInfo)orgUnitInfo, subOrgs, true);
        this.checkEnable(subOrgs);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        FullOrgUnitCollection coll = new FullOrgUnitCollection();
        for (int i = 0; i < subOrgs.size(); ++i) {
            coll.add((FullOrgUnitInfo)subOrgs.get(i));
        }
        uiContext.put((Object)"EditOrg", (Object)coll);
        uiContext.put((Object)"permi_org", (Object)this.getBGOrgUnitInfo());
        String bgFormId = this.getSelectedKeyValue();
        ArrayList<String> subBgFormIdList = new ArrayList<String>();
        IBgV2Distribute iBgDis = BgV2DistributeFactory.getRemoteInstance();
        BgFormInfo bgFormTotal = iBgDis.getBgFormForDisChk(bgFormId);
        BgFormStateEnum bgFormState = bgFormTotal.getState();
        if (bgFormState.getValue() == 2 || bgFormState.getValue() == 5 || bgFormState.getValue() == 7 || bgFormState.getValue() == 14 || bgFormState.getValue() == 4) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"curBgForm");
            str = str + bgFormState.toString();
            str = str + EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"canNotBeDeclared");
            MsgBox.showInfo((Component)((Object)this), (String)str);
            SysUtil.abort();
        }
        BgTemplateInfo bgTemplateInfoTotal = bgFormTotal.getBgTemplate();
        BgSchemeInfo bgSchemeInfo = bgFormTotal.getBgScheme();
        FullOrgUnitInfo org2 = null;
        for (FullOrgUnitInfo org2 : subOrgs) {
            BgFormInfo subBgFormInfo = iBgDis.getBgFormForDisChk(bgFormTotal.getBgType().getId().toString(), org2.getId().toString(), bgSchemeInfo.getId().toString(), bgTemplateInfoTotal.getId().toString());
            if (subBgFormInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)"\u4e0b\u7ea7\u6ca1\u6709\u9884\u7b97\u8868\uff01");
                SysUtil.abort();
                continue;
            }
            if (subBgFormInfo.getState().getValue() == 10) {
                MsgBox.showWarning((Component)((Object)this), (String)("\u4e0b\u7ea7\u6709\u9884\u7b97\u8868\u4e3a" + (Object)((Object)subBgFormInfo.getState()) + "\u72b6\u6001\uff0c\u4e0d\u80fd\u6c47\u603b\uff01"));
                SysUtil.abort();
                continue;
            }
            subBgFormIdList.add(subBgFormInfo.getId().toString());
        }
        IBgFormProcess iPross = BgFormProcessFactory.getRemoteInstance();
        iPross.declareBgForm(bgFormId, subBgFormIdList);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"state", (Object)new Integer(this.state));
        uiContext.put((Object)"BgType", (Object)this.getSelectedBgType());
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        IUIWindow popUI = UIFactory.createUIFactory((String)this.getMyEditUIModal()).create(BgV2FormEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        popUI.show();
    }

    private OrgUnitCollection getDisposeSubOrgs(String ouID, OrgViewType orgView) throws EASBizException, BOSException {
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCollectionSub = iNew.getChildren(ouID, orgView);
        if (orgUnitCollectionSub == null || orgUnitCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"NoSubOrg"));
            return null;
        }
        OrgUnitCollection orgUnitFilterCollectionSub = new OrgUnitCollection();
        if (orgUnitCollectionSub.size() > 0) {
            orgUnitFilterCollectionSub = BgTypeHelper.getOrgUnitCollByBgType(this.getSelectedBgType(), orgUnitCollectionSub);
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitFilterCollectionSub);
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSubOrgUnitSelectorUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        return ((BgSubOrgUnitSelectorUI)orgSelectorUI.getUIObject()).getOrgUnitCollectionSub();
    }

    private OrgUnitCollection getDeclareSubOrgs(String ouID, OrgViewType orgView) throws EASBizException, BOSException {
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCollectionSub = iNew.getChildren(ouID, orgView);
        if (orgUnitCollectionSub == null || orgUnitCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"NoSubOrg"));
            return null;
        }
        OrgUnitCollection orgUnitFilterCollectionSub = new OrgUnitCollection();
        if (orgUnitCollectionSub.size() > 0) {
            orgUnitFilterCollectionSub = BgTypeHelper.getOrgUnitCollByBgType(this.getSelectedBgType(), orgUnitCollectionSub);
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitFilterCollectionSub);
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSubOrgUnitSelectorUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        return ((BgSubOrgUnitSelectorUI)orgSelectorUI.getUIObject()).getOrgUnitCollectionSub();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        BgFormStateHelper stateHelper;
        boolean isOk;
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id == null || id.equals("")) {
            return;
        }
        if (BgClientHelper.checkInProInst(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u9884\u7b97\u8868\u6b63\u5728\u5de5\u4f5c\u6d41\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539\uff01");
            SysUtil.abort();
        }
        if (isOk = (stateHelper = new BgFormStateHelper()).isUpdateCurrProm(this.state)) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strState = BgFormStateEnum.getEnum(this.state).getAlias();
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsUpdate");
            int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)(str + strState + strResState + strMsg));
            if (confirm == 0) {
                this.popupEditWindow(OprtState.EDIT, this.getSelectedKeyValue());
            }
        } else {
            this.popupEditWindow(OprtState.EDIT, this.getSelectedKeyValue());
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.popupEditWindow(OprtState.VIEW, this.getSelectedKeyValue());
    }

    protected void popupEditWindow(String status, String keyValue) throws UIException {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)keyValue);
        uiContext.put((Object)"state", (Object)new Integer(this.state));
        if (status.equals(OprtState.ADDNEW)) {
            uiContext.put((Object)"isAddNew", (Object)true);
            status = OprtState.EDIT;
        }
        uiContext.put((Object)"BgType", (Object)this.getSelectedBgType());
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        uiContext.put((Object)"EditOrg", (Object)this.getBGOrgUnitInfo());
        IUIWindow popUI = UIFactory.createUIFactory((String)this.getMyEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, status);
        popUI.show();
        if (((EditUI)popUI.getUIObject()).isSave()) {
            this.execQuery();
        }
    }

    private BgTypeInfo getSelectedBgType() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("bgType.id").getValue();
        String number = (String)row.getCell("bgType.number").getValue();
        String name = (String)row.getCell("bgType.name").getValue();
        this.selectedBgTypeInfo = new BgTypeInfo();
        this.selectedBgTypeInfo.setId(BOSUuid.read((String)id));
        this.selectedBgTypeInfo.setNumber(number);
        this.selectedBgTypeInfo.setName(name);
        return this.selectedBgTypeInfo;
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent arg0) throws Exception {
        BgFormStateHelper stateHelper;
        boolean isOk;
        this.checkSelected();
        BgClientHelper.applyMutexService((Component)((Object)this), this.getSelectedKeyForAll(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        String id = this.getSelectedKeyValue();
        if (id == null || id.equals("")) {
            return;
        }
        if (BgClientHelper.checkInProInst(id)) {
            MsgBox.showWarning((Component)((Object)this), (String)"\u9884\u7b97\u8868\u6b63\u5728\u5de5\u4f5c\u6d41\u5904\u7406\u4e2d\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
            SysUtil.abort();
        }
        if (!BgFormHelper.checkBgFormValid(id)) {
            SysUtil.abort();
        }
        if (isOk = (stateHelper = new BgFormStateHelper()).isDeclCurrProm(this.state)) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strState = BgFormStateEnum.getEnum(this.state).getAlias();
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsDelete");
            int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)(str + strState + strResState + strMsg));
            if (confirm == 0) {
                this.deleteForm(arg0, id);
            }
        } else {
            this.deleteForm(arg0, id);
        }
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    protected void deleteForm(ActionEvent arg0, String id) throws BOSException, EASBizException, Exception {
        BgFormInfo bgForm = new BgFormInfo();
        String str = "select fstate from t_bg_bgform where fid = '" + id + "'";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            if (rs.next()) {
                bgForm.setState(BgFormStateEnum.getEnum(rs.getInt(1)));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            ex.printStackTrace();
            return;
        }
        boolean isPass = this.checkState(bgForm, true);
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        iBgForm.checkRemovable(id);
        IBgFormProcess iPross = BgFormProcessFactory.getRemoteInstance();
        iPross.deleteBgForm(id);
        this.refreshList();
    }

    @Override
    protected void ontblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow iRow = this.tblMain.getRow(rowIndex);
        if (iRow == null) {
            return;
        }
        BizEnumValueInfo bizEnumValueInfo = (BizEnumValueInfo)iRow.getCell("BgForm.state").getValue();
        String alias = bizEnumValueInfo.getAlias(SysContext.getSysContext().getLocale());
        this.state = 0;
        List list = BgFormStateEnum.getEnumList();
        for (BgFormStateEnum bgFormStateEnum : list) {
            if (!bgFormStateEnum.getAlias(SysContext.getSysContext().getLocale()).equals(alias)) continue;
            this.state = bgFormStateEnum.getValue();
            break;
        }
        if (this.state == 50 || this.state == 52 || this.state == 54 || this.state == 55) {
            this.btnView.setEnabled(false);
            this.menuItemView.setEnabled(false);
        } else {
            this.btnView.setEnabled(true);
            this.menuItemView.setEnabled(true);
        }
        if (this.state == 1 || this.state == 10 || this.state == 13 || this.state == 9 || this.state == 14 || this.state == 51 || this.state == 53) {
            this.btnEdit.setEnabled(true);
            this.menuItemEdit.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
        }
        if (this.state == 5 || this.state == 1 || this.state == 4 || this.state == 10 || this.state == 13 || this.state == 51 || this.state == 53 || this.state == 55 || this.state == 9 || this.state == 14) {
            this.btnRemove.setEnabled(true);
            this.menuItemRemove.setEnabled(true);
        } else {
            this.btnRemove.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        }
        if (this.state == 7 || this.state == 50 || this.state == 51 || this.state == 52 || this.state == 53 || this.state == 54 || this.state == 55) {
            this.btnDeclare.setEnabled(false);
            this.itemDeclareSingle.setEnabled(false);
        } else {
            this.btnDeclare.setEnabled(true);
            this.itemDeclareSingle.setEnabled(true);
        }
        this.btnDeclare.setVisible(true);
        this.itemDeclareSingle.setVisible(true);
        String typeNumber = (String)iRow.getCell("bgType.number").getValue();
        BgTypeInfo bti = new BgTypeInfo();
        IBgType bgType = BgTypeFactory.getRemoteInstance();
        bti = bgType.getBgTypeInfo("select id,name,number,isRptBgForm where number='" + typeNumber + "'");
        if (bti.isIsRptBgForm()) {
            this.btnSplit.setEnabled(false);
            this.itemSplit.setEnabled(false);
        } else if (this.state == 1 || this.state == 2) {
            this.btnSplit.setEnabled(true);
            this.itemSplit.setEnabled(true);
        } else {
            this.btnSplit.setEnabled(false);
            this.itemSplit.setEnabled(false);
        }
        if (bti.isIsRptBgForm()) {
            this.kDWorkButtonDeclare.setEnabled(false);
            this.btnDistribute.setEnabled(false);
            this.itemDeclare.setEnabled(false);
            this.itemDistribute.setEnabled(false);
        } else if (typeNumber != null) {
            if (typeNumber.equals("CashFlowStatementBudget")) {
                this.btnDistribute.setEnabled(false);
                this.kDWorkButtonDeclare.setEnabled(false);
                this.itemDeclare.setEnabled(false);
                this.itemDistribute.setEnabled(false);
            } else if (this.state == 5 || this.state == 13) {
                this.btnDistribute.setEnabled(false);
                this.kDWorkButtonDeclare.setEnabled(false);
                this.itemDeclare.setEnabled(false);
                this.itemDistribute.setEnabled(false);
            } else {
                this.btnDistribute.setEnabled(true);
                this.kDWorkButtonDeclare.setEnabled(true);
                this.itemDeclare.setEnabled(true);
                this.itemDistribute.setEnabled(true);
            }
        }
        if (this.state == 50 || this.state == 51 || this.state == 52 || this.state == 53 || this.state == 54 || this.state == 55) {
            this.kDWorkButtonDeclare.setEnabled(false);
            this.btnDistribute.setEnabled(false);
            this.btnSplit.setEnabled(false);
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.separator2.setVisible(false);
        this.actionDeclare.setBindWorkFlow(true);
        this.actionDispose.setBindWorkFlow(true);
        this.actionRemove.setBindWorkFlow(true);
        this.actionEdit.setBindWorkFlow(true);
        this.actionDeclareSingle.setBindWorkFlow(true);
        this.actionSplit.setBindWorkFlow(true);
        this.btnDeclare.setVisible(true);
        this.itemDeclareSingle.setVisible(true);
        this.btnUpgrade.setVisible(false);
        this.btnSplit.setVisible(false);
    }

    private void setBtnUpgradeVisible() {
        String str = "select fid from t_bg_bgform where fid not in ( select fbgformid from t_bg_bgkds )";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            if (rs.next()) {
                this.btnUpgrade.setVisible(true);
                this.btnUpgrade.setIcon(EASResource.getIcon((String)"imgTbtn_upgrade"));
            } else {
                this.btnUpgrade.setVisible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setIcon() {
        this.kDWorkButtonDeclare.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnDistribute.setIcon(EASResource.getIcon((String)"imgTbtn_disassemble"));
        this.btnSplit.setIcon(EASResource.getIcon((String)"imgTbtn_split"));
        this.btnDeclare.setIcon(EASResource.getIcon((String)"imgTbtn_declarecollect"));
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        this.tblMain.getGroupManager().setGroup(true);
        int size = this.tblMain.getColumnCount();
        for (int i = 0; i < size; ++i) {
            IColumn column = this.tblMain.getColumn(i);
            String key = column.getKey();
            if (key.equals("bgScheme.name") || key.equals("bgScheme.isFormal")) {
                column.setMergeable(true);
                continue;
            }
            column.setMergeable(false);
        }
        this.tblMain.getMergeManager().setMergeMode(1);
    }

    @Override
    public void actionSplit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSplit_actionPerformed(e);
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        int currRowNo = this.tblMain.getSelectManager().getActiveRowIndex();
        BizEnumValueInfo bizEnumValueInfo = (BizEnumValueInfo)this.tblMain.getRow(currRowNo).getCell("BgForm.state").getValue();
        String bgFormId = (String)this.tblMain.getRow(currRowNo).getCell("id").getValue();
        BgCycleTypeEnum sourceCycle = BgCycleTypeEnum.getEnum(this.getBgCycle(bgFormId));
        this.checkCanSplit(sourceCycle, bizEnumValueInfo, bgFormId);
        int[] schemePeriod = this.getBeginYearAndNumber(bgFormId);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"bgFormId", (Object)bgFormId);
        uiContext.put((Object)"sourceCycle", (Object)sourceCycle);
        uiContext.put((Object)"beginYear", (Object)new Integer(schemePeriod[0]));
        uiContext.put((Object)"beginNumber", (Object)new Integer(schemePeriod[1]));
        uiContext.put((Object)"endYear", (Object)new Integer(schemePeriod[2]));
        uiContext.put((Object)"endNumber", (Object)new Integer(schemePeriod[3]));
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgSetSplitRateUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        popUI.show();
        BigDecimal[][] scale = ((BgSetSplitRateUI)popUI.getUIObject()).getScale();
        PeriodCollection pc = ((BgSetSplitRateUI)popUI.getUIObject()).getPc();
        PeriodCollection[] subPc = ((BgSetSplitRateUI)popUI.getUIObject()).getSubPc();
        BgCycleTypeEnum targetBgCycle = ((BgSetSplitRateUI)popUI.getUIObject()).getTargetBgCycle();
        sourceCycle = ((BgSetSplitRateUI)popUI.getUIObject()).getSourceCycle();
        boolean isCancel = ((BgSetSplitRateUI)popUI.getUIObject()).isCancel();
        if (isCancel) {
            return;
        }
        if (scale.length == 0 || scale[0][0] == null) {
            return;
        }
        uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"BgType", (Object)this.getSelectedBgType());
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        uiContext.put((Object)"EditOrg", (Object)this.getBGOrgUnitInfo());
        uiContext.put((Object)"scale", (Object)scale);
        uiContext.put((Object)"pc", (Object)pc);
        uiContext.put((Object)"subPc", (Object)subPc);
        uiContext.put((Object)"sourceCycle", (Object)sourceCycle);
        uiContext.put((Object)"targetCycle", (Object)targetBgCycle);
        popUI = UIFactory.createUIFactory((String)this.getMyEditUIModal()).create(BgFormSplitEditUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        popUI.show();
    }

    public void checkCanSplit(BgCycleTypeEnum sourceCycle, BizEnumValueInfo bizEnumValueInfo, String bgFormId) throws EASBizException, BOSException {
        if (sourceCycle.equals((Object)BgCycleTypeEnum.Period)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"NotSplit5"));
            SysUtil.abort();
        }
        if (bizEnumValueInfo.getAlias().equals(BgFormStateEnum.Approved.getAlias())) {
            if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"IsSplitApprove")) == 2) {
                SysUtil.abort();
            }
            if (BgSplitFactory.getRemoteInstance().isRefByBgCtrl(bgFormId)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.client.BgSplitResource", (String)"NotSplit4"));
                SysUtil.abort();
            }
        }
    }

    public int getBgCycle(String bgFormId) throws BOSException, SQLException {
        int result = 0;
        StringBuffer sqlForm = new StringBuffer(40);
        sqlForm.append("SELECT a.FBgCycle FROM T_Bg_BgTemplate a,T_Bg_BgForm b WHERE a.fid=b.fbgtemplateid and b.fid='");
        sqlForm.append(bgFormId);
        sqlForm.append("'");
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm.toString());
        IRowSet irs = iExecutor.executeSQL();
        if (irs.next()) {
            result = irs.getInt(1);
        }
        return result;
    }

    protected void storeBgFormLog(BgOperationEnum bgOpr) throws EASBizException, BOSException {
        String strFormId = this.getSelectedKeyValue();
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setId(BOSUuid.read((String)strFormId));
        UserInfo user = (UserInfo)SysContext.getSysContext().getCurrentUser();
        BgFormLogHelper.addNewBgFormLog(null, bgFormInfo, bgOpr, user);
    }

    public int[] getBeginYearAndNumber(String bgFormId) throws BOSException, SQLException {
        int[] result = new int[4];
        StringBuffer sqlForm = new StringBuffer(40);
        sqlForm.append(" select a.FPeriodYear beginYear,a.FPeriodNumber beginNUmber,d.FPeriodYear endYear,d.FPeriodNumber endNUmber ");
        sqlForm.append(" from T_BD_Period a,T_Bg_BgForm b,T_BD_Period d ");
        sqlForm.append(" WHERE a.fid=b.fperiodfromid and d.fid=b.fperiodtoid and b.fid='");
        sqlForm.append(bgFormId);
        sqlForm.append("'");
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm.toString());
        IRowSet irs = iExecutor.executeSQL();
        if (irs.next()) {
            result[0] = irs.getInt(1);
            result[1] = irs.getInt(2);
            result[2] = irs.getInt(3);
            result[3] = irs.getInt(4);
        }
        return result;
    }

    @Override
    public void actionDeclareSingle_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        BOSUuid uuid = ((OrgStructureInfo)node.getUserObject()).getUnit().getId();
        if (uuid.toString().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"NotDeclareNoSuperOrg"));
            return;
        }
        if (!BgFormHelper.checkBgFormValid(this.getSelectedKeyValue())) {
            SysUtil.abort();
        }
        IBgFormDA iBgFormDA = BgFormDAFactory.getRemoteInstance();
        BgFormInfo bgForm = iBgFormDA.getSingleForm((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.checkState(bgForm, false);
        iBgFormDA.updateBgFormStatus((IObjectPK)new ObjectUuidPK(bgForm.getId()), BgFormStateEnum.DeclareIng);
        BgOperationEnum bgOpr = BgOperationEnum.Declare;
        this.storeBgFormLog(bgOpr);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"DeclareOK"));
        this.refresh(e);
        BgClientHelper.refreshBgFormList((CoreUI)this);
    }

    protected boolean checkState(BgFormInfo bgForm, boolean isDel) {
        BgFormStateHelper bsh = new BgFormStateHelper();
        int state = bgForm.getState().getValue();
        boolean isPass = false;
        boolean isOk = false;
        boolean isProm = false;
        try {
            if (isDel) {
                isOk = bsh.isDelForm(state);
                isProm = bsh.isDelProm(state);
            } else {
                isOk = bsh.isDeclCurrForm(state);
                isProm = bsh.isDeclCurrProm(state);
            }
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        if (!isOk) {
            String str = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"CurrBgForm");
            String strResState = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"State");
            String strState = bgForm.getState().getAlias();
            if (isProm) {
                String strMsg = null;
                strMsg = isDel ? EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsDelete") : EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"IsDeclare");
                int confirm = MsgBox.showConfirm2((Component)((Object)this), (String)(str + strState + strResState + strMsg));
                if (confirm == 2) {
                    SysUtil.abort();
                }
                isPass = true;
            } else {
                String strMsg = null;
                strMsg = isDel ? EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotDelete") : EASResource.getString((String)"com.kingdee.eas.ma.bg.BgAllApproveResource", (String)"NotDeclare");
                MsgBox.showInfo((Component)((Object)this), (String)(str + strState + strResState + strMsg));
                SysUtil.abort();
            }
        }
        return isPass;
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(true);
    }

    @Override
    protected void btnUpgrade_actionPerformed(ActionEvent e) throws Exception {
        super.btnUpgrade_actionPerformed(e);
        try {
            IBgKDS iBgKDS = BgKDSFactory.getRemoteInstance();
            iBgKDS.upgradeAllBgForm();
        }
        catch (EASBizException ex) {
            ex.printStackTrace();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
    }

    private void applyMutexService(String id, String userID) {
        IMutexServiceControl iMC = MutexServiceControlFactory.getRemoteInstance();
        iMC.requestObjIDForUpdate(id, userID);
    }

    private void checkCanBeDeclaredorSplited(BgTypeInfo bgType, OrgUnitInfo upUnit, OrgUnitCollection subUnit, boolean isDeclare) {
        if (bgType == null || upUnit == null || subUnit == null || subUnit.size() == 0) {
            throw new IllegalArgumentException();
        }
        IBgTemplate ibgTemp = null;
        try {
            ibgTemp = BgTemplateFactory.getRemoteInstance();
            String strBgType = bgType.getId().toString();
            StringBuffer strOrgIds = new StringBuffer("'");
            strOrgIds.append(upUnit.getId().toString());
            for (int i = 0; i < subUnit.size(); ++i) {
                strOrgIds.append("','");
                strOrgIds.append(subUnit.get(i).getId().toString());
            }
            strOrgIds.append("'");
            BgTemplateCollection tempCol = ibgTemp.getBgTemplateCollection("select bgCycle,orgUnit where orgUnit in (" + strOrgIds.toString() + ") and bgType='" + strBgType + "' and isCurrent = 1");
            if (tempCol == null || tempCol.size() == 0) {
                throw new IllegalArgumentException();
            }
            int upCycleType = 0;
            for (int i = 0; i < tempCol.size(); ++i) {
                BgTemplateInfo bgTem = tempCol.get(i);
                if (upCycleType > 0) {
                    if (bgTem == null || bgTem.getBgCycle().getValue() >= upCycleType) continue;
                    if (isDeclare) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"cantDeclareForPeriod"));
                    } else {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"cantSplitForPeriod"));
                    }
                    SysUtil.abort();
                    continue;
                }
                if (bgTem == null || bgTem.getOrgUnit() == null || !bgTem.getOrgUnit().getId().toString().equals(upUnit.getId().toString())) continue;
                upCycleType = bgTem.getBgCycle().getValue();
                tempCol.removeObject(i);
                i = -1;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void actionAddNewV2_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        if (orgUnitInfo == null) {
            String strErr = EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"plsSelectOrgType");
            MsgBox.showWarning((Component)((Object)this), (String)strErr);
            SysUtil.abort();
        }
        CtrlUnitInfo orgCtrl = SysContext.getSysContext().getCurrentCtrlUnit();
        BgClientHelper.checkIsOnCU((CoreUI)this, orgUnitInfo, orgCtrl);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"EditOrg", (Object)this.getBGOrgUnitInfo());
        uiContext.put((Object)"OrgIDPath", (Object)this.getOrgIDPath());
        this.treeOrgUnit.getSelectionPath().getPath();
        uiContext.put((Object)"identity", (Object)String.valueOf(System.currentTimeMillis()));
        this.prepareUIContext(uiContext, e);
        IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgV2FormHeadUI.class.getName(), (Map)uiContext);
        popUI.show();
        this.execQuery();
    }
}

