/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgFormLogCollection;
import com.kingdee.eas.ma.bg.BgFormLogFactory;
import com.kingdee.eas.ma.bg.BgFormLogInfo;
import com.kingdee.eas.ma.bg.IBgFormLog;
import com.kingdee.eas.ma.bg.client.AbstractBgFormLogViewUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.util.Map;

public class BgFormLogViewUI
extends AbstractBgFormLogViewUI {
    @Override
    public void loadFields() {
        super.loadFields();
        BgFormLogCollection bgFormLogC = this.getBgFormLogColl();
        this.putDataToTable(bgFormLogC);
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected BgFormLogCollection getBgFormLogColl() {
        Map map = this.getUIContext();
        String strFormId = (String)map.get("ID");
        BgFormLogCollection bgFormLogCollection = new BgFormLogCollection();
        try {
            IBgFormLog iBgFormLog = BgFormLogFactory.getRemoteInstance();
            bgFormLogCollection = iBgFormLog.getCollectionByBgFormId(BOSUuid.read((String)strFormId));
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        return bgFormLogCollection;
    }

    protected void putDataToTable(BgFormLogCollection bgFormLogCollection) {
        int size = bgFormLogCollection.size();
        for (int i = 0; i < size; ++i) {
            BgFormLogInfo bgFormLogInfo = bgFormLogCollection.get(i);
            IRow iRow = this.kDTable1.addRow();
            iRow.getCell("seq").setValue((Object)new Integer(bgFormLogInfo.getSeq()));
            iRow.getCell("bgForm.Name").setValue((Object)bgFormLogInfo.getBgForm().getName());
            iRow.getCell("operation").setValue((Object)bgFormLogInfo.getBgOperation().getAlias());
            iRow.getCell("user.Name").setValue((Object)bgFormLogInfo.getCreator().getName());
            iRow.getCell("createTime").setValue((Object)bgFormLogInfo.getCreateTime());
        }
    }

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        this.loadFields();
    }

    @Override
    protected void onbtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.onbtnConfirm_actionPerformed(e);
        this.getUIWindow().close();
    }
}

