/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.BgSchemeCollection;
import com.kingdee.eas.ma.bg.BgSchemeFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.IBgScheme;
import com.kingdee.eas.ma.bg.ReferencedCurrencyCollection;
import com.kingdee.eas.ma.bg.client.BgFormQSUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.Vector;

public class BgFormQSUIHelper {
    public static CurrencyInfo[] getCurrency(BgTemplateInfo temInfo) {
        ReferencedCurrencyCollection currencyColl = temInfo.getRefCurrencies();
        CurrencyInfo[] result = new CurrencyInfo[currencyColl.size()];
        int size = currencyColl.size();
        for (int i = 0; i < size; ++i) {
            result[i] = currencyColl.get(i).getCurrency();
        }
        return result;
    }

    public static int[] getControllerPos(int start, int offset, int size) {
        int[] pos = new int[size];
        pos[0] = start;
        for (int i = 1; i < size - 1; ++i) {
            pos[i] = pos[i - 1] + offset;
        }
        return pos;
    }

    public static Vector getBgTypes(FullOrgUnitInfo orgInfo) throws BOSException, SQLException {
        Vector<String[]> result = new Vector<String[]>(6);
        OrgType orgType = null;
        String language = SysContext.getSysContext().getLocale().getLanguage();
        StringBuffer sqlType = new StringBuffer(40);
        sqlType.append("SELECT distinct a.FId,a.FName_");
        sqlType.append(language);
        sqlType.append(",a.FNumber,a.FDescription_");
        sqlType.append(language);
        sqlType.append(",a.FIsRptBgForm ");
        sqlType.append(" FROM T_Bg_BgType a,T_Bg_BgOrgType b \t\tWHERE a.FIsEffective = 1 and \t\t\ta.fid=b.fbgtypeid and (");
        if (orgInfo.isIsAdminOrgUnit()) {
            orgType = OrgType.Admin;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsCompanyOrgUnit()) {
            orgType = OrgType.Company;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsPurchaseOrgUnit()) {
            orgType = OrgType.Purchase;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsSaleOrgUnit()) {
            orgType = OrgType.Sale;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsStorageOrgUnit()) {
            orgType = OrgType.Storage;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsCostOrgUnit()) {
            orgType = OrgType.CostCenter;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        if (orgInfo.isIsProfitOrgUnit()) {
            orgType = OrgType.ProfitCenter;
            sqlType.append(" b.forgtype=" + orgType.getValue() + " or");
        }
        String sql = sqlType.toString().substring(0, sqlType.toString().length() - 3) + ")";
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet irs = iExecutor.executeSQL();
        while (irs.next()) {
            String[] item = new String[]{irs.getString(1), irs.getString(2), irs.getString(3), irs.getString(4), String.valueOf(irs.getInt(5))};
            result.add(item);
        }
        return result;
    }

    public static void initComboBoxBgScheme(FullOrgUnitInfo orgInfo, KDComboBox comboBoxBgScheme, BgFormQSUI ui) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        BgSchemeCollection bgSchemes = iBgScheme.getCollectionByOrgUnit(orgInfo);
        BgSchemeCollection bgSchemesUp = iBgScheme.getCollectionBeUsedByBgForm(orgInfo);
        comboBoxBgScheme.setEnabled(false);
        comboBoxBgScheme.removeAllItems();
        comboBoxBgScheme.addItems(bgSchemes.toArray());
        comboBoxBgScheme.addItems(bgSchemesUp.toArray());
        if (comboBoxBgScheme.getItemCount() <= 0) {
            MsgBox.showWarning((Component)((Object)ui), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"msgSelectBgScheme"));
        } else {
            comboBoxBgScheme.setSelectedIndex(0);
            comboBoxBgScheme.setEnabled(true);
        }
    }
}

