/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountType;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitCommon;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCommonFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import java.util.Iterator;

public class BgItemHelper_ACCOUNT
implements IBgItemHelper {
    private FullOrgUnitInfo orgUnitInfo;
    private BgTypeInfo bgTypeInfo;
    private CompanyOrgUnitInfo companyOrgUnitInfo;
    private String accountTableId = null;

    @Override
    public BgItemCollection fetcheBgItems() throws EASBizException, BOSException {
        String strMas;
        int size;
        EntityViewInfo entity;
        IAccountView iAcount;
        if (this.accountTableId == null) {
            String orgId = this.getCompanyOrgUnitInfo().getId().toString();
            ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getRemoteInstance();
            CompanyOrgUnitInfo info = iCom.getCompanyOrgUnitInfo("select accountTable.id where id='" + orgId + "'");
            this.accountTableId = info.getAccountTable().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        if (this.bgTypeInfo.getNumber().equals("IncomeBudget")) {
            filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(1), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.accountTableId));
            filter.setMaskString("#0 and #1 ");
        } else if (this.bgTypeInfo.getNumber().equals("ExpenseBudget")) {
            filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(2), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(3), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(4), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(5), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.accountTableId));
            filter.setMaskString("(#0 or #1 or #2 or #3) and #4 ");
        } else if (this.bgTypeInfo.getNumber().equals("ProjectBudget")) {
            filter.getFilterItems().add(new FilterItemInfo("AccountTypeID.Property", (Object)String.valueOf(4), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.accountTableId));
            filter.setMaskString("#0 and #1");
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)this.accountTableId));
            filter.setMaskString("#0 ");
        }
        AccountViewCollection avc = null;
        boolean isActual = this.getCompanyOrgUnitInfo().isIsOnlyUnion();
        boolean isGroupModel = BgHelper.isGroupModel();
        isGroupModel = false;
        if (isGroupModel) {
            if (isActual) {
                if (filter.getFilterItems().size() == 0) {
                    avc = AccountUtils.getGroupControlAccountsByCompany(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgUnitInfo().getId()));
                    avc = this.filterByBgType(avc);
                } else {
                    avc = AccountUtils.getGroupControlAccountsByCompany(null, (IObjectPK)new ObjectUuidPK(this.getCompanyOrgUnitInfo().getId()));
                    avc = this.filterByBgType(avc);
                }
            } else {
                iAcount = AccountViewFactory.getRemoteInstance();
                entity = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCompanyOrgUnitInfo().getCU().getId().toString(), CompareType.EQUALS));
                entity.getSorter().add(new SorterItemInfo("number"));
                size = filter.getFilterItems().size();
                if (size > 1) {
                    strMas = filter.getMaskString();
                    strMas = strMas + " and #" + (size - 1);
                    filter.setMaskString(strMas);
                } else {
                    filter.setMaskString("#0");
                }
                entity.setFilter(filter);
                avc = iAcount.getAccountViewCollection(entity);
            }
        } else {
            iAcount = AccountViewFactory.getRemoteInstance();
            entity = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)this.getCompanyOrgUnitInfo().getCU().getId().toString(), CompareType.EQUALS));
            entity.getSorter().add(new SorterItemInfo("number"));
            size = filter.getFilterItems().size();
            if (size > 1) {
                strMas = filter.getMaskString();
                strMas = strMas + " and #" + (size - 1);
                filter.setMaskString(strMas);
            } else {
                filter.setMaskString("#0");
            }
            entity.setFilter(filter);
            avc = iAcount.getAccountViewCollection(entity);
        }
        BgItemCollection bic = new BgItemCollection();
        Iterator iter = avc.iterator();
        while (iter.hasNext()) {
            bic.add(this.convertBgItem(iter.next()));
        }
        return bic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.ACCOUNT;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        AccountViewInfo avi = (AccountViewInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(avi.getId());
        bii.setItemNumber(avi.getNumber());
        bii.setItemName(avi.getName());
        bii.setLongNumber(avi.getLongNumber());
        bii.setIsLeaf(avi.isIsLeaf());
        return bii;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        AccountViewInfo accountViewInfo = new AccountViewInfo();
        accountViewInfo.setId(bgItemInfo.getItemID());
        accountViewInfo.setNumber(bgItemInfo.getItemNumber());
        accountViewInfo.setName(bgItemInfo.getItemName());
        return accountViewInfo;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        CompanyOrgUnitInfo companyInfo = null;
        try {
            IOrgUnitCommon iOrgCommon = OrgUnitCommonFactory.getRemoteInstance();
            companyInfo = (CompanyOrgUnitInfo)iOrgCommon.getRelationUnit(this.orgUnitInfo.getId(), OrgType.Company);
        }
        catch (BOSException e) {
            e.getMessage();
        }
        catch (EASBizException e) {
            e.getMessage();
        }
        if (companyInfo != null) {
            KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
            kdBizPromptBox.setDisplayFormat("$number$");
            kdBizPromptBox.setEditFormat("$number$");
            boolean isActual = companyInfo.isIsOnlyUnion();
            boolean isGroupModel = false;
            try {
                isGroupModel = BgHelper.isGroupModel();
            }
            catch (EASBizException e1) {
                new BOSException((Throwable)e1);
            }
            catch (BOSException e1) {
                new BOSException((Throwable)e1);
            }
            FilterInfo filterInfo = new FilterInfo();
            isGroupModel = false;
            if (isGroupModel) {
                if (isActual) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("levelDiff", (Object)"0", CompareType.GREATER_EQUALS));
                    filterInfo.setMaskString("#0");
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, this.getCompanyOrgUnitInfo(), filterInfo));
                } else {
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, this.getCompanyOrgUnitInfo()));
                }
            } else {
                EntityViewInfo entity = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                if (this.bgTypeInfo.getNumber().equals("IncomeBudget")) {
                    filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(1), CompareType.EQUALS));
                    filter.setMaskString("#0 ");
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, companyInfo, filter));
                } else if (this.bgTypeInfo.getNumber().equals("ExpenseBudget")) {
                    filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(2), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(3), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(4), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("PLType", (Object)String.valueOf(5), CompareType.EQUALS));
                    filter.setMaskString("(#0 or #1 or #2 or #3)");
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, companyInfo, filter));
                } else if (this.bgTypeInfo.getNumber().equals("ProjectBudget")) {
                    filter.getFilterItems().add(new FilterItemInfo("AccountTypeID.Property", (Object)String.valueOf(4), CompareType.EQUALS));
                    filter.setMaskString("#0 ");
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, companyInfo, filter));
                } else {
                    kdBizPromptBox.setSelector((KDPromptSelector)new AccountPromptBox(uiObj, companyInfo));
                }
            }
            return kdBizPromptBox;
        }
        return null;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo() {
        if (this.companyOrgUnitInfo == null) {
            try {
                this.companyOrgUnitInfo = BgHelper.getCompanyOrgByOrgUnit((OrgUnitInfo)this.orgUnitInfo);
            }
            catch (EASBizException e) {
                new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                new BOSException((Throwable)e);
            }
        }
        return this.companyOrgUnitInfo;
    }

    public AccountViewCollection filterByBgType(AccountViewCollection accountViewCollection) {
        AccountViewCollection accountC = new AccountViewCollection();
        int size = accountViewCollection.size();
        if (this.bgTypeInfo.getNumber().equals("IncomeBudget")) {
            for (int i = 0; i < size; ++i) {
                AccountViewInfo accountViewInfo = accountViewCollection.get(i);
                if (accountViewInfo.getPLType().getValue() != 1) continue;
                accountC.add(accountViewInfo);
            }
        } else if (this.bgTypeInfo.getNumber().equals("ExpenseBudget")) {
            int costType = 2;
            int manageType = 3;
            int saleType = 4;
            int financeType = 5;
            for (int i = 0; i < size; ++i) {
                AccountViewInfo accountViewInfo = accountViewCollection.get(i);
                int plType = accountViewInfo.getPLType().getValue();
                if (plType != costType && plType != manageType && plType != saleType && plType != financeType) continue;
                accountC.add(accountViewInfo);
            }
        } else if (this.bgTypeInfo.getNumber().equals("ProjectBudget")) {
            try {
                int property = 4;
                IAccountType iAccountType = AccountTypeFactory.getRemoteInstance();
                SelectorItemCollection select = new SelectorItemCollection();
                select.add(new SelectorItemInfo("property"));
                for (int i = 0; i < size; ++i) {
                    ObjectUuidPK pk;
                    AccountTypeInfo accountTypeInfo;
                    AccountViewInfo accountViewInfo = accountViewCollection.get(i);
                    if (accountViewInfo.getAccountTypeID() == null || (accountTypeInfo = iAccountType.getAccountTypeInfo((IObjectPK)(pk = new ObjectUuidPK(accountViewInfo.getAccountTypeID().getId())), select)).getProperty().getValue() != property) continue;
                    accountC.add(accountViewInfo);
                }
            }
            catch (EASBizException e) {
                new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                new BOSException((Throwable)e);
            }
        } else {
            accountC = accountViewCollection;
        }
        return accountC;
    }
}

