/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgBizException;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgHelper;
import com.kingdee.eas.ma.bg.BgItemCollection;
import com.kingdee.eas.ma.bg.BgItemInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.client.IBgItemHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;

public class BgItemHelper_PROVIDER
implements IBgItemHelper {
    private FullOrgUnitInfo orgUnitInfo;
    private BgTypeInfo bgTypeInfo;
    private CompanyOrgUnitInfo companyOrgUnitInfo;
    private static final String QUERYPATH = "com.kingdee.eas.basedata.master.cssp.app.PSupplierQuery";

    @Override
    public BgItemCollection fetcheBgItems() throws BOSException, BgBizException {
        MetaDataPK mdp = new MetaDataPK(QUERYPATH);
        IQueryExecutor iqe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mdp);
        String strCompanyId = this.getCompanyOrgUnitInfo().getCU().getId().toString();
        iqe.setObjectView(this.getEntityViewInfoByCompany(strCompanyId));
        IRowSet rs = iqe.executeQuery();
        BgItemCollection bic = new BgItemCollection();
        try {
            while (rs.next()) {
                BgItemInfo bii = new BgItemInfo();
                bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
                bii.setBgDimension(this.getCurrentBgDimEnum());
                bii.setItemID(BOSUuid.read((String)rs.getString("id")));
                bii.setItemNumber(rs.getString("number"));
                bii.setItemName(rs.getString("name"));
                bii.setIsLeaf(true);
                bic.add(bii);
            }
        }
        catch (SQLException e) {
            throw new BgBizException(BgBizException.GETDATA, e, new Object[]{"Customer"});
        }
        return bic;
    }

    @Override
    public void setBgType(BgTypeInfo bgTypeInfo) {
        this.bgTypeInfo = bgTypeInfo;
    }

    @Override
    public void setOrgUnit(FullOrgUnitInfo orgUnitInfo) {
        this.orgUnitInfo = orgUnitInfo;
    }

    @Override
    public BgDimensionEnum getCurrentBgDimEnum() {
        return BgDimensionEnum.PROVIDER;
    }

    @Override
    public BgItemInfo convertBgItem(Object objectInfo) {
        SupplierInfo csbi = (SupplierInfo)objectInfo;
        BgItemInfo bii = new BgItemInfo();
        bii.setId(BOSUuid.create((BOSObjectType)bii.getBOSType()));
        bii.setBgDimension(this.getCurrentBgDimEnum());
        bii.setItemID(csbi.getId());
        bii.setItemNumber(csbi.getNumber());
        bii.setItemName(csbi.getName());
        bii.setIsLeaf(true);
        return bii;
    }

    @Override
    public Object convertBizItem(BgItemInfo bgItemInfo) {
        SupplierInfo csbi = new SupplierInfo();
        csbi.setId(bgItemInfo.getItemID());
        csbi.setNumber(bgItemInfo.getItemNumber());
        csbi.setName(bgItemInfo.getItemName());
        return csbi;
    }

    @Override
    public KDBizPromptBox getBizPromptBox(IUIObject uiObj) {
        KDBizPromptBox kdBizPromptBox = new KDBizPromptBox();
        kdBizPromptBox.setQueryInfo(QUERYPATH);
        kdBizPromptBox.setDisplayFormat("$number$");
        kdBizPromptBox.setEditFormat("$number$");
        String strCompanyId = this.getCompanyOrgUnitInfo().getId().toString();
        kdBizPromptBox.setEntityViewInfo(this.getEntityViewInfoByCompany(strCompanyId));
        return kdBizPromptBox;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnitInfo() {
        if (this.companyOrgUnitInfo == null) {
            try {
                this.companyOrgUnitInfo = BgHelper.getCompanyOrgByOrgUnit((OrgUnitInfo)this.orgUnitInfo);
            }
            catch (EASBizException e) {
                new BOSException((Throwable)e);
            }
            catch (BOSException e) {
                new BOSException((Throwable)e);
            }
        }
        return this.companyOrgUnitInfo;
    }

    public EntityViewInfo getEntityViewInfoByCompany(String strCompanyId) {
        EntityViewInfo entity = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", (Object)strCompanyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("cu.id", null, CompareType.EQUALS));
        filterInfo.setMaskString("#0 or #1");
        entity.setFilter(filterInfo);
        return entity;
    }
}

