/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeCollection;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.bg.client.AbstractBgOrgBasedListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class BgOrgBasedListUI
extends AbstractBgOrgBasedListUI {
    protected boolean isInit = false;
    protected FullOrgUnitInfo currOrg = null;
    protected boolean isBgScheme = false;

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comboxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        TreeModel treeModel = null;
        try {
            String rootUnitID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            treeModel = NewOrgUtils.getTreeModel((OrgViewType)orgViewType, null, (String)rootUnitID, null, null);
            this.treeOrgUnit.setModel(treeModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.treeOrgUnit.getModel() != null) {
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)this.treeOrgUnit.getModel().getRoot());
        }
    }

    protected IObjectPK getOrgPK() {
        CompanyOrgUnitInfo info;
        if (this.treeOrgUnit == null) {
            return super.getOrgPK();
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            CompanyOrgUnitInfo info2;
            CompanyOrgUnitInfo companyOrgUnitInfo = info2 = SysContext.getSysContext().getCurrentFIUnit() instanceof CompanyOrgUnitInfo ? SysContext.getSysContext().getCurrentFIUnit() : null;
            if (info2 == null) {
                return null;
            }
            ObjectUuidPK orgPk = new ObjectUuidPK(info2.getId());
            return orgPk;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo org = oui.getUnit();
        org.setLongNumber(oui.getLongNumber());
        if (org.isIsCompanyOrgUnit()) {
            ObjectUuidPK orgPk = new ObjectUuidPK(org.getId());
            return orgPk;
        }
        CompanyOrgUnitInfo companyOrgUnitInfo = info = SysContext.getSysContext().getCurrentFIUnit() instanceof CompanyOrgUnitInfo ? SysContext.getSysContext().getCurrentFIUnit() : null;
        if (info == null) {
            return null;
        }
        ObjectUuidPK orgPk = new ObjectUuidPK(info.getId());
        return orgPk;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(SysContext.getSysContext().getCurrentCtrlUnit().getId());
    }

    public void isolateOrg(DefaultKingdeeTreeNode node, String orgRangeStr) throws BOSException, SQLException {
        int size = node.getChildCount();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            String orgId = ((OrgUnitInfo)childNode.getUserObject()).getId().toString();
            if (childNode.getChildCount() > 0) {
                this.isolateOrg(childNode, orgRangeStr);
            }
            if (orgRangeStr.indexOf(orgId) != -1 || childNode.getChildCount() > 0) continue;
            this.treeOrgUnit.removeNodeFromParent((MutableTreeNode)childNode);
            --i;
            --size;
        }
    }

    public String getOrgRange(String userId) throws BOSException, SQLException {
        String result = "";
        String sqlForm = "SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID='" + userId + "'";
        ISQLExecutor iExecutor = SQLExecutorFactory.getRemoteInstance((String)sqlForm);
        IRowSet irs = iExecutor.executeSQL();
        while (irs.next()) {
            result = result.equals("") ? irs.getString(1) : result + "," + irs.getString(1);
        }
        return result;
    }

    public void onLoad() throws Exception {
        this.initComboxOrgType();
        super.onLoad();
        this.tblMain.checkParsed();
        this.splitPaneMain.setResizeWeight(0.2);
        this.treeOrgUnit.setModel(null);
        this.comboxOrgType.setEnabled(false);
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COMPANY);
        this.comboxOrgType.setEnabled(true);
        this.treeOrgUnit.setEnabled(false);
        this.refreshOrgUnitTree();
        this.locateCurrentOrg();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        boolean isPerimess = true;
        if (node != null) {
            isPerimess = !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node);
        }
        this.actionAddNew.setEnabled(isPerimess);
        this.treeOrgUnit.setEnabled(true);
        if (this.comboxOrgType.getItemCount() > 0) {
            this.comboxOrgType.setSelectedIndex(0);
        }
        this.treeOrgUnit_valueChanged(null);
        this.isInit = true;
    }

    protected void initComboxOrgType() {
        this.comboxOrgType.setEnabled(false);
        this.comboxOrgType.removeAllItems();
        if (!this.isBgScheme) {
            this.currOrg = (FullOrgUnitInfo)SysContext.getSysContext().getCurrentOrgUnit();
            if (this.currOrg.isIsCompanyOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.COMPANY);
            }
            if (this.currOrg.isIsAdminOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.ADMIN);
            }
            if (this.currOrg.isIsCompanyOrgUnit() || this.currOrg.isIsCostOrgUnit() || this.currOrg.isIsProfitOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.RESPONSECENTER);
            }
            if (this.currOrg.isIsSaleOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.SALE);
            }
            if (this.currOrg.isIsPurchaseOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.PURCHASE);
            }
            if (this.currOrg.isIsStorageOrgUnit()) {
                this.comboxOrgType.addItem((Object)OrgViewType.STORAGE);
            }
            this.comboxOrgType.setEnabled(true);
        } else {
            this.comboxOrgType.addItem((Object)OrgViewType.CTRLUNIT);
        }
    }

    protected FullOrgUnitInfo getBGOrgUnitInfo() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        if (OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            return null;
        }
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo info = oui.getUnit();
        info.setLongNumber(oui.getLongNumber());
        return info;
    }

    protected FullOrgUnitInfo getOrgUnitInfo(DefaultKingdeeTreeNode node) {
        OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
        FullOrgUnitInfo info = oui.getUnit();
        info.setLongNumber(oui.getLongNumber());
        return info;
    }

    protected String getOrgUnitId() {
        FullOrgUnitInfo oui = this.getBGOrgUnitInfo();
        if (oui == null) {
            return "";
        }
        return oui.getId().toString();
    }

    protected OrgViewType getOrgViewType() {
        return (OrgViewType)this.comboxOrgType.getSelectedItem();
    }

    protected Vector getOrgIDPath() throws EASBizException, BOSException {
        TreePath path = this.treeOrgUnit.getSelectionPath();
        if (path == null) {
            return null;
        }
        Object[] pathObj = path.getPath();
        if (pathObj == null) {
            return null;
        }
        int length = pathObj.length;
        Vector<String> result = new Vector<String>(length);
        int treeType = -1;
        String firstOrgId = "";
        for (int i = length - 1; i >= 0; --i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)pathObj[i];
            Object obj = node.getUserObject();
            if (obj == null || !(obj instanceof OrgStructureInfo)) continue;
            OrgStructureInfo oui = (OrgStructureInfo)obj;
            FullOrgUnitInfo orgUnitInfo = oui.getUnit();
            if (treeType == -1) {
                treeType = (Integer)orgUnitInfo.get("treeType");
            }
            firstOrgId = orgUnitInfo.getId().toString();
            result.add(orgUnitInfo.getId().toString());
        }
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        this.getParentId(iNew, firstOrgId, treeType, result);
        return result;
    }

    private void getParentId(INewOrgViewFacade iNew, String firstOrgId, int treeType, Vector result) throws EASBizException, BOSException {
        OrgUnitInfo org = iNew.getParent(firstOrgId, OrgViewType.getEnum((int)treeType));
        if (org == null) {
            return;
        }
        result.add(org.getId().toString());
        firstOrgId = org.getId().toString();
        this.getParentId(iNew, firstOrgId, treeType, result);
    }

    @Override
    protected void comboxOrgType_actionPerformed(ActionEvent e) throws Exception {
        if (!this.comboxOrgType.isEnabled()) {
            return;
        }
        this.treeOrgUnit.setEnabled(false);
        this.refreshOrgUnitTree();
        this.treeOrgUnit.setEnabled(true);
        this.locateCurrentOrg();
    }

    private void locateCurrentOrg() {
        block5: {
            CompanyOrgUnitInfo companyInfo;
            block4: {
                companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
                if (companyInfo != null && companyInfo.getId() != null) break block4;
                if (this.treeOrgUnit.getRowCount() <= 0) break block5;
                this.treeOrgUnit.setSelectionRow(0);
                break block5;
            }
            if (this.treeOrgUnit.getRowCount() == 0) {
                this.tblMain.removeRows();
            }
            int height = this.treeOrgUnit.getRowCount();
            for (int i = 0; i < height; ++i) {
                TreePath tp = this.treeOrgUnit.getPathForRow(i);
                if (tp == null) continue;
                DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
                if (tn == null) {
                    return;
                }
                OrgStructureInfo oui = (OrgStructureInfo)tn.getUserObject();
                FullOrgUnitInfo info = oui.getUnit();
                info.setLongNumber(oui.getLongNumber());
                if (!info.getId().toString().equals(companyInfo.getId().toString())) continue;
                this.treeOrgUnit.setSelectionRow(i);
                break;
            }
        }
        if (this.treeOrgUnit.getSelectionPath() == null && this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.setSelectionRow(0);
        }
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        if (!this.treeOrgUnit.isEnabled()) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            this.enableBtns(false);
            this.tblMain.removeRows();
            if (this.isInit) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.bg.BgFormResource", (String)"SelectPermiUnit"));
                SysUtil.abort();
            }
        } else {
            FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
            this.enableBtns(true);
            if (orgUnitInfo == null) {
                return;
            }
            this.tblMain.removeRows();
            this.execQuery();
        }
    }

    protected void enableBtns(boolean flag) {
        this.btnAddNew.setEnabled(flag);
        this.actionAddNew.setEnabled(flag);
        this.btnView.setEnabled(flag);
        this.btnEdit.setEnabled(flag);
        this.btnRefresh.setEnabled(flag);
        this.btnRemove.setEnabled(flag);
    }

    public boolean checkPermissionByOrg(OrgUnitInfo orgUnitInfo) throws BOSException {
        boolean isPermiss = false;
        if (orgUnitInfo == null) {
            return isPermiss;
        }
        SysContext sys = SysContext.getSysContext();
        UserInfo userInfo = sys.getCurrentUserInfo();
        if (userInfo == null) {
            return isPermiss;
        }
        String strUserId = userInfo.getId().toString();
        String strOrgId = orgUnitInfo.getId().toString();
        IOrgRange iOrgRange = OrgRangeFactory.getRemoteInstance();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("user", (Object)strUserId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("org", (Object)strOrgId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        entityViewInfo.setFilter(filterInfo);
        OrgRangeCollection orgRangeCollection = iOrgRange.getOrgRangeCollection(entityViewInfo);
        if (orgRangeCollection.size() > 0) {
            isPermiss = true;
        }
        return isPermiss;
    }
}

