/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgTemplateCollection;
import com.kingdee.eas.ma.bg.BgTemplateDAFactory;
import com.kingdee.eas.ma.bg.BgTemplateFactory;
import com.kingdee.eas.ma.bg.BgTemplateInfo;
import com.kingdee.eas.ma.bg.BgTypeInfo;
import com.kingdee.eas.ma.bg.IBgTemplate;
import com.kingdee.eas.ma.bg.IBgTemplateDA;
import com.kingdee.eas.ma.bg.client.BgOrgUnitInfoF7SelectorForRpt;
import java.awt.IllegalComponentStateException;
import java.util.Vector;

public class BgOrgUnitF7SelectorHelper {
    public static BgTemplateInfo findBgTemplateInfoOfPath(BgTypeInfo bgTypeInfo, String strOrgUnitNumber) {
        BgTemplateInfo temp1 = BgOrgUnitF7SelectorHelper.findBgTemplateInfo(bgTypeInfo, strOrgUnitNumber);
        if (temp1 != null) {
            return temp1;
        }
        String orgLongNumber = BgOrgUnitInfoF7SelectorForRpt.getOrgLongNumber();
        if (orgLongNumber == null) {
            return null;
        }
        String[] numbers = orgLongNumber.split("!");
        if (numbers.length < 2) {
            return null;
        }
        for (int i = numbers.length - 2; i >= 0; --i) {
            temp1 = BgOrgUnitF7SelectorHelper.findBgTemplateInfo(bgTypeInfo, numbers[i]);
            if (temp1 == null) continue;
            return temp1;
        }
        return null;
    }

    private static BgTemplateInfo findBgTemplateInfo(BgTypeInfo bgTypeInfo, String strOrgUnitNumber) {
        BgTemplateInfo bgTemplateInfo = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("isCurrent", (Object)"1", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.number", (Object)strOrgUnitNumber, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("bgType.id", (Object)bgTypeInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2");
            entityViewInfo.setFilter(filterInfo);
            entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
            IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
            boolean isValid = true;
            BgTemplateCollection bgTemplateCollection = iBgTemplate.getBgTemplateCollection(entityViewInfo);
            if (bgTemplateCollection != null && bgTemplateCollection.size() > 0) {
                bgTemplateInfo = bgTemplateCollection.get(0);
                bgTemplateInfo = BgTemplateDAFactory.getRemoteInstance().getBgTemplate(bgTemplateCollection.get(0).getId().toString());
            }
        }
        catch (BOSException e1) {
            throw new IllegalComponentStateException(e1.toString());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (bgTemplateInfo == null) {
            bgTemplateInfo = BgOrgUnitF7SelectorHelper.findBgTemplateInfo(bgTypeInfo.getId().toString());
        }
        return bgTemplateInfo;
    }

    private static BgTemplateInfo findBgTemplateInfo(String bgTypeId) {
        BgTemplateInfo bgTemplateInfo = null;
        try {
            IBgTemplateDA bean = BgTemplateDAFactory.getRemoteInstance();
            Vector vectPath = BgOrgUnitInfoF7SelectorForRpt.getSelectedPath();
            bgTemplateInfo = bean.getCurrentBgTemplate(vectPath, bgTypeId);
        }
        catch (BOSException e1) {
            bgTemplateInfo = null;
        }
        catch (EASBizException e) {
            bgTemplateInfo = null;
        }
        return bgTemplateInfo;
    }
}

