/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bg.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.bg.BgPostilCollection;
import com.kingdee.eas.ma.bg.BgPostilFactory;
import com.kingdee.eas.ma.bg.BgPostilInfo;
import com.kingdee.eas.ma.bg.IBgPostil;
import com.kingdee.eas.ma.bg.client.AbstractBgPostilViewUI;
import com.kingdee.eas.util.SysUtil;
import java.awt.event.ActionEvent;
import java.util.Map;

public class BgPostilViewUI
extends AbstractBgPostilViewUI {
    @Override
    public void loadFields() {
        super.loadFields();
        BgPostilCollection bgPostilC = this.getBgPostilColl();
        this.putDataToTable(bgPostilC);
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected BgPostilCollection getBgPostilColl() {
        Map map = this.getUIContext();
        String strFormId = (String)map.get("ID");
        BgPostilCollection bgPostilCollection = new BgPostilCollection();
        try {
            IBgPostil iBgPostil = BgPostilFactory.getRemoteInstance();
            bgPostilCollection = iBgPostil.getCollectionByBgFormId((IObjectPK)new ObjectUuidPK(strFormId));
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        return bgPostilCollection;
    }

    protected void putDataToTable(BgPostilCollection bgPostilCollection) {
        int size = bgPostilCollection.size();
        for (int i = 0; i < size; ++i) {
            BgPostilInfo bgPostilInfo = bgPostilCollection.get(i);
            IRow iRow = this.kDTable1.addRow();
            iRow.getCell("seq").setValue((Object)new Integer(bgPostilInfo.getSeq()));
            iRow.getCell("bgForm.name").setValue((Object)bgPostilInfo.getBgForm().getName());
            iRow.getCell("description").setValue((Object)bgPostilInfo.getDescription());
            iRow.getCell("user.name").setValue((Object)bgPostilInfo.getUser().getName());
            iRow.getCell("createTime").setValue((Object)bgPostilInfo.getCreateTime());
        }
    }

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        this.loadFields();
    }

    @Override
    protected void onbtnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.onbtnConfirm_actionPerformed(e);
        this.getUIWindow().close();
    }
}

